﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace NT2chCtrl.html
{
    public partial class HtmlElement
    {
        bool mInitSelector = false;

        private void initSelector()
        {
            if (!mInitSelector)
            {
                mMatchedSelector.Sort(CompareSelector);
                mInitSelector = true;
            }
        }

        static int CompareSelector(css.Selector lhs, css.Selector rhs)
        {
            return lhs.getSpecificity() - rhs.getSpecificity();
        }

        public bool tryGetBackgroundColor(out Color color)
        {
            initSelector();


            bool bRet = false;
            color = Colors.Transparent;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("background-color");
                if (null == p)
                    continue;
                color = p.getColor();
                bRet = true;
                break;
            }
            return bRet;
        }


        public bool tryGetImage(out Image img, string path)
        {
            initSelector();

            css.Property widthProperty = null;
            css.Property heightProperty = null;

            img = null;

            bool bRet = false;
            BitmapImage bImg = null;
            int nWidth = -1;
            int  nHeight = -1;
            int count;

            string sWidth = this.getAttributeValue("width");
            string sHeight = this.getAttributeValue("height");
            if (sWidth != null)
            {
                int.TryParse(sWidth, out nWidth);
            }
            if (sHeight != null)
            {
                int.TryParse(sHeight, out nHeight);
            }

            if (nWidth == -1 || nHeight == -1)
            {
                count = mMatchedSelector.Count;
                for (int i = count - 1; i >= 0; i--)
                {
                    css.Selector stor = mMatchedSelector[i];
                    if (widthProperty == null && nWidth == -1)
                    {
                        widthProperty = stor.getProperty("width");
                    }
                    if (heightProperty == null && nHeight == -1)
                    {
                        heightProperty = stor.getProperty("height");
                    }
                    if (null != widthProperty && null != heightProperty)
                        break;
                }
                if (nWidth == -1 && widthProperty != null)
                {
                    double d = widthProperty.getLength();
                    if (d != double.NaN)
                        nWidth = (int)d;
                }
                if (nHeight == -1 && heightProperty != null)
                {
                    double d = heightProperty.getLength();
                    if (d != double.NaN)
                        nHeight = (int)d;
                }
            }

            bImg = wpf.ImageCash.getBitmapImage(path);
            if (bImg != null)
            {
                img = new Image();
                img.Stretch = System.Windows.Media.Stretch.Uniform;
                if(nWidth > -1)
                    img.Width = nWidth;
                if(nHeight > -1)
                    img.Height = nHeight;
                img.Source = bImg;
                bRet = true;
            }
            return bRet;
        }

        public bool tryGetBackgroundImage(out Brush brush)// BitmapImage bImage)
        {
            initSelector();

            css.Property imgProperty = null;
            css.Property szProperty = null;

            brush = null;

            //bool bRet = false;
            BitmapImage bImg = null;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                if (imgProperty == null)
                {
                    imgProperty = stor.getProperty("background-image");
                }
                if (szProperty == null)
                {
                    szProperty = stor.getProperty("background-size");
                }
                if (null != szProperty && null != imgProperty)
                    break;
            }
            if (imgProperty != null)
            {
                string url = imgProperty.getUrlPath();
                if (url != null)
                {
                    bImg = wpf.ImageCash.getBitmapImage(url);
                    if (bImg != null)
                    {
                        brush = setImageBrushSize(bImg, szProperty);
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    string gradient = imgProperty.getLinearGradientValue();
                    if (gradient != null)
                    {
                        brush = getLinearGradientBrush(gradient);
                        return (brush != null);
                    }
                    gradient = imgProperty.getRadialGradientValue();
                    if (gradient != null)
                    {
                        brush = getRadialGradientBrush(gradient);
                        return (brush != null);
                    }                    
                }
            }
            return false;
        }

        private static Brush getLinearGradientBrush(string source)
        {
            //Color colStart = Colors.Transparent;
            //Color colEnd = Colors.Transparent;
            double angle = 90;
            string strColor;
            bool corner2corner = false;
            Point[] points = null;

            List<Color> cStops = new List<Color>();
            List<double> dStops = new List<double>();

            int state = 0;
            int textStart = 0;
            int idx;
            int nVal;
            //Color color;
            int bracket = 0;

            int length = source.Length;
            for (int i = 0; i < length; i++)
            {
                switch (HtmlParser.getCharToken(source[i]))
                {
                    case HtmlParser.CHAR_TOKEN.HYPHIEN:
                        if (state != 0)
                            return null;
                        state = 1;
                        textStart = i;
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        if (state == 0 || state == 1)
                        {
                            if (state == 0)
                                textStart = i;
                            idx = source.IndexOf("deg", textStart);
                            if (idx < 0)
                                return null;
                            if (!int.TryParse(source.Substring(textStart, idx - textStart), out nVal))
                            {
                                return null;
                            }
                            angle = nVal;
                            state = 2;
                            i = idx + 2;
                        }
                        else if (state == 4)
                        {
                            break;
                        }
                        else if (state == 5)
                        {
                            textStart = i;
                            state = 6;
                        }
                        else if (state == 6)
                        {
                            break;
                        }
                        else
                        {
                            return null;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.PERCENT:
                        if (state != 6)
                            return null;
                        if (!int.TryParse(source.Substring(textStart, i- textStart), out nVal))
                            return null;
                        dStops.Add(((double)nVal) / 100);
                        state = 7;
                        break;
                    case HtmlParser.CHAR_TOKEN.COMMA:
                        if (state == 0 || state == 1)
                            return null;
                        else if (state == 2)
                        {
                            state = 3;
                        }
                        else if (state == 4)
                        {
                            if (bracket > 0)
                                break;
                            strColor = source.Substring(textStart, i - textStart);
                            cStops.Add(css.cssColor.getColor(strColor));
                            dStops.Add(double.NaN);
                        }
                        else if (state == 5)
                        {
                            dStops.Add(double.NaN);
                        }
                        else if (state == 7)
                        {
                        }
                        else
                        {
                            return null;
                        }
                        state = 3;
                        break;
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            idx = source.IndexOf("to ", i);
                            if (idx == i)
                            {
                                int end;
                                if(!tryGetCornerDirection(source, idx + 3, out points, out end))
                                    return null;
                                corner2corner = true;
                                i = end;
                                state = 3;
                            }
                            else
                            {
                                textStart = i;
                                state = 4;
                            }
                        }
                        else if (state == 3)
                        {
                            textStart = i;
                            state = 4;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.SHARP:
                        if (state == 0 || state == 3)
                        {
                            textStart = i;
                            state = 4;
                        }
                        else
                        {
                            return null;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.L_BRACKET:
                        if (state != 4)
                            return null;
                        bracket++;
                        break;
                    case HtmlParser.CHAR_TOKEN.R_BRACKET:
                        if (state != 4)
                            return null;
                        bracket--;
                        break;
                    case HtmlParser.CHAR_TOKEN.NL:
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        if (state == 4)
                        {
                            strColor = source.Substring(textStart, i - textStart);
                            cStops.Add(css.cssColor.getColor(strColor));
                            state = 5;
                        }
                        break;
                }
            }
            if (state == 4)
            {
                strColor = source.Substring(textStart, length - textStart);
                cStops.Add(css.cssColor.getColor(strColor));
                dStops.Add(double.NaN);
            }
            else if(state == 5){
                dStops.Add(double.NaN);
            }else if(state ==6){
                return null;
            }

            int count = cStops.Count;

            if (count == 0 || dStops.Count != count)
                return null;
            if (count == 1)
            {
                return new SolidColorBrush(cStops[0]);
            }

            double delta = ((double)1) / (count - 1);

            GradientStopCollection collection  = new GradientStopCollection(count);

            for (int i = 0; i < count; i++)
            {
                if (double.IsNaN(dStops[i]))
                    collection.Add(new GradientStop(cStops[i], delta * i));
                else
                    collection.Add(new GradientStop(cStops[i], dStops[i]));
            }
            if (!corner2corner)
                return new LinearGradientBrush(collection, angle);
            else
                return new LinearGradientBrush(collection, points[0], points[1]);
        }


        private static Brush getRadialGradientBrush(string source)
        {

            string sVal;

            List<Color> cStops = new List<Color>();
            List<double> dStops = new List<double>();

            int state = 0;
            int textStart = 0;
            int nVal;
            Color color;
            int bracket = 0;

            //int nShape = -1;//-1 not specify, 1. circle, 2. ellipse

            int length = source.Length;
            for (int i = 0; i < length; i++)
            {
                HtmlParser.CHAR_TOKEN token =
                    HtmlParser.getCharToken(source[i]);
                switch (token)
                {
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            textStart = i;
                            state = 1;
                        }
                        else if (state == 2)
                        {
                            textStart = i;
                            state = 3;
                        }
                        else if (state == 4 || state == 5)
                        {
                            return null;
                        }
                        else if (state == 7)
                        {
                            break;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.SHARP:
                        if (state != 2)
                            return null;
                        textStart = i;
                        state = 7;
                        break;
                    case HtmlParser.CHAR_TOKEN.COMMA:
                    case HtmlParser.CHAR_TOKEN.NL:
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        if (bracket > 0)
                        {
                            if (state != 1 && state != 3)
                                return null;
                            break;
                        }
                        if (state == 4)
                        {
                            if (token == HtmlParser.CHAR_TOKEN.COMMA)
                            {
                                state = 2;
                                dStops.Add(double.NaN);
                                break;
                            }
                        }
                        else if (state == 5)
                        {
                            return null;
                        }
                        else if (state == 6)
                        {
                            if (token == HtmlParser.CHAR_TOKEN.COMMA)
                                state = 2;
                            break;
                        }
                        sVal = source.Substring(textStart, i - textStart);
                        if (state == 1)
                        {
                            if (sVal.Equals("circle"))
                            {
                                //nShape = 1;
                                if (token == HtmlParser.CHAR_TOKEN.COMMA)
                                    state = 2;
                                else
                                    state = 6;
                                break;
                            }
                            else if (sVal.Equals("ellipse"))
                            {
                                //nShape = 2;
                                if (token == HtmlParser.CHAR_TOKEN.COMMA)
                                    state = 2;
                                else
                                    state = 6;
                                break;
                            }
                            else
                            {
                                state = 3;
                            }
                        }
                        if (state == 3 || state == 7)
                        {
                            color = css.cssColor.getColor(sVal);
                            if (color == Colors.Transparent)
                                return null;
                            cStops.Add(color);
                        }
                        if (token == HtmlParser.CHAR_TOKEN.COMMA)
                        {
                            state = 2;
                            dStops.Add(double.NaN);
                        }
                        else
                        {
                            state = 4;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        if (state == 4){
                            state = 5;
                            textStart = i;
                        }
                        else if (state == 5)
                        {
                        }
                        else if (state == 1 || state == 3)
                        {
                            if (bracket == 0)
                                return null;
                        }
                        else if (state == 7)
                        {
                            break;
                        }
                        else
                        {
                            return null;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.PERCENT:
                        if (state != 5)
                            return null;
                        sVal = source.Substring(textStart, i - textStart);
                        if (!int.TryParse(sVal, out nVal))
                        {
                            return null;
                        }
                        dStops.Add(((double)nVal) / 100);
                        state = 6;
                        break;
                    case HtmlParser.CHAR_TOKEN.L_BRACKET:
                        if (state != 1 && state != 3)
                            return null;
                        bracket++;
                        break;
                    case HtmlParser.CHAR_TOKEN.R_BRACKET:
                        if (state != 1 && state != 3)
                            return null;
                        bracket--;
                        break;
                }
            }
            if (state == 1 || state == 3)
            {
                sVal = source.Substring(textStart, length - textStart);
                color = css.cssColor.getColor(sVal);
                if (color == Colors.Transparent)
                    return null;
                cStops.Add(color);
                dStops.Add(double.NaN);
            }
            else if (state == 4)
            {
                dStops.Add(double.NaN);
            }
            else if (state == 5)
            {
                return null;
            }

            int count = cStops.Count;

            if (count == 0 || dStops.Count != count)
                return null;
            if (count == 1)
            {
                return new SolidColorBrush(cStops[0]);
            }

            double delta = ((double)1) / (count - 1);

            GradientStopCollection collection = new GradientStopCollection(count);

            for (int i = 0; i < count; i++)
            {
                if (double.IsNaN(dStops[i]))
                    collection.Add(new GradientStop(cStops[i], delta * i));
                else
                    collection.Add(new GradientStop(cStops[i], dStops[i]));
            }
            return new RadialGradientBrush(collection);            
        }

        private static bool tryGetCornerDirection(string source, int startIdx, out Point[] points, out int end)
        {
            end = 0;
            points = new Point[2];
            points[0].X = 0.5;
            points[1].X = 0.5;
            points[0].Y = 0.5;
            points[1].Y = 0.5;
            HtmlParser.CHAR_TOKEN token;


            int textStart = startIdx;
            int state = 0;

            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                token = HtmlParser.getCharToken(source[i]);
                switch (token)
                {
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if (state == 0)
                        {
                            textStart = i;
                            state = 1;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.COMMA:
                    case HtmlParser.CHAR_TOKEN.NL:
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                        if (state == 1)
                        {
                            switch (source.Substring(textStart, i-textStart))
                            {
                                case "top":
                                    points[0].Y = 1;
                                    points[1].Y = 0;
                                    break;
                                case "bottom":
                                    points[0].Y = 0;
                                    points[1].Y = 1;
                                    break;
                                case "left":
                                    points[0].X = 1;
                                    points[1].X = 0;
                                    break;
                                case "right":
                                    points[0].X = 0;
                                    points[1].X = 1;
                                    break;
                            }
                        }
                        if (token == HtmlParser.CHAR_TOKEN.COMMA)
                        {
                            end = i;
                            return true;
                        }
                        state = 0;
                        break;    
                }
            }
            return false;
        }

        private ImageBrush setImageBrushSize(BitmapImage bImg, css.Property property)
        {
            string param = null;
            ImageBrush iBrush = new ImageBrush(bImg);
            if (property != null)
                param = property.getValue();
            switch (param)
            {
                case "auto":
                case null:
                    iBrush.Stretch = Stretch.Fill;
                    iBrush.ViewportUnits = BrushMappingMode.Absolute;
                    Rect rc = new Rect();
                    rc.X = rc.Y = 0;
                    rc.Width = bImg.Width;
                    rc.Height = bImg.Height;
                    iBrush.TileMode = TileMode.Tile;
                    iBrush.Viewport = rc;
                    break;
                case "contain":
                    iBrush.Stretch = Stretch.Uniform;
                    break;
                case "cover":
                    iBrush.Stretch = Stretch.UniformToFill;
                    break;
                default:
                    iBrush.Stretch = Stretch.Fill;
                    break;
            }
            return iBrush;

        }
        public bool tryGetColor(out Color color)
        {
            initSelector();


            bool bRet = false;
            color = Colors.Transparent;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("color");
                if (null == p)
                    continue;
                color = p.getColor();
                bRet = true;
                break;
            }
            return bRet;
        }

        public bool tryGetFontWeight(out int weight)
        {
            initSelector();

            weight = 400;
            bool bRet = false;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("font-weight");
                if (null == p)
                    continue;
                if (p.getFontWeight(out weight))
                    bRet = true;
                break;
            }
            return bRet;
        }
        public bool tryGetFontFamily(out string fontNames)
        {
            initSelector();

            fontNames = null;
            bool bRet = false;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("font-family");
                if (null == p)
                    continue;
                if (p.getFontFamily(out fontNames))
                    bRet = true;
                break;
            }
            return bRet;
        }

        public bool tryGetFontStyle(out css.Property.FontStyle style)
        {
            initSelector();

            style = css.Property.FontStyle.Normal;
            bool bRet = false;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("font-style");
                if (null == p)
                    continue;
                if (p.getFontStyle(out style))
                    bRet = true;
                break;
            }
            return bRet;
        }

        public bool tryGetLength(string propertyName, out double outLength, double? fontSize)
        {
            initSelector();

            bool bRet = false;
            outLength = double.NaN;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty(propertyName);
                if (null == p)
                    continue;
                outLength = p.getLength(fontSize);
                if (outLength != double.NaN)
                    bRet = true;
                break;
            }
            return bRet;
        }


        public bool tryGetPropertyValue(string propertyName, out string pValue)
        {
            initSelector();

            bool bRet = false;
            pValue = null;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty(propertyName);
                if (null == p)
                    continue;
                pValue = p.getValue();
                bRet = true;
                break;
            }
            return bRet;
        }


        public bool tryGetVisibility(out css.Property.Visibility visibility)
        {
            initSelector();


            bool bRet = false;
            visibility = css.Property.Visibility.Other;
            int count = mMatchedSelector.Count;
            for (int i = count - 1; i >= 0; i--)
            {
                css.Selector stor = mMatchedSelector[i];
                css.Property p = stor.getProperty("visibility");
                if (null == p)
                    continue;                
                visibility = p.getVisibility();
                bRet = true;
                break;
            }
            return bRet;
        }

    }
}
