﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;

namespace NT2chCtrl
{
    partial class UIElementListPanel : Panel
    {
        class ScrollItemHeight
        {
            double[] mHeightArray = new double[0];

            public double setHeight(int position, double value)
            {
                if (position < 0 || position >= mHeightArray.Length)
                    return 0;

                double tmp = mHeightArray[position];
                mHeightArray[position] = value;
                return value - tmp;
            }

            public double getHeight(int position)
            {
                if (position < 0 || position >= mHeightArray.Length)
                    return 0;
                return mHeightArray[position];
            }

            public void initHeightArray(int num)
            {
                if (num < 0)
                    num = 0;
                mHeightArray = new double[num];
                for (int i = 0; i < num; i++)
                {
                    mHeightArray[i] = DEFAULT_ITEM_HEIGHT;
                }
            }

            public double getTotalHeight()
            {
                double total = 0;
                foreach (double d in mHeightArray)
                {
                    total += d;
                }
                return total;
            }

            public bool tryGetItemPosition(double offset, out int position, out double itemOffset)
            {
                position = 0;
                itemOffset = 0;

                if (offset < 0)
                    return false;

                int num = mHeightArray.Length;
                if (num == 0)
                    return false;

                double totalHeight = 0;
                for (int i = 0; i < num; i++)
                {
                    totalHeight += mHeightArray[i];
                    if (offset < totalHeight)
                    {
                        position = i;
                        double tmp = totalHeight - offset;
                        itemOffset = mHeightArray[i] - tmp;
                        return (itemOffset < 0) ? false : true;
                    }
                }
                return false;
            }

            public double getScrollOffset(int itemPosition)
            {
                int num = mHeightArray.Length;
                if (num == 0 || num <= itemPosition)
                    return 0;

                double totalHeight = 0;
                for (int i = 0; i < itemPosition; i++)
                {
                    totalHeight += mHeightArray[i];
                }
                return totalHeight;
            }
        }
    }
}
