﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace NT2chCtrl
{
    public partial class UIElementListPanel : Panel
    {
#if DOTNET45
        bool mTouchDown = false;
        Point mPos;
        Point mDownPos;
        int mTimeStamp;

        void UIElementListPanel_TouchDown(object sender, System.Windows.Input.TouchEventArgs e)
        {
            mTouchDown = true;
            mTimeStamp = e.Timestamp;
            
            TouchPoint point = e.GetTouchPoint(this);
            mDownPos = mPos = point.Position;
            e.Handled = true;
            //System.Diagnostics.Debug.WriteLine(
            /*string msg = "TouchDown 【" +
                pos.Position.X + "-" + pos.Position.Y + "】";
            if (test == 0)
            {
                MessageBox.Show(msg);
                test = 1;
            }*/
        }
        void UIElementListPanel_TouchMove(object sender, System.Windows.Input.TouchEventArgs e)
        {
            if (!mTouchDown)
                return;
            TouchPoint pos = e.GetTouchPoint(this);
            double vOffset = pos.Position.Y - mPos.Y;
            mPos = pos.Position;

            setScrollValue(mCurrentScrollPos - vOffset);
            //System.Diagnostics.Debug.WriteLine(
            //string msg = "TouchMove (" + 
            //    pos.Position.X + "-" + pos.Position.Y + ")";
            //throw new NotImplementedException();
            //if (test == 1)
            //{
            //   MessageBox.Show(msg);
            //   test = 0;
            //}
        }

        void UIElementListPanel_TouchUp(object sender, System.Windows.Input.TouchEventArgs e)
        {
            if (!mTouchDown)
                return;
            mTouchDown = false;

            int timestamp = e.Timestamp;

            int timeElapse = timestamp - mTimeStamp;

            //string msg = "Time elapse: " + timeElapse + "msec";

            //MessageBox.Show(msg);

            TouchPoint pos = e.GetTouchPoint(this);
            double vOffset = pos.Position.Y - mDownPos.Y;
            //mPos = pos.Position;
            vOffset *= 1000;
            vOffset /= timeElapse;

            startScrollObserveTimer(vOffset);
            //TouchPoint pos = e.GetTouchPoint(this);
            //System.Diagnostics.Debug.WriteLine(
            //string msg = "TouchUp 【" +
            //    pos.Position.X + "-" + pos.Position.Y + "】";
        }

        void UIElementListPanel_TouchLeave(object sender, TouchEventArgs e)
        {
            mTouchDown = false;
            //throw new NotImplementedException();
        }

        void UIElementListPanel_TouchEnter(object sender, TouchEventArgs e)
        {
            mTouchDown = false;
            //throw new NotImplementedException();
        }
#endif
    }
}
