﻿using NT2chCtrl2;
using NT2chObject;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace NT2chCtrl2
{
    public partial class NTSubjectViewPanel : UserControl, ISubjectView
    {
        private void MenuItemClose_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTBoardData data = btn.Tag as NTBoardData;
            if (data == null)
                return;

            int idx = mBoardList.IndexOf(data);
            if(idx < 0)
                return;

            mBoardList.RemoveAt(idx);


            ObservableCollection<NTThread> orgList = mLstThreadTitle.ItemsSource as ObservableCollection<NTThread>;
            if (orgList == null)
                return;

            int cnt = mBoardList.Count;
            if(idx == cnt)
                idx--;

            if (idx < 0)
            {
                orgList.Clear();
            }
            else
            {
                data = mBoardList[idx];
                mCommand.TryToOpenBoard(data.mBoard);
            }
        }

        private void ListViewItem_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTThread thread = tb.Tag as NTThread;
            if (thread == null)
                return;

            bool existsLog = thread.ReadCnt > 0;

            IThread2 ithread = findThread(thread) as IThread2;
            if (ithread == null)
                return;

            ListItemViewPopup popup = new ListItemViewPopup(ithread, mCommand, existsLog);
            popup.show();
        }

        IThread findThread(NTThread thread)
        {
            List<IThread> list = mCurrentBoard.getThreadList();
            foreach (IThread ithread in list)
            {
                if(ithread.getDatName().Equals(thread.getDatName()))
                    return ithread;
            }
            return null;
        }
        private void MenuItem_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData data = tb.Tag as NTBoardData;
            if (data == null)
                return;

            MenuItemPopup popup = new MenuItemPopup(data.mBoard, mCommand, new CloseTab(this));
            popup.show();
        }

        class CloseTab : NT2chCtrl2.MenuItemPopup.ICloseTab
        {
            NTSubjectViewPanel mParent;
            public CloseTab(NTSubjectViewPanel panel)
            {
                mParent = panel;
            }
            public void CloseAllExceptThis(IBoard iboard)
            {
                int len = mParent.mBoardList.Count;
                NTBoardData data = null;
                int idx = 0;
                for (; idx < len; idx++)
                {
                    data = mParent.mBoardList[idx];
                    if (iboard.getName().Equals(data.BoardName))
                    {
                        break;
                    }
                }
                if (idx == len)
                    return;

                mParent.mBoardList.Clear();
                mParent.mBoardList.Add(data);
                mParent.mCommand.TryToOpenBoard(data.mBoard);
            }

            public void CloseOnTheLeft(IBoard iboard)
            {
                int len = mParent.mBoardList.Count;
                NTBoardData data = null;
                int idx = 0;
                for (; idx < len; idx++)
                {
                    data = mParent.mBoardList[idx];
                    if (iboard.getName().Equals(data.BoardName))
                    {
                        break;
                    }
                }
                if (idx == len)
                    return;
                for (int i = 0; i < idx; i++)
                {
                    mParent.mBoardList.RemoveAt(0);
                }
                mParent.mCommand.TryToOpenBoard(data.mBoard);
            }

            public void CloseOnTheRight(IBoard iboard)
            {
                int len = mParent.mBoardList.Count;
                NTBoardData data = null;
                int idx = 0;
                for (; idx < len; idx++)
                {
                    data = mParent.mBoardList[idx];
                    if (iboard.getName().Equals(data.BoardName))
                    {
                        break;
                    }
                }
                if (idx == len)
                    return;
                for (int i = idx+1; i < len; i++)
                {
                    mParent.mBoardList.RemoveAt(idx+1);
                }
                mParent.mCommand.TryToOpenBoard(data.mBoard);
            }

            public void CloseAll()
            {
                ObservableCollection<NTThread> orgList = 
                    mParent.mLstThreadTitle.ItemsSource as ObservableCollection<NTThread>;
                if (orgList == null)
                    return;
                mParent.mBoardList.Clear();
                orgList.Clear();
            }
 
        }

        NTBoardData mObserveDragData = null;
        Point mObserveMousePoint;
        DateTime mClickedTime = DateTime.Now;
        TextBlock mClickedTextBlock = null;

        private bool chkDblClick(TextBlock tb)
        {
            DateTime dt = DateTime.Now;
            TimeSpan ts = dt.Subtract(mClickedTime);
            if((0 != ((int)(ts.TotalSeconds))) || 
                mClickedTextBlock == null ||
                !mClickedTextBlock.Equals(tb))
            {
                mClickedTextBlock = tb;
                mClickedTime = DateTime.Now;
                return false;
            }
            return true;
        }

        private void MenuItem_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData data = tb.Tag as NTBoardData;
            if (data == null)
                return;
            if (chkDblClick(tb))
            {
                mObserveDragData = null;
                mCommand.UpdateBoard(data.mBoard);
                return;
            }
            mObserveDragData = data;
            mObserveMousePoint = e.GetPosition(tb);

            //e.Handled = true;
        }
        
        private void MenuItem_MouseMove(object sender, MouseEventArgs e)
        {
            if (mObserveDragData == null)
                return;

            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData data = tb.Tag as NTBoardData;
            if (data == null)
                return;

            Point point = e.GetPosition(tb);
            Vector v = Point.Subtract(point, mObserveMousePoint);
            if (v.Length > DragDropData.DRAG_START_MOVE_DELTA)
            {
                DataObject dObj = new DataObject(
                    DragDropData.BOARD_MENU_ITEM_DRAG_DATA, mObserveDragData);
                DragDrop.DoDragDrop(tb, dObj, DragDropEffects.Move);
                //e.Handled = true;
                mObserveDragData = null;

                removeDummyData();
            }

        }

        void MenuItem_DragEnter(object sender, DragEventArgs e)
        {
        //    e.Effects = DragDropEffects.Move;
        //    e.Handled = true;
        }

        void MenuItem_DragOver(object sender, DragEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData data = tb.Tag as NTBoardData;
            if (data == null)
                return;

            string text = tb.Text.Trim();
            if (text.Length > 0)
            {
                removeDummyData();
                return;
            }
            //Point point = e.GetPosition(tb);
            //if(point.X < 20)
            e.Effects = DragDropEffects.Move;
            //else
            //    e.Effects = DragDropEffects.None;
            e.Handled = true;

            insertDummyData(data);

        }

        
        void MenuItem_Drop(object sender, DragEventArgs e)
        {
            
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData target = tb.Tag as NTBoardData;
            if (target == null)
                return;

            string text = tb.Text.Trim();
            if (text.Length > 0)
            {
                removeDummyData();
                return;
            }
          
            IDataObject dataObj = e.Data;

            if (!dataObj.GetDataPresent(DragDropData.BOARD_MENU_ITEM_DRAG_DATA))
                return;

            NTBoardData source =
                    dataObj.GetData(DragDropData.BOARD_MENU_ITEM_DRAG_DATA)
                    as NTBoardData;
            if (source == null)
                return;

            int targetIdx = mBoardList.IndexOf(target);
            int sourceIdx = mBoardList.IndexOf(source);
            if (targetIdx < 0 || sourceIdx < 0)
                return;

            mBoardList.RemoveAt(sourceIdx);

            if (targetIdx > sourceIdx)
                targetIdx--;

            mBoardList.Insert(targetIdx, source);

            removeDummyData();
            e.Effects = DragDropEffects.Move;
            e.Handled = true;
        }

        void insertDummyData(NTBoardData target)
        {
            NTBoardData dummy = NTBoardData.getDummy();
            int targetIdx = mBoardList.IndexOf(target);
            if(targetIdx < 0)
                return;
            int dummyIdx = mBoardList.IndexOf(dummy);
            if (dummyIdx >= 0)
            {
                mBoardList.RemoveAt(dummyIdx);

                if (dummyIdx < targetIdx)
                {
                    targetIdx--;
                }
            }
            mBoardList.Insert(targetIdx, dummy);
        }

        void removeDummyData()
        {
            NTBoardData dummy = NTBoardData.getDummy();
            mBoardList.Remove(dummy);
        }

        private void MenuItem_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (mObserveDragData != null)
            {
                mObserveDragData = null;
            }

            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTBoardData data = tb.Tag as NTBoardData;
            if (data == null)
                return;

            IBoard iboard = data.mBoard;
            mCommand.TryToOpenBoard(iboard);
        }

        private void ListViewItem_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            NTThread thread = tb.Tag as NTThread;
            if (thread == null)
                return;

            ThreadDescrption description = getThreadDescription(thread);
            if (description != null)
                mCommand.OpenThread(description);

        }

        void FavoriteImage_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            if(btn == null)
                return;
      
            NTThread thread = btn.Tag as NTThread;
            if (thread == null)
                return;

            ThreadDescrption threadDesc = getThreadDescription(thread);
            if (threadDesc == null)
                return;

            bool favorite = !thread.IsFavorite;
            if (favorite)
            {
                if (mCommand.AddThreadToFavorite(threadDesc))
                    thread.IsFavorite = favorite;
            }
            else
            {
                if (mCommand.RemoveThreadFromFavorite(threadDesc))
                    thread.IsFavorite = favorite;
            }
        }

        void ColumnHeader_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            TextBlock tb = sender as TextBlock;
            if (tb == null)
                return;

            string tag = tb.Tag as string;
            if (tag == null)
                return;

            ObservableCollection<NTThread> orgList = mLstThreadTitle.ItemsSource as ObservableCollection<NTThread>;
            if (orgList == null)
                return;

            List<NTThread> list = new List<NTThread>();

            foreach (NTThread thread in orgList)
                list.Add(thread);

            //Console.Out.WriteLine(tag);
            switch (tag)
            {
                case "SeqNo":
                    list.Sort(SubjectListSortBySeqNo);
                    break;
                case "F":
                    list.Sort(SubjectListSortByIsFavorite);
                    break;
                case "Title":
                    list.Sort(SubjectListSortByTitle);
                    break;
                case "ResCnt":
                    list.Sort(SubjectListSortByResCnt);
                    break;
                case "ReadCnt":
                    list.Sort(SubjectListSortByReadCnt);
                    break;
                case "RemainCnt":
                    list.Sort(SubjectListSortByRemainCnt);
                    break;
                case "LastMod":
                    list.Sort(SubjectListSortByLastMod);
                    break;
                case "LastWrite":
                    list.Sort(SubjectListSortByLastWrite);
                    break;
            }

            orgList.Clear();
            foreach (NTThread thread in list)
                orgList.Add(thread);
        }
        static int SubjectListSortBySeqNo(NTThread thread1, NTThread thread2)
        {
            return thread1.SeqNo - thread2.SeqNo;
        }

        static int SubjectListSortByIsFavorite(NTThread thread1, NTThread thread2)
        {
            if(thread1.IsFavorite == thread2.IsFavorite)
                return 0;
            return thread1.IsFavorite ? -1 : 1;
        }

        static int SubjectListSortByTitle(NTThread thread1, NTThread thread2)
        {
            return thread2.Title.CompareTo(thread1.Title);
        }
        static int SubjectListSortByResCnt(NTThread thread1, NTThread thread2)
        {
            return thread2.ResCnt - thread1.ResCnt;
        }
        static int SubjectListSortByReadCnt(NTThread thread1, NTThread thread2)
        {
            return thread2.ReadCnt - thread1.ReadCnt;
        }
        static int SubjectListSortByRemainCnt(NTThread thread1, NTThread thread2)
        {
            return thread2.RemainCnt - thread1.RemainCnt;
        }
        static int SubjectListSortByLastMod(NTThread thread1, NTThread thread2)
        {
            DateTime dt1 = DateTime.MinValue;
            DateTime dt2 = DateTime.MinValue;
            try
            {
                dt1 = DateTime.Parse(thread1.LastMod);
            }
            catch { }
            try
            {
                dt2 = DateTime.Parse(thread2.LastMod);
            }
            catch { }

            return dt2.CompareTo(dt1);
        }

        static int SubjectListSortByLastWrite(NTThread thread1, NTThread thread2)
        {
            DateTime dt1 = DateTime.MinValue;
            DateTime dt2 = DateTime.MinValue;
            try
            {
                dt1 = DateTime.Parse(thread1.LastWrite);
            }
            catch { }
            try
            {
                dt2 = DateTime.Parse(thread2.LastWrite);
            }
            catch { }

            return dt2.CompareTo(dt1);
        }
    }
}
