

///////////////////////////////////////////////////////
///// TEST ////////////////////////////////////////////

function testDone(answer){
    var elm = elmFor("resultsArea");
    var obj = JSON.parse(answer);
    var array = [];
    for (date in obj){
        array.push("== " + date + " ==<br>" + obj[date]);
    }
    elm.innerHTML = array.join("<br>");
}
function test(){
    var elm = elmFor("resultsArea");
    elm.innerHTML = "";

    var args = new Object();
    args["patientId"] = "03234200";
    args["yearMonth"] = "2013-08";
    NRCall("GET_TREATMENTS", args, testDone, true);
}

function showArrowBox(){
    var elm = elmFor("resultsArea");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.padding = "10px";
    div.style.backgroundColor = "#eee";

    var dv = newDIV(div, "/balloon-1-top");
    dv.innerHTML = "Arrow Box";
}

////////////////////////////////////////////////////////////////
///// PHP7 /////////////////////////////////////////////////////

function NRDebug(){
    // サーバから返された処理を実行
    if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
        var value = xmlHttpObject.responseText;
        console.log("=== NRDebug ===<br>\n"+value); //## 返されたメッセージを debug 用に表示
    } 
}

function testPHP7(){
    xmlHttpObject = createXMLHttpRequest(NRDebug);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        xmlHttpObject.open("GET", "./php7.php", true);
        xmlHttpObject.send(null);
    }
}

////////////////////////////////////////////////////////////////
///// 文字数制限メニュー //////////////////////////////////////////

function showMenuResult(){
    elmFor("resultsArea").innerHTML = selectedLimitedMenu();
}
function openLimitedMenu(){
    var elm = elmFor("resultsArea");
    elm.innerHTML = "";
    
    // 文字列制限メニューを生成
    var menus = ["","短メニュー","これはとてもとても長いメニュー","これは中間のメニュー"];
    makeLimitedMenu(elm, menus, "", 5);
    var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "showMenuResult()");
    
    var div = newDIV(elm, "resultsArea");
    div.style.fontSize = "10pt";
}

////////////////////////////////////////////////////////////////
///// 祝日リストの読込み //////////////////////////////////////////

function checkDate(){
    // ポップアップの日付が祝日かどうかチェック
    var date = elmFor("datePop").value;
    var array = arrayWithDateTime(date);
    var year = array[0];
    var elm = elmFor("resultArea");
    
    if (hasHolidays(year) == false){
        getHolidays(year, alert);
        elm.innerHTML = "";
        var sp = newSPAN(elm, "");
        sp.innerHTML = year + " の祝日を読込みます";
        sp.innerHTML += "<br>読込んだメッセージが出たら実行してください";
        sp.style.fontSize = "10pt";
        sp.style.color = "#00f";
        return;
    }

    var title = isHoliday(date);
    if (title){
        elm.innerHTML = title;
    } else {
        // 祝日リストを表示
        elm.innerHTML = "";
        var tbl = newTABLE(elm, "/base-table");
        tbl.style.fontSize = "10pt";
        
        var array = holidays();
        for (num in array){
            var rec = array[num];
            var tr = newTR(tbl, "", "");
            var td = newTD(tr, "", rec.date);
            var td = newTD(tr, "", rec.title);
        }
    }
}
function checkHolidays(){
    //_initDebug(true); //##
    
    var elm = elmFor("resultsArea");
    elm.innerHTML = "";
    
    var div1 = newDIV(elm, "popupArea");
    var div2 = newDIV(elm, "resultArea");
    var array = arrayWithDateTime(today());
    var yyyy = array[0];
    var mm = array[1];
    var dd = array[2];
    var pu = newDatePopUp(div1, "datePop", "", yyyy, mm, dd, false, null);
    var bt = newDIV(div1, "/whiteButton");
    bt.innerHTML = "OK";
    bt.setAttribute("onclick", "checkDate()");
    
    if (hasHolidays(yyyy) == false)
        getHolidays(yyyy, alert);
}

function printTest(){
	var url = "./printTest.php";
    
	var win = window.open(url, "_blank");
	win.document.title = "PRINT"; // window title に "PRINT" 表示
	win.focus();
}

function showOffButton(id){
    var div = elmFor(id);
    div.innerHTML = "";
    div.style.margin = "5px 0";
    
    var btn = newDIV(div, "/on-button");
    btn.innerHTML = "";
    btn.setAttribute("onclick", "showOnButton('" + id + "')");
    btn.style.backgroundColor = "#faa";
    btn.style.padding = "2px 0 0px 20px";

    var bt = newDIV(btn, "/child-button");
    bt.innerHTML = "x";
    bt.style.padding = "0 8px";
}
function showOnButton(id){
    // on / off button 表示テスト
    var div = elmFor(id);
    div.innerHTML = "";
    div.style.margin = "5px 0";
    
    var btn = newDIV(div, "/on-button");
    btn.innerHTML = "";
    btn.setAttribute("onclick", "showOffButton('" + id + "')");
    btn.style.backgroundColor = "#aec";
    btn.style.padding = "2px 20px 0px 0";
    
    var bt = newDIV(btn, "/child-button");
    bt.innerHTML = " ";
    bt.style.padding = "0 8px";
}

function initTestBench(){
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    var pframe = new PictureFrame(elm, "40%", "50%");
    
	// HEADER ==============================
    pframe.headerLeft.innerHTML = "TestBench";
    
    // BODY ===========================
    // test menu
    var div = newDIV(pframe.body, "menuArea");
    div.style.padding = "5px 0";
    
    // 祝日リスト
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "祝日リスト";
	bt.setAttribute("onclick", "checkHolidays()");

    // iOS テスト
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "iOS テスト";
	bt.setAttribute("onclick", "initIosTest()");
    
    // プリント・テスト
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "プリント";
	bt.setAttribute("onclick", "printTest()");
    
    // プリント・テスト
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "on / off button";
	bt.setAttribute("onclick", "showOnButton('resultsArea')");
    
    // ArrowBOx
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "ArrowBox";
    bt.setAttribute("onclick", "showArrowBox()");
    
    // PHP7
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "PHP7";
    bt.setAttribute("onclick", "testPHP7()");
    
    // テスト
    var bt = newDIV(div, "/blueButton");
    bt.innerHTML = "test";
	bt.setAttribute("onclick", "test()");
    
	// コンテンツ表示エリア
    var div = newDIV(pframe.body, "resultsArea");
    div.style.fontSize = "9pt";
	
	// FOOTER ==============================
    pframe.footerLeft.innerHTML = test_version();


    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "TEST ツール";
}

function test_version(){
    return "Ver.150724";
}