/*
var _image;
function setImage(img){
    _image = img;
}
function image(){
    // image object を返す： _image.src, _image.width などを利用
    return _image;
}
*/

///// 受診者カルテに付属する画像を読込する /////

///////////////////////
///// dragAndDrop /////

function FileDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    console.log("FileDrop", file.type); //###
/*    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
*/    
    setImageName(file.name);
   
    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
        if (img.src.indexOf('data:image/tiff;') >= 0){
            alert("TIFF 型式の画像はサポートされていません");
            return;
        }
        setImageSrc(e.target.result); // 画像保存
    }

    // canvas へ描画
    img.onload = function() {
        var ctx = can.getContext("2d");
        var width = can.width;
        var height = can.height;
        
        // 再描画前に今までのイメージを消去
        ctx.clearRect(0, 0, width, height);
        
        // 画像を表示するクリッピング領域を設定
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(width, 0);
        ctx.lineTo(width, height);
        ctx.lineTo(0, height);
        ctx.clip();
        
        // 画像の高さが can.height に収まるよう縮尺して表示
        // ここでは img.onload 時点の img を使う：image() では width,height 未記録
        var w = img.width * height / img.height;
        ctx.drawImage(img, 0, 0, w, height);  
    }
    reader.readAsDataURL(file);

    // ドロップされた画像をサーバへ保存
//    saveImage();
//    return;

    // 保存ボタンを表示
    var elm = elmFor("saveButtonArea");
    elm.innerHTML = "";
    var bt = newDIV(elm, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveImage()");

}

///// dragAndDrop /////
///////////////////////

function file_append(){
	// ファイル選択ボタンを増やす
	var elm = document.getElementById("file");
    var dv = newDIV(elm, "");
	var ub = newUploadBUTTON(dv, "", "files[]");
}

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    putWindowSize(); // ウインドー・サイズを記憶
    
    setTimeout(getImages, 3000);
}

function makeImagePane(ul, file){
    // path からイメージを生成し elm へ表示
    // === サムネイルを表示 ========================
    var div = newDIV(ul, "");
    var sp = newSPAN(div, "");
    var path = imagePath();
    var img = makeThumbnail(ul, path, file);
    sp.innerHTML = img;
    var url = path + "/" + file;
    // url = "../NOA_ARCHIVE/03234200/20130527185022_0.png" 形式
    sp.setAttribute("onclick", "open_image('"+url+"')");
    if (pictureExpand())
        sp.setAttribute("class", "thumb-nail"); // マウスがのると画像が拡大
    // カルテに埋め込むためのタグを生成
    //var path = "/NOA_ARCHIVE/"+patientId()+"/";
    var tag = "<IMG:" + url + ">";
    sp.addEventListener("dragstart",
                        function(ev) {
                        var dt = ev.dataTransfer;
                        dt.setData("text/plain", tag);
                        return true;
                        },
                        false);
    
    // === 画像削除アイコンとファイル名を表示 ==========
    var height = thumbNailSize();
    if (height * 1 > 90){
        var dv = newDIV(div, "");
        var sp = newSPAN(dv, "");
        sp.style.paddingLeft = "5px";
    } else { // サムネイルが小さい場合はファイル名を同じ行に表示
        var dv = div;
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
    }
    // ファイル名
    var sp = newSPAN(dv, "");
    sp.innerHTML = file;
    sp.style.margin = "0 5px";
    sp.style.fontSize = "9pt";
    if (paneType() == _patientImageType){ // カルテ添付ペーン
        sp.setAttribute("class", "listMember");
        sp.setAttribute("onclick", "pastePicture(this)");
    }
    
    // イメージを削除ボタン
    var img = newIMAGE(dv, "", "./remove-field.png", "");
    img.setAttribute("onclick", "removeImage('"+path +"','"+file+"')");
    img.style.height = "12px";
    img.style.position = "relative";
    img.style.bottom = "-3px";
}

function showIconsVertical(files){
	// 添付ファイルをサムネールとして縦横表示
	var div = elmFor("thumbNailRow");
	div.innerHTML = "";
    
    var dv = newDIV(div, "");
    dv.style.marginBottom = "8px";
    // 画像拡大チェックボックス
    var sp = newSPAN(dv, "expandCheckBox");
    var cb = newCHECKBOX(sp, "", "画像拡大", pictureExpand());
    cb.setAttribute("onchange", "setPictureExpand(this)");
    setInfoTip("expandCheckBox", "マウスで画像拡大"); // INFO TIP
    // 画像転記の確認チェックボックス
    if (paneType() == _patientImageType){
        var sp = newSPAN(dv, "copyCheckBox");
        var cb = newCHECKBOX(sp, "", "転記確認", confirmPictureCopy());
        cb.setAttribute("onchange", "setConfirmPictureCopy(this)");
        setInfoTip("copyCheckBox", "画像転記の際 確認"); // INFO TIP
    }
	
	// image ファイルの配列を生成
    var ul = newUL(div, "");
    ul.style.margin = "0";
    ul.style.paddingLeft = "8px";
	for (num in files){
		var filename = files[num];
		if (filename.charAt(0) == ".") continue;
        
        // image のクリックで別パネルに image 表示
        makeImagePane(ul, filename);
	}
}

