

////////////////////////////////////////
/// Ajax による処理 //////////////////////

var _currentCode;
function setCurrentCode(code){
    _currentCode = code;
}
function currentCode(){
    // 現在選択されているコードを返す
    return _currentCode;
}

var _records;
function setRecords(array){
    _records = new Object();
    for (num in array){
        var rec = array[num];
        _records[rec.name] = rec;
    }
}
function records(){
    // 現在選択されているコードに対応するレコード・オブジェクトを返す
    return _records;
}
function urlForName(name){
    // 薬剤名に該当する URL を返す
    var rec = _records[name];
    var memo = rec.memo;
    if (!memo || (memo.length == 0)) return null;
    
    // rec.meno の中に "鎮痛・抗炎症剤 URL:voltaren.pdf ..." のような形でデータが入っている
    var array = memo.split("URL:");
    if (array.length > 1){
        var st = array[1];
        var ary = st.split(" ");
        return ary[0];
    } else {
        return null;
    }
}

function effectArray(){
	// type(約束、内用、屯用、外用) に応じた効能リストを返す
	var effectObj = new Object();
	var obj = records();
    for (name in obj){
        var rec = obj[name];
		var effects = rec.effect; // "鎮痛 解熱" 形式
		if (!effects || (effects.length == 0)) continue;
		
		var ary = effects.split(" ");
        for (j in ary){
			var effect = ary[j]; // "鎮痛" 形式
			// 効能をユニークにするため object の添字として保存
			if (effect.length) effectObj[effect] = name;
		}
	}
	
	// ユニークな効能を array に入れて返す
	var array = new Array();
	for (key in effectObj)
		array.push(key);
	array.sort();
	return array;
}

function gotRecord(answer){
    //alert("gotRecord->"+answer); //##
    if (answer && (answer.length > 0)){
        var array = JSON.parse(answer);
        setRecords(array);
        //alert("->"+encodeObject(array)); //##
        
        showPopupMenu();
    } else {
        var elm = elmFor("popupMenuArea");
        elm.innerHTML = "";
        var sp = newSPAN(elm, "");
		sp.innerHTML = "データを読み込んでいます ...";
        sp.style.fontSize = "9pt";
        sp.style.padding = "3px 0 0 10px";
        sp.style.color = "#f00";
    }
}
function typeSelected(elm){
	// PHPサーバへリクエストを送り、データが返送されたら func() で受ける
    var code = null;
    if (elm.value == "内用")
        code = "21";
    else if (elm.value == "屯用")
        code = "22";
    else if (elm.value == "外用")
        code = "23";
    
    setCurrentCode(code);
    
    var args = new Object();
    args['code'] = code;
    
    _callServer("GET_LIST", "priceListServer.php", args, gotRecord);
}

function gotDocument(answer){
    //alert("gotDocument ->"+answer); //##
    // Image を別ウインドウで表示
    var url = encodeSTRING(answer);
    var win = window.open("imageViewer.php?value=" + url, ""
                          ,"width=1000,height=1000,scrollbars=yes,resizable=yes");
    win.focus();
}
function getDocument(elm, isPanel){
    // ポップアップ・メニューで選択された名称に対する画像ファイルをサーバへリクエスト
    var name = (isPanel) ? elm.innerText : elm.value;
    var url = urlForName(name);
    //alert(name+"-> "+url); //------
    
    if (url){
        // 間違って上位の path がついている場合があるので最下位の path にする
        var ary = url.split("/");
        url = ary[ary.length - 1];
        _debug("-> "+url); //------
        
        var args = new Object();
        args['filename'] = encodeSTRING(url);
        
        _callServer("GET_FILE", "priceListServer.php", args, gotDocument);
    } else {
        //alert(elm.value + " の添付書類は登録されていません");
        openManTool(name); // マニュアル取込ツールを開く
    }
}

/// Ajax による処理 //////////////////////
////////////////////////////////////////


////////////////////////////////////////
/// localStorage ///////////////////////

function setDocViewerMenuType(elm){
    // DocView のメニュー表示型式を記憶
    window.localStorage["docViewerMenuType"] = (elm.checked) ? "1" : "0";

    showPopupMenu();
}
function docViewerMenuType(){
    var status = window.localStorage["docViewerMenuType"];
    
    return (status && status * 1) ? true : false;
}

/// localStorage ///////////////////////
////////////////////////////////////////


function showMenu(menus){
    // 薬剤名メニューを表示
    var elm = document.getElementById("popupMenuArea");
    elm.innerHTML = "";

    if (docViewerMenuType() == true){ // パネル型式のメニュー
        var div = newDIV(elm, "");
        div.style.padding = "8px";
        for (num in menus){
            var bt = newDIV(div, "/blueButton");
            bt.innerHTML = menus[num];
            bt.setAttribute("onclick", "getDocument(this,'panel')");
        }
    } else { // ロータリー型式のメニュー
        //_initDebug(true); //##
        _debug("docViewerMenuType->"+docViewerMenuType()); //##
        _debug("->"+menus.join("<br>")); //##
        
        menus.splice(0, 0, "");
        var pu = newPopupMenu(elm, "namePopup", menus, "");
        pu.setAttribute("onchange", "getDocument(this)");
    }
    
    // 絞込フィールドを表示
    var elm = elmFor("narrowArea");
    elm.innerHTML = "";
    var fd = newFIELD(elm, "narrowF", "", 15, "");
    fd.setAttribute("placeholder", "絞込キー"); // info 入力ヒントを表示
    fd.setAttribute("onchange", "narrowItems()");
    fd.focus();
    var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "絞込";
    bt.setAttribute("onclick", "narrowItems()");
}

function showPopupMenu(){
    // 薬剤名メニューを生成
    
    // この処理を allKeys() に任せずこのメソッド内で処理すると、どういう訳か
    // 以後ツール類が別ウインドウで立ち上がってしまう
    var menus = allKeys(records());
    
    showMenu(menus);
}


//////////////////////////////////////////////////////////
///// 薬効で絞込 ///////////////////////////////////////////

function yakkouClicked(elm){
	// 薬効が選択されたら、それに一致した薬剤ポップアップを生成表示
	var yakkou = elm.innerHTML;
	closeFloatPanel();
    
	// 絞り込みキーを基に薬品名リストを作成
    var menus = new Array();
    var obj = records();
    for (name in obj){
        var rec = obj[name];
		var effects = rec.effect; // "鎮痛 解熱" 形式
		if (!effects || (effects.length == 0)) continue;
        if (effects.indexOf(yakkou) < 0) continue;
        
        menus.push(name);
    }
    showMenu(menus);
}
function openEffectPanel(){
	// 薬効で絞込のためのパネルを表示
    if (! currentCode()){
        alert("用法が選択されていません");
        return;
    }
    
    var w = 310;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "薬効で絞込み";
    var elm = openSeeThroughPanel("_floatPanel",x,y,w,title,"formEditorHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "5px";
 
    // パネル・メニューを表示
    var div = newDIV(elm, "");
    div.style.backgroundColor = "#fff";
    div.style.padding = "5px";
    div.style.borderRadius = "10px";
    
    var array = effectArray();
    for (num in array){
        var sp = newDIV(div, "/blueButton");
        sp.innerHTML = array[num];
        sp.setAttribute("onclick", "yakkouClicked(this)");
    }
}

///// 薬効で絞込 ///////////////////////////////////////////
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
///// 絞込キーによる絞込 ////////////////////////////////////

function narrowItems(){
    // 絞込キーによる絞込実行
    var item = elmFor("popup").value;
    if (item.length == 0){
        alert("用法が選択されていません");
        return;
    }
    
	// 絞り込みキーを基に薬品名リストを作成
    var key = elmFor("narrowF").value;
    var menus = new Array();
    var obj = records();
    for (name in obj){
        if (key.length > 0){
            var rec = obj[name];
            if (rec.alias.indexOf(key) < 0) continue;
        }
        
        menus.push(name);
    }

    showMenu(menus);
}

///// 絞込キーによる絞込 ////////////////////////////////////
//////////////////////////////////////////////////////////

function openManTool(name){
    // ガイド・パネルを開く
	window.open("./manTool.php?name="+name,"_blank");
}

function help(){
	// ヘルプパネルを表示
    window.open("./docViewerHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openDocViewer(){
    // Prescription/index.html から起動され、薬剤添付文書閲覧ツールを開く
    
    //_initDebug(true); //##
    var base = document.getElementById("base");
    base.innerHTML = "";
    
    // HEADER ================================
    var div = newDIV(base, "/tool-header");
    // -- LEFT ------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // ラベル
    var sp = newSPAN(dv, "");
    sp.innerHTML = "薬剤添付文書 閲覧";
    // -- RIGHT ----------
    var dv = newDIV(div, "/right-side");
    // HELP
    var img = newIMAGE(dv, "", "Help.png", "Help");
    img.setAttribute("onclick","help()");
    img.style.width = "19px";
    img.setAttribute("class", "expandIcon");
    
    // docMaker BODY =====================================
    var div = newDIV(base, "contentsArea");
    div.style.padding = "10px 5px";
    
    // 薬剤タイプ選択
    var dv = newDIV(div, "typePopArea");
    dv.style.fontSize = "10pt";
    var array = ["", "内用", "屯用", "外用"];
	var pu = newPopupMenu(dv, "popup", array, "");
    pu.setAttribute("onchange", "typeSelected(this)");
    
    // 薬効ボタン
    var bt = newDIV(dv, "/flatButton");
    bt.innerHTML = "薬効";
    bt.setAttribute("onclick", "openEffectPanel()");
    bt.style.marginLeft = "5px";
    
    // 表示形式チェックボックス
    var sp = newSPAN(dv, "");
    sp.style.fontSize = "9pt";
    var status = docViewerMenuType(); // localStrorage
    var cb = newCHECKBOX(sp, "", "パネル型式", status);
    cb.setAttribute("onchange", "setDocViewerMenuType(this)"); // localStorage.js
    
    // 絞込エリア
    var sp = newSPAN(dv, "narrowArea");
    sp.style.paddingLeft = "5px";
    
    // 薬剤名選択
    var dv = newDIV(div, "popupMenuArea");

    // FOOTER ==========================================
    var div = newDIV(base, "/tool-footer");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "薬剤添付文書閲覧ツール";
}

function version(){
    // Development started at 2013-10-07.
    return "Ver.140607";
}