

/////////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////////

function gotLimittedVisitor(answer){
    // 受診者リストを表示
    obj = JSON.parse(answer);
    
    // obj = '11108400(name(村岡　敬子)lvd(2013-07-22 09:48:22))11187000(name(丸山 かえで)lvd(2013-07-22 10:42:03))' 型式
	var elm = parent().elmFor("workArea");
    elm.innerHTML = "";
    
    //alert(encodeObject(obj)); //##
    
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.margin = "3px";
    
    var tr = newTR(tbl, "", "");
    tr.style.background = "#eee";
    var td = newTD(tr, "", "");
    td.style.width = "150px";
    var im = newIMAGE(td, "icon", "./close.png", "?");
    im.style.height = "12px";
    im.setAttribute("onclick", "closeWorkArea()");
    im.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "");
    sp.innerHTML = "最終受診日";
    sp.style.paddingLeft = "5px";
    var td = newTD(tr, "", "カルテID");
    td.style.width = "100px";
    var td = newTD(tr, "", "氏名");
    
    var srcObj = new Object();
    var count = 0;
    for (lvd in obj){
        var rec = obj[lvd];
        var tr = newTR(tbl, "/row", "");
        var action = "parent().openChartAsAnotherWindow('"+rec.patientId+"')";
        tr.setAttribute("onclick", action);
        var td = newTD(tr, "", lvd);
        var td = newTD(tr, "", rec.patientId);
        td.style.paddingLeft = "5px";
        var td = newTD(tr, "", rec.name);
        
        srcObj[rec.patientId] = lvd;
        count++;
    }
    
    // listMaker 用データを localStorage に記憶
    setListMakerSrc(srcObj); 
    
    var tr = newTR(tbl, "", "");
    tr.style.background = "#eee";
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "3");
    td.style.paddingLeft = "5px";
    // listMaker を立ち上げるボタンを生成
    var img = newIMAGE(td, "outArrow", "./outArrow.png", "?");
    img.style.height = "14px";
    img.setAttribute("onclick", "openListMaker()");
    img.setAttribute("class", "expandIcon");
    //setInfoTip("outArrow", "検索結果を別パネルで詳細表示"); // INFO
    var sp = newSPAN(td, "");
    sp.innerHTML = count + " 件 みつかりました";
    sp.style.paddingLeft = "5px";
}
function getConditionalPatient(from, to){
    // fromDate, toDate の期間の受診者をリストアップ
    var args = new Object();
    args["fromDate"] = from;
    args["toDate "] = to;

    NRCall("GET_CONDITIONAL_PATIENT", args, gotLimittedVisitor);
}

///// Ajax //////////////////////////////////////////////////
/////////////////////////////////////////////////////////////


function search(){
    // 指定された年月日以後受診していないカルテを検索

    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "finderWindowSize");
    
    var from = "";
    var val = document.getElementById("fromPop").value;
    var array = val.split("-");
    if (array.length == 3){
        from = val + " 00:00:00";
    }

    var to = "";
    var val = document.getElementById("toPop").value;
    var array = val.split("-");
    if (array.length == 3){
        to = val + " 23:59:59";
    }
    
    if (!from && !to){
        alert("年月日が指定されていません");
    } else {
        if (from == "")
            from = "0000-00-00 00:00:00";
        if (to == "")
            to = todayAndTime();

        // listMaker へ渡す情報を localStorage に記憶
        var st = "受診日検索（ ";
        st += from + " から " + to + " までの受診者の検索結果 ）";
        setListMakerHeader(st);

        getConditionalPatient(from, to);
    }
    
    // window size を記憶
    putFinderWindowSize();
}

function makeLvdSearcher(){
    // 最終受診日からの検索画面を生成：search.js から使う
	var elm = elmFor("lvdSearchArea");
    elm.innerHTML = "";
    elm.style.fontSize = "9pt";
    
    // === CONTENTS ======================
    var div = newDIV(elm, "");
    makeTodayPop(div, "fromPop", "から");
    makeTodayPop(div, "toPop", "まで");
    
    // button
    var dv = newDIV(elm, "");
    dv.style.textAlign = "right";
    dv.style.marginRight = "20px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "の期間で最後に受診したカルテを";
    var bt = newDIV(sp, "/greenButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "search()");
    bt.style.marginLeft = "5px";
    

    function makeTodayPop(elm, id, label){
        // 年月日ポップアップを生成
        var div = newDIV(elm, "");
        var sp = newSPAN(div, "");
        var array = today().split("-");
        var yyyy = array[0] * 1;
        var mm = array[1] * 1;
        var dd = array[2] * 1;
        var pm = newDatePopUp(sp, id, "平成", yyyy, mm, dd, false, null);
        var sp = newSPAN(div, "");
        sp.innerHTML = label;
        sp.style.paddingLeft = "3px";
    }
}
function initLvdSearcher(){
    //_initDebug(false); //##

	var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
    
	// === HEADER =======================
    var div = newDIV(elm, "");
    var dv = newDIV(div, "/tool-header");
    dv.innerHTML = "最終受診日検索";
    dv.style.fontSize = "12px";
    dv.style.paddingLeft = "10px";
    
    // === CONTENTS ======================
    var div = newDIV(elm, "");
    div.style.padding = "5px 0px";

    var dv = newDIV(div, "lvdSearchArea");
    makeLvdSearcher();

	// === FOOTER ===================
    var div = newDIV(elm, "");
	var tbl = newTABLE(div, "/base-table");
	var tr = newTR(tbl, "/tool-footer", "");
	var td = newTD(tr, "/left-side", version());
	var td = newTD(tr, "", "");
}

function version(){
	return "Ver.130725";
}
