//////////////////////////////////////////////////////////////////////////////
// $Id$
//
// a2da-defines.h
// A2DA Data structure definition file
//
// (C) 2003, NNsi project, all rights reserved.
//

#include <PalmOS.h>

// DA creator
#define A2DA_Creator 'a2DA'

// font width 
struct A2DAcharFontWidth
{
    UInt16        charCode;        // LN^R[h
    UInt16        fontWidth;       // tHg̕
};
typedef struct A2DAcharFontWidth A2DAcharFontWidth;

// A2DA AA view form globals
// structure:
struct A2DADataType
{
    UInt16        scale;           // \{
    UInt32        os5density;      // PalmOS5̉𑜓x
    RectangleType dimF;            // \̈̃TCY(coord̈)
    RectangleType area;            // \̈̃TCY(̈)
    UInt16        maxX;            // `GA̍őTCY(x)
    UInt16        maxY;            // `GA̍őTCY(y)
    UInt16        startX;          // `Jnꏊ
    UInt16        startY;          // `Iꏊ
    UInt16       *singleWidth;     // VOoCg̕
    UInt16       *doubleWidth;     // _uoCg̕
    UInt16        singleDbSize;
    A2DAcharFontWidth *singleDB;
    UInt16        doubleDbSize;
    A2DAcharFontWidth *doubleDB;    
};
typedef struct A2DADataType  A2DADataType;

// global feature id:
#define ADT_FTRID       1
#define ADT_FTRID_MEM   2

// other definitions...
#define MARGIN    16

// AA scale type
#define A2DA_SCALE_11   0
#define A2DA_SCALE_23   1
#define A2DA_SCALE_12   2
#define A2DA_SCALE_14   3

// NNsiƂ̘Ag@\p`
#define A2DA_NNSIEXT_DATASTART    "<NNsi:NNsiExt "
#define A2DA_NNSIEXT_ENDDATA      "</NNsi:NNsiExt>"
#define A2DA_NNSIEXT_SOURCE       "<NNsi:Source>"
#define A2DA_NNSIEXT_ENDSOURCE    "</NNsi:Source>"

#define A2DA_NNSIEXT_SOURCE_STREAM "stream"  // f[^\[Xw

#define A2DA_NNSIEXT_DATANAME     "<NNsi:Name>"
#define A2DA_NNSIEXT_ENDDATANAME  "</NNsi:Name>"
