/*============================================================================*
 *  FILE: 
 *     nnshmain.c
 *
 *  Description: 
 *     Main routines for NNsh. 
 *
 *===========================================================================*/
#define THRMNG_C
#include "local.h"

static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR);
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS);
static Boolean set_SearchTitleString     (void);
static Boolean search_NextTitle          (Int16 direction);
static Boolean display_message           (void);
static Boolean get_all_message           (void);
static Boolean update_message            (void);
static Boolean update_getall_message     (void);
static Boolean delete_notreceived_message(Boolean update);
static Boolean delete_message            (void);
static Boolean get_subject_txt           (void);
static Boolean popEvt_ThreadMain         (EventType *event);
static Boolean keyDownEvt_ThreadMain     (EventType *event);
static Boolean ctlSelEvt_ThreadMain      (EventType *event);
static Boolean ctlRepEvt_ThreadMain      (EventType *event);
static Boolean menuEvt_ThreadMain        (EventType *event);

static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect);

extern void    Initialize_NNshSetting(FormType *frm);
extern void    Effect_NNshSetting    (FormType *frm);
extern Boolean Handler_NNshSetting   (EventType *event);
extern Boolean Handler_JumpSelection(EventType *event);

#ifdef USE_HANDERA
/*-------------------------------------------------------------------------*/
/*   Function : change_handera_rotate                                      */
/*                                                         HandEraʉ] */
/*-------------------------------------------------------------------------*/
static void change_handera_rotate(void)
{
    FormType            *frm;
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h

    frm = FrmGetActiveForm();
    if(NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
        VgaSetScreenMode(screenMode1To1, VgaRotateSelect(handEraRotateMode));
        HandEraResizeForm(frm);
        FrmDrawForm(frm);
        Update_Thread_List(NNshParam->lastBBS, 
                           NNshParam->selectedTitleItem,
                           NNSH_STEP_REDRAW);
    }
    else
    {
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
    }
    return;
}
#endif

/*-------------------------------------------------------------------------*/
/*   Function : updateSelectionItem                                        */
/*                                                          item̑IXV */
/*-------------------------------------------------------------------------*/
static void updateSelectionItem(Int16 direction)
{
    Int16          item;
    FormType      *frm;
    RectangleType  dimF;
    UInt16         fontID, nlines, fontHeight;

    item = NNshParam->selectedTitleItem + direction; 
    if ((item >= 0)&&(item < NNshGlobal->nofTitleItems))
    {
        // IACeړ
        frm  = FrmGetActiveForm();
        FrmGetObjectBounds(frm,
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);
        if (NNshParam->useSonyTinyFontTitle == 0)
        {
            fontID = NNshParam->currentFont;
        }
        else
        {
            fontID = NNshParam->sonyHRFontTitle;
        }
        NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                             &fontID, &fontHeight, &nlines);

        // Xꗗ̕\(`)
        NNsi_WinUpdateList(item,
                           NNshParam->selectedTitleItem,
                           NNshGlobal->msgTitleIndex,
                           nlines,
                           &dimF,
                           fontHeight);
        NNshParam->selectedTitleItem = item;
    }
    else
    {
        // y[Wړ
        if (item > 0)
        {
            if ((NNshParam->titleDispState == NNSH_DISP_HALFWAY)||
                (NNshParam->titleDispState == NNSH_DISP_UPPERLIMIT))
            {	
                // y[W\
                Update_Thread_List(NNshParam->lastBBS,
                                   0,
                                   NNSH_STEP_PAGEUP);
            }
        }
        else
        {
            if ((NNshParam->titleDispState == NNSH_DISP_HALFWAY)||
                (NNshParam->titleDispState == NNSH_DISP_LOWERLIMIT))
            {	
                // Oy[W\
                Update_Thread_List(NNshParam->lastBBS,
                                   NNSH_ITEM_LASTITEM,
                                   NNSH_STEP_PAGEDOWN);
            }
        }
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : change_list_font                                           */
/*                                                            tHgύX */
/*-------------------------------------------------------------------------*/
static void change_list_font(void)
{
    FormType *frm;
    ListType *lstP;
    UInt16    selB;

    // tHgID̑I
    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        // ʏ`惂[hptHg̕ύX
        NNshParam->currentFont = FontSelect(NNshParam->currentFont);
    }
    else
    {
        // nC][hptHg̕ύX
        NNshParam->sonyHRFontTitle = FontSelect(NNshParam->sonyHRFontTitle);
    }

    // tHgύX̕\́AXgč쐬ĕ\
    frm  = FrmGetActiveForm();
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selB = LstGetSelection(lstP);
    Update_Thread_List(selB, NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : change_graph_mode                                          */
/*                                        OtBbN`惂[h̐؂ւ */
/*-------------------------------------------------------------------------*/
static void change_graph_mode(void)
{
    FormType *frm;
    ListType *lstP;
    UInt16    selB;

    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        // nC][h֕ύX
        NNshParam->useSonyTinyFontTitle = 1;
    }
    else
    {
        // ʏ`惂[h֕ύX
        NNshParam->useSonyTinyFontTitle = 0;
    }

    // `惂[hύX̕\́AXgč쐬ĕ\
    frm  = FrmGetActiveForm();
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selB = LstGetSelection(lstP);
    Update_Thread_List(selB, NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : setMultiPurposeSwitch                                      */
/*                                          ړIXCb`ɏf[^ݒ */
/*-------------------------------------------------------------------------*/
static void setMultiPurposeSwitch(FormType *frm, UInt16 itemID, UInt16 btnID)
{
    UInt16       data;
    ControlType *ctlP;

    // ړIXCb`ɐݒ肳ꂽڂɂ킹ăf[^擾
    switch (itemID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        data = NNshParam->enablePartGet;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        data = NNshParam->convertHanZen;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        data = NNshParam->useProxy;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        // mFȗ
        data = NNshParam->confirmationDisable;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        data = NNshParam->getAllThread;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        data = NNshParam->useSonyTinyFontTitle;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        data = NNshParam->printNofMessage;
        break;

      case NNSH_SWITCHUSAGE_GETRESERVE:
        // X擾\
        data = NNshParam->getReserveFeature;
        break;

      case NNSH_SWITCHUSAGE_IMODEURL:
        // i-mode URLgp
        data = NNshParam->useImodeURL;
        break;

      case NNSH_SWITCHUSAGE_BLOCKDISP:
        // ][\[h
        data = NNshParam->blockDispMode;
        break;

      case NNSH_SWITCHUSAGE_MACHINEW:
        // ܂BBSVmF{
        data = NNshParam->enableNewArrivalHtml;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ(`FbN{bNX̉ʕ\Ȃ)
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, btnID));
        CtlSetValue  (ctlP, 0);
        CtlSetEnabled(ctlP, false);
        CtlSetUsable (ctlP, false);
        return;
        break;
    }
    // ݒlʂɔf
    SetControlValue(frm, btnID, &data);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : updateMultiPurposeSwitch                                   */
/*                                                  ړI{^ꂽ */
/*-------------------------------------------------------------------------*/
static Boolean updateMultiPurposeSwitch(UInt16 paramID, UInt16 btnID)
{
    Boolean ret;
    UInt16  data;
    Char    *ptr;

    // f[^̏
    ret = false;
    data = 0;
    ptr  = "";

    // ݒ肳ꂽf[^擾
    UpdateParameter(FrmGetActiveForm(), btnID, &data);
    switch (paramID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        NNshParam->enablePartGet = data;
        ptr = MSG_PARTGET_MODE;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        NNshParam->convertHanZen = data;
        ptr = MSG_HANZEN_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        NNshParam->useProxy = data;
        ptr = MSG_USEPROXY_MODE;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        if (data == 0)
        {
            // mFȗ
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
        }
        else
        {
            // _CAOSďȗ
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        }
        ptr = MSG_OMITCONFIRM_MODE;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        NNshParam->getAllThread = data;
        ptr = MSG_GETALLSUBJECT_MODE;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        NNshParam->useSonyTinyFontTitle = data;
        ptr = MSG_GRAPHIC_DRAW_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        NNshParam->printNofMessage = data;
        ptr = MSG_SHOWMESSAGENUM_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_GETRESERVE:
        // X擾\
        NNshParam->getReserveFeature = data;
        ptr = MSG_GETRESERVE_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_IMODEURL:
        // i-mode URLgp[h
        NNshParam->useImodeURL = data;
        ptr = MSG_IMODEURL_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_BLOCKDISP:
        // ][\[h
        NNshParam->blockDispMode = data * NNSH_BLOCKDISP_NOFMSG;
        ptr = MSG_BLOCKDISP_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_MACHINEW:
        // ܂BBSVmF
        NNshParam->enableNewArrivalHtml = data;
        ptr = MSG_MACHINEW_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ
        return (false);
        break;
    }
    if (data == 0)
    {
        // ݒƂʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_RESET_SUFFIX, 0);
    }
    else
    {
        // ݒ肵Ƃʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_SET_SUFFIX, 0);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : executeAction                                              */
/*                                          @\s(ړI{^p) */
/*-------------------------------------------------------------------------*/
static Boolean executeAction(UInt16 funcID)
{
    Boolean      ret = false;
    UInt16       item, dummy;
    EventType   *dummyEvent;

    // @\R}hԍjumpSelectionɊi[
    // (܂ǂȂB)
    NNshGlobal->jumpSelection = funcID;
    switch (funcID)
    {
      case MULTIBTN_FEATURE_INFO:
         // X
        if (NNshGlobal->nofTitleItems != 0)
        {
            item = convertListIndexToMsgIndex(NNshParam->selectedTitleItem);
            (void) DisplayMessageInformations(item, &dummy);

            NNsi_RedrawThreadList();
        }
        break;

      case MULTIBTN_FEATURE_OPEN:
        // XQ
        display_message();
        break;

      case MULTIBTN_FEATURE_GET:
        // bZ[W擾(擾/S擾͎؊)
        update_getall_message();
        break;

      case MULTIBTN_FEATURE_PARTGET:
        // bZ[W擾
        update_message();
        break;

      case MULTIBTN_FEATURE_ALLGET:
        // bZ[WS擾(Ď擾)
        get_all_message();
        break;

      case MULTIBTN_FEATURE_DELETE:
        // X폜
        delete_message();
        break;

      case MULTIBTN_FEATURE_SORT:
        // X̐s
        Show_BusyForm(MSG_SORTING_WAIT);
        SortSubjectList();
        Hide_BusyForm(false);

        // X^Cg̐擪ֈړ
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case MULTIBTN_FEATURE_MODTITLE:
        // X^CgύX
        modify_title();
        break;

      case MULTIBTN_FEATURE_OPENWEB:
        // IXuEUŊJ
        if (NNshGlobal->browserCreator != 0)
        {
            // WebBrowserŊJ
            launch_WebBrowser();
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MULTIBTN_FEATURE_MESNUM:
        // XԎw̃bZ[W擾
        Get_MessageFromMesNum(&ret);
        if (ret == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);

            // gpBBSꗗ̍XV
            (void) Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &item);
            if (item < NNshParam->lastBBS)
            {
                NNshParam->lastBBS = 0;
            }
        }
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case MULTIBTN_FEATURE_SEARCH:
        // ^Cg(̐ݒ)
        if (set_SearchTitleString() != true)
        {
            return (true);
        }
        // not break;  (ăX^Cs)

      case MULTIBTN_FEATURE_NEXT:
        // X^C()
        (void) search_NextTitle(NNSH_SEARCH_FORWARD);
        break;

      case MULTIBTN_FEATURE_PREV:
        // X^C(O)
        (void) search_NextTitle(NNSH_SEARCH_BACKWARD);
        break;

      case MULTIBTN_FEATURE_TOP:
        // X^Cg̐擪ֈړ
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case MULTIBTN_FEATURE_BOTTOM:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        NNshParam->startTitleRec = NNSH_ITEM_LASTITEM;
        Update_Thread_List(NNshParam->lastBBS,
                           NNSH_ITEM_LASTITEM,
                           NNSH_STEP_PAGEDOWN);
        break;

      case MULTIBTN_FEATURE_GETBBS:
        // ̍XV(擾)
        if (GetBBSList(NNshParam->bbs_URL) == false)
        {
            return (true);
        }
        /** not break; (ĎgpIs) **/

      case MULTIBTN_FEATURE_USEBBS:
        // gpIʂJ
        NNshMain_Close(FRMID_MANAGEBBS);
        break;

      case MULTIBTN_FEATURE_COPYGIKO:
        // QƐpOɃRs[
        copy_to_readOnly();
        break;

      case MULTIBTN_FEATURE_DELNOTGET:
        // 擾X폜
        delete_notreceived_message(true);
        break;

      case MULTIBTN_FEATURE_DBCOPY:
        // DBVFSɃobNAbv
        if (((NNshParam->useVFS) & (NNSH_VFS_ENABLE)) == NNSH_VFS_ENABLE)
        {
            // DBVFSɃobNAbv
            BackupDBtoVFS(NNSH_ENABLE);
        }
        else
        {
             // "݃T|[gĂ܂" \s
             NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MULTIBTN_FEATURE_GRAPHMODE:
        // `惂[hύX
        change_graph_mode();
        break;

#ifdef USE_HANDERA
      case MULTIBTN_FEATURE_ROTATE:
        // HandEraʉ]
        change_handera_rotate();
        break;
#endif  // #ifdef USE_HANDERA

      case MULTIBTN_FEATURE_FONT:
        // tHgύX
        change_list_font();
        break;

      case MULTIBTN_FEATURE_NETWORK:
        // lbg[NݒJ
        OpenNetworkPreferences();
        break;

      case MULTIBTN_FEATURE_SELMENU:
        // Ij[\
        open_menu();
        break;

      case MULTIBTN_FEATURE_DISCONN:
        // ؒf
        NNshNet_LineHangup();
        break;

      case MULTIBTN_FEATURE_GETLIST:
        // Xꗗ擾(SUBJECT.TXT擾)
        get_subject_txt();
        break;

      case MULTIBTN_FEATURE_NEWARRIVAL:
        // VbZ[WmF
        update_newarrival_message();
        break;

      case MULTIBTN_FEATURE_NNSHSET:
        // NNsiݒ(T)ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING_ABSTRACT);
        break;

      case MULTIBTN_FEATURE_NNSHSET1:
        // NNsiݒ-1ʂJ
        NNshMain_Close(FRMID_CONFIG_NNSH);
        break;

      case MULTIBTN_FEATURE_NNSHSET2:
        // NNsiݒ-2ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING2);
        break;

      case MULTIBTN_FEATURE_NNSHSET3:
        // NNsiݒ-3ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING3);
        break;

      case MULTIBTN_FEATURE_NNSHSET4:
        // NNsiݒ-4ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING4);
        break;

      case MULTIBTN_FEATURE_NNSHSET5:
        // NNsiݒ-5ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING5);
        break;

      case MULTIBTN_FEATURE_NNSHSET6:
        // NNsiݒ-6ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING6);
        break;

      case MULTIBTN_FEATURE_NNSHSET7:
        // NNsiݒ-7ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING7);
        break;

      case MULTIBTN_FEATURE_NNSHSET8:
        // NNsiݒ-8ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING8);
        break;

      case MULTIBTN_FEATURE_NNSHSET9:
        // NNsiݒ-9ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING9);
        break;

      case MULTIBTN_FEATURE_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case MULTIBTN_FEATURE_SELECTNEXT:
        // 1̃ACeI
        updateSelectionItem(1);
        break;

      case MULTIBTN_FEATURE_SELECTPREV:
        // 1̃ACeI
        updateSelectionItem(-1);
        break;

      case MULTIBTN_FEATURE_PREVPAGE:
        // Oy[W̕\
        if ((NNshParam->titleDispState == NNSH_DISP_HALFWAY)||
            (NNshParam->titleDispState == NNSH_DISP_LOWERLIMIT))
        {
            Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEDOWN);
        }
        break;

      case MULTIBTN_FEATURE_NEXTPAGE:
        // y[W̕\
        if ((NNshParam->titleDispState == NNSH_DISP_HALFWAY)||
            (NNshParam->titleDispState == NNSH_DISP_UPPERLIMIT))
        {
            Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEUP);
        }
        break;

      case MULTIBTN_FEATURE_NNSIEND:
        // NNsiI
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType = appStopEvent;
        EvtAddEventToQueue(dummyEvent);
        break;

      case MULTIBTN_FEATURE_NGWORD1:
        // NGL[[hPݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD1,
                        NNshParam->hideWord1, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);

        // NGݒ1̕`FbN
        SeparateWordList(NNshParam->hideWord1, &(NNshGlobal->hide1));

        NNsi_RedrawThreadList();
        break;

      case MULTIBTN_FEATURE_NGWORD2:
        // NGL[[hQݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD2,
                        NNshParam->hideWord2, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);

        // NGݒ2̕`FbN
        SeparateWordList(NNshParam->hideWord2, &(NNshGlobal->hide2));

        NNsi_RedrawThreadList();
        break;

      case MULTIBTN_FEATURE_USER1TAB:
      case MULTIBTN_FEATURE_USER2TAB:
        // [U^uݒʂJ
        NNshMain_Close(FRMID_FAVORSET_DETAIL);
        break;

      case MULTIBTN_FEATURE_DEVICEINFO:
        // foCX̏\
        ShowDeviceInfo_NNsh();
        break;
        
      case MULTIBTN_FEATURE_GOTODUMMY:
        // _~[ʂ֑J
        NNshMain_Close(FRMID_NNSI_DUMMY);
        break;

      case MULTIBTN_FEATURE_NEWTHREAD:
        // Xĉʂ֑J
        newThread_message();
        break;

      default:
        // ̑(Ȃ)
        NNsh_DebugMessage(ALTID_WARN, "Unknown FuncID", "", funcID);
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   open_menu                                                */
/*                                                 NNsiƎ̃j[\  */
/*-------------------------------------------------------------------------*/
static Boolean open_menu(void)
{
    FormType    *frm;
    ControlType *ctlP;
    EventType   *dummyEvent;
    Char      *ptr, listPtr[NNSH_ITEMLEN_JUMPLIST*(NNSH_JUMPSEL_NUMLIST + 1)];
    UInt16    btnId, savedParam, jumpList[NNSH_JUMPSEL_NUMLIST + 1], itemCnt;

    // Xg̍쐬
    MemSet(listPtr, sizeof(listPtr), 0x00);
    MemSet(jumpList, sizeof(jumpList), 0x00);
    ptr = listPtr;
    itemCnt = 0;

    // BBSI
    StrCopy(ptr, NNSH_JUMPMSG_OPENBBS);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENBBS);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENBBS;
    itemCnt++;

    // j[J
    if (NNshParam->addMenuTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_OPENMENU);
        ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMENU);
        jumpList[itemCnt] = NNSH_JUMPSEL_OPENMENU;
        itemCnt++;
    }

    // ؒf
    StrCopy(ptr, NNSH_JUMPMSG_DISCONNECT);
    ptr = ptr + sizeof(NNSH_JUMPMSG_DISCONNECT);
    jumpList[itemCnt] = NNSH_JUMPSEL_DISCONNECT;
    itemCnt++;

    // VmF
    StrCopy(ptr, NNSH_JUMPMSG_OPENNEW);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENNEW);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENNEW;
    itemCnt++;

    // ꗗ擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENLIST);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENLIST);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENLIST;
    itemCnt++;

    // X擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENGET);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENGET);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENGET;
    itemCnt++;

    // XQ
    StrCopy(ptr, NNSH_JUMPMSG_OPENMES);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMES);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENMES;
    itemCnt++;

    // QƐpփRs[
    if (NNshParam->addMenuCopyMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_COPYMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_COPYMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_COPYMSG;
        itemCnt++;
    }

    // X
    StrCopy(ptr, NNSH_JUMPMSG_OPENINFO);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENINFO);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENINFO;
    itemCnt++;

    // X폜
    if (NNshParam->addMenuDeleteMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_DELMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_DELMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_DELMSG;
        itemCnt++;
    }

    // `惂[hύX
    if (NNshParam->addMenuGraphTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_GRAPHMODE);
        ptr = ptr + sizeof(NNSH_JUMPMSG_GRAPHMODE);
        jumpList[itemCnt] = NNSH_JUMPSEL_GRAPHMODE;
        itemCnt++;
    }

    // ړIXCb`P
    if (NNshParam->addMenuMultiSW1 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW1);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW1);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW1;
        itemCnt++;
    }

    // ړIXCb`Q
    if (NNshParam->addMenuMultiSW2 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW2);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW2);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW2;
        itemCnt++;
    }

    // foCX
    if (NNshParam->addMenuDeviceInfo != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_SHOWDEVINFO);
        ptr = ptr + sizeof(NNSH_JUMPMSG_SHOWDEVINFO);
        jumpList[itemCnt] = NNSH_JUMPSEL_SHOWDEVINFO;
        itemCnt++;
    }

    // NNsiI
    if (NNshParam->addMenuNNsiEnd != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_NNSIEND);
        ptr = ptr + sizeof(NNSH_JUMPMSG_NNSIEND);
        jumpList[itemCnt] = NNSH_JUMPSEL_NNSIEND;
        itemCnt++;
    }

    // IEBhE\
    btnId = NNshWinSelectionWindow(listPtr, itemCnt);
    if (btnId != BTNID_JUMPCANCEL)
    {
        // IXgԍj[ԍ̕ϊ
        btnId = jumpList[NNshGlobal->jumpSelection];
        switch (btnId)
        {
          case NNSH_JUMPSEL_OPENBBS:
            // BBSꗗI(|bvAbv)
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,POPTRID_BBSINFO));
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_OPENMENU:
            // j[J
            // (_~[ō㕔penDownEvent𐶐)
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType    = penDownEvent;
            dummyEvent->penDown  = true;
            dummyEvent->tapCount = 1;
            dummyEvent->screenX  = 5;
            dummyEvent->screenY  = 5;
            EvtAddEventToQueue(dummyEvent);
            break;

          case NNSH_JUMPSEL_DISCONNECT:
            // ؒf
            savedParam = NNshParam->confirmationDisable;
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            NNshNet_LineHangup();
            NNshParam->confirmationDisable = savedParam;
            break;

          case NNSH_JUMPSEL_OPENNEW:
            // VmF
            (void) executeAction(MULTIBTN_FEATURE_NEWARRIVAL);
            break;

          case NNSH_JUMPSEL_OPENLIST:
            // ꗗXV
            (void) executeAction(MULTIBTN_FEATURE_GETLIST);
            break;

          case NNSH_JUMPSEL_OPENGET:
            // bZ[W擾(擾/S擾͎f)
            (void) executeAction(MULTIBTN_FEATURE_GET);
            break;

          case NNSH_JUMPSEL_OPENMES:
            // XQ
            (void) executeAction(MULTIBTN_FEATURE_OPEN);
            break;

          case NNSH_JUMPSEL_OPENINFO:
            // X\
            (void) executeAction(MULTIBTN_FEATURE_INFO);
            break;

          case NNSH_JUMPSEL_COPYMSG:
            // QƐpփRs[
            (void) executeAction(MULTIBTN_FEATURE_COPYGIKO);
            break;

          case NNSH_JUMPSEL_DELMSG:
            // X폜
            (void) executeAction(MULTIBTN_FEATURE_DELETE);
            break;

          case NNSH_JUMPSEL_GRAPHMODE:
            // `惂[hύX
            (void) executeAction(MULTIBTN_FEATURE_GRAPHMODE);
            return (true);
            break;

          case NNSH_JUMPSEL_MULTISW1:
            // ړIXCb`PƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_GETMODE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_MULTISW2:
            // ړIXCb`QƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm,CHKID_SELECT_MULTIPURPOSE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_SHOWDEVINFO:
            // foCX\
            (void) executeAction(MULTIBTN_FEATURE_DEVICEINFO);
            break;

          case NNSH_JUMPSEL_NNSIEND:
            // NNsiI
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType    = appStopEvent;
            EvtAddEventToQueue(dummyEvent);
            break;

          default:
            // Ȃ
            break;
        }
    }
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : NNshMain_Close                                             */
/*                                                      ꗗʂ̃N[Y */
/*-------------------------------------------------------------------------*/
static void NNshMain_Close(UInt16 nextFormID)
{
#if 0
    UInt16 savedParam;

    if (NNshParam->autoDeleteNotYet != 0)
    {
        // ړɖ擾X폜
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        delete_notreceived_message(false);
        NNshParam->confirmationDisable = savedParam;
    }
#endif

    // X^Cg\폜
    ClearMsgTitleInfo();

    // ʂ̉ʂJ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(nextFormID);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   copy_to_readOnly                                         */
/*                                  Ot@CQƐpOɃRs[ */
/*-------------------------------------------------------------------------*/
static Boolean copy_to_readOnly(void)
{
    Err                  ret;
    UInt16               selM, selBBS, butID;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;
    Char                *fileName, *orgName, *area;

    // {@\́AVFSpł|\(VFSȊO͏sȂ)
    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        NNsh_ErrorMessage(ALTID_WARN, MSG_ONLYVFS_FEATURE, "", 0);
        return (false);
    }

    // obt@̊m
    fileName = MemPtrNew(MAXLENGTH_FILENAME);
    if (fileName == NULL)
    {
        return (false);
    }
    orgName  = MemPtrNew(MAXLENGTH_FILENAME);
    if (orgName == NULL)
    {
        MemPtrFree(fileName);
        return (false);
    }

    // X擾
    ret = get_message_Info(&mesInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        //  X擾̂߁ARs[͍sȂ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTGET_MESSAGE,
                           mesInfo.threadTitle, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[fBNg쐬
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);

    // Ox[XfBNgt
    area = NULL;
    if (NNshGlobal->logPrefixH != 0)
    {
        area = MemHandleLock(NNshGlobal->logPrefixH);
    }
    if (area == NULL)
    {
        StrCopy(fileName, LOGDATAFILE_PREFIX);
    }
    else
    {
        StrCopy(fileName, area);
        MemHandleUnlock(NNshGlobal->logPrefixH);
    }
    StrCat (fileName, mesInfo.boardNick);
    fileName[StrLen(fileName) - 1] = '\0';
    (void) CreateDir_NNsh(fileName);

    // Rs[t@C쐬
    StrCat (fileName, "/");
    StrCat (fileName, mesInfo.threadFileName);

    // Rs[t@C쐬
    MemSet (orgName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(orgName, mesInfo.boardNick);
    StrCat (orgName, mesInfo.threadFileName);

    // t@C{ɃRs[邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_COPY,
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // CancelI(Ȃ)
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[̎{
    NNsh_DebugMessage(ALTID_INFO, "Dest :",   fileName, 0);
    NNsh_DebugMessage(ALTID_INFO, "Source :", orgName, 0);
    Show_BusyForm(MSG_COPY_IN_PROGRESS);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̂VFS̎QƐpOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_VFS_DISABLE);
    }
    else
    {
        // VFS̃OVFS̎QƐpOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_VFS_ENABLE);
    }
    Hide_BusyForm(false);
    if (ret != errNone)
    {
        // t@CRs[ɎsB
        (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);

        // Rs[Ɏs|\
        NNsh_ErrorMessage(ALTID_ERROR, MSG_FAILURE_COPY, fileName, ret);
        goto FUNC_END;
    }

    // Rs[ʒm
    NNsh_InformMessage(ALTID_INFO, MSG_INFORM_COPYEND, "", 0);

FUNC_END:
    MemPtrFree(orgName);
    MemPtrFree(fileName);
    if (ret != errNone)
    {
        return (false);
    }

    if (NNshParam->copyDelReadOnly != 0)
    {
        // Rs[ƂARs[t@C폜
        return (delete_message());
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   set_SearchTitleString                                    */
/*                                                X^C̐ݒ */
/*-------------------------------------------------------------------------*/
static Boolean set_SearchTitleString(void)
{
    Boolean       ret = false;
    Char         *ptr = NULL;

    // ̈̎擾
    if (NNshGlobal->searchTitleH == 0)
    {
        NNshGlobal->searchTitleH = MemHandleNew(BUFSIZE);
        if (NNshGlobal->searchTitleH == 0)
        {
            return (false);
        }
        ptr = MemHandleLock(NNshGlobal->searchTitleH);
        if (ptr != NULL)
        {
            MemSet(ptr, BUFSIZE, 0x00);
        }
    }
    else
    {
        ptr = MemHandleLock(NNshGlobal->searchTitleH);
    }
    if (ptr == NULL)
    {
        // ̈擾s
        MemHandleFree(NNshGlobal->searchTitleH);
        NNshGlobal->searchTitleH = 0;
        return (false);
    }

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_SEARCH,
                          ptr, BUFSIZE, NNSH_DIALOG_USE_SEARCH, NULL);

    MemHandleUnlock(NNshGlobal->searchTitleH);

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   isValidRecordForSearchTitle                              */
/*                  X^C{Ă悢Xǂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Boolean isValidRecordForSearchTitle(UInt16  selBBS, Char *bbsName,
                                           NNshSubjectDatabase  *mesInfo)
{
    // Xg`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < NNshParam->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_GETALL:
        if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
        {
            // 擾ςݑSĂ̂Ƃ͖擾̃Xł͂Ȃꍇ
            return (false);
        }
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // mF{邩ǂ̊mF([UݒP)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &(NNshParam->custom1)));
        break;

      case NNSH_SELBBS_CUSTOM2:
        // mF{邩ǂ̊mF([UݒQ)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &(NNshParam->custom2)));
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏vȂ
            return (false);
        }
        break;
    }
    // sX
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   search_NextTitle                                         */
/*                                                        X^C */
/*-------------------------------------------------------------------------*/
static Boolean search_NextTitle(Int16 direction)
{
    Err                  ret;
    Char                 msg[BUFSIZE], match1[BUFSIZE], match2[MAX_THREADNAME];
    Char                *ptr;
    UInt16               selMES, selBBS, index, loop, end;
    Int16                step;
    DmOpenRef            dbRef;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;

    // X^CꗗȂꍇ́Aɉ
    if (NNshGlobal->nofTitleItems == 0)
    {
        // R[h񂪑݂Ȃ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, 
                           MSG_NOTFOUND_OMIT, 0);
        return (false);
    }

    // 񂪊mۍς݂mF
    if (NNshGlobal->searchTitleH == 0)
    {
        return (false);
    }

    // 񂪐ݒς݂̏ꍇɂ́A̕擾
    ptr = MemHandleLock(NNshGlobal->searchTitleH);
    if (ptr == NULL)
    {
        return (false);
    }

    // (J[\ʒu)̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    // [UݒPтQ̂Ƃɂ́Aʓr擾
    if (selBBS == NNSH_SELBBS_CUSTOM1)
    {
        // [UݒP
        ret = Get_BBS_Info(NNshParam->custom1.boardNick, &bbsInfo);
    }
    else if (selBBS == NNSH_SELBBS_CUSTOM2)
    {
        // [UݒQ
        ret = Get_BBS_Info(NNshParam->custom2.boardNick, &bbsInfo);
    }
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    // X̎{(\)
    MemSet (msg, sizeof(msg), 0x00);
    StrCopy(msg, MSG_SEARCHING_TITLE);
    StrCat (msg, ptr);
    Show_BusyForm(msg);

    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (direction == NNSH_SEARCH_FORWARD)
    {
        // tH[hw
        GetDBCount_NNsh(dbRef, &end);
        end  = 0;
        step = -1;
    }
    else
    {
        // obN[hw
        GetDBCount_NNsh(dbRef, &end);
        end--;
        step = 1;
    }

    // 啶ʂȂꍇɂ́Aɕϊ
    MemSet(match1, sizeof(match1), 0x00);
    if (NNshParam->searchCaseless != 0)
    {
        (void) StrToLower(match1, ptr);
    }
    else
    {
        (void) StrCopy(match1, ptr);
    }

    // JnR[hԍ擾
    index = convertListIndexToMsgIndex(selMES);
    if (ret != errNone)
    {
        // R[h̎擾ɎsAs\
        goto FUNC_END;
    }
    // JnR[hԍ""猟{悤
    index = index + step;

    // ̎
    for (loop = index; loop != end; loop = loop + step)
    {
        // GetRecord_NNsh()Ń[NAĂ邽ߕsv
        // MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
        GetRecord_NNsh(dbRef, loop, sizeof(NNshSubjectDatabase), &mesInfo);

        // rɍvXǂ̃`FbN
        if (isValidRecordForSearchTitle(selBBS, bbsInfo.boardNick, &mesInfo) ==
            false)
        {
            // rKv̂ȂXAɂ
            continue;
	}

        //  w肳ꂽƃ}b`邩mF
        MemSet(match2, sizeof(match2), 0x00);
        if (NNshParam->searchCaseless != 0)
        {
            // X^Cɕϊ
            (void) StrToLower(match2, mesInfo.threadTitle);
        }
        else
        {
            (void) StrCopy(match2, mesInfo.threadTitle);
        }

        if (StrStr(match2, match1) != NULL)
        {
            CloseDatabase_NNsh(dbRef);
            Hide_BusyForm(false);

            // Xꗗ̕\ӏύX
            NNshParam->startTitleRec = loop;
            NNshParam->endTitleRec   = loop;
            Update_Thread_List(selBBS, 0, NNSH_STEP_REDRAW);
            MemHandleUnlock(NNshGlobal->searchTitleH);
            return (true);
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

FUNC_END:
    // Ɏs
    NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, ptr, 0);
    MemHandleUnlock(NNshGlobal->searchTitleH);

    // XXg̍XV(SELMES)
    Update_Thread_List(selBBS, NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR)
{
    Err ret;

    if (NNshGlobal->nofTitleItems == 0)
    {
        // R[h񂪑݂Ȃ
        return (~errNone);
    }

    // bZ[W̏
    *selTHR                    = NNshParam->selectedTitleItem;
    NNshParam->openThreadIndex = *selTHR;

    // XgԍXindexɕϊ
    NNshParam->openMsgIndex    = convertListIndexToMsgIndex(*selTHR);

    // X擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, mesInfo);
    if (ret != errNone)
    {
        // R[h̎擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        MemSet(mesInfo, sizeof(NNshSubjectDatabase), 0x00);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_message_Info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS)
{
    Err        ret;
    FormType  *frm;
    ListType  *lstP;
    UInt16     dummy;

    *selBBS = 0;

    // X擾
    ret = get_subject_info(mesInfo, selTHR);
    if (ret != errNone)
    {
        return (~errNone);
    }

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    *selBBS = LstGetSelection(lstP);

    // IꂽBBS̃XgԍŁABBS̃[h𔻒f
    if (*selBBS >= NNSH_SELBBS_OFFLINE)
    {
        // BBSȊÔƂ́ABBS擾
        ret = Get_BBS_Info(*selBBS, bbsInfo);
    }
#if 0
    else if (*selBBS == NNSH_SELBBS_CUSTOM1)
    {
        // [UݒP
        ret = Get_BBS_Info(NNshParam->custom1.boardNick, bbsInfo);
    }
    else if (*selBBS == NNSH_SELBBS_CUSTOM2)
    {
        // [UݒQ
        ret = Get_BBS_Info(NNshParam->custom2.boardNick, bbsInfo);
    }
#endif
    else
    {
        // i[UݒȊÓj́AboardNickgBBS擾
        ret = Get_BBS_Database(mesInfo->boardNick, bbsInfo, &dummy);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   display_message                                          */
/*                                                        bZ[W̕\ */
/*-------------------------------------------------------------------------*/
static Boolean display_message(void)
{
    Err                  ret;
    UInt16               selM, butID, selBBS;
    NNshSubjectDatabase  subjInfo;
    NNshBoardDatabase    bbsInfo;

    // X擾
    ret = get_message_Info(&subjInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X擾̂ƂA擾̎|xAX擾邩mFB
    if (subjInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X擾
        if (get_all_message() == false)
        {
            // Xꗗʂĕ\
            NNsi_RedrawThreadList();
            return (false);
        }
        // Xf[^擾łƂ́Aʂ\ɑJڂB
    }

    // BBS(Ō)QƂƂɕύX(CɓΉ)
    NNshParam->lastBBS = selBBS;

    // QƉʂI[v
    NNshMain_Close(FRMID_MESSAGE);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_all_message                                          */
/*                                                     bZ[WS擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_all_message(void)
{
    Boolean             err = false;
    Err                 ret;
    Char                url[BUFSIZE];
    UInt16              butID, selMES, selBBS, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    // XXXg̏ʂɂ邩`FbN
    if (Check_same_thread(selMES, &mesInfo, NULL, &butID) == errNone)
    {
        //  XꍇADB̕sh~邽߁Ax\
        // f[^̎擾sȂB
        NNsh_InformMessage(ALTID_WARN, MSG_THREADLIST_ALREADY,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    if (mesInfo.state != NNSH_SUBJSTATUS_NOT_YET)
    {
        // Ɏ擾ς݁AbZ[Wŏ擾邪A{ɂ̊mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_GET_ALREADY, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // LZ
            NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", 0);
            return (false);
        }
    }
    ////////////  bZ[WS擾̏  ///////////

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if ((NNshParam->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // XgԍXindexɕϊ
            index = convertListIndexToMsgIndex(selMES);

            // V\񎞂Ɏ擾\ݒ肵ďI
            mesInfo.msgAttribute
                     = mesInfo.msgAttribute | NNSH_MSGATTR_GETRESERVE;
            (void) update_subject_database(index, &mesInfo);
            return (true);
        }
    }

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    (void) CreateThreadURL(NNSH_DISABLE, url, sizeof(url), &bbsInfo, &mesInfo);
    
    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O擾ыL^
    ret = Get_AllMessage(url, bbsInfo.boardNick, mesInfo.threadFileName,
                         index, (UInt16) bbsInfo.bbsType);
    if ((ret == errNone)&&((bbsInfo.state&(NNSH_BBSSTATE_LEVELMASK)) != 0))         
    {
        // MIAWXxݒ肳Ăꍇ
        if (Get_Subject_Database(index, &mesInfo) == errNone)
        {
            // BBSɐݒ肳ꂽWXx𔽉f
            switch ((bbsInfo.state)&(NNSH_BBSSTATE_LEVELMASK))
            {
              case NNSH_BBSSTATE_FAVOR_L1:
                // Lxɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L1));
                break;

              case NNSH_BBSSTATE_FAVOR_L2:
                // 1xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L2));
                break;

              case NNSH_BBSSTATE_FAVOR_L3:
                // 2xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L3));
                break;

              case NNSH_BBSSTATE_FAVOR_L4:
                // 3xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L4));
                break;

              case NNSH_BBSSTATE_FAVOR:
                // Hxɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR));
                break;

              default:
                // Ȃ
                break;
            }
            // XDBXV
            (void) update_subject_database(index, &mesInfo);
        }
    }

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_MESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS,
                             NNshParam->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&(NNshParam->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = false;
    }
    // 擾G[ɂ́AG[
    if (ret != errNone)
    {
        err = false;
    }
    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_message                                           */
/*                                                     bZ[W擾  */
/*-------------------------------------------------------------------------*/
static Boolean update_message(void)
{
    Boolean             err;
    Err                 ret;
    Char                url[BUFSIZE];
    UInt16              butID, selBBS, selMES, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
    // XVłȂ|\
    if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    //  VFSɃO邪AVFSgpݒɂȂĂȂꍇɂ́A
    // XVłȂ|\
    if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾IA܂擾ĂȂB(S擾邩mF)
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X(S)擾
        return (get_all_message());
    }

    ////////////  bZ[W擾̏  ///////////

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if ((NNshParam->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // XgԍXindexɕϊ
            index = convertListIndexToMsgIndex(selMES);

            // V\񎞂Ɏ擾\ݒ肵ďI
            mesInfo.msgAttribute
                     = mesInfo.msgAttribute | NNSH_MSGATTR_GETRESERVE;
            (void) update_subject_database(index, &mesInfo);
            return (true);
        }
    }

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    (void) CreateThreadURL(NNSH_DISABLE, url, sizeof(url), &bbsInfo, &mesInfo);

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O̎擾ыL^(ǋL)
    ret = Get_PartMessage(url, bbsInfo.boardNick, &mesInfo, index, NULL);

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_PARTMESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS, 
                             NNshParam->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&(NNshParam->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = true;
    }

    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   modify_title                                             */
/*                                                      X^Cg̕ύX */
/*-------------------------------------------------------------------------*/
static Boolean modify_title(void)
{
    Err                 ret;
    Char                newName[MAX_THREADNAME], logBuf[BUFSIZE];
    UInt16              selBBS, selTHR, butID, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // lƂČ݂̃^CgRs[
    MemSet(newName, sizeof(newName), 0x00);
    StrNCopy(newName, mesInfo.threadTitle, MAX_THREADNAME);

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_MODIFYTITLE, newName, sizeof(newName),
                          NNSH_DIALOG_USE_MODIFYTITLE, NULL);
    if (ret == true)
    {
        MemSet(logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, MSG_DIALOG_MODIFYTITLE);
        StrCat (logBuf, mesInfo.threadTitle);
        StrCat (logBuf, MSG_DIALOG_MODIFYTITLE2);

        // {ɃX^CgύX邩mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, logBuf, newName, 0);
        if (butID == 0)
        {
            // ^CgXV
            MemSet  (mesInfo.threadTitle, MAX_THREADNAME, 0x00);
            StrNCopy(mesInfo.threadTitle, newName, MAX_THREADNAME);
            index = convertListIndexToMsgIndex(selTHR);
            ret =  update_subject_database(index, &mesInfo);
            if (ret != errNone)
            {
                NNsh_InformMessage(ALTID_WARN, "Update failure", " ret:", ret);
            }
            else
            {
                Update_Thread_List(selBBS, 
                                   NNshParam->selectedTitleItem, 
                                   NNSH_STEP_REDRAW);
            }
            return (true);
        }
    }
    NNsi_RedrawThreadList();
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   launch_WebBrowser                                        */
/*                                                  WebBrowserŃXJ */
/*-------------------------------------------------------------------------*/
static Boolean launch_WebBrowser(void)
{
    Err                 ret;
    Char                logBuf[BIGBUF];
    UInt16              selBBS, selTHR;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // XbZ[WURL\z
    MemSet (logBuf, sizeof(logBuf), 0x00);
    CreateThreadBrowserURL(NNSH_DISABLE, logBuf, &bbsInfo, &mesInfo);

    // WebBrowserŊJƂAŐVTOJ悤ɂ
    if (NNshParam->browseMesNum != 0)
    {
        switch (bbsInfo.bbsType)
        {
          case NNSH_BBSTYPE_SHITARABAJBBS:
          case NNSH_BBSTYPE_MACHIBBS:
            StrCat(logBuf, "&LAST=");
            break;

          case NNSH_BBSTYPE_SHITARABA:
            StrCat(logBuf, "&ls=");
            break;

          case NNSH_BBSTYPE_2ch:
          default:
            if (NNshParam->useImodeURL != 0)
            {
                StrCat(logBuf, "/n");
                goto OPEN_WEB;
	    }
            else
	    {
                StrCat(logBuf, "/l");
	    }
            break;
        }
        NUMCATI(logBuf, NNshParam->browseMesNum);
    }
    else
    {
        // i-modepURLꍇAURL𒲐
        if (NNshParam->useImodeURL != 0)
        {
            switch (bbsInfo.bbsType)
            {
              case NNSH_BBSTYPE_2ch:
                StrCat(logBuf, "/i");
                break;

              case NNSH_BBSTYPE_SHITARABAJBBS:
              case NNSH_BBSTYPE_MACHIBBS:
              case NNSH_BBSTYPE_SHITARABA:
              default:
                break;
            }
        }
    }
OPEN_WEB:

    // \XURLfobO\
    NNsh_DebugMessage(ALTID_INFO, "OPEN URL :", logBuf, 0);

    // NetFrontN(NNsiIɋN)
    (void) WebBrowserCommand(NNshGlobal->browserCreator,
                             0, 0, 
                             NNshGlobal->browserLaunchCode, logBuf, NULL);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkIfNewArrivalIsValid                                 */
/*                                        VbZ[W擾ۂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Err checkIfNewArrivalIsValid(UInt16  selBBS, Char *bbsName,
                                    NNshSubjectDatabase  *mesInfo)
{
    if ((mesInfo->msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)
    {
        // 擾\񂵂ĂXAbZ[W擾
        return (errNone);
    }

    if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // bZ[W擾ȂA擾{Ȃ
        return (~errNone);
    }

    if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo->msgState == FILEMGR_STATE_OPENED_STREAM))||
        (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo->msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
        // 擾{łȂ
        return (~errNone);
    }

    switch (mesInfo->bbsType)
    {
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_SHITARABA:
        // `FbNnj
        break;

      case NNSH_BBSTYPE_MACHIBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS:
        if (NNshParam->enableNewArrivalHtml != 0)
        {
            // ܂BBS/@JBBSVmFꍇɂ́A`FbNOK
            break;
        }
        return (~errNone);
        break;

      default:
        // ^Cv "Q˂" ܂ "" ȊÓA{Ȃ
        return (~errNone);
        break;
    }

#ifdef USE_STRSTR
    if (StrCompare(mesInfo->boardNick, OFFLINE_THREAD_NICK) == 0)
#else
    if ((mesInfo->boardNick[0]  == '!')&&
        (mesInfo->boardNick[1]  == 'G')&&
        (mesInfo->boardNick[2]  == 'i'))
#endif
    {
        // QƐpOȂA擾{Ȃ
        return (~errNone);
    }
    if (mesInfo->maxLoc >= NNSH_MESSAGE_LIMIT)
    {
        // 擾(ő)bZ[WɓBĂȂA擾{Ȃ
        return (~errNone);
    }

    // ʂ̃`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < NNshParam->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_GETALL:
        // 擾ςݑSĂ̂Ƃ͑S
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &(NNshParam->custom1)) != true)
        {
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &(NNshParam->custom2)) != true)
        {
            return (~errNone);
        }
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏Ⴄ
            return (~errNone);
        }
        break;
    }
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_newarrival_message                                */
/*                                                  VbZ[W擾 */
/*-------------------------------------------------------------------------*/
static Boolean update_newarrival_message(void)
{
    Err                  ret = ~errNone;
    Boolean              penState, bbsUpdate;
    UInt16               selBBS, loop, savedParam, count, x, y;
    UInt16               getBBS, dummy, keepBBS;
    Char                *url, logMsg[MINIBUF], dispMsg[MINIBUF];
    FormType            *frm;
    ListType            *lstP;
    ControlType         *ctlP;
    MemHandle            mesH;
    DmOpenRef            dbRef;
    NNshBoardDatabase   *bbsInfo;
    NNshSubjectDatabase *mesInfo, *mesRead;

    // [N̈̊m(3)
    url = MemPtrNew(BUFSIZE);
    if (url == NULL)
    {
        return (false);
    }

    // XԎw擾Ŏ擾ۗ̂ɂāA"VmF"
    OpenDatabase_NNsh(DBNAME_GETRESERVE, DBVERSION_GETRESERVE, &dbRef);
    if (dbRef != 0)
    {
        // 擾ۗX̃XԎw擾{́AmFbZ[W\Ȃ
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;

        // 擾
        GetDBCount_NNsh(dbRef, &count);

        // SAXԎw擾{
        for (loop = 0; loop < count; loop++)
        {
            // f[^擾
            GetRecord_NNsh(dbRef, loop, BUFSIZE, url);

            // XԎw擾{
            (void) GetThreadDataFromMesNum(&bbsUpdate, url, BUFSIZE);
        }

        // XԎw擾̎擾ۗcȃSR[h폜
        while (count != 0)
        {
            (void) DeleteRecordIDX_NNsh(dbRef, (count - 1));
            count--;
        }
        CloseDatabase_NNsh(dbRef);

        NNshParam->confirmationDisable = savedParam;
    }

    bbsInfo = MemPtrNew(sizeof(NNshBoardDatabase));
    if (bbsInfo == NULL)
    {
        MemPtrFree(url);
        return (false);
    }
    mesInfo = MemPtrNew(sizeof(NNshSubjectDatabase));
    if (bbsInfo == NULL)
    {
        MemPtrFree(url);
        MemPtrFree(bbsInfo);
        return (false);
    }

    // mۂ[N̈
    MemSet(url,     BUFSIZE,                     0x00);
    MemSet(bbsInfo, sizeof(NNshBoardDatabase),   0x00);

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS  = LstGetSelection(lstP);
    dummy   = 0;
    keepBBS = selBBS;
    switch (selBBS)
    {
      case NNSH_SELBBS_NOTREAD:
        // ǂɂƂAVmF^úAp[^擾
        selBBS = NNshParam->newArrivalNotRead;
        dummy  = 1;
        break;

      case NNSH_SELBBS_CUSTOM1:
        selBBS  = NNshParam->custom1.newArrival;
        dummy   = 1;
        break;

      case NNSH_SELBBS_CUSTOM2:
        selBBS = NNshParam->custom2.newArrival;
        dummy  = 1;
        break;

      default:
        break;
    }
    if (dummy != 0)
    {
        // BBS\^u()ύX
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        NNshParam->lastBBS = selBBS;

        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, selBBS));
    }

    // BBS̎擾^uI
    switch (selBBS)
    {
      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̔擾
        getBBS = NNshParam->custom1.boardNick;
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̔擾
        getBBS = NNshParam->custom2.boardNick;
        break;

      case NNSH_SELBBS_OFFLINE:
        // OFFLINEXIĂꍇ́AXVs\
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE, "", 0);
        goto FUNC_END;
        break;

      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_GETALL:
      case NNSH_SELBBS_NOTREAD:
      default:
        getBBS = selBBS;
        break;
    }

    // ʏ̏ꍇɂ́A擾(̏ꍇ͒擾)
    if (getBBS > NNSH_SELBBS_OFFLINE)
    {
        ret = Get_BBS_Info(getBBS, bbsInfo);
        if (ret != errNone)
        {
            // BBSɎ擾sAI
            NNsh_DebugMessage(ALTID_ERROR, MSG_CANNOT_UPDATE, "(BBS data)", 0);
            goto FUNC_END;
        }
    }

    /////////////////  bZ[W擾̏  ////////////////

    // "X"\
    Show_BusyForm(MSG_SEARCHING_TITLE);

    // VbZ[WmF́AmFbZ[Wu\ȂvݒɂB
    savedParam = NNshParam->confirmationDisable;
    NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;

    // SX擾
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &count);

    // BBS擾XVtOneeɂ
    bbsUpdate = false;

    // VmF
    for (loop = count; loop > 0; loop--)
    {
        // 悻̌c茏\
        if ((loop % 10) == 0)
        {
            StrCopy(logMsg, MSG_SEARCHING_TITLE MSG_SEARCHING_LEFT);
            NUMCATI(logMsg, loop);
            SetMsg_BusyForm(logMsg);
        }

        // Xf[^擾
        GetRecordReadOnly_NNsh(dbRef, (loop - 1), &mesH, (void **) &mesRead);

        // 擾\XA^uCɓ/擾ςݑS/ǂǂ̃`FbN
        if (((mesRead->msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)||
            (getBBS < NNSH_SELBBS_OFFLINE))
        {
            //  `FbNɊYꍇɂ́ABBS擾BA擾ς
            // BBSboardNickƍ擾悤ƂBBSboardNickv
            // ꍇɂ́ABBS͂łɎ擾ς݂ƂĂ̏𗘗p
            if (StrCompare(mesRead->boardNick, bbsInfo->boardNick) != 0)
            {
                ret = Get_BBS_Database(mesRead->boardNick, bbsInfo, &dummy);
                if (ret != errNone)
                {
                    // BBSɎ擾sAf`FbNւ
                    ReleaseRecordReadOnly_NNsh(dbRef, mesH);
                    goto NEXT_STEP;
                }
                bbsUpdate = true;  // BBSXVAƃtO𗧂Ă
            }
        }

        // VbZ[W擾Xǂ`FbN
        if (checkIfNewArrivalIsValid(selBBS,bbsInfo->boardNick,mesRead) != 
                                                                       errNone)
        {
            // VmF{Xł͂ȂAf`FbNւ
            ReleaseRecordReadOnly_NNsh(dbRef, mesH);
            goto NEXT_STEP;
        }

        // f[^x[Xx
        ReleaseRecordReadOnly_NNsh(dbRef, mesH);
        CloseDatabase_NNsh(dbRef);
        Get_Subject_Database((loop - 1), mesInfo);

        // bZ[W擾URL̍쐬
        (void) CreateThreadURL(NNSH_DISABLE, url, BUFSIZE, bbsInfo, mesInfo);

        // \郁bZ[W̒ǉ
        MemSet (dispMsg, MINIBUF, 0x00);
        StrCopy(dispMsg, " (");
        NUMCATI(dispMsg, (count - loop) + 1);
        StrCat (dispMsg, "/");
        NUMCATI(dispMsg, count);
        StrCat (dispMsg, ")");

        // ꎞIBUSYEBhE
        Hide_BusyForm(false);

        // O̎擾ыL^(ǋL)
        ret = Get_PartMessage(url, bbsInfo->boardNick, mesInfo,
                              (loop - 1), dispMsg);

        // VmFō擾sꍇ
        if ((ret == NNSH_ERRORCODE_PARTGET)&&
            (NNshParam->autoUpdateGetError != 0))
        {
            // bZ[Wǂ񂾏ꏊ
            x = mesInfo->maxLoc;
            y = mesInfo->currentLoc;

            // ŏSĎ擾Ȃ
            ret = Get_AllMessage(url, bbsInfo->boardNick,
                                 mesInfo->threadFileName,
                                 (loop - 1), (UInt16) bbsInfo->bbsType);
            if (ret == errNone)         
            {
                // MÎƂAǂݏoꏊȑȌꏊɕ
                if (Get_Subject_Database((loop - 1), mesInfo) == errNone)
                {
                    mesInfo->maxLoc     = x;
                    mesInfo->currentLoc = y;
                    (void) update_subject_database((loop - 1), mesInfo);
                }
            }
        }

        // BUSYEBhE𕜊
        Show_BusyForm(MSG_SEARCHING_TITLE);

        // f[^x[XēxJ
        OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);

        //  O擾~ꂽ or vIG[ɂ
        // VbZ[W̊mF𒆎~B
        if (ret == ~errNone)
        {
            // mFbZ[Wȗ̃p[^ɖ߂
            NNshParam->confirmationDisable = savedParam;

            // 𒆎~|Aʕ\
            NNsh_InformMessage(ALTID_INFO, 
                               MSG_ABORT_MESSAGE, 
                               MSG_NOTCHECK_RECORDS, loop);
            break;
        }

        //  BBS(擾\X̂߂)XVĂꍇ
        if (bbsUpdate == true)
        {
            if (getBBS > NNSH_SELBBS_OFFLINE)
            {
                // BBSĎ擾ČBBSɖ߂
                // (̓[v擾̂ōXVȂ)
                (void) Get_BBS_Info(getBBS, bbsInfo);
                bbsUpdate = false;
            }
        }

NEXT_STEP:
        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GET, 
                                  MSG_NOTCHECK_RECORDS, loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

    // mFbZ[Wȗ̃p[^ɖ߂
    NNshParam->confirmationDisable = savedParam;

    // uVmFvɖǈꗗ\
    if (NNshParam->autoOpenNotRead != 0)
    {
        // IĂBBS̃XgԍύX
        keepBBS = NNSH_SELBBS_NOTREAD;
    }

    // BBS\^uύX
    NNshParam->lastBBS = keepBBS;
    NNshWinSetPopItems(FrmGetActiveForm(),POPTRID_BBSINFO, LSTID_BBSINFO, keepBBS);

FUNC_END:
    // ֐̏I
    MemPtrFree(url);
    MemPtrFree(bbsInfo);
    MemPtrFree(mesInfo);

    if (NNshParam->disconnArrivalEnd != 0)
    {
        // uVmFvIɉؒf
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        NNshNet_LineHangup();
        NNshParam->confirmationDisable = savedParam;
    }

    // XgXV
    Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_getall_message                                    */
/*                                     bZ[W擾("XV" {^p) */
/*-------------------------------------------------------------------------*/
static Boolean update_getall_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[WԂ擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // bZ[WԂɂāAANVύX
    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾ȂS擾
        (void) get_all_message();
        goto RETR;
    }

    // 擾ς݂Ȃ獷擾
    (void) update_message();
RETR:
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_notreceived_message                               */
/*                                                    MX폜 */
/*-------------------------------------------------------------------------*/
Boolean delete_notreceived_message(Boolean update)
{
    Err                   ret;
    UInt16                selMES, selBBS, cnt;
    NNshSubjectDatabase   mesInfo;
#if 0
    FormType             *frm;
    ListType             *lstP;

    // IĂBBS̃Xgԍ擾
    frm    = FrmGetActiveForm();
    lstP   = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS = LstGetSelection(lstP);
#else
    selBBS = NNshParam->lastBBS;
#endif

    //  uǂvu擾ςݑSāv^u\ɖ擾ꗗ폜ꂽꍇ́A
    // S擾X(^Cg)폜
    if ((selBBS == NNSH_SELBBS_GETALL)||(selBBS == NNSH_SELBBS_NOTREAD))
    {
        (void) DeleteSubjectList(" ", NNSH_SUBJSTATUS_UNKNOWN, &cnt);
        // XgXV(selBBS)
        return (Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE));
        // return (true);
    }

    // 疢擾ꗗ͍폜łȂB
    if (selBBS <  NNSH_SELBBS_OFFLINE)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOTDELETE_FAVOR,"", 0);
        return (false);    
    }

    // X̎擾
    ret = get_subject_info(&mesInfo, &selMES);
    if (ret != errNone)
    {
        return (false);
    }

    // 擾̃X폜
    (void) DeleteSubjectList(mesInfo.boardNick, NNSH_SUBJSTATUS_NOT_YET, &cnt);

    // Ẍ݂ʒu菬ꍇɂ́ÃXɃJ[\킹
    if (selMES >= cnt)
    {
        selMES = cnt - 1;    
    }

    if (update == false)
    {
        // ʕ\XVȂꍇ
        return (true);
    }

    // XgXV(selBBS)
    return (Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE));
}


/*-------------------------------------------------------------------------*/
/*   Function :   newThread_message                                        */
/*                                                           Xď  */
/*-------------------------------------------------------------------------*/
static Boolean newThread_message(void)
{
#ifdef USE_NEWTHREAD_FEATURE
    Err                ret;
    UInt16             selBBS, btnID;
    NNshBoardDatabase  bbsData;

    // XĂ擾
    selBBS = NNshParam->lastBBS;

    // 疢擾ꗗ͍폜łȂ
    if (selBBS <=  NNSH_SELBBS_OFFLINE)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_NOTAVAIL_BBS, "", 0);
        return (false);    
    }

    // BBS擾
    MemSet(&bbsData, sizeof(bbsData), 0x00);
    ret = Get_BBS_Info(selBBS, &bbsData);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, MSG_NOTAVAIL_BBS, "(Get_BBS_Info())", ret);
        return (false);
    }

    // BBS^CvQ˂ȊÔƂ́AXĂȂ
    if (bbsData.bbsType != NNSH_BBSTYPE_2ch)
    {
        //   uݖȃtB[`[v\
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "(BBS TYPE)", 0);
        return (false);
    }

    // X{ɗĂ邩mF
    btnID = NNsh_ErrorMessage(ALTID_CONFIRM, bbsData.boardName, MSG_NEWTHREAD_CONFIRM, 0);
    if (btnID != 0)
    {
        // XăLZ
        return (false);
    }

    // XĉʂJ
    NNshMain_Close(FRMID_NEW_THREAD);
    
#else
    // XďsȂꍇ...
    //   uݖȃtB[`[v\
    NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif     
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_message                                           */
/*                                                           X폜  */
/*-------------------------------------------------------------------------*/
Boolean delete_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS, butID, index;
    Char                fileName[MAXLENGTH_FILENAME], *area;
    DmOpenRef           dbRef;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X{ɍ폜邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_DELETE_MSGCONFIRM, 
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // 폜LZ
        return (false);
    }

    // XDB̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }

    // Xt@C({̂̃Ot@C)폜
    MemSet (fileName, sizeof(fileName), 0x00);
    if (selBBS != NNSH_SELBBS_OFFLINE)
    {
        // OFFLINEÔƂ́AboardNicktȂ
        StrCopy(fileName, mesInfo.boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNg擾
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            GetSubDirectoryName(mesInfo.dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, mesInfo.threadFileName);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̏̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_DISABLE);
    }
    else
    {
        // VFS̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }
    if((ret != errNone)&&(ret != fileErrNotFound)&&(ret != vfsErrFileNotFound))
    {
        NNsh_InformMessage(ALTID_ERROR, "File Delete: ", fileName, ret);
    }

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // XCfbNXt@C폜ăN[Y
    (void) DeleteRecordIDX_NNsh(dbRef, index);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return (Update_Thread_List(selBBS, selMES, NNSH_STEP_REDRAW));
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_txt                                          */
/*                                      Xꗗ(subject.txt)擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_subject_txt(void)
{
    Err       ret;
    UInt16    selBBS, keepBBS;
    FormType *frm;
    ListType *lstP;
    ControlType *ctlP;

    frm  = FrmGetActiveForm();
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO)); 
    selBBS  = LstGetSelection(lstP);

    // [Uݒ^ûƂ́Aw肳ꂽ^üꗗ擾
    keepBBS = 0;
    if (selBBS == NNSH_SELBBS_CUSTOM1)
    {
        selBBS  = NNshParam->custom1.getList;
        keepBBS = NNSH_SELBBS_CUSTOM1;
    }
    else if (selBBS == NNSH_SELBBS_CUSTOM2)
    {
        selBBS  = NNshParam->custom2.getList;
        keepBBS = NNSH_SELBBS_CUSTOM2;
    }
    if (keepBBS != 0)
    {
        // BBS\^u()ύX
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        NNshParam->lastBBS = selBBS;
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, selBBS));
    }

    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_GETALL:
      case NNSH_SELBBS_NOTREAD:
      case NNSH_SELBBS_CUSTOM1:
      case NNSH_SELBBS_CUSTOM2:
        // "Cɓ"A"擾ςݑS"A"ǂ"\ɂ́A󂯕tȂB
        ret = ~errNone;
        break;

      case NNSH_SELBBS_OFFLINE:
        // ItCX̌s
        create_offline_database();
        ret = errNone;
        break;

      default:
        // Xꗗ擾
        ret = NNsh_GetSubjectList(selBBS);
        break;
    }
    if (keepBBS != 0)
    {
        // BBS\^u()ɖ߂
        LstSetSelection(lstP, keepBBS);

        // BBS\^uύX
        NNshParam->lastBBS = keepBBS;
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, keepBBS));
    }

    // Xꗗ\Ȃ
    if (ret == errNone)
    {
        FrmDrawForm(frm);
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   popEvt_ThreadMain                                        */
/*                                          XgICxg[` */
/*-------------------------------------------------------------------------*/
static Boolean popEvt_ThreadMain(EventType *event)
{
    UInt16 savedParam;
    switch (event->data.popSelect.listID)
    {
      case LSTID_BBSINFO:
        if (NNshParam->autoDeleteNotYet != 0)
        {
            // ړɖ擾X폜
            savedParam = NNshParam->confirmationDisable;
            NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            delete_notreceived_message(false);
            NNshParam->confirmationDisable = savedParam;
        }

        // LSTID_BBSINFOpopSelectEventȂAXXV
        NNshParam->lastBBS = event->data.popSelect.selection;
        (void) Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   rctPointEvt_ThreadMain                                   */
/*                                              X^bvƂ̏ */
/*-------------------------------------------------------------------------*/
static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect)
{
    Coord  locY;
    UInt16 fontID, nlines, fontHeight, selItem;

    // IACe肷
    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        fontID = NNshParam->currentFont;
    }
    else
    {
        fontID = NNshParam->sonyHRFontTitle;
    }
    NNsi_UpdateRectangle(rect, NNshParam->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        locY = (event->screenY * 2) - rect->topLeft.y;
    }
    else
#endif
    {
#ifdef USE_HIGHDENSITY
        // 𑜓xɂ킹ĕ`̈̍擾
        switch (NNshGlobal->os5HighDensity)
        {
          case kDensityDouble:
            locY = (event->screenY * 2) - rect->topLeft.y;
            break;

          case kDensityTriple:
            locY = (event->screenY * 3) - rect->topLeft.y;
            break;

          case kDensityQuadruple:
            locY = (event->screenY * 4) - rect->topLeft.y;
            break;

          case kDensityOneAndAHalf:
            locY = (event->screenY * 3 / 2) - rect->topLeft.y;
            break;

          case kDensityLow:
          default:
            locY = event->screenY - rect->topLeft.y;
            break;
        }
#else
        locY = event->screenY - rect->topLeft.y;
#endif // #ifdef USE_HIGHDENSITY
    }
    selItem = locY / fontHeight;

    // ͈͊ȎIꍇAȂ
    if (selItem >= NNshGlobal->nofTitleItems)
    {
        return (true);
    }

    if (selItem == NNshParam->selectedTitleItem)
    {
        // _u^bvoAXJƂ
        return (display_message());
    }

    // IACeړ
    NNsi_WinUpdateList(selItem,
                       NNshParam->selectedTitleItem, 
                       NNshGlobal->msgTitleIndex,
                       nlines, rect, fontHeight);
    NNshParam->selectedTitleItem = selItem;
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   keyDownEvt_ThreadMain                                    */
/*                                                        L[͎̏ */
/*-------------------------------------------------------------------------*/
static Boolean keyDownEvt_ThreadMain(EventType *event)
{
    Boolean   ret = false;
    UInt16    keyCode;

    // 5way navigatorpL[R[hRo[g
    keyCode = KeyConvertFiveWayToJogChara(event);
    switch (keyCode)
    {
      case vchrHard1:
        // n[hL[𐧌䂷ꍇ́AAA
        if (NNshParam->useHardKeyControl != 0)
        {
            // n[hL[PƂ̐ݒ
            return (executeAction((NNshParam->ttlFtr.key1)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard2:
        // n[hL[𐧌䂷ꍇ́AAA
        if (NNshParam->useHardKeyControl != 0)
        {
            // n[hL[QƂ̐ݒ
            return (executeAction((NNshParam->ttlFtr.key2)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard3:
        // n[hL[𐧌䂷ꍇ́AAA
        if (NNshParam->useHardKeyControl != 0)
        {
            // n[hL[RƂ̐ݒ
            return (executeAction((NNshParam->ttlFtr.key3)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard4:
        // n[hL[𐧌䂷ꍇ́AAA
        if (NNshParam->useHardKeyControl != 0)
        {
            // n[hL[SƂ̐ݒ
            return (executeAction((NNshParam->ttlFtr.key4)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrCapture:
        // CLIELv`[{^𐧌䂷ꍇ́AAA
        if (NNshParam->useHardKeyControl != 0)
        {
            // CLIELv`[{^Ƃ̐ݒ
            return (executeAction((NNshParam->ttlFtr.clieCapture)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      // n[hL[̏
      case vchrPageDown:
        return (executeAction((NNshParam->ttlFtr.down)&(MULTIBTN_FEATURE_MASK)));
        break;

      // n[hL[̏
      case vchrPageUp:
        return (executeAction((NNshParam->ttlFtr.up)&(MULTIBTN_FEATURE_MASK)));
        break;

      // uv(WO_C)̏
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrNextField:
        ret = executeAction(MULTIBTN_FEATURE_SELECTNEXT);
        break;

      // uv(WO_C)̏
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrPrevField:
        ret = executeAction(MULTIBTN_FEATURE_SELECTPREV);
        break;

      case chrCapital_T:  // TL[̓
      case chrSmall_T:
        // Xg̐擪\
        (void) executeAction(MULTIBTN_FEATURE_TOP);
        break;

      case chrCapital_B:    // BL[̓
      case chrSmall_B:
        // X^Cg̖ֈړ
        (void) executeAction(MULTIBTN_FEATURE_BOTTOM);
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedUp:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGUP;
#endif
        /** not break!!  **/
      case chrLeftArrow:         // J[\L[(5way)
      case chrRecordSeparator:   // J[\L[()̏
      case chrCapital_P:         // PL[̓
      case chrSmall_P:           // pL[̓
        // Oy[W̕\ 
        (void) executeAction(MULTIBTN_FEATURE_PREVPAGE);
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedDown:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGDOWN;
#endif
        /** not break!!  **/

      case chrRightArrow:     // J[\L[E(5wayE)
      case chrUnitSeparator:  // J[\L[()̏
      case chrCapital_N:      // NL[̓
      case chrSmall_N:        // nL[̓
        // y[W̕\ 
        (void) executeAction(MULTIBTN_FEATURE_NEXTPAGE);
        break;

      // JOG PushȈ(XgI)
      case vchrJogRelease:
#ifdef USE_CLIE
        if (NNshGlobal->tempStatus != NNSH_TEMPTYPE_CLEARSTATE)
        {
            // ꎞԂNA(܂킵Ƃ)
            NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
            break;
        }
#endif
        /*****  not break!! (XgI{)  *****/

      // HandEra JOG PushI/EnterL[͎̏(XgI)
      case chrCarriageReturn:
      case chrLineFeed:
        return (executeAction((NNshParam->ttlFtr.jogPush)&(MULTIBTN_FEATURE_MASK)));
        break;

      // obN{^/ESCL[/BSL[̏
      case vchrJogBack:
      case chrBackspace:
      case chrEscape:
        return (executeAction((NNshParam->ttlFtr.jogBack)&(MULTIBTN_FEATURE_MASK)));
        break;

      // Xy[XL[
      case chrSpace:
        // VMSGmF
        return (executeAction(MULTIBTN_FEATURE_NEWARRIVAL));
        break;

      case chrCapital_J:
      case chrSmall_J:
        // XԎw̃bZ[W擾
        return (executeAction(MULTIBTN_FEATURE_MESNUM));
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf
        return (executeAction(MULTIBTN_FEATURE_DISCONN));
        break;

      // CL[
      case chrCapital_C:
      case chrSmall_C:
        // foCX
        return (executeAction(MULTIBTN_FEATURE_DEVICEINFO));
        break;

      default:
        // ̑
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlSelEvt_ThreadMain                                     */
/*                                                      {^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlSelEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_MSGCHK:
        // ړI{^U
        return (executeAction((NNshParam->multiBtn6Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_OPEN_THREAD:
        // ړI{^P
        return (executeAction((NNshParam->multiBtn1Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_UPDATE_THREAD:
        // ړI{^Q
        return (executeAction((NNshParam->multiBtn2Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_DELETE_THREAD:
        // ړI{^R
        return (executeAction((NNshParam->multiBtn3Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_LIST_THREAD:
        // ړI{^T
        return (executeAction((NNshParam->multiBtn5Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_DISCONNECT:
        // ړI{^S
        return (executeAction((NNshParam->multiBtn4Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case CHKID_SELECT_GETMODE:
        // ړIXCb`P̐ݒXV
        if (updateMultiPurposeSwitch(NNshParam->usageOfTitleMultiSwitch1,
                                     CHKID_SELECT_GETMODE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;

      case CHKID_SELECT_MULTIPURPOSE:
        // ړIXCb`Q̐ݒXV
        if (updateMultiPurposeSwitch(NNshParam->usageOfTitleMultiSwitch2,
                                     CHKID_SELECT_MULTIPURPOSE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;
  
      default:
        // ̑
        return (false);
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlRepEvt_ThreadMain                                     */
/*                                              s[g{^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlRepEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlRepeat.controlID)
    {
      case BTNID_LISTPREV:
        // Py[Wֈړ
        return (executeAction(MULTIBTN_FEATURE_PREVPAGE));
        break;

      case BTNID_LISTNEXT:
        // Py[Wֈړ
        return (executeAction(MULTIBTN_FEATURE_NEXTPAGE));
        break;
  
      default:
        // ̑
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Handler_ThreadMain                                       */
/*                                          XǗʗpCxgnh */
/*=========================================================================*/
Boolean Handler_ThreadMain(EventType *event)
{
    Boolean        ret;
    FormType      *frm;
    RectangleType  dimF;

    ret = false;
    switch (event->eType)
    {
      case keyDownEvent:
        (void) keyDownEvt_ThreadMain(event);
        return (true);
        break;

      case fldEnterEvent:
        break;

      case ctlSelectEvent:
        return (ctlSelEvt_ThreadMain(event));
        break;

      case ctlRepeatEvent:
        return (ctlRepEvt_ThreadMain(event));
        break;

      case frmOpenEvent:
        break;

      case popSelectEvent:
        return (popEvt_ThreadMain(event));
        break;

      case lstSelectEvent:
        break;

      case lstEnterEvent:
        break;

      case lstExitEvent:
        break;

      case menuEvent:
        (void) menuEvt_ThreadMain(event);
        return (true);
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent :
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;
#endif  // #ifdef USE_HANDERA

      case menuOpenEvent:
        break;

      case sclRepeatEvent:
        break;

      case sclExitEvent:
        break;

      case penDownEvent:
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_TAPPED),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
	    // Gadget^bv(== XI)
            return (rctPointEvt_ThreadMain(event, frm, &dimF));
        }
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv(== X̉E[)

            // y[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTNEXT),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // y[W{^ꂽƂɂ
                return (executeAction(MULTIBTN_FEATURE_NEXTPAGE));
            }

            // Oy[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTPREV),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // Oy[W{^ꂽƂɂ
                return (executeAction(MULTIBTN_FEATURE_PREVPAGE));
            }

            // XIƂɂ
            FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
            return (rctPointEvt_ThreadMain(event, frm, &dimF));
        }
        return (false);
        break;

      default:
        break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   OpenForm_ThreadMain                                      */
/*                                         XǗʂJƂ̏  */
/*=========================================================================*/
void OpenForm_ThreadMain(FormType *frm)
{
    Err          ret;
    UInt16       lp;
    ControlType *ctlP;

    // I[vAItCX̌
    if ((NNshParam->offChkLaunch != 0)&&(NNshGlobal->bbsTitles == NULL))
    {
        create_offline_database();
    }

    // ړIXCb`P̏ݒʂɔf
    setMultiPurposeSwitch(frm, NNshParam->usageOfTitleMultiSwitch1,
                          CHKID_SELECT_GETMODE);

    // ړIXCb`Q̏ݒʂɔf
    setMultiPurposeSwitch(frm, NNshParam->usageOfTitleMultiSwitch2,
                          CHKID_SELECT_MULTIPURPOSE);

    // ړI{^P̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_OPEN_THREAD));
    CtlSetLabel(ctlP, NNshParam->multiBtn1Caption);

    // ړI{^Q̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_UPDATE_THREAD));
    CtlSetLabel(ctlP, NNshParam->multiBtn2Caption);

    // ړI{^R̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_DELETE_THREAD));
    CtlSetLabel(ctlP, NNshParam->multiBtn3Caption);

    // ړI{^S̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_DISCONNECT));
    CtlSetLabel(ctlP, NNshParam->multiBtn4Caption);

    // ړI{^T̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_LIST_THREAD));
    CtlSetLabel(ctlP, NNshParam->multiBtn5Caption);

    // ړI{^ŨLvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_MSGCHK));
    CtlSetLabel(ctlP, NNshParam->multiBtn6Caption);

    // BBSꗗ̍쐬(ꗗȂ΁ABBSꗗ擾悤)
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret != errNone)
    {
        // 쐬sAtH[͍XVȂAUʂ`悷
        Update_Thread_List(0, 0, NNSH_STEP_REDRAW);
        return;
    }

    // NNshParam->lastBBS(OIĂBBS)ςȂƂ(ꗗ̐擪ɂ)
    if (lp < NNshParam->lastBBS)
    {
        NNshParam->lastBBS = 0;
    }

    // BBSꗗ̃XgԂ𔽉fB
    NNshWinSetListItems(frm, LSTID_BBSINFO, NNshGlobal->bbsTitles, lp,
                        NNshParam->lastBBS, &(NNshGlobal->bbsTitleH), NULL);

    // |bvAbvgK̃x(XgԂɍ킹)XV
    NNshWinSetPopItems(frm, POPTRID_BBSINFO, LSTID_BBSINFO, NNshParam->lastBBS);

    // Xꗗ̕\XV
    Update_Thread_List(NNshParam->lastBBS, 
                       NNshParam->selectedTitleItem,
                       NNSH_STEP_REDRAW);

    // JtH[IDݒ肷(ݒ蒆ɂ́AlastFrmID͕ύXȂ)
    if ((NNshParam->useBookmark != 0)&&(NNshParam->bookMsgNumber != 0))
    {
        // ݒ蒆Ȃ̂ŁAȂ
    }
    else
    {
        NNshParam->lastFrmID = NNSH_FRMID_THREAD;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   menuEvt_ThreadMain                                       */
/*                                      XǗʗpj[[` */
/*-------------------------------------------------------------------------*/
static Boolean menuEvt_ThreadMain(EventType *event)
{
    Boolean err = false;

    switch (event->data.menu.itemID)
    {
      case MNUID_SHOW_DEVICEINFO:
        // foCX݂̌̏ԕ\
        (void) executeAction(MULTIBTN_FEATURE_DEVICEINFO);
        break;

      case MNUID_SHOW_VERSION:
        // o[W̕\
        (void) executeAction(MULTIBTN_FEATURE_VERSION);
        break;

      case MNUID_CONFIG_NNSH:
        // NNsiݒʂJ
        return (executeAction(MULTIBTN_FEATURE_NNSHSET));
        break;

      case MNUID_NET_DISCONN:
        // ؒf
        return (executeAction(MULTIBTN_FEATURE_DISCONN));
        break;

      case MNUID_UPDATE_CHECK:
        // VbZ[WmF
        return (executeAction(MULTIBTN_FEATURE_NEWARRIVAL));
        break;

      case MNUID_UPDATE_BBS:
        // XV(擾)
        return (executeAction(MULTIBTN_FEATURE_GETBBS));
        break;

      case MNUID_SELECT_BBS:
        // gpIʂJ
        return (executeAction(MULTIBTN_FEATURE_USEBBS));
        break;

      case MNUID_GET_NEWMESSAGE:
        // Xꗗ擾(SUBJECT.TXT擾)
        return (executeAction(MULTIBTN_FEATURE_GETLIST));
        break;

      case MNUID_INFO_MESSAGE:
        // X
        (void) executeAction(MULTIBTN_FEATURE_INFO);
        break;

      case MNUID_MODIFY_TITLE:
        // X^CgύX
        return (executeAction(MULTIBTN_FEATURE_MODTITLE));
        break;

      case MNUID_DEL_THREADLIST:
        // 擾X폜
        return (executeAction(MULTIBTN_FEATURE_DELNOTGET));
        break;

      case MNUID_DELETE_MESSAGE:
        // X폜
        err = executeAction(MULTIBTN_FEATURE_DELETE);
        break;

      case MNUID_GET_ALLMESSAGE:
        // bZ[WS擾(Ď擾)
        return (executeAction(MULTIBTN_FEATURE_ALLGET));
        break;

      case MNUID_UPDATE_MESSAGE:
        // bZ[W擾
        return (executeAction(MULTIBTN_FEATURE_PARTGET));
        break;

      case MNUID_OPEN_MESSAGE:
        // XQ
        return (executeAction(MULTIBTN_FEATURE_OPEN));
        break;

      case MNUID_FONT_MODE:
        // `惂[hύX
        return (executeAction(MULTIBTN_FEATURE_GRAPHMODE));
        break;

      case MNUID_FONT:
        // tHgύX
        return (executeAction(MULTIBTN_FEATURE_FONT));
        break;

      case MNUID_GET_MESSAGENUM:
        // XԎw̃bZ[W擾
        return (executeAction(MULTIBTN_FEATURE_MESNUM));
        break;

      case MNUID_SEARCH_TITLE:
        // ^Cg(̐ݒ)
        err = executeAction(MULTIBTN_FEATURE_SEARCH);
        break;

      case MNUID_SEARCH_NEXT:
        // X^C()
        err = executeAction(MULTIBTN_FEATURE_NEXT);
        break;

      case MNUID_SEARCH_PREV:
        // X^C(O)
        err = executeAction(MULTIBTN_FEATURE_PREV);
        break;

      case MNUID_MOVE_TOP:
        // X^Cg̐擪ֈړ
        return (executeAction(MULTIBTN_FEATURE_TOP));
        break;

      case MNUID_MOVE_BOTTOM:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        return (executeAction(MULTIBTN_FEATURE_BOTTOM));
        break;

      case MNUID_COPY_READONLY:
        // XQƐpOփRs[
        (void) executeAction(MULTIBTN_FEATURE_COPYGIKO);
        break;

      case MNUID_OS5_LAUNCH_WEB:
        // IXuEUŊJ
        (void) executeAction(MULTIBTN_FEATURE_OPENWEB);
        break;

      case MNUID_BACKUP_DATABASE:
        // DBVFSɃobNAbv
        (void) executeAction(MULTIBTN_FEATURE_DBCOPY);
        break;

      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        (void) executeAction(MULTIBTN_FEATURE_NETWORK);
        break;

      case MNUID_SORT_SUBJECT:
        // X̐s
        return (executeAction(MULTIBTN_FEATURE_SORT));
        break;

#ifdef USE_HANDERA
      case MNUID_HANDERA_ROTATE:
        // HandEra ʉ] //
        (void) executeAction(MULTIBTN_FEATURE_ROTATE);
        break;
#endif  // #ifdef USE_HANDERA

      case MNUID_CONFIG_USER1TAB:
        // [U^uPݒ 
        (void) executeAction(MULTIBTN_FEATURE_USER1TAB);
        break;

      case MNUID_CONFIG_USER2TAB:
        // [U^uQݒ 
        (void) executeAction(MULTIBTN_FEATURE_USER2TAB);
        break;
      case MNUID_NEW_THREAD:
        // X
        (void) executeAction(MULTIBTN_FEATURE_NEWTHREAD);
        break;

      default:
        // ̑(肦Ȃ͂...)
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (err);
}

/*=========================================================================*/
/*   Function : NNsi_RedrawThreadList                                      */
/*                                                    Xꗗʂĕ` */
/*=========================================================================*/
void NNsi_RedrawThreadList(void)
{
    FormType      *frm;
    RectangleType  dimF;
    UInt16         fontID, fontHeight, nlines;

    if (FrmGetActiveFormID() == FRMID_THREAD)
    {
        frm = FrmGetActiveForm();
        FrmDrawForm(frm);    	
        FrmGetObjectBounds(frm,
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), 
                           &dimF);
        if (NNshParam->useSonyTinyFontTitle == 0)
        {
            fontID = NNshParam->currentFont;
        }
        else
        {
            fontID = NNshParam->sonyHRFontTitle;
        }
        NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                             &fontID, &fontHeight, &nlines);
        NNsi_WinDrawList(NNshParam->selectedTitleItem, 
                         NNshGlobal->msgTitleIndex, nlines,
                         &dimF, fontHeight);
    }
    return;
}
