/*============================================================================*
 *  FILE: 
 *     machine.c
 *
 *  Description: 
 *     Palm device specific functions.
 *
 *===========================================================================*/
#define MACHINE_C

#ifdef USE_CLIE
// SONYpWOAVXg}XN
#define NUMBER_OF_MASKS   3
UInt16 NNshSonyJogMask[] = {
     sonyJogAstMaskType1, // tH[ɌʂɃ}XNݒ肷
     NUMBER_OF_MASKS,     // }XNtH[
     FRMID_MESSAGE,       sonyJogAstMaskAll,
     FRMID_MANAGEBBS,     sonyJogAstMaskAll,
     FRMID_THREAD,        sonyJogAstMaskAll,
     0, 0, 0, 0           // |]T...
};
#endif

extern Err setOfflineLogDir(Char *fileName);

/*-------------------------------------------------------------------------*/
/*   Function :   checkVFSdevice_NNsh                                      */
/*                               VFS̃T|[g󋵂p[^ɔf */
/*-------------------------------------------------------------------------*/
static void checkVFSdevice_NNsh(void)
{
    Err            err;
    Char           dirName[sizeof(DATAFILE_PREFIX)+ MARGIN];
    UInt32         vfsMgrVersion, volIterator;
    VolumeInfoType volInfo;  

    // VFS̃T|[gLmFB
    vfsMgrVersion = 0;
    err = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &vfsMgrVersion);
    if (err == errNone)
    {
        //  VFSgp\mFB(t@X}jAƂɂ)
        volIterator = vfsIteratorStart;
        while (volIterator != vfsIteratorStop)
        {
            err = VFSVolumeEnumerate(&(NNshGlobal->vfsVol), &volIterator);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeEnumerate()", "", err);
                break;
            }
            err = VFSVolumeInfo(NNshGlobal->vfsVol, &volInfo);
            if (err != errNone)
            {
                NNsh_DebugMessage(ALTID_WARN, "VFSVolumeInfo()", "", err);
                break;
            }
            if (volInfo.fsType == vfsFilesystemType_VFAT)
            {
                // "VFSgp\ɎIVFS ON" ݒmF
                if (NNshParam->vfsOnAutomatic != 0)
                {

                    // VFS ONɂ
                    NNshParam->useVFS = ((NNSH_VFS_ENABLE)|
                                         (NNSH_VFS_WORKAROUND)|
                                         (NNSH_VFS_USEOFFLINE)|
                                         (NNSH_VFS_DBBACKUP));
					 
                    if (NNshParam->vfsOnNotDBCheck == 0)
                    {
                        //  "VFS ONłDB`FbNȂ"  OFF̂Ƃ
                        //  (NDB`FbNnmɂ)
                        NNshParam->useVFS = 
                                      (NNshParam->useVFS|(NNSH_VFS_DBIMPORT));
                    }
                }
                if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
                {
                    // NNshpf[^i[pfBNg쐬(VFS ON)
                    StrCopy(dirName, DATAFILE_PREFIX);
                    dirName[StrLen(dirName) - 1] = '\0';
                    err = CreateDir_NNsh(dirName);
                    NNsh_DebugMessage(ALTID_INFO, "Created :", dirName, err);
                    err = errNone;
		}
                if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
                {
                    // NNshpOFFLINEf[^i[fBNg쐬(VFS ON)
                    StrCopy(dirName, LOGDATAFILE_PREFIX);
                    dirName[StrLen(dirName) - 1] = '\0';
                    err = CreateDir_NNsh(dirName);
                    NNsh_DebugMessage(ALTID_INFO,"Created :",dirName,err);

                    // logdir.txtǂOFFLINEOx[XfBNg擾
                    (void) setOfflineLogDir(LOGDIR_FILE);
                    err = errNone;
		}
                break;
            }
        }
    }
    if (err != errNone)
    {
        // foCXVFST|[gȂꍇ́ANNshݒVFSgpݒNA
        NNshParam->useVFS = NNSH_NOTSUPPORT_VFS;
    }
    return;
}

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   CLIEdisplayNotify                                        */
/*                                                CLIEfBXvCXV() */
/*-------------------------------------------------------------------------*/
Err CLIEdisplayNotify(SysNotifyParamType *notifyP)
{
    FormType *frm;

    // ---------------------------------------------------
    //    ӁFnotifyP ́ANULLŃR[
    // ---------------------------------------------------
    if (NNshGlobal->silkRef != 0)
    {
        frm = FrmGetActiveForm();
        HandEraResizeForm(frm);
        //   ʕ\̍XV́AW̃Cxg[vōsB̂߂ɁA
        // `wtOύXAnilEvent𔭍sB
        NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;
        UpdateFieldRegion();
        EvtWakeup();
    }
    return (errNone);
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   setCLIESupport_NNsh                                      */
/*                                              CLIET|[g@\ݒ肷 */
/*-------------------------------------------------------------------------*/
static void setCLIESupport_NNsh(void)
{
    SonySysFtrSysInfoP     infoP;
    Boolean                isColor;
    UInt32                 vskVer, width, height, depth;
    Err                    ret;

    infoP                        = NULL;
    NNshGlobal->jogAssistSetBack = NULL;

    // SONYfoCXǂ̃`FbN
    if ((FtrGet(sysFtrCreator, sysFtrNumOEMCompanyID, &depth) != 0)||
        (depth != sonyHwrOEMCompanyID_Sony))
    {
        // SONYfoCXłȂ΁AI
        return;
    }

    // JOGAVXg@\̐ݒ
    if (!FtrGet(sonySysFtrCreator, sonySysFtrNumSysInfoP, (UInt32 *)&infoP))
    {
        // JOGAVXg@\Ă邩ǂ`FbN
        if (infoP && (infoP->extn & sonySysFtrSysInfoExtnJogAst))
        {
            // ݂̃WOAVXg擾
            if(!FtrGet(sonySysFtrCreator, sonySysFtrNumJogAstMaskP,
                       (UInt32 *) &(NNshGlobal->jogAssistSetBack)))
            {
                // ݂̃WOAVXgۊǁANNsip̐ݒ
                 NNshGlobal->jogInfoBack =
                                            *(NNshGlobal->jogAssistSetBack);
                *(NNshGlobal->jogAssistSetBack) =  NNshSonyJogMask;

                // WOAVXgI[in̐ݒ͏ȗ(񂾂)
            }
        }
    }

    // SILK}l[W̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameSilk, &(NNshGlobal->silkRef));
    if (ret == sysErrLibNotFound)
    {
        // SILK}l[W[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr',sonySysFileCSilkLib,&(NNshGlobal->silkRef));
    }
    if (ret != errNone)
    {
        // 281Silk}l[WR[h}[W
        ret = SysLibLoad(sonySysFileTSilkLib,
                         sonySysFileCSilkLib,
                         &(NNshGlobal->silkRef));    // OS5
        if (ret != errNone)
        {
            ret = SysLibLoad('libr','SlSi',&(NNshGlobal->silkRef));
        }
        if (ret != errNone)
        {
            // SILK}l[W͎gpłȂAɂSONY HRLIB[h
            NNshGlobal->silkRef = 0;
            goto SONY_HRLIB_LOAD;
        }
    }

    // SILKgpȂꍇɂ͎ɐi
    if (NNshGlobal->notUseSilk != 0)
    {
        NNshGlobal->silkRef = 0;
        NNshGlobal->silkVer = 1;
        goto SONY_HRLIB_LOAD;
    }

    // SILK}l[W̃o[WmF
    ret = FtrGet(sonySysFtrCreator, sonySysFtrNumVskVersion, &vskVer);
    if (ret != errNone)
    {
        // SILK}l[WVERSION1ATCŶ݃T|[g(NRp)
        if (SilkLibOpen(NNshGlobal->silkRef) == errNone)
        {
            // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
            SilkLibEnableResize(NNshGlobal->silkRef);
            NNshGlobal->silkVer = 1;
        }
    }
    else
    {
        // SILK}l[WVERSION2A(NXȍ~)
        if (VskOpen(NNshGlobal->silkRef) == errNone)
        {
            // SILK̃TCYT|[gĂ邱Ƃ(SILK}l[W)ʒm
            VskSetState(NNshGlobal->silkRef, vskStateEnable, 1);
            NNshGlobal->silkVer = 2;
        }
    }

    // sysNotifyDisplayChangeEventsubscribe
    ret = SysNotifyRegister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                            CLIEdisplayNotify, sysNotifyNormalPriority,
                            NULL);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_WARN, "SysNotifyRegister()", "", ret);
    }

SONY_HRLIB_LOAD:
    // SONY HiResgpȂꍇɂ́AŏI
    if (NNshParam->disableSonyHR != 0)
    {
        // HRLIB͎gpȂ
        NNshGlobal->hrRef    = 0;
        NNshGlobal->notUseHR = NNshParam->disableSonyHR;
        return;
    }

    // HRLIB̎QƔԍ擾
    ret = SysLibFind(sonySysLibNameHR, &(NNshGlobal->hrRef));
    if (ret == sysErrLibNotFound)
    {
        // HRLIB[h̏ꍇA[hł邩TryĂ݂B
        ret = SysLibLoad('libr', sonySysFileCHRLib, &(NNshGlobal->hrRef));
    }
    if (ret != errNone)
    {
        // HRLIB͎gpłȂ
        NNshGlobal->hrRef = 0;
        return;
    }
    // HRLIB̎gp錾HRLIB̃o[Wԍ擾
    HROpen(NNshGlobal->hrRef);
    HRGetAPIVersion(NNshGlobal->hrRef, &(NNshGlobal->hrVer));
    if (NNshGlobal->hrVer < HR_VERSION_SUPPORT_FNTSIZE)
    {
        // o[W̃nC]...ʃ[hmF...
        ret = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet, 
                              &width, &height, &depth, &isColor);
        if (ret != errNone)
        {
            // HRLIB͎gpȂ
            HRClose(NNshGlobal->hrRef);
            NNshGlobal->hrRef = 0;
            return;
        }

        NNshGlobal->prevHRWidth = width;
        if (width != hrWidth)
        {
            // ʃ[hnC]łȂ̂ŁAnC][hɐ؂ւ
            width  = hrWidth;
            height = hrHeight;
            ret    = HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                     &width, &height, &depth, &isColor);
            if (ret != errNone)
            {
                // HRLIB͎gpȂ
                HRClose(NNshGlobal->hrRef);
                NNshGlobal->hrRef = 0;
                return;
            }
        }
    }
    else
    {
        // ʃ[h͕ύXȂB
        NNshGlobal->prevHRWidth = hrWidth;
    }
    return;
}
#endif

#ifdef USE_CLIE
/*-------------------------------------------------------------------------*/
/*   Function :   resetCLIESupport_NNsh                                    */
/*                                                  CLIET|[g */
/*-------------------------------------------------------------------------*/
static void resetCLIESupport_NNsh(void)
{
    Boolean                isColor;
    UInt32                 width, height, depth;

    // JOGAVXg@\ɖ߂
    if (NNshGlobal->jogAssistSetBack != NULL)
    {
        *(NNshGlobal->jogAssistSetBack) = NNshGlobal->jogInfoBack;
    }

    if (NNshGlobal->silkRef == 0)
    {
        // SONYpVN̋@\gpȂꍇɂHRLIB̉
        goto SONY_HRLIB_UNLOAD;
    }

    // sysNotifyDisplayChangeEventunsubscribe
    (void) SysNotifyUnregister(0, SOFT_CREATOR_ID, sysNotifyDisplayChangeEvent,
                               sysNotifyNormalPriority);

    // SILK}l[W̉
    if (NNshGlobal->silkVer == 1)
    {
        // SILK}l[W(NRp)
        SilkLibDisableResize(NNshGlobal->silkRef);
        SilkLibClose(NNshGlobal->silkRef);
    }
    else
    {
        // VSILK}l[W(NXȍ~)
        VskSetState(NNshGlobal->silkRef, vskStateEnable, 0);
        VskClose(NNshGlobal->silkRef);
    }

SONY_HRLIB_UNLOAD:
    if (NNshGlobal->hrRef != 0)
    {
        // AvNɁAʃ[h猳ɖ߂
        if (NNshGlobal->prevHRWidth != hrWidth)
        {
            HRWinScreenMode(NNshGlobal->hrRef, winScreenModeGet,
                            &width, &height, &depth, &isColor);
            width      = stdWidth;
            height     = stdHeight;
            (void) HRWinScreenMode(NNshGlobal->hrRef, winScreenModeSet,
                                   &width, &height, &depth, &isColor);
        }
        // Sony HRLIB̎gpI
        HRClose(NNshGlobal->hrRef);
    }
    return;
}
#endif

#ifdef USE_HANDERA
/*-------------------------------------------------------------------------*/
/*   Function :   setHandEraSupport_NNsh                                   */
/*                                               HandErafoCX̃`FbN */
/*-------------------------------------------------------------------------*/
static void setHandEraSupport_NNsh(void)
{
    UInt32              handEraOsVersion;
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h

    // HandEra QVGA T|[gLmFB
    handEraOsVersion = 0;
    if (_TRGVGAFeaturePresent(&handEraOsVersion))          
    {
        NNshGlobal->device = NNSH_DEVICE_HANDERA;
    }

    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
        VgaSetScreenMode(screenMode1To1, handEraRotateMode);
    }
}
#endif // #ifdef USE_HANDERA

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveObject                                        */
/*                                                     IuWFNg̈ړ  */
/*-------------------------------------------------------------------------*/
static void HandEraMoveObject(FormPtr frmP, UInt16 objIndex,
                              Coord x_diff, Coord y_diff)
{
    Boolean move = true;
    Coord   old_x, old_y;

#ifdef USE_GLUE
    if (FrmGlueGetObjectUsable(frmP, objIndex) != true)
    {
        // BĂIuWFNg͈ړȂ
    	move = false;
    }
    else
#endif
    {
        FrmHideObject(frmP, objIndex);
    }
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 110)
    {
        // ̕ɂIuWFNg͈ړȂ
        // ([x^...ƃJbR...)
        // x_diff = 0;
        y_diff = 0;
    }
    FrmSetObjectPosition(frmP, objIndex, old_x + x_diff, old_y + y_diff);

    // ړIuWFNg\
    if (move == true)
    {
        FrmShowObject(frmP, objIndex);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeObject                                      */
/*                                                 IuWFNg̃TCY  */
/*-------------------------------------------------------------------------*/
static void HandEraResizeObject(FormPtr frmP, UInt16 objIndex,
                                Coord x_diff, Coord y_diff)
{
    RectangleType r;
    Coord         old_x, old_y;

    FrmHideObject(frmP, objIndex);

    // IuWFNg̃TCY
    FrmGetObjectPosition(frmP, objIndex, &old_x, &old_y);
    if (old_y < 11)
    {
        // ̕ɂIuWFNg͑ɂȂ
        // (Ƃ肠...l...)
        return;
    }

    FrmGetObjectBounds(frmP, objIndex, &r);
    r.extent.x += x_diff;
    r.extent.y += y_diff;
    FrmSetObjectBounds(frmP, objIndex, &r);

    FrmShowObject(frmP, objIndex);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraResizeForm                                        */
/*                                                     tH[̃TCY  */
/*-------------------------------------------------------------------------*/
void HandEraResizeForm(FormPtr frmP)
{
    Coord           x, y, xDiff, yDiff;
    RectangleType   r;
    UInt16          objectIndex, numObjects, rowNum, nofRow, height;
    Int16           fldIndex, sclIndex;
    TableType      *tableP;
    ControlType    *ctlPtr;
    FormObjectKind  objType;
    WinHandle       winH;

    winH = FrmGetWindowHandle(frmP);
    if (WinModal(winH) == true)
    {
        /** [_tH[AEBhẼTCY͎{Ȃ **/
        return;
    }

    /**  **/
    fldIndex = -1;
    sclIndex = -1;

    /* VTCY */
    WinGetDisplayExtent(&x, &y);
    
    /* TCY */
    FrmGetFormBounds(frmP, &r);

    /* [_tH[łȂꍇAȂȉ̔Kvisj */
    r.topLeft.x = r.topLeft.x + 1;
    r.topLeft.y = r.topLeft.y + 1;
    r.extent.x  = r.extent.x  - 2;
    r.extent.y  = r.extent.y  - 2;

    xDiff = x - (r.topLeft.x + r.extent.x);
    yDiff = y - (r.topLeft.y + r.extent.y);

    if ((xDiff == 0)&&(yDiff == 0))
    {
        return;
    }

    /* TCY */
    r.extent.x = r.extent.x + xDiff;
    r.extent.y = r.extent.y + yDiff;
    WinSetWindowBounds(winH, &r);
        
    /* IuWFNg̈ړATCY */
    numObjects = FrmGetNumberOfObjects(frmP);
    for (objectIndex = 0; objectIndex < numObjects; objectIndex++)
    {
        objType = FrmGetObjectType(frmP, objectIndex);
        switch (objType)
        {
          case frmFieldObj:
            // tB[ḧړiXԓFieldjATCYiX\Fieldj
            if (FldGetVisibleLines((FieldType *) 
                                     FrmGetObjectPtr(frmP, objectIndex)) == 1)
            {
                // tB[ḧړ
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            else
            {
                // tB[h̃TCY
                HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
                fldIndex = objectIndex;
            }
            break;
          case frmControlObj:
            // {^֘Äړ
            ctlPtr = (ControlType *)FrmGetObjectPtr(frmP, objectIndex);
#if 0
            if ((CtlGlueGetControlStyle(ctlPtr) == buttonCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == checkboxCtl)||
                (CtlGlueGetControlStyle(ctlPtr) == repeatingButtonCtl))
#endif
            {
                HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            }
            break;
          case frmTableObj:
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            tableP = FrmGetObjectPtr(frmP, objectIndex);
            nofRow = TblGetNumberOfRows(tableP);
            TblGetBounds(tableP, &r);
            height = (r.extent.y - r.topLeft.y) / nofRow + 1;
            for (rowNum = 0; rowNum < nofRow; rowNum++)
            {
                TblSetRowHeight(tableP, rowNum, height);
            }
            break;

          case frmGadgetObj:
            // KWFbg̃TCY
            HandEraResizeObject(frmP, objectIndex, xDiff, yDiff);
            break;

          case frmLabelObj:
          case frmGraffitiStateObj:
            // GSÏړ
            HandEraMoveObject(frmP, objectIndex, 0, yDiff);
            break;

          case frmScrollBarObj:
            // XN[o[̃TCYAړ
            HandEraResizeObject(frmP, objectIndex, 0, yDiff);
            HandEraMoveObject(frmP, objectIndex, xDiff, 0);
            sclIndex = objectIndex;
            break;

          case frmListObj:
            // XgIuWFNg͉ȂB

          default:
            // ???(Ȃ)
            break;
        }
    }
    if ((fldIndex >= 0) && (sclIndex >= 0))
    {
        // XN[o[̃Abvf[g
        NNshWinViewUpdateScrollBar(
              FrmGetObjectId(frmP, fldIndex), FrmGetObjectId(frmP, sclIndex)); 
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   HandEraMoveDialog                                        */
/*                                                   _CÖړ      */
/*-------------------------------------------------------------------------*/
void HandEraMoveDialog(FormPtr frmP)
{
    Coord         x, y;
    RectangleType r;

#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        r.topLeft.x += 2; 
        r.topLeft.y += 2; 
        r.extent.x -= 4;
        r.extent.y -= 4;
        goto MOVE_OBJECT;
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        /* Ŝ̃TCY */
        WinGetDisplayExtent(&x, &y);
    
        /* dialog̃TCY */
        FrmGetFormBounds(frmP, &r);

        /* Ȃȉ̔Kvisj */
        // r.topLeft.x -=2;
        // r.topLeft.y -=2;
        r.extent.x  -= 4;
        r.extent.y  -= 4;
        goto MOVE_OBJECT;
    }
#endif
    return;

MOVE_OBJECT:
    /* dialog̈ړ */
    if (y - (r.topLeft.y + r.extent.y) < 0)
    {
        r.topLeft.y = y - r.extent.y;
    }
    WinSetWindowBounds(FrmGetWindowHandle(frmP), &r);

    NNsi_FrmDrawForm(frmP, true);

    return;
}

/*=========================================================================*/
/*   Function :   NNshRestoreNNsiSetting                                   */
/*                                                     NNsiݒ̓ǂݍ  */
/*=========================================================================*/
void NNshRestoreNNsiSetting(Int16 version, UInt16 size, NNshSavedPref *prm)
{
    Err           ret;
    UInt32        offset;
    UInt16        cnt, nofRec;
    DmOpenRef     dbRef;
    Char         *ptr;
    RGBColorType  color;

    // NNsiݒ̗̈
    nofRec = 0;

    if ((version == SOFT_PREFVERSION)&&(size == sizeof(NNshSavedPref)))
    {
        //  ݒ肳ꂽo[WƍNꂽo[Wэ\̃TCY
        // ꍇ̂݁ANNsiݒ𕜋B

        // ϐ 
        offset = 0;
        ptr    = (Char *) prm;

        // caANNsiݒǂݏo(R[h̓o^̌ˍŁAAA)
        OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
        GetDBCount_NNsh(dbRef, &nofRec);
        cnt = nofRec;
        while ((cnt != 0)&&(offset < sizeof(NNshSavedPref)))
        {
            ret = GetRecord_NNsh(dbRef,(cnt - 1),DBSIZE_SETTING, &ptr[offset]);
            if (ret != errNone)
            {
                // f[^ǂݏoɎs(̏ꍇANNsiݒ͏)
                NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_READFAIL, "", ret);
                nofRec = 0;
                break;
            }
            cnt--;
            offset = offset + DBSIZE_SETTING;
        }
        CloseDatabase_NNsh(dbRef);
    }
    if (nofRec == 0)
    {
        // NNsiݒ
        prm->lastFrmID            = NNSH_FRMID_THREAD;
        prm->bufferSize           = NNSH_WORKBUF_DEFAULT;
        prm->partGetSize          = NNSH_WORKBUF_DEFAULT;
        prm->netTimeout           = NNSH_NET_TIMEOUT;
        prm->currentFont          = NNSH_DEFAULT_FONT;
        prm->sonyHRFont           = NNSH_DEFAULT_FONT_HR;
        prm->sonyHRFontTitle      = NNSH_DEFAULT_FONT_HR;
        prm->useCookieWrite       = NNSH_ENABLE;
        prm->disableUnderline     = NNSH_ENABLE;
        prm->writeBufferSize      = NNSH_WRITEBUF_DEFAULT;
        prm->writeAlwaysSage      = NNSH_ENABLE;
        prm->printNofMessage      = NNSH_ENABLE;
        prm->notListReadOnly      = NNSH_ENABLE;
        prm->autoOpenNotRead      = NNSH_ENABLE;
        prm->addReturnToList      = NNSH_ENABLE;
        prm->addMenuGraphView     = NNSH_ENABLE;
        prm->addMenuBackRtnMsg    = NNSH_ENABLE;
        prm->addMenuGraphTitle    = NNSH_ENABLE;
        prm->newArrivalNotRead    = NNSH_SELBBS_NOTREAD;
        prm->displayFavorLevel    = NNSH_MSGATTR_FAVOR_L1;
        prm->useSonyTinyFontTitle = NNSH_ENABLE;
        prm->useSonyTinyFont      = NNSH_ENABLE;

#ifdef USE_COLOR
        // OS 3.5ȏ̏ꍇ
        if (NNshGlobal->palmOSVersion >= 0x03503000)
        {
            // ԐF(G[)
            MemSet(&color, sizeof(color), 0x00);
            color.r = 255;
            prm->colorError       = WinRGBToIndex(&color);

            // (Sēǂ񂾁A1000A㉺{^)
            MemSet(&color, sizeof(color), 0x00);
            prm->colorAlready     = WinRGBToIndex(&color);
            prm->colorOver        = prm->colorAlready;
            prm->colorButton      = prm->colorOver;
            prm->colorViewFG      = prm->colorButton;

            // (ǂ)
            // MemSet(&color, sizeof(color), 0x00);
            color.b = 100;
            prm->colorRemain      = WinRGBToIndex(&color);

            // (VK擾A擾)
            MemSet(&color, sizeof(color), 0x00);
            color.b = 255;
            prm->colorNew         = WinRGBToIndex(&color);
            prm->colorUpdate      = prm->colorNew;

            // DF(擾Ȃ)
            MemSet(&color, sizeof(color), 0x00);
            color.r = 128;
            color.g = 128;
            color.b = 128;
            prm->colorNotYet      = WinRGBToIndex(&color);
            prm->colorUnknown     = prm->colorNotYet;
            prm->colorOver        = prm->colorNotYet;
        }
#endif
        // ړIXCb`P(ꗗ)
        prm->usageOfTitleMultiSwitch1 = NNSH_SWITCH1USAGE_DEFAULT;

        // ړIXCb`Q(ꗗ)
        prm->usageOfTitleMultiSwitch2 = NNSH_SWITCH2USAGE_DEFAULT;

        // ړI{^P(ꗗ)
        StrCopy(prm->multiBtn1Caption, MULTIBTN1_CAPTION_DEFAULT);
        prm->multiBtn1Feature = ((MULTIBTN1_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ړI{^Q(ꗗ)
        StrCopy(prm->multiBtn2Caption, MULTIBTN2_CAPTION_DEFAULT);
        prm->multiBtn2Feature = ((MULTIBTN2_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ړI{^R(ꗗ)
        StrCopy(prm->multiBtn3Caption, MULTIBTN3_CAPTION_DEFAULT);
        prm->multiBtn3Feature = ((MULTIBTN3_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ړI{^S(ꗗ)
        StrCopy(prm->multiBtn4Caption, MULTIBTN4_CAPTION_DEFAULT);
        prm->multiBtn4Feature = ((MULTIBTN4_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ړI{^T(ꗗ)
        StrCopy(prm->multiBtn5Caption, MULTIBTN5_CAPTION_DEFAULT);
        prm->multiBtn5Feature = ((MULTIBTN5_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ړI{^U(ꗗ)
        StrCopy(prm->multiBtn6Caption, MULTIBTN6_CAPTION_DEFAULT);
        prm->multiBtn6Feature = ((MULTIBTN6_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ꗗn[hL[ݒ
        prm->ttlFtr.up = ((UPBTN_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ꗗn[hL[ݒ
        prm->ttlFtr.down = ((DOWNBTN_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ꗗJOG Push{^ݒ
        prm->ttlFtr.jogPush = ((JOGPUSH_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ꗗJOG Back{^ݒ
        prm->ttlFtr.jogBack = ((JOGBACK_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // ꗗCapture{^ݒ
        prm->ttlFtr.clieCapture = ((CAPTURE_FEATURE_DEFAULT)|(MULTIBTN_FEATURE));

        // QƎn[hL[ݒ
        prm->viewFtr.up   = ((UPBTN_VIEWFEATURE_DEFAULT)|(MULTIVIEWBTN_FEATURE));

        // QƎn[hL[ݒ
        prm->viewFtr.down = ((DOWNBTN_VIEWFEATURE_DEFAULT)|(MULTIVIEWBTN_FEATURE));

        // QƎ JOG Push{^ݒ
        prm->viewFtr.jogPush     = ((JOGPUSH_VIEWFEATURE_DEFAULT)|(MULTIVIEWBTN_FEATURE));

        // QƎ JOG Back{^ݒ
        prm->viewFtr.jogBack     = ((JOGBACK_VIEWFEATURE_DEFAULT)|(MULTIVIEWBTN_FEATURE));

        // QƎ Capture{^ݒ
        prm->viewFtr.clieCapture = ((CAPTURE_VIEWFEATURE_DEFAULT)|(MULTIVIEWBTN_FEATURE));

        // [UݒP̊mF
        prm->custom1.newArrival = NNSH_SELBBS_CUSTOM1;
        prm->custom1.getList    = NNSH_SELBBS_CUSTOM1;
        prm->custom1.boardNick  = NNSH_SELBBS_CUSTOM1;
        StrCopy(prm->custom1.tabName, CUSTOM1_THREAD_NAME);
        prm->custom1.condition  = NNSH_CONDITION_GETERR_ERROR;

        // [UݒQ̊mF(Palm֘ÃXoݒ)
        prm->custom2.newArrival = NNSH_SELBBS_CUSTOM2;
        prm->custom2.getList    = NNSH_SELBBS_CUSTOM2;
        prm->custom2.boardNick  = NNSH_SELBBS_CUSTOM2;

        StrCopy(prm->custom2.tabName, CUSTOM2_THREAD_NAME);
        StrCopy(prm->custom2.string1, NNSH_STRING_CUSTOM2_DEFAULT1);
        StrCopy(prm->custom2.string2, NNSH_STRING_CUSTOM2_DEFAULT2);
        StrCopy(prm->custom2.string3, NNSH_STRING_CUSTOM2_DEFAULT3);
        prm->custom2.stringSet  = NNSH_STRING_SELECTION | NNSH_STRING_OR;

        // ꗗ\ɏd̊mF{悤ύX
        prm->checkDuplicateThread = NNSH_ENABLE;

        // ʐM^CAEgAPĎs悤ύX
        prm->nofRetry = 1;

        // VG[ƍĎ擾悤ύX
        prm->autoUpdateGetError   = NNSH_ENABLE;

        // WBBSꗗ擾(URL)𔽉f
        StrCopy(prm->bbs_URL, URL_BBSTABLE);
        NNsh_WarningMessage(ALTID_WARN, MSG_NNSISET_REFRESH, "", 0);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshSaveNNsiSetting                                      */
/*                                                         NNsiݒ̋L  */
/*-------------------------------------------------------------------------*/
static void NNshSaveNNsiSetting(Int16 version, UInt16 size,
                                NNshSavedPref *param)
{
    Err       ret;
    UInt32    offset;
    UInt16    nofRec;
    DmOpenRef dbRef;
    Char      *ptr;

    OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
    GetDBCount_NNsh(dbRef, &nofRec);
    while (nofRec != 0)
    {
        //  łNNsiݒ肪L^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRef, (nofRec - 1));
        nofRec--;
    }

    // NNsiݒDBɓo^(R[ho^̌ˍɒӁI)
    offset = 0;
    ptr    = (Char *) param;
    while (offset < sizeof(NNshSavedPref))
    {
        ret = EntryRecord_NNsh(dbRef, DBSIZE_SETTING, &ptr[offset]);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_WARN, "EntryRecord_NNsh()", "", ret);
            NNsh_DebugMessage(ALTID_WARN, "    ", "offset:", offset);
            NNsh_DebugMessage(ALTID_WARN, "    ", "size:", DBSIZE_SETTING);
            break;
        }
        offset = offset + DBSIZE_SETTING;
    }
    CloseDatabase_NNsh(dbRef);

    return;
}

/*=========================================================================*/
/*   Function :   NNshSilkMinimize                                         */
/*                                          OtBeBGAŏ */
/*=========================================================================*/
Err NNshSilkMinimize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMinimizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ŏs
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeToStatus);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMin);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*=========================================================================*/
/*   Function :   NNshSilkMaximize                                         */
/*                                          OtBeBGAő剻 */
/*=========================================================================*/
Err NNshSilkMaximize(FormType *frm)
{
#ifdef USE_HANDERA
    if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        SilkMaximizeWindow();
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
#ifdef USE_CLIE
    // SILK}l[WnodmĂ邩H
    if (NNshGlobal->silkRef != 0)
    {
        // SILK̍ő剻s
        if (NNshGlobal->silkVer == 1)
        {
            // Version1(NRp)
            SilkLibResizeDispWin(NNshGlobal->silkRef, silkResizeNormal);
        }
        else
        {
            // Version2(NXȍ~)
            VskSetState(NNshGlobal->silkRef, vskStateResize, vskResizeMax);
        }
        HandEraResizeForm(frm);
        return (errNone);
    }
#endif
    return (~errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   NNshClearGlobal                                          */
/*                                          NNsĩO[öJ */
/*-------------------------------------------------------------------------*/
static void NNshClearGlobal(NNshWorkingInfo *workBuf)
{
    NNshMessageIndex *idxP;

    MEMFREE_HANDLE(workBuf->searchTitleH);
    MEMFREE_HANDLE(workBuf->boardIdxH);
    MEMFREE_HANDLE(workBuf->logPrefixH);
    MEMFREE_HANDLE(workBuf->bbsTitleH);
    MEMFREE_PTR(workBuf->bbsTitles);

    if (workBuf->msgIndex != NULL)
    {
        idxP = workBuf->msgIndex;
        CloseFile_NNsh(&(idxP->fileRef));
        MEMFREE_PTR(workBuf->msgIndex);
    }

    MEMFREE_PTR(workBuf->tempInfo);

    return;
}

/*=========================================================================*/
/*   Function :   BackupDatabaseToVFS                                      */
/*                                         NNsiDBVFSɃobNAbv */
/*=========================================================================*/
void BackupDBtoVFS(UInt16 backupAllDB)
{
    Err   ret;
    Char *buf, flag;

    flag = 0;

    // BUSYEBhE̕\̈m
    buf = MemPtrNew(BUFSIZE);
    if (buf == NULL)
    {

        // G[\
        NNsh_DebugMessage(ALTID_ERROR,"Cannot Alloc BUFFER"," size:",BUFSIZE);
        return;
    }
    MemSet(buf, BUFSIZE, 0x00);

    // (BBS-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_BBSLIST);
    Show_BusyForm(buf);
    if (backupAllDB != 0)
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_BBSLIST);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 1;
        }
    }

    // (Subject-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_SUBJECT);
    SetMsg_BusyForm(buf);

    if ((backupAllDB != 0)||
        (((NNshGlobal->updateDatabaseInfo) & (NNSH_DB_UPDATE_SUBJECT)) != 0))
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_SUBJECT);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 2;
        }
    }

    // (Settings-NNsĩobNAbv)
    StrCopy(buf, MSG_NNSI_DBBACKUP_BUSY);
    StrCat (buf, DBNAME_SETTING);
    SetMsg_BusyForm(buf);

    if ((backupAllDB != 0)||
        (((NNshGlobal->updateDatabaseInfo) & (NNSH_DB_UPDATE_SETTING)) != 0))
    {
        ret = BackupDatabaseToVFS_NNsh(DBNAME_SETTING);
        if (ret != errNone)
        {
            // G[łȂ
            flag = flag + 4;
        }
    }

    // BUSY\
    Hide_BusyForm(false);

    MemPtrFree(buf);
    if (flag != 0)
    {
        // obNAbvG[Ƃʒm
        NNsh_WarningMessage(ALTID_ERROR, MSG_NNSI_DBBACKUP_FAIL, "", flag);
    }
    NNshGlobal->updateDatabaseInfo = 0;

    return;
}

/*=========================================================================*/
/*   Function :   RestoreDBtoVFS                                           */
/*                                           NNsiDBVFS烊XgA */
/*=========================================================================*/
Err RestoreDBtoVFS(Boolean forceRead)
{
    Err      ret, ret1, ret2;
    FileRef  fileRef;
    Char     fileName[MAXLENGTH_FILENAME];
    UInt32   dummy;
    UInt16   butId;
    NNshVFSDBInfo vfsDB[3];
    UInt16 idx;
    ControlType  *chkObj, *lblObj;
    UInt8 fileExistCnt = 0;
    UInt8 importFileNum, deleteFileNum;
    NNshDBInfo dbInfo;
    DateTimeType date;
    
    struct {
	UInt16 chkIdImport;
	UInt16 chkIdDelete;
	UInt16 idx;
	UInt16 lblIdMEM;
	UInt16 lblIdVFS;
    } importInfo[] = {
	  {CHKID_IMPORT_SETTING, CHKID_DELETE_SETTING, NNSH_VFSDB_SETTING, LBLID_DBMEM_SETTING, LBLID_DBVFS_SETTING},
	  {CHKID_IMPORT_SUBJECT, CHKID_DELETE_SUBJECT, NNSH_VFSDB_SUBJECT, LBLID_DBMEM_SUBJECT, LBLID_DBVFS_SUBJECT},
	  {CHKID_IMPORT_BBSLIST, CHKID_DELETE_BBSLIST, NNSH_VFSDB_BBSLIST, LBLID_DBMEM_BBSLIST, LBLID_DBVFS_BBSLIST},
    };
    int i;
	    
    
    importFileNum = 0;
    deleteFileNum = 0;
    MemSet(vfsDB, sizeof(vfsDB), 0x00);
    MemSet(&dbInfo, sizeof(dbInfo), 0x00);
    
    // VFS̃T|[gLmFB
    dummy = 0;
    ret = FtrGet(sysFileCVFSMgr, vfsFtrIDVersion, &dummy);
    if (ret != errNone)
    {
        // VFST|[g̏ꍇɂ́AIB
        NNsh_DebugMessage(ALTID_INFO, "Not Support VFS :", "", ret);
        return (~errNone);
    }

    // VFSgpłƂABackupꂽDB邩(FILEOPEN)mF
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(fileName, DATAFILE_PREFIX);
    StrCat (fileName, DBNAME_SUBJECT);
    StrCat (fileName, ".pdb");
    if (VFSFileOpen(NNshGlobal->vfsVol, fileName, vfsModeRead, &fileRef) !=
        errNone)
    {
	if (forceRead == true)
	{
	    // BACKUPꂽt@CȂ̂ŏI
	    NNsh_DebugMessage(ALTID_INFO, "Backup DB files do not exist", "", 0);
	    return (~errNone);
	}
	vfsDB[NNSH_VFSDB_SUBJECT].fileExist = 0;
    }
    else
    {
	vfsDB[NNSH_VFSDB_SUBJECT].fileExist = 1;
	VFSFileDBInfo(fileRef, NULL, NULL, NULL, NULL, &vfsDB[NNSH_VFSDB_SUBJECT].modDateVFS,
		      NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	fileExistCnt++;
    }
    // File Open(== DB)AXgA邩mF
    VFSFileClose(fileRef);
    
    if (forceRead == true)
    {
	butId = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_RESTORE, "", 0);
	if (butId != 0)
	{
	    // CancelIꂽ߁AXgAȂB
	    NNsh_DebugMessage(ALTID_INFO, "DB-Restore is canceled.", "", 0);
	    return (~errNone);
	}
    }
    else
    {
	FormPtr frm, curFrm;
	Char *p;
	
	// t@C݂邩mF
	StrCopy(fileName, DATAFILE_PREFIX);
	StrCat (fileName, DBNAME_SETTING);
	StrCat (fileName, ".pdb");

	if (VFSFileOpen(NNshGlobal->vfsVol, fileName, vfsModeRead, &fileRef) !=
	    errNone)
	    vfsDB[NNSH_VFSDB_SETTING].fileExist = 0;
	else
	{
	    vfsDB[NNSH_VFSDB_SETTING].fileExist = 1;
	    VFSFileDBInfo(fileRef, NULL, NULL, NULL, NULL, &vfsDB[NNSH_VFSDB_SETTING].modDateVFS,
			  NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	    fileExistCnt++;
	}
	VFSFileClose(fileRef);

	StrCopy(fileName, DATAFILE_PREFIX);
	StrCat (fileName, DBNAME_BBSLIST);
	StrCat (fileName, ".pdb");

	if (VFSFileOpen(NNshGlobal->vfsVol, fileName, vfsModeRead, &fileRef) !=
	    errNone)
	    vfsDB[NNSH_VFSDB_BBSLIST].fileExist = 0;
	else
	{
	    vfsDB[NNSH_VFSDB_BBSLIST].fileExist = 1;
	    VFSFileDBInfo(fileRef, NULL, NULL, NULL, NULL, &vfsDB[NNSH_VFSDB_BBSLIST].modDateVFS,
			  NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	    fileExistCnt++;
	}
	VFSFileClose(fileRef);

	// VFS  DB t@CȂ߁AXgAȂB
	if (!fileExistCnt)
	    return(~errNone);

	// {̓ɂDB̏擾
	dbInfo.modDateP = &vfsDB[NNSH_VFSDB_SETTING].modDateMEM;
	StrCopy(fileName, DBNAME_SETTING);
	GetDBInfo_NNsh(fileName, &dbInfo);

	dbInfo.modDateP = &vfsDB[NNSH_VFSDB_SUBJECT].modDateMEM;
	StrCopy(fileName, DBNAME_SUBJECT);
	GetDBInfo_NNsh(fileName, &dbInfo);
	
	dbInfo.modDateP = &vfsDB[NNSH_VFSDB_BBSLIST].modDateMEM;
	StrCopy(fileName, DBNAME_BBSLIST);
	GetDBInfo_NNsh(fileName, &dbInfo);
	
	curFrm = FrmGetActiveForm();
	frm = FrmInitForm(FRMID_DBIMPORT);

	// t@C݂ȂɂĂ̓`FbN{bNXB
	for (i = 0; i < sizeof(importInfo) / sizeof(importInfo[0]); i++)
	{
	    if (vfsDB[importInfo[i].idx].fileExist == 0)
	    {
		idx = FrmGetObjectIndex(frm, importInfo[i].chkIdImport);
		chkObj = FrmGetObjectPtr(frm, idx);
		
		CtlSetValue(chkObj, 0);
		FrmHideObject(frm, idx);

		idx = FrmGetObjectIndex(frm, importInfo[i].chkIdDelete);
		chkObj = FrmGetObjectPtr(frm, idx);

		CtlSetValue(chkObj, 0);
		FrmHideObject(frm, idx);
	    }
	    else
	    {
		idx = FrmGetObjectIndex(frm, importInfo[i].lblIdVFS);
		lblObj = FrmGetObjectPtr(frm, idx);
		TimSecondsToDateTime(vfsDB[importInfo[i].idx].modDateVFS, &date);
			
		p = vfsDB[importInfo[i].idx].dateStrVFS;

		StrIToA(p, date.year);
		StrCat(p, "/");
		StrIToA(p + StrLen(p), date.month);
		StrCat(p, "/");
		StrIToA(p + StrLen(p), date.day);
		StrCat(p, " ");
		StrIToA(p + StrLen(p), date.hour);
		StrCat(p, ":");
		StrIToA(p + StrLen(p), date.minute);
		StrCat(p, ":");
		StrIToA(p + StrLen(p), date.second);
		
		CtlSetLabel(lblObj, p);
	    }

	    idx = FrmGetObjectIndex(frm, importInfo[i].lblIdMEM);
	    lblObj = FrmGetObjectPtr(frm, idx);
	    TimSecondsToDateTime(vfsDB[importInfo[i].idx].modDateMEM, &date);
	    
	    p = vfsDB[importInfo[i].idx].dateStrMEM;
	    StrIToA(p, date.year);
	    StrCat(p, "/");
	    StrIToA(p + StrLen(p), date.month);
	    StrCat(p, "/");
	    StrIToA(p + StrLen(p), date.day);
	    StrCat(p, " ");
	    StrIToA(p + StrLen(p), date.hour);
	    StrCat(p, ":");
	    StrIToA(p + StrLen(p), date.minute);
	    StrCat(p, ":");
	    StrIToA(p + StrLen(p), date.second);
		
	    CtlSetLabel(lblObj, p);
	}
	
	if(FrmDoDialog(frm) == BTNID_DIALOG_OK)
	{
	    for(i = 0; i < sizeof(importInfo) / sizeof(importInfo[0]); i++)
	    {
		chkObj = FrmGetObjectPtr(frm,
					 FrmGetObjectIndex(frm, importInfo[i].chkIdImport));
		vfsDB[importInfo[i].idx].importDB = CtlGetValue(chkObj);
		if (vfsDB[importInfo[i].idx].importDB)
		    importFileNum++;

		chkObj = FrmGetObjectPtr(frm,
					 FrmGetObjectIndex(frm, importInfo[i].chkIdDelete));
		vfsDB[importInfo[i].idx].deleteFile = CtlGetValue(chkObj);
		if (vfsDB[importInfo[i].idx].deleteFile)
		    deleteFileNum++;
	    
	    }
	    FrmDeleteForm(frm);
	    FrmSetActiveForm(curFrm);
	}
	else
	{
	    FrmDeleteForm(frm);
	    FrmSetActiveForm(curFrm);
	    return(~errNone);
	}
    }

    if (importFileNum || forceRead == true)
    {
	// "XgA"\
	Show_BusyForm(MSG_DBRESTORE_BUSY);
    }
    else
    {
	if (deleteFileNum)
	{
	    // "폜"\
	    Show_BusyForm(MSG_DBDELETE_BUSY);
	}
	else
	{
	    // XgAA폜Ȃ
	    return(~errNone);
	}
    }

    // DBXgAC
    if (forceRead == true)
	(void) RestoreDatabaseFromVFS_NNsh(DBNAME_DIRINDEX);
	
    if (vfsDB[NNSH_VFSDB_SETTING].importDB || forceRead == true)
    {
	ret2 = RestoreDatabaseFromVFS_NNsh(DBNAME_SETTING);
	NNshGlobal->restoreSetting = 1;
    }
    else
    {
	NNshGlobal->restoreSetting = 0;
	ret2 = errNone;
    }
	
    if (forceRead == false && vfsDB[NNSH_VFSDB_SETTING].deleteFile && ret2 == errNone)
    {
	StrCopy(fileName, DBNAME_SETTING);
	StrCat(fileName, ".pdb");
	
	// t@C폜
	(void)DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }
    
    if (vfsDB[NNSH_VFSDB_SUBJECT].importDB || forceRead == true)
	ret1 = (RestoreDatabaseFromVFS_NNsh(DBNAME_SUBJECT));
    else
	ret1 = errNone;
    
    if (forceRead == false && vfsDB[NNSH_VFSDB_SUBJECT].deleteFile && ret1 == errNone)
    {
	StrCopy(fileName, DBNAME_SUBJECT);
	StrCat(fileName, ".pdb");
	
	// t@C폜
	(void)DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }
    
    if (vfsDB[NNSH_VFSDB_BBSLIST].importDB || forceRead == true)
	ret = RestoreDatabaseFromVFS_NNsh(DBNAME_BBSLIST);
    else
	ret = errNone;
    
    if (forceRead == false && vfsDB[NNSH_VFSDB_BBSLIST].deleteFile && ret == errNone)
    {
	StrCopy(fileName, DBNAME_BBSLIST);
	StrCat(fileName, ".pdb");
	
	// t@C폜
	(void)DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }

    // "XgA" or "폜" \̍폜
    Hide_BusyForm(true);

    if (ret2 != errNone)
    {
        // XgAs(Xꗗ)
        NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_NG, DBNAME_SETTING, 0);
    }

    if (ret1 != errNone)
    {
        // XgAs(Xꗗ)
        NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_NG, DBNAME_SUBJECT, 0);
    }

    if (ret != errNone)
    {
        // XgAs(BBSꗗ)
        NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_NG, DBNAME_BBSLIST, 0);
    }

    if (importFileNum || forceRead == true)
    {
	// XgA
	NNsh_InformMessage(ALTID_INFO, MSG_DBRESTORE_OK, "", 0);
    }

    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkInstalledWebBrowser                                 */
/*                                        WebBrowser̃CXg[`FbN */
/*-------------------------------------------------------------------------*/
static void checkInstalledWebBrowser(void)
{
    UInt16            cardNo;
    LocalID           dbID;
    DmSearchStateType searchState;
    Err               ret;

    // NetFrontCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3T', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // NetFrontCXg[Ă
        NNshGlobal->browserCreator    = 'NF3T';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // WebBrowser 2.0CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'NF3P', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // WebBrowser 2.0CXg[Ă
        NNshGlobal->browserCreator    = 'NF3P';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Xiino(PalmScape)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PScp', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // XiinoCXg[Ă
        NNshGlobal->browserCreator    = 'PScp';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }

    // Xiino(LEM)CXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'dXin', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Xiino(LEM)CXg[Ă
        NNshGlobal->browserCreator    = 'dXin';
        NNshGlobal->browserLaunchCode = 0xfa21;
        return;
    }


    // BlazerCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'BLZ1', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // BlazerCXg[Ă
        NNshGlobal->browserCreator    = 'BLZ1';
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

    // Eudora WebCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'QCwb', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // Eudora WebCXg[Ă
        NNshGlobal->browserCreator    = 'QCwb';
        NNshGlobal->browserLaunchCode = 0xfa0;
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        return;
    }

#if 0
    // PocketLinkCXg[Ă邩mF
    ret = DmGetNextDatabaseByTypeCreator(true, &searchState,
                                         sysFileTApplication, 'PLNK', 
                                         true, &cardNo, &dbID);
    if (ret == errNone)
    {
        // PocketLinkCXg[Ă(but does not work...)
        NNshGlobal->browserCreator    = 'PLNK';
        // NNshGlobal->browserLaunchCode = sysAppLaunchCmdGoToURL;
        NNshGlobal->browserLaunchCode = sysAppLaunchCmdOpenDB;
        return;
    }
#endif

    NNsh_DebugMessage(ALTID_INFO, MSG_CANNOTFIND_BROWSER, "", ret);
    return;
}

/*=========================================================================*/
/*   Function : KeyConvertFiveWayToJogChara                                */
/*                                  5Way̓̓R[hWÕR[hɕϊ */
/*=========================================================================*/
UInt16 KeyConvertFiveWayToJogChara(EventType *event)
{
    UInt16 *command;

    // 5way̓͂łȂ΁AL[R[ĥ܂܉
    if (event->data.keyDown.chr != vchrNavChange)
    {
        // n[hL[̊mFBBB
        if ((NNshParam->useHardKeyControl != 0)&&
            (event->data.keyDown.chr >= vchrHardKeyMin))
        {
            // n[hL[R[h̊mF
            switch (event->data.keyDown.chr)
            {
              case vchrHard1:
                // n[hL[P
                command = &(NNshParam->useKey.key1);
                break;

              case vchrHard2:
                // n[hL[Q
                command = &(NNshParam->useKey.key2);
                break;

              case vchrHard3:
                // n[hL[R
                command = &(NNshParam->useKey.key3);
                break;

              case vchrHard4:
                // n[hL[S
                command = &(NNshParam->useKey.key4);
                break;

              case vchrCapture:
                // CLIE NX Lv`{^
                command = &(NNshParam->useKey.clieCapture);
                break;

              default:
                return (event->data.keyDown.chr);
                break;
            }
            // R}h̔
            switch (*command)
            {
              case HARDKEY_FEATURE_CONTROLNNSI:
                // NNsiŐ(n[hL[ꂽƂ̏s)
                return (event->data.keyDown.chr);
                break;

              case HARDKEY_FEATURE_TRANSJOGPUSH:
                // L[R[hJOG PUSH(LineFeed)ɏ
                return (chrLineFeed);
                break;

              case HARDKEY_FEATURE_TRANSJOGBACK:
                // L[R[hJOG BACK(ESC)ɏ
                return (chrEscape);
                break;

              case HARDKEY_FEATURE_DONOTHING:
              default:
                // Ȃ
                break;
            }
        }
        return (event->data.keyDown.chr);
    }

    if (((event->data.keyDown.keyCode) & (navBitSelect | navChangeSelect))
         == navChangeSelect)
    {
        // WOƓɂ
        return (vchrJogRelease);
    }
    if ((event->data.keyDown.keyCode) & navBitLeft)
    {
        // J[\L[Ɠɂ
        return (chrLeftArrow);
    }
    if ((event->data.keyDown.keyCode) & navBitRight)
    {
        // J[\L[EƓɂ
        return (chrRightArrow);
    }

    // LȊO͂̂܂܉
    return (event->data.keyDown.chr);
}

#ifdef USE_HIGHDENSITY
/*-------------------------------------------------------------------------*/
/*   Function :   setDoubleDensitySupport_NNsh                             */
/*                                              𑜓xT|[g̃`FbN */
/*-------------------------------------------------------------------------*/
static void setDoubleDensitySupport_NNsh(void)
{
    UInt32  version;

    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;

    // OS 3.5̏ꍇ
    if (NNshGlobal->palmOSVersion < 0x03503000)
    {
        // J[T|[g̒[(J[T|[g̐ݒsɂ
        NNshParam->useColor = 0;
    }
#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        // CLIEA𑜓x̃`FbNȂ(CLIEnC]g)
        return;
    }
#endif

    // 𑜓xtB[`[̎擾
    if (FtrGet(sysFtrCreator, sysFtrNumWinVersion, &version) != 0)
    {
        // 𑜓xtB[`[̃T|[gȂ
        return;
    }
    NNsh_DebugMessage(ALTID_INFO, "Window Version", ": ", version);
    if (version < 4)
    {
        //@𑜓x̃T|[gȂAI
        //  (Ő񂾂낤...}jAɂ͂Ă...)
        return;
    }

    // Window̉𑜓x擾
    WinScreenGetAttribute(winScreenDensity, &(NNshGlobal->os5HighDensity));

    // Ƃ肠AW𑜓xɂ
    WinSetCoordinateSystem(kCoordinatesStandard);

    return;
}
#endif   // #ifdef USE_HIGHDENSITY

/*-------------------------------------------------------------------------*/
/*   Function : convertFormID                                              */
/*                                                tH[hc̃Ro[g */
/*-------------------------------------------------------------------------*/
static UInt16 convertFormID(UInt16 lastFrmID)
{
    UInt16 frmId;

    // lastFrmID ۂ̃tH[IDփRo[g
    switch (lastFrmID)
    {
      case NNSH_FRMID_MESSAGE:
        // XQƉ
        frmId = FRMID_MESSAGE;
        break;
#if 0
      case NNSH_FRMID_BOARDINPUT:
      case NNSH_FRMID_MESSAGEINFO:
      case NNSH_FRMID_MANAGEBBS:
      case NNSH_FRMID_INPUTDIALOG:
      case NNSH_FRMID_BUSY:
      case NNSH_FRMID_WRITE_MESSAGE:
      case NNSH_FRMID_NNSI_SETTING7:
      case NNSH_FRMID_NNSI_SETTING6:
      case NNSH_FRMID_NNSI_SETTING5:
      case NNSH_FRMID_NNSI_SETTING4:
      case NNSH_FRMID_NNSI_SETTING3:
      case NNSH_FRMID_NNSI_SETTING2:
      case NNSH_FRMID_CONFIG_NNSH:
#endif
      case NNSH_FRMID_THREAD:
      default:
        // Xꗗ
        frmId = FRMID_THREAD;
        break;
    }
    return (frmId);
}

/*=========================================================================*/
/*   Function :   OpenForm_NNsiDummy                                       */
/*                                             NNsiN(DUMMY)ʃI[v */
/*=========================================================================*/
Err OpenForm_NNsiDummy(FormType *frm)
{
    Err          ret;
    Char         *osVer, buffer[BUFSIZE * 2];
    UInt8        remainPer;
    UInt32       useSize, totalSize, freeSize;

    // o̓obt@NA
    MemSet (buffer, sizeof(buffer), 0x00);

    // OS̃o[Wo͂
    osVer = SysGetOSVersionString();
    StrCat (buffer, "PalmOS ");
    StrCat (buffer, osVer);
    MemPtrFree(osVer);

    // ݂̃obecʂobt@ɏo͂
    remainPer      = 0;
    SysBatteryInfo(false, NULL, NULL, NULL, NULL, NULL, &remainPer);
    StrCat (buffer, "\n---\nBattery :");
    NUMCATI(buffer, (UInt16) remainPer); 
    StrCat (buffer, "%");

    // 󂫃̎擾
    freeSize = GetOSFreeMem(&totalSize, &useSize);
    {
        // VFS̗e(/ő)o͂
        StrCat (buffer, "\n\nMemory(Free/Total)\n    ");
        NUMCATI(buffer, ((freeSize)/1024));
        StrCat (buffer, "kB/");
        NUMCATI(buffer, ((totalSize/1024))); 
        StrCat (buffer, "kB");
    }

    // VFS̎擾
    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)
    {
        // VFS̗eʂmF
        ret = VFSVolumeSize(NNshGlobal->vfsVol, &useSize, &totalSize);
        if (ret == errNone)
        {
            // VFS̗e(/ő)o͂
            StrCat (buffer, "\n\nVFS(Free/Total)\n    ");
            NUMCATI(buffer, ((totalSize - useSize)/1024));
            StrCat (buffer, "kB/");
            NUMCATI(buffer, ((totalSize/1024))); 
            StrCat (buffer, "kB");
        }
    }

    // foCX\
    NNshWinSetFieldText(frm, FLDID_DUMMYMSG, true, buffer, StrLen(buffer));

    return (errNone);
}

/*=========================================================================*/
/*   Function :   Hander_NNsiDummy                                         */
/*                                  NNsiN(DUMMY)ʂ̃Cxgnh  */
/*=========================================================================*/
Boolean Handler_NNsiDummy(EventType *event)
{
    UInt16     itemId, len;
    Char       kwBuf[PASSSIZE * 2];
    EventType *dummyEvent;

    // {^`FbNȊÕCxg͑߂
    switch (event->eType)
    { 
      case menuEvent:
        // j[I
        itemId = event->data.menu.itemID;
        break;

      case ctlSelectEvent:
        // {^ꂽ(֐i)
        itemId = event->data.ctlSelect.controlID;
        break;

      case keyDownEvent:
        // L[͂(Ȃ)
        return (true);
        break;

      default: 
        return (false);
        break;
    }

    switch (itemId)
    {
      case MNUID_NNSI_WELCOME:
      case SELTRID_NNSI_DUMMY:
        // NR[h
        MemSet(kwBuf, sizeof(kwBuf), 0x00);
        // NpX[hݒ
        if (DataInputDialog(NNSH_INPUTWIN_ENTPASS, kwBuf, PASSSIZE,
                            NNSH_DIALOG_USE_PASS, NULL) != false)
        {
            len = StrLen(NNshParam->launchPass);
            if (StrNCompare(NNshParam->launchPass, kwBuf, len) == 0)
            {
                // NpX[ḧvmF
                NNsh_InformMessage(ALTID_INFO, MSG_MATCH_LAUNCHWORD, "", 0);

                // OIʂJ
                FrmGotoForm(convertFormID(NNshParam->lastFrmID));
                return (true);
            }
        }
        FrmDrawForm(FrmGetActiveForm());
        break;

      case MNUID_NNSI_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case BTNID_NNSI_DUMMY_OK:
      default:
        // LȊO(NNsiI)
        // OK{^(NNsiI)
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType = appStopEvent;
        EvtAddEventToQueue(dummyEvent);
        break; 
    }
    return (true);
}
