/*============================================================================*
 *  FILE: 
 *     sections.h
 *
 *  Description: 
 *     Multi-segment definitions.
 *
 *===========================================================================*/
#include <PalmOS.h>
#include <PalmCompatibility.h>

#define EDIT_SECTION   __attribute__ ((section ("editfns")))
#define EDIT_SECTION2  __attribute__ ((section ("editfns2")))
#define EDIT_SECTION3  __attribute__ ((section ("editfns3")))
#define EDIT_SECTION4  __attribute__ ((section ("editfns4")))
#define EDIT_SECTION5  __attribute__ ((section ("editfns5")))

/***** skeleton.c *****/
UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags);

/***** main.c *****/
#ifdef MAIN_C
static Boolean MyApplicationHandleEvent(EventType *event);
static UInt16  MyStartApplication(void);
static void    MyStopApplication(void);
#endif

/***** bbsmng.c *****/
#ifdef BBSMNG_C
static UInt16  getBoardURL(Char *url, Char *nick, Char *top, Char *bottom)          EDIT_SECTION5;
static void    parseBoard(DmOpenRef dbRef, Char *top, UInt32 *readSize)             EDIT_SECTION5;
static void    updateBoardList(void)                                                EDIT_SECTION5;
static Err     searchBBSTitle(Char *title, UInt16 direction, UInt16 *recNum)        EDIT_SECTION5;
static void entryBBSRecord(UInt16 recNum)                                           EDIT_SECTION5;
static void    closeForm_SelectBBS(void)                                            EDIT_SECTION5;
static void    setBBSListItem(void)                                                 EDIT_SECTION5;
static void    setAllBBS_Selection(UInt16 value)                                    EDIT_SECTION5;
static Boolean detail_SelectBBS(void)                                               EDIT_SECTION5;
static Boolean ctlSelEvt_SelectBBS(EventType *event)                                EDIT_SECTION5;
static Int16   ctlRepEvt_SelectBBS(EventType *event)                                EDIT_SECTION5;
static Int16   keyDownEvt_SelectBBS(EventType *event)                               EDIT_SECTION5;
static void    set_Selection_Info(UInt16 pageNum)                                   EDIT_SECTION5;
static void    display_BBS_Selection(UInt16 pageNum, Int16  selection)              EDIT_SECTION5;
#endif

Boolean GetBBSList(Char *url)                                                    EDIT_SECTION5;
Boolean Handler_SelectBBS(EventType *event)                                      EDIT_SECTION;
void    OpenForm_SelectBBS(FormType *frm)                                        EDIT_SECTION;
Err     Get_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)                  EDIT_SECTION5;
Err     Update_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)               EDIT_SECTION5;
Err     Get_BBS_Database(Char *boardNick, NNshBoardDatabase *bbs, UInt16 *index) EDIT_SECTION5;
Err     Update_BBS_Database(UInt16 index, NNshBoardDatabase *bbs)                EDIT_SECTION5;
Err     Create_BBS_INDEX(Char **bdLst, UInt16 *cnt)                              EDIT_SECTION5;


/***** msgwrite.c *****/
#ifdef MSGWRITE_C
static void     setBBSNameAndTime(UInt16 bbsType, Char *boardNick, Char *buffer, UInt16 bufSize)             EDIT_SECTION5;
static void     setFormParameters(Char *nick, Char *buffer, UInt16 bufSize, Char *tempArea, UInt16 areaSize, Char *defSubmit) EDIT_SECTION5;
static void     returnToMessageView(void)                                                                    EDIT_SECTION5;
static Boolean  menuEvt_WriteMessage(EventType *event)                                                       EDIT_SECTION5;
static void     checkCheckBoxUpdate(UInt16 chkId)                                                           EDIT_SECTION5;
static Boolean  selEvt_Control_WriteMessage(EventType *event)                                                EDIT_SECTION5;
static Boolean  selEvt_KeyDown_WriteMessage(EventType *event)                                                EDIT_SECTION5;
static Boolean  sclRepEvt_WriteMessage(EventType *event)                                                     EDIT_SECTION5;
static Boolean  fldChgEvt_WriteMessage(EventType *event)                                                     EDIT_SECTION5;
static Char    *checkWriteReply(Char *buffer, UInt32 bufSize, UInt32 command, UInt16 bbsType, Err *ret)      EDIT_SECTION5;
static Err      threadWrite_Message(void)                                                                   EDIT_SECTION5;
static Err      create_outputMessageFile(FormType *diagFrm, Char *buffer,UInt32 bufSize, Char *boardNick, 
                                         Char *key, UInt16 bbsType)                                          EDIT_SECTION5;
static void    outputTextField(FormType *frm, UInt16 fldID, Char *buf, UInt16 size, UInt16 bbsType, NNshFileRef *fileRef) EDIT_SECTION5;

#ifdef USE_NEWTHREAD_FEATURE
  static Err      execute_newThread       (FormType *frm)    EDIT_SECTION5;
  static Boolean  sclRepEvt_newThread     (EventType *event) EDIT_SECTION5;
  static Boolean  selEvt_Control_newThread(EventType *event) EDIT_SECTION5;
  static Boolean  selEvt_KeyDown_newThread(EventType *event) EDIT_SECTION5;
#endif

#endif
Boolean          Handler_WriteMessage (EventType *event)                                                      EDIT_SECTION5;
void            OpenForm_WriteMessage(FormType *frm)                                                         EDIT_SECTION;
void            SaveWritingMessage (void)                                                                    EDIT_SECTION5;

Boolean          Handler_newThread    (EventType *event)                                                      EDIT_SECTION5;
void            OpenForm_newThread   (FormType *frm)                                                         EDIT_SECTION;

#ifdef SUBJMGR_C
static void entryNotExistSubject(DmOpenRef dbRef, NNshSubjectDatabase *subjDb) EDIT_SECTION4;
static Err parse_SubjectList(Char *buffer, UInt32 readSize, UInt16 bbsType,
                             Char *boardNick, UInt16 *cnt) EDIT_SECTION4;
#endif
Err DeleteSubjectList(Char *boardNick, UInt16 delState, UInt16 *thrCnt)                                      EDIT_SECTION4;
void SortSubjectList(void) EDIT_SECTION4;

UInt16 convertListIndexToMsgIndex(UInt16 listIdx)                                                            EDIT_SECTION4;
Err NNsh_GetSubjectList(UInt16 index)                                                                        EDIT_SECTION4;
Err Check_same_thread(UInt16 selMES,NNshSubjectDatabase *data,NNshSubjectDatabase *matchedData,UInt16 *idx)  EDIT_SECTION4;
Err GetSubjectIndex(Char *boardNick, Char *threadFileName, UInt16 *index)                                    EDIT_SECTION4;
Boolean CheckIfCustomTabIsValid(Char                *bbsName,
                                NNshSubjectDatabase *mesInfo,
                                NNshCustomTab       *custom) EDIT_SECTION4;
                             
#ifdef OFFLINE_C
static Err checkOfflineEntryAvailable(DmOpenRef dbRef, UInt16 *recNum,
                                      UInt16 nofItems, UInt16 *recList,
                                      Char *threadFileName, UInt16 msgState,
                                      UInt16 offset) EDIT_SECTION2;
static Err getOfflineThreadRecords(UInt16 *nofItems, UInt16 **offThread) EDIT_SECTION2;
static Char *getThreadTitle(Char *msgP, UInt32 *size) EDIT_SECTION2;

static void setVFSOfflineThreadInfo(DmOpenRef dbRef, DmOpenRef dirDBRef,
                                    UInt16 nofItems, UInt16 *recList,
                                    UInt16 depth, UInt16 index, Char *dirName,
                                    NNshSubjectDatabase *subDb, UInt16 *cnt) EDIT_SECTION2;
#endif
Err create_offline_database(void) EDIT_SECTION2;
Err SetThreadInformation(Char *fileName, UInt16 fileMode,
                         NNshSubjectDatabase *subDB) EDIT_SECTION2;
Err setOfflineLogDir(Char *fileName) EDIT_SECTION2;








                              


////////////////////////// 


















Err NNshHttp_commMain(UInt16 type, Char *url, Char *cookie, Char *appendData,
                      UInt32 range, UInt32 endRange, UInt16 port, Char *proxy,
                      Char *message) EDIT_SECTION;
Boolean ctlSelEvt_DispMessage(EventType *event) EDIT_SECTION;
Boolean menuEvt_DispMessage(EventType *event) EDIT_SECTION;
Boolean Handler_NNshMessage(EventType *event) EDIT_SECTION;
Err OpenForm_NNshMessage(FormType *frm) EDIT_SECTION;
Err GetSubDirectoryName(UInt16 index, Char *dirName) EDIT_SECTION;
void UpdateFieldRegion(void) EDIT_SECTION;

Err Get_Subject_Database(UInt16 index, NNshSubjectDatabase *subjDB) EDIT_SECTION;
Err MoveMessageToReadOnly(UInt16 index) EDIT_SECTION;
Err CreateMessageThreadIndex(NNshMessageIndex *index, UInt32 *nofMsg,
                             UInt32 *msgOffset, UInt16 bbsType) EDIT_SECTION;
Err update_subject_database(UInt16 index, NNshSubjectDatabase *subjDB) EDIT_SECTION;
Err Get_AllMessage(Char *url, Char *boardNick, Char *file, UInt16 idxMES,
                   UInt16 bbsType) EDIT_SECTION;
Err Get_PartMessage(Char *url, Char *boardNick, NNshSubjectDatabase *mesDB, 
                    UInt16 idxMES, Char *message) EDIT_SECTION;
Err MoveSubject_BBS(Char *dest, Char *src)           EDIT_SECTION2;
void MarkMessageIndex(UInt16 index, UInt16 favor)    EDIT_SECTION2;
Boolean Get_MessageFromMesNum(Boolean *updateBBS)    EDIT_SECTION2;
Boolean GetThreadDataFromMesNum(Boolean *updateBBS, Char *buf, UInt16 bufLen) EDIT_SECTION2;
Err CreateThreadURL(UInt16 urlType, Char *url, UInt16 bufSize, 
                    NNshBoardDatabase *bbsInfo, NNshSubjectDatabase *mesInfo) EDIT_SECTION2;
void CreateThreadBrowserURL(UInt16 urlType, Char *url, NNshBoardDatabase *bbsInfo, NNshSubjectDatabase *mesInfo) EDIT_SECTION2;
Boolean Handler_MessageInfo(EventType *event)        EDIT_SECTION2;
Err DisplayMessageInformations(UInt16 msgIndex, UInt16 *msgAttribute) EDIT_SECTION2;
     
Err OpenFile_NNsh(Char *fileName, UInt16 fileMode, NNshFileRef *fileRef) EDIT_SECTION;
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize) EDIT_SECTION;
Err ReadFile_NNsh(NNshFileRef *fileRef, UInt32 offset, UInt32 size, 
                  void *ptr, UInt32 *readSize) EDIT_SECTION;
Err CloseFile_NNsh(NNshFileRef *fileRef) EDIT_SECTION;
Err CheckFileSpace_NNsh(UInt16 fileMode, UInt32 size) EDIT_SECTION;

void NNsi_FrmDrawForm(FormType *frm, Boolean redraw) EDIT_SECTION;
void NNsi_UpdateRectangle(RectangleType *dimF, UInt16 fontType, UInt16 *fontID, 
                          UInt16 *fontHeight, UInt16 *nlines) EDIT_SECTION;

void NNshWinViewUpdateScrollBar(UInt16 fldID, UInt16 sclID) EDIT_SECTION;
Boolean NNshWinViewPageScroll(UInt16 fldID, UInt16 sclID, 
                              UInt16 lines, WinDirectionType direction) EDIT_SECTION;
void NNsi_WinDrawList(UInt16 pointIndex, Char *titleIndex[], UInt16 listItems,
                      RectangleType *dimF, UInt16 height) EDIT_SECTION;
void NNsi_WinUpdateList(UInt16 pointIndex, UInt16 prevIndex,
                        Char *titleIndex[], UInt16 listItems,
                        RectangleType *dimF, UInt16 height) EDIT_SECTION;
void NNsi_RedrawThreadList(void)  EDIT_SECTION;

Boolean Update_Thread_List(UInt16 bbsIdx, UInt16 selItem, UInt16 step) EDIT_SECTION;

Err GetPartMessage_NNsh(Char *url, Char *boardNick,
                        NNshSubjectDatabase *mesDB, UInt16 idxMES) EDIT_SECTION;

#ifdef THRMNG_C
static void    change_handera_rotate(void)  EDIT_SECTION2;
static void    updateSelectionItem(Int16 direction) EDIT_SECTION2;
static void    change_list_font(void)       EDIT_SECTION2;
static void    change_graph_mode(void)      EDIT_SECTION2;
static void    setMultiPurposeSwitch(FormType *frm, UInt16 itemID, UInt16 btnID) EDIT_SECTION2;
static Boolean updateMultiPurposeSwitch(UInt16 paramID, UInt16 btnID) EDIT_SECTION2;
static Boolean launch_WebBrowser(void)        EDIT_SECTION2;
static void NNshMain_Close(UInt16 nextFormID) EDIT_SECTION2;
static Boolean open_menu(void)                EDIT_SECTION2;
static Boolean executeAction(UInt16 funcID) EDIT_SECTION2;
static Boolean modify_title(void) EDIT_SECTION2;
static Boolean copy_to_readOnly(void) EDIT_SECTION2;
static Boolean set_SearchTitleString(void) EDIT_SECTION2;
static Boolean search_NextTitle(Int16 direction) EDIT_SECTION2;
static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR) EDIT_SECTION2;
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS) EDIT_SECTION2;
static Boolean newThread_message(void) EDIT_SECTION2;
static Boolean display_message(void) EDIT_SECTION2;
static Boolean get_all_message(void) EDIT_SECTION2;
static Boolean update_message(void) EDIT_SECTION2;
static Boolean update_newarrival_message(void) EDIT_SECTION2;
static Boolean update_getall_message(void) EDIT_SECTION2;
static Boolean get_subject_txt(void) EDIT_SECTION2;
static Boolean rctPointEvt_ThreadMain(EventType *event, FormType *frm, RectangleType *rect) EDIT_SECTION2;
static Boolean popEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean keyDownEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean ctlSelEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean menuEvt_ThreadMain(EventType *event) EDIT_SECTION2;
#endif

#ifdef MSGMGR_C
static Err createThreadIndexSub_MachiBBS(Char   *buffer, UInt32 size,
                           UInt32 offset, UInt32 *nofMsg, UInt32 *msgOffset,
                           Char *start, Char *end) EDIT_SECTION2;
static void message_entryDatabase(UInt16 idxMES,UInt32 fileSize,UInt16 bbsType) EDIT_SECTION2;
static Err message_entryMessage(Char *targetFile, UInt32 *dataSize, UInt16 bbsType) EDIT_SECTION2;
static Err message_appendMessage(Char *targetFile, NNshSubjectDatabase *mesDB) EDIT_SECTION2;
#endif
#ifdef MSGVIEW_C
static void checkHideMessage(Char *buffer) EDIT_SECTION3;
static void setFavoriteLabel(FormType *frm, UInt16 attribute)              EDIT_SECTION3;
static void outputMemoPad(void)                                            EDIT_SECTION3;
static void openWebBrowser(UInt16 confirmation, Char *buffer, UInt16 size) EDIT_SECTION3;
static void jumpPrevious(void) EDIT_SECTION3;
static void jumpEdge(Boolean loc) EDIT_SECTION3;
static void parseMessage(Char *buf, Char *source, UInt32 size, UInt16 *nofJmp, UInt16 *jmpBuf, UInt16 kanjiCode, Boolean setJumpFlag) EDIT_SECTION3;
static void changeFont(void) EDIT_SECTION3;
static void ReadMessage_Close(UInt16 nextFormID) EDIT_SECTION3;
static void displayMessageSub(UInt16 bbsType, Char *topP, UInt32 mesNum,
                              UInt32 offset,  UInt32 size, Char *buf, Boolean setJumpMsg) EDIT_SECTION3;
static Err displayMessage(NNshMessageIndex *idxP, UInt16 isBottom) EDIT_SECTION3;
static Boolean moveMessageNext(Boolean chkScroll) EDIT_SECTION3;
static Boolean moveMessagePrev(Boolean chkScroll, UInt16 dispLoc) EDIT_SECTION3;
static Boolean jumpMessage(FormType *frm,NNshMessageIndex *idxP) EDIT_SECTION3;
static Boolean sclRepEvt_DispMessage(EventType *event) EDIT_SECTION3;
static Boolean selEvt_KeyDown_DispMessage(EventType *event) EDIT_SECTION3;
static Err PartReceiveMessage_View(void) EDIT_SECTION3;
static void NNsh_Search_Message(UInt16 type, Char *str, Boolean flag) EDIT_SECTION3;
static Err NNsh_Get_MessageToBuf(NNshMessageIndex *idxP, UInt16 msg, UInt16 type, Boolean flag) EDIT_SECTION3;
static Boolean executeViewAction(UInt16 funcID) EDIT_SECTION3;
#endif

// BUSY FORMs
void SetMsg_BusyForm(Char *msg)      EDIT_SECTION4;
void Show_BusyForm  (Char *msg)      EDIT_SECTION4;
void Hide_BusyForm  (Boolean redraw) EDIT_SECTION4;

// DIALOGs
UInt16 NNsh_DialogMessage(UInt16 level, UInt16 altID, Char *mes1, Char *mes2, UInt32 num) EDIT_SECTION4;
Boolean NNsh_MenuEvt_Edit(EventType *event)     EDIT_SECTION4;
Boolean Handler_EditAction(EventType *event)    EDIT_SECTION4;
Boolean Handler_JumpSelection(EventType *event) EDIT_SECTION4;
UInt16 NNshWinSelectionWindow(Char *listItemP, UInt16 nofItems) EDIT_SECTION4;

// Backup/Restore Databases
Err  BackupDatabaseToVFS_NNsh   (Char *dbName) EDIT_SECTION4;
Err  RestoreDatabaseFromVFS_NNsh(Char *dbName) EDIT_SECTION4;
void BackupDBtoVFS(UInt16 backupAllDB) EDIT_SECTION4;
Err  RestoreDBtoVFS(Boolean forceRead) EDIT_SECTION4;

// HTTP connection
Err NNshHttp_comm(UInt16 type, Char *url, Char *cookie, Char *appendData,
                  UInt32 range, UInt32 endRange, Char *message) EDIT_SECTION4;
// Hang up line
void NNshNet_LineHangup(void) EDIT_SECTION4;

// Launch Web Browser
Err WebBrowserCommand(UInt32 creator, UInt16 subLaunch, 
                      UInt16 flags, UInt16 cmd, Char *parameterP,
                      UInt32 *resultP) EDIT_SECTION4;
// Launch Network Preferences screen
void OpenNetworkPreferences(void) EDIT_SECTION4;

#ifdef NNSHSET_C
static void clearFeatureList(void) EDIT_SECTION4;
static void closeForm_NNsiSettings(UInt16 nextFormID) EDIT_SECTION4;
static Err createFeatureListStrings(NNshWordList **lst, UInt16 strRscId) EDIT_SECTION4;

static Boolean keyDownEvt_NNshSetting(EventType *event) EDIT_SECTION4;
static Boolean setTitleHardKey(Char *title, UInt16 data, UInt16 mask, NNshHardkeyControl *info) EDIT_SECTION4;
static Boolean selectOmitDialog(void)  EDIT_SECTION4;

static Err effect_NNshSetting(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting2(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting3(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting4(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting5(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting6(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting7(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting8(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting9(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSettingA(FormType *frm) EDIT_SECTION4;
static Err effect_FavorTabSet(FormType *frm, NNshCustomTab *custom) EDIT_SECTION4;
static void closeForm_FavorTabSet(UInt16 nextForm) EDIT_SECTION4;
#endif
Err     OpenForm_FavorTabSet(FormType *frm)   EDIT_SECTION;
Boolean Handler_FavorTabSet(EventType *event) EDIT_SECTION;
#ifdef MSGLIST_C
static Boolean checkDispList(UInt16 bbsIndex, NNshSubjectDatabase *subjP,
                             NNshBoardDatabase *bdP) EDIT_SECTION3;
static void copyThreadTitleString(Char  *dest, Char *src, UInt16 length,
                                  UInt16 state, UInt16 msgNumber) EDIT_SECTION3;
static void reverse_List_Order(UInt16 nofItems,     Char *buffer,
                               UInt16 *listIndex,   Char **titleIndex,
                               UInt16 *titleStatus, UInt16 *msgNumbers) EDIT_SECTION3;
static Err AllocMsgTitleInfo(UInt16 nofItems) EDIT_SECTION3;
static Err create_TitleList(UInt16 bbsIndex, UInt16 areaCount, Char *buffer,
                            UInt16 *startRec, UInt16 *endRec, Int16 step) EDIT_SECTION3;
#ifdef USE_COLOR
void NNsi_SetTitleColor(UInt16 status) EDIT_SECTION3;
#endif
#endif

Boolean ConvertHanZen (UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertSJtoJIS(UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte) EDIT_SECTION3;
Boolean ConvertSJtoEUC(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte, UInt16 *parseByte) EDIT_SECTION3;
void    StrCopyEUC(Char *dst, Char *src)     EDIT_SECTION3;
void    StrCopySJ (Char *dst, Char *src)     EDIT_SECTION3;
void    StrNCopyHanZen(Char *dest, Char *src, UInt16 length) EDIT_SECTION3;

Err     SendToLocalMemopad(Char *title, Char *data) EDIT_SECTION3;
Boolean DataInputDialog(Char *title, Char *area, UInt16 size, UInt16 usage, void *valueP) EDIT_SECTION3;
void    ShowVersion_NNsh   (void) EDIT_SECTION3;
void    ShowDeviceInfo_NNsh(void) EDIT_SECTION3;
Err      SeparateWordList(Char *string, NNshWordList *wordList) EDIT_SECTION3;
void    ReleaseWordList(NNshWordList *wordList) EDIT_SECTION3;
UInt32   GetOSFreeMem(UInt32 *totalMemoryP, UInt32 *dynamicMemoryP) EDIT_SECTION3;


/*** DATABASE ACCESSING FUNCTIONS ***/
void OpenDatabase_NNsh (Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef) EDIT_SECTION;
void CloseDatabase_NNsh(DmOpenRef dbRef) EDIT_SECTION;
void QsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset) EDIT_SECTION;
void IsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset) EDIT_SECTION;
void GetDBCount_NNsh   (DmOpenRef dbRef, UInt16 *count) EDIT_SECTION;
Err  GetDBInfo_NNsh(Char *dbName, NNshDBInfo *info)     EDIT_SECTION;
Err  EntryRecord_NNsh  (DmOpenRef dbRef, UInt16 size,  void *recordData) EDIT_SECTION;
Err  GetRecord_NNsh    (DmOpenRef dbRef, UInt16 index, UInt16 size, void *matchedData) EDIT_SECTION;
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record) EDIT_SECTION;
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH) EDIT_SECTION;
Err  UpdateRecord_NNsh (DmOpenRef dbRef, UInt16 index, UInt16 size, void *updateData) EDIT_SECTION;
Err  IsExistRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 *index) EDIT_SECTION;
Err  SearchRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 size, void *matchedData, UInt16 *index) EDIT_SECTION;
Err  DeleteRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset) EDIT_SECTION;
Err  DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index) EDIT_SECTION;
Boolean GetExistRecordList(DmOpenRef dbRef, Char *boardNick, MemHandle *listH, UInt16 *threadNum) EDIT_SECTION;

/*** FILE(FileStream/VFS) ACCESSING FUNCTIONS ***/
Err DeleteFile_NNsh (Char *fileName, UInt16 location) EDIT_SECTION;
Err CreateFile_NNsh (Char *fileName) EDIT_SECTION;
Err RenameFile_NNsh (Char *oldFileName, Char *newFileName) EDIT_SECTION;
Err CreateDir_NNsh  (Char *dirName) EDIT_SECTION;
Err CloseFile_NNsh  (NNshFileRef *fileRef) EDIT_SECTION;
Err CopyFile_NNsh   (Char *destFile, Char *sourceFile, UInt16 location) EDIT_SECTION;
Err OpenFile_NNsh   (Char *fileName, UInt16 fileMode, NNshFileRef *fileRef) EDIT_SECTION;
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize) EDIT_SECTION;
Err ReadFile_NNsh   (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *readSize) EDIT_SECTION;
Err WriteFile_NNsh  (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;
Err AppendFile_NNsh (NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;
Err AppendFileAsURLEncode_NNsh(NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;

#ifdef USE_XML_OUTPUT
Err Output_NNsiSet_XML(Char *fileName) EDIT_SECTION5;
Err Input_NNsiSet_XML (Char *fileName) EDIT_SECTION5;
#endif
