/*
 *  $Id: NGwordRecords.cs,v 1.2 2005/02/26 13:17:49 mrsa Exp $
 *    --- NNsiNG[hf[^
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;

namespace NEET
{
	public class NGwordRecord
	{
		private string mNGword;
		private uint   mCheckArea;
		private uint   mMatchedAction;
		private int    mReserved;

		/// <summary>
		///   vpeB (NG word)
		/// </summary>
		public string ngWord
		{
			get
			{
				return (mNGword);
			}

			set
			{
				mNGword = value;
			}
		}

		/// <summary>
		///   vpeB (check Area)
		/// </summary>
		public uint checkArea
		{
			get
			{
				return (mCheckArea);
			}

			set
			{
				mCheckArea = value;
			}
		}

		/// <summary>
		///   vpeB (Mached Action)
		/// </summary>
		public uint matchedAction
		{
			get
			{
				return (mMatchedAction);
			}

			set
			{
				mMatchedAction = value;
			}
		}

		/// <summary>
		///   vpeB (reserved)
		/// </summary>
		public int reserved
		{
			get
			{
				return (mReserved);
			}

			set
			{
				mReserved = value;
			}
		}

	}

	/// <summary>
	///  Class ̊Tv̐
	/// </summary>
	public class NGwordContainer
	{
		// ut@CJv_CAO
		private System.Windows.Forms.OpenFileDialog fileSelectionDialog = null;

		// PalmOSDBt@C̃ANZT(par.exewrapperNX)
		private PalmDatabaseAccessor mDbAccessor		= null;

		// NG[hcãR[hƈꎞt@C̕ϊ
		private NGwordDbParser 	mDbParser				= null;

		// NG[hca̓̓t@C
		private string				mDbName				= null;

		// QƃOcãIuWFNgǗpXg
		private ArrayList			mDbArrayList		= null;

		public NGwordContainer(string aDbName, ref PalmDatabaseAccessor aAccessor)
		{
			//  IuWFNg̏...
			mDbName			= aDbName;
			mDbAccessor		= aAccessor;
			mDbArrayList	= new ArrayList();
			mDbParser		= new NGwordDbParser();
			fileSelectionDialog = new System.Windows.Forms.OpenFileDialog();
			fileSelectionDialog.AddExtension = true;
		}

		/// <summary>
		///    f[^ReiNX
		///    (DBt@Cf[^ǂݏoăIuWFNgɓWJ)
		/// </summary>
		public bool initializeDatas()
		{
			int nofRecords = 0;

			// cãwb_ǂŃR[h擾
			if (mDbAccessor.getRecordNumber(out nofRecords) == false)
			{
				// DB̓ǂݍݎsBBB(I)
				MessageBox.Show("DBt@C ܂ par.exȅꏊ" +
								"w肳ĂȂ悤łB\n" +
								"(t@Cݒ̌肢܂B)",
								"Access Failure",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// R[h̊mFsAR[hf[^ǂݍ
			if (nofRecords == 0)
			{
				// R[hȂǂݍ܂Ȃ...
				return (true);
			}

			// ꎞt@C̎w
			string tempFileName = mDbName + ".temp";

			// R[ĥ鐔ǂݍŃIuWFNgɕϊAo^
			for (int loop = 0; loop < nofRecords; loop++)
			{
				try
				{
					// par.exegp1R[ht@CɓWJ
					if (mDbAccessor.pickUpRecord(loop, tempFileName) != false)
					{
						// f[^L^pR[h𐶐
						NGwordRecord entryRecord = new NGwordRecord();

						// R[h͂
						mDbParser.inputRecordFromTemporaryFile(tempFileName, ref entryRecord);

						// R[hXgɓo^
						mDbArrayList.Add(entryRecord);
					}
				}
				catch
				{
					// ϊɎsĂȂ...
				}
			}

			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}

		/// <summary>
		///   QƃOcãR[hԂ
		/// </summary>
		public int numberOfRecords()
		{
			return (mDbArrayList.Count);
		}

		/// <summary>
		///   R[h̏擾
		/// </summary>
		public NGwordRecord getRecordData(int aIndexNumber)
		{
			if ((aIndexNumber < 0)&&
				(aIndexNumber >= mDbArrayList.Count))
			{
				return (null);
			}
			return ((NGwordRecord) mDbArrayList[aIndexNumber]);
		}

		/// <summary>
		///    VKR[h̒ǉ
		/// </summary>
		public NGwordRecord newRecordData()
		{
			// OR[h𐶐
			NGwordRecord entryRecord = new NGwordRecord();

			// VR[hIuWFNgXgɓo^
			mDbArrayList.Add(entryRecord);

			return (entryRecord);
		}

		/// <summary>
		///   R[hP폜
		/// </summary>
		public void removeRecord(int aIndexNumber)
		{
			NGwordRecord targetRecord = (NGwordRecord) mDbArrayList[aIndexNumber];

			mDbArrayList.Remove(targetRecord);
			return;
		}

		/// <summary>
		///   OR[hQۑ
		/// </summary>
		public bool saveDatabase(bool aOverWrite)
		{
			if (aOverWrite != true)
			{
				try
				{
					fileSelectionDialog.CheckFileExists = false;
					fileSelectionDialog.FileName = mDbName;
					if (fileSelectionDialog.ShowDialog() == DialogResult.Cancel)
					{
						// t@Co͂̒f...
						return (false);
					}
				}
				catch
				{
					// Ȃ...
				}
			}
			else
			{
				// t@C͂caƂĎw肳ꂽ...
				fileSelectionDialog.FileName = mDbName;
			}

			// ꎞt@C̎w
			string tempFileName = mDbName + ".temp";

			// ۑt@C̎w
			string targetFileName = fileSelectionDialog.FileName;

			// t@C݂ꍇɂ́Arenameĕۊǂ
			if (File.Exists(targetFileName) == true)
			{
				try
				{
					File.Move(targetFileName, targetFileName + ".BAK");
				}
				catch
				{
					// G[ɂȂƂ͉Ȃ
				}
			}

			// f[^x[Xt@CVKɍ쐬
			try
			{
				mDbAccessor.createDatabase(targetFileName,
										  mDbParser.getDbName(),
										  mDbParser.getDbType(),
										  mDbParser.getDbCreatorName(),
										  mDbParser.getDbVersion());
			}
			catch
			{
				// DBt@CVK쐬Ɏs...
				MessageBox.Show("DBt@C̍쐬Ɏs܂B",
								"t@C쐬s",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// [vāAێĂIuWFNgSāiSR[hjo
			for (int loop = 0; loop < mDbArrayList.Count; loop++)
			{
				NGwordRecord theData = getRecordData(loop);
				try
				{
					// ꎞt@Cɏo͌ADBt@Cɏo
					mDbParser.outputRecordToTemporaryFile(tempFileName, ref theData);
					mDbAccessor.appendRecordToDatabase(targetFileName, tempFileName);
				}
				catch
				{
					// o͎sAAAłȂ...
				}
			}
			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}
	}

//////////////////////////////////////////////////
// // NG-3\
//////////////////////////////////////////////////
// typedef struct {
//	Char   ngWord[NGWORD_LEN];
//	UInt8  checkArea;
//	UInt8  matchedAction;
//	UInt16 reserved1;
//} NNshNGwordDatabase;
//////////////////////////////////////////////////

}
