/*
 *  $Id: getLogDbContainer.cs,v 1.6 2005/02/26 13:17:49 mrsa Exp $
 *    --- NNsi̎QƃOf[^x[X̋L^ꏊ...
 *
 *    getLogDbContainer()				F RXgN^
 *    setGetLogAccessor()				F PalmDB̃ANZT擾
 *    initializeDatas()					F DBt@CIuWFNgɓWJ
 *    numberOfGetLogRecords()			F ݂̎QƃR[h擾
 *    getRecordData()					F IuWFNg
 *    newRecordData()					F VK̃IuWFNg
 *    selectLogDatabaseFileNameToSave()	F ۑpcat@C
 *    saveGetLogDatabase()				F R[hDBt@Cɕۑ
 *
 */
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Net;

namespace NEET
{
	/// <summary>
	///  Of[^̃Rei̐
	/// </summary>
	public class getLogDbContainer : System.Windows.Forms.UserControl
	{
		/// <summary>
		///   KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container     components = null;
		private System.Windows.Forms.Label          label1;
		private System.Windows.Forms.OpenFileDialog fileSelectionDialog;


		// PalmOSDBt@C̃ANZT(par.exewrapperNX)
		private PalmDatabaseAccessor mLogUrlDb             = null;

		// QƃOcãR[hƈꎞt@C̕ϊ
		private GetLogDbParser	mGetLogDbParser = null;

		// QƃOcãR[h
		private int                  mNumberOfLogDbRecords = 0;

		// QƃOca̓̓t@C
		private string               mLogUrlDbName         = null;

		// QƃOcȁo̓t@C
		private string               mDbFileNameToSave     = "";

		// QƃOcãIuWFNgǗpXg
		private ArrayList		mGetLogDatabaseArrayList = null;

		/// <summary>
		///   RXgN^
		/// </summary>
		public getLogDbContainer()
		{
			// ̌ĂяóCWindows.Forms fUCiŕKvłB
			InitializeComponent();

			//  IuWFNg̏...
			mGetLogDatabaseArrayList = new ArrayList();
			mGetLogDbParser          = new GetLogDbParser();
		}

		/// <summary>
		///   gpĂ郊\[X̌㏈s܂B
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
					components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region R|[lg fUCiŐꂽR[h
		/// <summary>
		/// fUCiT|[gɕKvȃ\bhłB̃\bh̓e 
		/// R[hGfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.fileSelectionDialog = new System.Windows.Forms.OpenFileDialog();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(0, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "QƃÕR[hReiNX";
			// 
			// getLogDbContainer
			// 
			this.Controls.Add(this.label1);
			this.Name = "getLogDbContainer";
			this.Size = new System.Drawing.Size(168, 32);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		///	  QƃOcãANZXNXݒ肷
		/// </summary>
		public void setGetLogAccessor(string aDbName, ref PalmDatabaseAccessor aLogUrlDb)
		{
			mNumberOfLogDbRecords   = 0;
			mLogUrlDb               = aLogUrlDb;
			mLogUrlDbName           = aDbName;
			mDbFileNameToSave       = mLogUrlDbName;
			return;
		}

		/// <summary>
		///    f[^ReiNX
		///    (DBt@Cf[^ǂݏoăIuWFNgɓWJ)
		/// </summary>
		public bool initializeDatas()
		{
			// cãwb_ǂŃR[h擾
			if (mLogUrlDb.getRecordNumber(out mNumberOfLogDbRecords) == false)
			{
				// DB̓ǂݍݎsBBB(I)
				MessageBox.Show("DBt@C ܂ par.exȅꏊ" +
								"w肳ĂȂ悤łB\n" +
								"(t@Cݒ̌肢܂B)",
								"Access Failure",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// R[h̊mFsAR[hf[^ǂݍ
			if (mNumberOfLogDbRecords == 0)
			{
				// R[hȂǂݍ܂Ȃ...
				return (true);
			}

			// ꎞt@C̎w
			string tempFileName = mLogUrlDbName + ".temp";

			// R[ĥ鐔ǂݍŃIuWFNgɕϊAo^
			for (int loop = 0; loop < mNumberOfLogDbRecords; loop++)
			{
				try
				{
					// par.exegp1R[ht@CɓWJ
					if (mLogUrlDb.pickUpRecord(loop, tempFileName) != false)
					{
						// OR[h𐶐
						logRecord entryRecord = new logRecord();

						// R[h͂
						mGetLogDbParser.inputRecordFromTemporaryFile(tempFileName, ref entryRecord);

						// R[hXgɓo^
						mGetLogDatabaseArrayList.Add(entryRecord);
					}
				}
				catch
				{
					// ϊɎsĂȂ...
				}
			}

			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}

		/// <summary>
		///   QƃOcãR[hԂ
		/// </summary>
		public int numberOfGetLogRecords()
		{
			return (mGetLogDatabaseArrayList.Count);
		}

		/// <summary>
		///   R[h̏擾
		/// </summary>
		public logRecord getRecordData(int aIndexNumber)
		{
			if ((aIndexNumber < 0)&&
				(aIndexNumber >= mGetLogDatabaseArrayList.Count))
			{
				return (null);
			}
			return ((logRecord) mGetLogDatabaseArrayList[aIndexNumber]);
		}

		/// <summary>
		///    VKR[h̒ǉ
		/// </summary>
		public logRecord newRecordData()
		{
			// OR[h𐶐
			logRecord entryRecord = new logRecord();

			// VR[hIuWFNgXgɓo^
			mGetLogDatabaseArrayList.Add(entryRecord);

			return (entryRecord);
		}

		/// <summary>
		///   R[hP폜
		/// </summary>
		public void removeRecord(int aIndexNumber)
		{
			logRecord targetRecord = (logRecord) mGetLogDatabaseArrayList[aIndexNumber];

			mGetLogDatabaseArrayList.Remove(targetRecord);
			return;
		}

		/// <summary>
		///   ۑp̃t@Cw肷
		/// </summary>
		public void selectLogDatabaseFileNameToSave()
		{
			try
			{
				fileSelectionDialog.CheckFileExists = false;
				fileSelectionDialog.FileName = mDbFileNameToSave;
				fileSelectionDialog.ShowDialog();
				mDbFileNameToSave = fileSelectionDialog.FileName;
			}
			catch
			{
				// Ȃ...
			}

		}

		/// <summary>
		///   OR[hQۑ
		/// </summary>
		public bool saveGetLogDatabase()
		{
			// ꎞt@C̎w
			string tempFileName = mLogUrlDbName + ".temp";

			// t@C݂ꍇɂ́Arenameĕۊǂ
			if (File.Exists(mDbFileNameToSave) == true)
			{
				try
				{
					File.Move(mDbFileNameToSave, mDbFileNameToSave + ".BAK");
				}
				catch
				{
					// G[ɂȂƂ͉Ȃ
				}
			}

			// f[^x[Xt@CVKɍ쐬
			try
			{
				mLogUrlDb.createDatabase(mDbFileNameToSave,
										 mGetLogDbParser.getDbName(),
										 mGetLogDbParser.getDbType(),
										 mGetLogDbParser.getDbCreatorName(),
										 mGetLogDbParser.getDbVersion());
			}
			catch
			{
				// DBt@CVK쐬Ɏs...
				MessageBox.Show("DBt@C̍쐬Ɏs܂B",
								"t@C쐬s",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error);
				return (false);
			}

			// [vāAێĂIuWFNgSāiSR[hjo
			for (int loop = 0; loop < mGetLogDatabaseArrayList.Count; loop++)
			{
				logRecord theData = getRecordData(loop);
				try
				{
					// ꎞt@Cɏo͌ADBt@Cɏo
					mGetLogDbParser.outputRecordToTemporaryFile(tempFileName, ref theData);
					mLogUrlDb.appendRecordToDatabase(mDbFileNameToSave, tempFileName);
				}
				catch
				{
					// o͎sAAAłȂ...
				}
			}
			try
			{
				// ꎞt@C폜
				File.Delete(tempFileName);
			}
			catch
			{
				// 폜s...łȂ...
			}
			return (true);
		}
	}
}

