//////////////////////////////////////////////////////////////////////////////
// $Id: nnda-defines.h,v 1.16 2005/03/18 13:19:32 mrsa Exp $
//
// nnda-defines.h
// nnDA Data structure definition file
//
// (C) 2004, NNsi project, all rights reserved.
//

#include <PalmOS.h>
#include <PalmCompatibility.h>
#include <VFSMgr.h>
#include <Progress.h>
#include <FileStream.h>

// DA creator
#define nnDA_Creator    'nnDA'
#define nnDA_TITLESIZE  16
#define nnDA_DEFTITLE   "NNsi View DA"
#define nnDA_FILENAMESIZE 256

// UnicodeToJis0208 e[uR[h
typedef struct
{
    UInt16 size;
    UInt16 table[256];
} UnicodeToJis0208Rec;

// Jis0208ToUnicode e[uR[h
typedef struct
{
    UInt16 code;
} Jis0208ToUnicodeRec;

// JpegLib f[^̈(part1)
typedef struct
{
    UInt8 private[20];
} JpegLibData;

// JpegLib f[^̈(part2)
typedef struct
{
    UInt8 private[20];
} JpegLibDecodeOptions;

typedef struct {
 UInt16     source;
 Boolean    freePtr;
 UInt32     size;
 MemPtr     dataPtr;
 Boolean    grayScale;
 UInt16     scaleFactor;
} pnoJpegType, *pnoJpegPtr;

// nnDA AA view form globals
// structure:
struct nnDADataType
{
    UInt32        palmOSVersion;   // foCXOSo[W
    UInt16        displayCommand;  // \R}h
    UInt16        editCommand;     // HR}h
    FontID        fontId;          // \tHghc
    UInt16        scale;           // \{
    UInt32        os5density;      // PalmOS5̉𑜓x
    RectangleType dimF;            // \̈̃TCY(coord̈)
    RectangleType area;            // \̈̃TCY(̈)
    UInt8        *areaP;           // \f[^̃|C^
    UInt16        length;          // \f[^
    UInt16        startX;          // `Jnꏊ
    UInt16        startY;          // `Iꏊ
    UInt16        maxX;            // `f[^ő(X)
    UInt16        maxY;            // `f[^ŏ(Y)
    UInt16              *singleWidth;     // VOoCg̕
    UInt16              *doubleWidth;     // _uoCg̕
#ifdef USE_CLIE
    UInt16               hrRef;           // SONY HRQƔԍ
    UInt16               hrVer;           // Sony HR̃o[Wԍ
#endif  // #ifdef USE_CLIE
    Char                 title[nnDA_TITLESIZE + 4];  // tH[̃^CgTCY
    Char                 fileName[nnDA_FILENAMESIZE + 4];
    UInt32               creator;
    UInt32               dataSize;
    Int32                times;
    UInt16               kanjiCode;
    UInt16               vfsVol;
    UInt32               vfsVolumeIterator;
    VolumeInfoType       volInfo;  
    FileRef              vfsFileRef;
    FileHand             streamRef;
    UInt16               sourceLocation;  // JPEGf[^̃\[XP[V
    UInt16               jpegRef;
    BitmapType          *bitmapPP;
    void               *jpegData;
    JpegLibData          data;
    JpegLibDecodeOptions dopt;
    pnoJpegType          pnoData;
};
typedef struct nnDADataType  nnDADataType;

// ̈̊m(|C^)
#define MEMALLOC_PTR(size)    MemPtrNew(size)

// ̈̃NA(|C^)
#define MEMFREE_PTR(ptr)        \
    if (ptr != NULL)            \
    {                           \
        MemPtrFree(ptr);        \
        ptr = NULL;             \
    }

// global feature id:
#define ADT_FTRID       1
#define ADT_FTRID_MEM   2

// other definitions...
#define BUFSIZE        48
#define MARGIN         16
#define BUF_MARGIN    128
#define DISP_LIMIT  10240

// NNsiƂ̘Ag@\p`
#define nnDA_NNSIEXT_VIEWSTART    "<NNsi:NNsiExt type=\"VIEW\">"
#define nnDA_NNSIEXT_ENDVIEW      "</NNsi:NNsiExt>"
#define nnDA_NNSIEXT_INFONAME     "<NNsi:Info>"
#define nnDA_NNSIEXT_ENDINFONAME  "</NNsi:Info>"

#define nnDA_NNSIEXT_UTF8FILE     "UTF8FILE:"
#define nnDA_NNSIEXT_UTF8FILEFOLD "UTF8FOLDFILE:"
#define nnDA_NNSIEXT_BINFILE      "BFILE:"
#define nnDA_NNSIEXT_FILE         "FILE:"
#define nnDA_NNSIEXT_FILE_FOLD    "FOLDFILE:"
#define nnDA_NNSIEXT_HTMLFILE     "HTMLFILE:"
#define nnDA_NNSIEXT_HTML_FOLD    "FOLDHTMLFILE:"
#define nnDA_NNSIEXT_VIEWMEM      "MEM:"
#define nnDA_NNSIEXT_VIEWMEM_FOLD "FOLDMEM:"
#define nnDA_NNSIEXT_HELPLIST     "HELP:LIST"
#define nnDA_NNSIEXT_HELPVIEW     "HELP:VIEW"
#define nnDA_NNSIEXT_HELPUSERTAB  "HELP:FAVORTAB"
#define nnDA_NNSIEXT_HELPNNSISET  "HELP:NNSISET"
#define nnDA_NNSIEXT_HELPGETLOG   "HELP:GETLOG"
#define nnDA_NNSIEXT_SHOWJPEG     "SHOWJPEG:"
#define nnDA_NNSIEXT_VFSFILE      "VFSFILE:"
#define nnDA_NNSIEXT_VFSFILE_FOLD "FOLDVFS:"

#define nnDA_TITLE_HELP_LIST      "ꗗʑ"
#define nnDA_TITLE_HELP_VIEW      "QƉʑ"
#define nnDA_TITLE_HELP_USERTAB   "[U^u"
#define nnDA_TITLE_HELP_NNSISET   "NNsiݒ"
#define nnDA_TITLE_HELP_GETLOG    "QƃOꗗʑ"

#define nnDA_DISPCOMMAND_NOTHING  0   // R}hwȂ
#define nnDA_DISPCOMMAND_FOLD     1   // [Ő܂Ԃ
#define nnDA_DISPCOMMAND_JPEGINFO 2   // JPEG(\)
#define nnDA_DISPCOMMAND_JPEGDISP 3   // JPEG(摜\)

#define nnDA_EDITCOMMAND_BINDATA     16
#define nnDA_EDITCOMMAND_NORMALPARSE 17
#define nnDA_EDITCOMMAND_HTMLPARSE   18
#define nnDA_EDITCOMMAND_UTF8        19

#define nnDA_JPEGSOURCE_MEMORY     0  // JPEGf[^memory
#define nnDA_JPEGSOURCE_FILESTREAM 1  // JPEGf[^file stream
#define nnDA_JPEGSOURCE_VFS        2  // JPEGf[^VFS

/**********  bZ[Wp[Xp  *********/
#define MSGSTATUS_NAME              1
#define MSGSTATUS_EMAIL             2
#define MSGSTATUS_DATE              3
#define MSGSTATUS_NORMAL            4

/********** R[h **********/
#define NNSH_KANJICODE_SHIFTJIS     0x00
#define NNSH_KANJICODE_EUC          0x01
#define NNSH_KANJICODE_JIS          0x02
#define NNSH_KANJICODE_UTF8         0x03
#define nnDA_KANJICODE_RAW          0xff

// from SonyChars.h
#ifndef vchrJogPushedDown
  #define vchrJogPushedDown     (0x1704)
#endif
#ifndef vchrJogPushedUp
  #define vchrJogPushedUp       (0x1703)
#endif
#ifndef vchrJogUp
  #define vchrJogUp             (0x1700)
#endif
#ifndef vchrJogDown
  #define vchrJogDown           (0x1701)
#endif
#ifndef vchrJogPush
  #define vchrJogPush           (0x1705)
#endif
#ifndef vchrJogRelease
  #define vchrJogRelease        (0x1706)
#endif
#ifndef vchrJogBack
  #define vchrJogBack           (0x1707)
#endif

#ifndef vchrJogLeft
  #define vchrJogLeft           (0x1708)
#endif

#ifndef vchrJogRight
  #define vchrJogRight          (0x1709)
#endif

///// from PalmChars.h
#ifndef vchrNavChange
  #define vchrNavChange           (vchrPalmMin + 3)

  #define navBitUp                0x0001
  #define navBitDown              0x0002
  #define navBitLeft              0x0004
  #define navBitRight             0x0008
  #define navBitSelect            0x0010
  #define navBitsAll              0x001F

  #define navChangeUp             0x0100
  #define navChangeDown           0x0200
  #define navChangeLeft           0x0400
  #define navChangeRight          0x0800
  #define navChangeSelect         0x1000
  #define navChangeBitsAll        0x1F00
#endif

#ifdef USE_CLIE
/***** Sony HR-Lib *****/
#define sonySysFileCHRLib         'SlHr'             /* High Resolution */
#define sonySysFileTHRLib         sysFileTLibrary    /* 'libr' */
#define sonySysLibNameHR          "Sony HR Library"

/***** SONY High Resolution LIBRARY (from SonyHRLib.h)  *****/
#define HR_VERSION_SUPPORT_FNTSIZE        (0x200)
#define hrWidth                           320
#define hrHeight                          320

#define HR_TRAP(trapNum)                  SYS_TRAP(trapNum)

#define HRTrapGetAPIVersion               (sysLibTrapCustom)
#define HRTrapWinScreenMode               ((sysLibTrapCustom)+48)
#define HRTrapWinEraseRectangle           ((sysLibTrapCustom)+21)
#define HRTrapWinDrawChar                 ((sysLibTrapCustom)+8)
#define HRTrapWinDrawBitmap               ((sysLibTrapCustom)+7)
#define HRTrapWinDrawChars                ((sysLibTrapCustom)+9)

extern Err  HROpen(UInt16 refNum)
                                           HR_TRAP(sysLibTrapOpen);
extern Err  HRClose(UInt16 refNum)
                                           HR_TRAP(sysLibTrapClose);
extern Err  HRGetAPIVersion(UInt16 refNum, UInt16 *versionP)
                                           HR_TRAP(HRTrapGetAPIVersion);
extern Err  HRWinScreenMode(UInt16 refNum, WinScreenModeOperation operation, UInt32 *widthP, UInt32 *heightP, UInt32 *depthP, Boolean *enableColorP)
                                           HR_TRAP(HRTrapWinScreenMode);
extern void HRWinEraseRectangle(UInt16 refNum, RectangleType *rP, UInt16 cornerDiam)
                                           HR_TRAP(HRTrapWinEraseRectangle);
extern void HRWinDrawChar(UInt16 refNum, WChar theChar, Coord x, Coord Y)
                                           HR_TRAP(HRTrapWinDrawChar);
extern void HRWinDrawBitmap(UInt16 refNum, BitmapPtr bitmapP, Coord x, Coord Y)
	HR_TRAP(HRTrapWinDrawBitmap);

extern void HRWinDrawChars(UInt16 refNum, const Char *chars, Int16 len, Coord x, Coord y)
        HR_TRAP(HRTrapWinDrawChars);

// ===== from SonyJpegUtilLib.h =====
#ifdef USE_SONY_JPEG

/* JpegUtil-Lib */
#define sonySysFileCJpegUtilLib	'SlJU'	/* Jpeg Util Lib */
#define sonySysFileTJpegUtilLib	sysFileTLibrary	/* 'libr' */
//#define sonySysLibNameJpegUtil	"Sony Jpeg Util Library"
#define sonySysLibNameJpegUtil	"Sony Jpeg Util Library"

#define JPEG_UTIL_LIB_TRAP(trapNum) SYS_TRAP(trapNum)

#define jpegUtilLibErrorBase               (0x00)
#define jpegUtilLibErrorClass              (sonyJpegErrorClass | jpegUtilLibErrorBase)

#define jpegUtilLibErrNone                 (errNone)
#define jpegUtilLibErrBadParam             (jpegUtilLibErrorClass | 1)  // invalid parameter
#define jpegUtilLibErrNotOpen              (jpegUtilLibErrorClass | 2)  // library is not open
#define jpegUtilLibErrStillOpen            (jpegUtilLibErrorClass | 3)  // library still in used
#define jpegUtilLibErrNoMemory             (jpegUtilLibErrorClass | 4)
#define jpegUtilLibErrNotSupported         (jpegUtilLibErrorClass | 5)
#define jpegUtilLibErrNotJpegFormat        (jpegUtilLibErrorClass | 6)
#define jpegUtilLibErrNotExifFormat        (jpegUtilLibErrorClass | 7)
#define jpegUtilLibErrExifParamNotFound    (jpegUtilLibErrorClass | 8)
#define jpegUtilLibErrEncDecCanceled       (jpegUtilLibErrorClass | 9)
#define jpegUtilLibErrResourceBusy         (jpegUtilLibErrorClass | 10)

/***************************************************************************
 * Definition
 ***************************************************************************/
#define Incapable                          (0)
#define Capable                            (1)

/******************************************************************************
 *      Structure                                                             *
 ******************************************************************************/
typedef Boolean (*JpegPrgCallbackFunc)  (void *prgCbData);

typedef struct
{
    UInt16                 percent;          // progress
    ProgressPtr            prgP;             // in case of using ProgressMgr
    JpegPrgCallbackFunc    prgCbFunc;        // callback function in the case not using ProgressMgr
    void                  *prgCbData;
} PrgInfoType, *PrgInfoP;

typedef struct
{
    UInt32    numerator;
    UInt32    denominator;    
} RationalType;

/* capability */
typedef struct {
    UInt16 version:1;
    UInt16 latitudeRef:1;
    UInt16 latitude:1;
    UInt16 longitudeRef:1;
    UInt16 longitude:1;
    UInt16 altitudeRef:1;
    UInt16 altitude:1;
    UInt16 mapDatum:1;
    UInt16 reserved:8;
} GPSInfoCapabilityType;

/* capability */
typedef struct {
    UInt16 softName:1;
    UInt16 gpsInfo:1;
    UInt16 orientation:1;    // available ver.2.0
    UInt16 reserved:13;
} JpegDetailInfoCapabilityType;

typedef struct
{
    GPSInfoCapabilityType    gpsInfoCapability;
    Char                     version[4];
    Char                     latitudeRef[2];
    RationalType             latitude[3];
    Char                     longitudeRef[2];
    RationalType             longitude[3];
    Char                     altitudeRef;
    RationalType             altitude;
    Char                    *mapDatum;
} GPSInfoType, *GPSInfoP;

typedef struct
{
    JpegDetailInfoCapabilityType    jpegDetailInfoCapability;    
    Char                            dateTime[20];           /* ex) 2001:10:23 21:04:13 */
    Char                           *softName;
    GPSInfoP                        gpsInfoP;
    // available ver.2.0
    Char                            dateTimeOriginal[20];   /* ex) 2001:10:23 21:04:13 */
    Char                            dateTimeDigitized[20];  /* ex) 2001:10:23 21:04:13 */
    UInt16                          orientation;
    //JpegImageOrientation          orientation;            //add by tashiro 02/05/24
} JpegDetailInfoType, *JpegDetailInfoP;

/***************************************************************************
 * Enum
 ***************************************************************************/
typedef enum {
    jpegDecRatioNormal = 0,
    jpegDecRatioHalf,
    jpegDecRatioQuarter,
    jpegDecRatioOctant
} JpegImageRatio;

typedef enum {
    jpegDecModeNormal = 0,
    jpegDecModeThumbnail
} JpegImageType;

// available ver.2.0
typedef enum {
    JpegImageOriNotSupported = 0,
    JpegImageOriNormal,
    JpegImageOriNormalR,       //notsupported
    JpegImageOriCW180,
    JpegImageOriCW180R,        //notsupported
    JpegImageOriCW90R,         //notsupported
    JpegImageOriCW90,
    JpegImageOriCCW90R,        //notsupported
    JpegImageOriCCW90
} JpegImageOrientation;


/***************************************************************************
 * Macro
 ***************************************************************************/
#define FreeJpegDetailInfo(jpegDetailInfoP)                           \
{                                                                     \
    if((jpegDetailInfoP)->jpegDetailInfoCapability.softName) {        \
        MemPtrFree((jpegDetailInfoP)->softName);                      \
    }                                                                 \
    if((jpegDetailInfoP)->jpegDetailInfoCapability.gpsInfo) {         \
        if((jpegDetailInfoP)->gpsInfoP->gpsInfoCapability.mapDatum) { \
            MemPtrFree((jpegDetailInfoP)->gpsInfoP->mapDatum);        \
        }                                                             \
        MemPtrFree((jpegDetailInfoP)->gpsInfoP);                      \
    }                                                                 \
}


/***************************************************************************
 * Jpeg Util library function trap ID's. Each library call gets a trap number:
 *   JpegLibTrapXXXX which serves as an index into the library's dispatch
 *   table. The constant sysLibTrapCustom is the first available trap number
 *   after the system predefined library traps Open,Close,Sleep & Wake.
 *
 * WARNING!!! The order of these traps MUST match the order of the dispatch
 *  table in LibDispatch.c!!!
 ****************************************************************************/
#define jpegUtilLibTrapGetLibAPIVersion           ((sysLibTrapCustom)+0)
#define jpegUtilLibTrapDecodeImageToBmp           ((sysLibTrapCustom)+1)     /* jpegUtilLibDecodeImageToBmp           */
#define jpegUtilLibTrapDecodeImageToWindow        ((sysLibTrapCustom)+2)     /* jpegUtilLibDecodeImageToWindow        */
#define jpegUtilLibTrapEncodeImageFromBmp         ((sysLibTrapCustom)+3)     /* jpegUtilLibEncodeImageFromBmp         */
#define jpegUtilLibTrapEncodeImageFromWindow      ((sysLibTrapCustom)+4)     /* jpegUtilLibEncodeImageFromWindow      */
#define jpegUtilLibTrapEncodeImageFromPGP         ((sysLibTrapCustom)+5)     /* jpegUtilLibEncodeImageFromPGP         */
#define jpegUtilLibTrapGetJpegInfo                ((sysLibTrapCustom)+6)     /* jpegUtilLibGetJpegInfo                */
#define jpegUtilLibTrapDecodeImageToBmpForFS      ((sysLibTrapCustom)+7)     /* jpegUtilLibDecodeImageToBmpForFS      */
#define jpegUtilLibTrapDecodeImageToWindowForFS   ((sysLibTrapCustom)+8)     /* jpegUtilLibDecodeImageToWindowForFS   */
#define jpegUtilLibTrapEncodeImageFromBmpForFS    ((sysLibTrapCustom)+9)     /* jpegUtilLibEncodeImageFromBmpForFS    */
#define jpegUtilLibTrapEncodeImageFromWindowForFS ((sysLibTrapCustom)+10)    /* jpegUtilLibEncodeImageFromWindowForFS */
#define jpegUtilLibTrapEncodeImageFromPGPForFS    ((sysLibTrapCustom)+11)    /* jpegUtilLibEncodeImageFromPGPForFS    */
#define jpegUtilLibTrapGetJpegInfoForFS           ((sysLibTrapCustom)+12)    /* jpegUtilLibGetJpegInfoForFS           */
#define jpegUtilLibTrapSetJpegOrientation         ((sysLibTrapCustom)+13)    /* jpegUtilLibSetJpegOrientation         */
#define jpegUtilLibTrapSetJpegOrientationForFS    ((sysLibTrapCustom)+14)    /* jpegUtilLibSetJpegOrientationForFS    */

/********************************************************************
 *              Library API Prototypes
 ********************************************************************/

/* open the library */
extern Err jpegUtilLibOpen(UInt16 jpegUtilLibRefNum)
                    JPEG_UTIL_LIB_TRAP(sysLibTrapOpen);

/* close the library */
extern Err jpegUtilLibClose(UInt16 jpegUtilLibRefNum)
                    JPEG_UTIL_LIB_TRAP(sysLibTrapClose);

/* library sleep */
extern Err jpegUtilLibSleep(UInt16 jpegUtilLibRefNum)
                    JPEG_UTIL_LIB_TRAP(sysLibTrapSleep);

/* library wakeup */
extern Err jpegUtilLibWake(UInt16 jpegUtilLibRefNum)
                    JPEG_UTIL_LIB_TRAP(sysLibTrapWake);

/*--------------------------------------------------------------------------
 * Custom library API functions
 *--------------------------------------------------------------------------*/

/* Get our library API version */
extern UInt32 jpegUtilLibGetLibAPIVersion(UInt16 jpegUtilLibRefNum)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapGetLibAPIVersion);

extern Err jpegUtilLibDecodeImageToBmp(UInt16 jpegLibRefNum, FileRef fileRef,
                                       MemPtr inBufP, JpegImageType imageType,
                                       JpegImageRatio ratio, BitmapPtr *bitmapPP,
                                       PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapDecodeImageToBmp);

extern Err jpegUtilLibDecodeImageToWindow(UInt16 jpegLibRefNum, FileRef fileRef,
                                          MemPtr inBufP, JpegImageType imageType,
                                          RectangleType *rP, PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapDecodeImageToWindow);

extern Err jpegUtilLibEncodeImageFromBmp(UInt16 jpegLibRefNum, Boolean isExif,
                                         Char *dateTimeOriginal, Char *softName, GPSInfoP gpsInfoP, 
                                         UInt8 quality, BitmapPtr bitmapP,
                                         FileRef fileRef, MemPtr *outBufP, UInt32 *outBufSize,
                                         PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromBmp);

extern Err jpegUtilLibEncodeImageFromWindow(UInt16 jpegLibRefNum, Boolean isExif,
                                            Char *dateTimeOriginal, Char *softName, GPSInfoP gpsInfoP,
                                            UInt8 quality, RectangleType *rP,
                                            FileRef fileRef, MemPtr *outBufP, UInt32 *outBufSize,
                                            PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromWindow);

extern Err jpegUtilLibEncodeImageFromPGP(UInt16 jpegLibRefNum, Boolean isExif,
                                         Char *softName, GPSInfoP gpsInfoP,
                                         UInt8 quality, DmOpenRef dRef, FileRef inFileRef,
                                         FileRef outFileRef, MemPtr *outBufP, UInt32 *outBufSize,
                                         PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromPGP);

extern Err jpegUtilLibGetJpegInfo(UInt16 jpegLibRefNum, FileRef fileRef,
                                  MemPtr inBufP, UInt32 *imgHeight, UInt32 *imgWidth, 
                                  Boolean *isThumbnail, JpegDetailInfoP jpegDetailInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapGetJpegInfo);

// available ver.2.0
extern Err jpegUtilLibDecodeImageToBmpForFS(UInt16 jpegLibRefNum, FileHand stream,
                                            JpegImageType imageType,
                                            JpegImageRatio ratio, BitmapPtr *bitmapPP,
                                            PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapDecodeImageToBmpForFS);

extern Err jpegUtilLibDecodeImageToWindowForFS(UInt16 jpegLibRefNum, FileHand stream,
                                               JpegImageType imageType,
                                               RectangleType *rP, PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapDecodeImageToWindowForFS);

extern Err jpegUtilLibEncodeImageFromBmpForFS(UInt16 jpegLibRefNum, Boolean isExif,
                                              Char *dateTimeOriginal, Char *softName, GPSInfoP gpsInfoP, 
                                              UInt8 quality, BitmapPtr bitmapP,
                                              FileHand stream, PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromBmpForFS);

extern Err jpegUtilLibEncodeImageFromWindowForFS(UInt16 jpegLibRefNum, Boolean isExif,
                                                 Char *dateTimeOriginal, Char *softName, GPSInfoP gpsInfoP,
                                                 UInt8 quality, RectangleType *rP,
                                                 FileHand stream, PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromWindowForFS);

extern Err jpegUtilLibEncodeImageFromPGPForFS(UInt16 jpegLibRefNum, Boolean isExif,
                                              Char *softName, GPSInfoP gpsInfoP,
                                              UInt8 quality, DmOpenRef dRef, FileRef inFileRef,
                                              FileHand stream, PrgInfoP prgInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapEncodeImageFromPGPForFS);

extern Err jpegUtilLibGetJpegInfoForFS(UInt16 jpegLibRefNum, FileHand stream,
                                       UInt32 *imgHeight, UInt32 *imgWidth, 
                                       Boolean *isThumbnail, JpegDetailInfoP jpegDetailInfoP)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapGetJpegInfoForFS);

extern Err jpegUtilLibSetJpegOrientation(UInt16 jpegLibRefNum, FileRef fileRef,
                                         MemPtr inBufP, JpegImageOrientation orientation)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapSetJpegOrientation);

extern Err jpegUtilLibSetJpegOrientationForFS(UInt16 jpegLibRefNum, FileHand stream,
                                              JpegImageOrientation orientation)
   JPEG_UTIL_LIB_TRAP(jpegUtilLibTrapSetJpegOrientationForFS);

#endif  // #ifdef USE_SONY_JPEG
#endif  // #ifdef USE_CLIE

/*!
 * ----------------------------------------------------------------------
 *  Yves Piguet쐬 "jpeglib for Palm OS" gpݒ...
 *     http://www.nyctergatis.com/jpeglib/index.html
 *
 *     CLIE(OS5?) ȊOPalmfoCXł́A"JpegLib.prc"CXg[
 *      KvB
 * ----------------------------------------------------------------------
 */
#define jpegLibName    "JpegLib"
#define jpegLibCreator 'JpgL'
#define jpegLibCurrentVersion 100

Err JpegLibOpen(UInt16 refnum, UInt32 currentVersion)
	SYS_TRAP(sysLibTrapOpen);

Err JpegLibClose(UInt16 refnum, UInt16 *usecount)
	SYS_TRAP(sysLibTrapClose);

Err JpegLibRead(UInt16 refnum,
		JpegLibData const *src, JpegLibDecodeOptions const *dopt,
		UInt16 *width, UInt16 *height, UInt16 *nComp, void **data)
	SYS_TRAP(sysLibTrapCustom);

void JpegLibCreateDataFileStreaming(UInt16 refnum, JpegLibData *src, FileHand fh)
	SYS_TRAP(sysLibTrapCustom + 5);

void JpegLibCreateDataVFS(UInt16 refnum, JpegLibData *src, FileRef fileRef)
	SYS_TRAP(sysLibTrapCustom + 6);

void JpegLibCreateDecOptions(UInt16 refnum, JpegLibDecodeOptions *dopt)
	SYS_TRAP(sysLibTrapCustom + 12);

void JpegLibSetDecOptDestBitmap(UInt16 refnum, JpegLibDecodeOptions *dopt)
	SYS_TRAP(sysLibTrapCustom + 14);

void JpegLibSetDecOptScale(UInt16 refnum, JpegLibDecodeOptions *dopt, UInt16 scale)
	SYS_TRAP(sysLibTrapCustom + 16);
/*
 * ----------------------------------------------------------------------
 */

/*!
 * ----------------------------------------------------------------------
 *  Stefan Stolz쐬 "pnoJpegLib for PalmOS"gpݒ...
 *     http://www.bin-people.de/pnoJpegLib/
 *
 *     CLIEȊOPalmOS5foCXł́A(pnoJpegLib.prc)
 *      CXg[Ďgɕ\łƎv܂...
 * ----------------------------------------------------------------------
 */
#define pno_srcNoSource     0
#define pno_srcMemPtr       1
#define pno_srcMemHandle    2
#define pno_srcVFS          3

#define PNOJPEG_LIB_TRAP(trapNum) SYS_TRAP(trapNum)

#define     pnoJpegCreatorID    'ajLi'
#define     pnoJpegTypeID       sysFileTLibrary
#define     pnoJpegName         "pnoJpegLib"

/* invalid parameter */
#define pnoJpegErrParam     (appErrorClass | 1)     

/* library is not open */
#define pnoJpegErrNotOpen   (appErrorClass | 2)     

/* returned from pnoJpegClose() if the library is still open */
#define pnoJpegErrStillOpen (appErrorClass | 3)     
/* Standard library open, close, sleep and wake functions */

extern Err pnoJpegOpen(UInt16 refNum)PNOJPEG_LIB_TRAP(sysLibTrapOpen);
extern Err pnoJpegClose(UInt16 refNum)PNOJPEG_LIB_TRAP(sysLibTrapClose);
extern Err pnoJpegSleep(UInt16 refNum)PNOJPEG_LIB_TRAP(sysLibTrapSleep);
extern Err pnoJpegWake(UInt16 refNum)PNOJPEG_LIB_TRAP(sysLibTrapWake);

/* Custom library API functions */
extern Err pnoJpegCreate(UInt16 refNum, pnoJpegPtr data)PNOJPEG_LIB_TRAP(sysLibTrapBase + 5);
extern Err pnoJpegLoadFromPtr(UInt16 refNum, pnoJpegPtr data, MemPtr dataPtr, UInt32 dataSize)PNOJPEG_LIB_TRAP(sysLibTrapBase + 6);
extern Err pnoJpegLoadFromVFS(UInt16 refNum, pnoJpegPtr data, UInt16 volRefNum, char *filePath)PNOJPEG_LIB_TRAP(sysLibTrapBase + 7);
extern Err pnoJpegLoadFromHandle(UInt16 refNum, pnoJpegPtr data, MemHandle hImageData)PNOJPEG_LIB_TRAP(sysLibTrapBase + 8);
extern Err pnoJpegGetInfo(UInt16 refNum, pnoJpegPtr data, Coord *width, Coord *height)PNOJPEG_LIB_TRAP(sysLibTrapBase + 9);
extern Err pnoJpegSetScaleFactor(UInt16 refNum, pnoJpegPtr data, UInt16 factor)PNOJPEG_LIB_TRAP(sysLibTrapBase + 10);
extern Err pnoJpegSetGrayScale(UInt16 refNum, pnoJpegPtr data, Boolean grayScale)PNOJPEG_LIB_TRAP(sysLibTrapBase + 11);
extern Err pnoJpegRead(UInt16 refNum, pnoJpegPtr data, BitmapPtr *bmpPtr)PNOJPEG_LIB_TRAP(sysLibTrapBase + 12);
extern Err pnoJpegBmp2DoubleDensity(UInt16 refNum, BitmapPtr *bmp)PNOJPEG_LIB_TRAP(sysLibTrapBase + 13);
 
/*
 * ----------------------------------------------------------------------
 */
