﻿//  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
//
//  Copyright(C) 2001-2006 Taku Kudo <taku@chasen.org>
//  Copyright(C) 2004-2006 Nippon Telegraph and Telephone Corporation
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NMeCab.Core
{
    public static class Utils
    {
        public static double LogSumExp(double x, double y, bool flg)
        {
            const double MinusLogEpsilon = 50.0;

            if (flg) return y;  // init mode
            double vMin = Math.Min(x, y);
            double vMax = Math.Max(x, y);
            if (vMax > vMin + MinusLogEpsilon)
                return vMax;
            else
                return vMax + Math.Log(Math.Exp(vMin - vMax) + 1.0);
        }

        public static uint GetBitField(uint bits, int offset, int len)
        {
            //BitVector32構造体でもよいが、あえて異なる実装とする。
            uint mask = ~(uint.MaxValue << len);
            return (bits >> offset) & mask;
        }

        public static bool GetFlag(uint bits, int offset)
        {
            //BitVector32構造体でもよいが、あえて異なる実装とする。
            uint mask = 0x1u << offset;
            return (bits & mask) != 0;
        }

        public static bool CompareFlags(uint flags1, uint flags2, int offset, int len)
        {
            uint mask = ~(uint.MaxValue << len) << offset;
            return (flags1 & flags2 & mask) != 0;
        }

        //public static unsafe uint TurnEndianness(uint value) 
        //{
        //    //System.Net.IPAddress.HostToNetworkOrderでもよいが、

        //    byte* pVal = (byte*)&value;

        //    byte* pDist = stackalloc byte[4];
        //    pDist += 3;

        //    *pDist-- = *pVal++;
        //    *pDist-- = *pVal++;
        //    *pDist-- = *pVal++;
        //    *pDist = *pVal;

        //    return *(uint*)pDist;
        //}
    }
}
