/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.semaphore.DefaultSemaphoreServiceMBean;
import jp.ossc.nimbus.service.semaphore.MemorySemaphore;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class DefaultSemaphoreService
extends ServiceBase
implements Semaphore,
DefaultSemaphoreServiceMBean {
    private static final long serialVersionUID = 6475921591298262486L;
    private int capacity = -1;
    private Semaphore semaphore = null;
    private long sleepTime = -1L;
    private long checkInterval = -1L;
    private String semaphoreClassName = MemorySemaphore.class.getName();
    private long timeoutMillis = -1L;
    private int maxWaitCount = -1;
    private long forceFreeTimeoutMillis = -1L;

    public boolean getResource(long timeout, int count, long forceFreeTimeout) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, count, forceFreeTimeout);
    }

    public boolean getResource(long timeout, int count) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, count, this.forceFreeTimeoutMillis);
    }

    public boolean getResource(long timeout) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(timeout, this.maxWaitCount, this.forceFreeTimeoutMillis);
    }

    public boolean getResource(int count) {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(this.timeoutMillis, count, this.forceFreeTimeoutMillis);
    }

    public boolean getResource() {
        if (this.semaphore == null) {
            return false;
        }
        return this.semaphore.getResource(this.timeoutMillis, this.maxWaitCount, this.forceFreeTimeoutMillis);
    }

    public void freeResource() {
        this.semaphore.freeResource();
    }

    public int getResourceCapacity() {
        return this.capacity;
    }

    public void setResourceCapacity(int capa) {
        this.capacity = capa;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeout) {
        this.timeoutMillis = timeout;
    }

    public int getMaxWaitCount() {
        return this.maxWaitCount;
    }

    public void setMaxWaitCount(int count) {
        this.maxWaitCount = count;
    }

    public long getForceFreeTimeoutMillis() {
        return this.forceFreeTimeoutMillis;
    }

    public void setForceFreeTimeoutMillis(long timeout) {
        this.forceFreeTimeoutMillis = timeout;
    }

    public int getResourceRemain() {
        return this.semaphore == null ? -1 : this.semaphore.getResourceRemain();
    }

    public int getWaitingCount() {
        return this.semaphore == null ? 0 : this.semaphore.getWaitingCount();
    }

    public void release() {
        this.semaphore.release();
    }

    public void accept() {
        this.semaphore.accept();
    }

    public int getMaxUsedResource() {
        return this.semaphore == null ? 0 : this.semaphore.getMaxUsedResource();
    }

    public int getMaxWaitedCount() {
        return this.semaphore == null ? 0 : this.semaphore.getMaxWaitedCount();
    }

    public void setSemaphoreClassName(String name) {
        this.semaphoreClassName = name;
    }

    public String getSemaphoreClassName() {
        return this.semaphoreClassName;
    }

    public void startService() throws Exception {
        this.semaphore = (Semaphore)Class.forName(this.semaphoreClassName, true, NimbusClassLoader.getInstance()).newInstance();
        this.semaphore.setResourceCapacity(this.getResourceCapacity());
        if (this.getSleepTime() > 0L) {
            this.semaphore.setSleepTime(this.getSleepTime());
        }
        if (this.getCheckInterval() > 0L) {
            this.semaphore.setCheckInterval(this.getCheckInterval());
        }
    }

    public void stopService() {
        this.semaphore.release();
    }
}

