/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.http;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.http.HttpClientFactoryServiceMBean;

public class HttpClientFactoryService
extends ServiceBase
implements ResourceFactory,
HttpClientFactoryServiceMBean {
    private static final long serialVersionUID = -4952869498749452801L;
    private ServiceName httpClientFactoryServiceName;
    private HttpClientFactory httpClientFactory;

    public void setHttpClientFactoryServiceName(ServiceName name) {
        this.httpClientFactoryServiceName = name;
    }

    public ServiceName getHttpClientFactoryServiceName() {
        return this.httpClientFactoryServiceName;
    }

    public void setHttpClientFactory(HttpClientFactory factory) {
        this.httpClientFactory = factory;
    }

    public void startService() throws Exception {
        if (this.httpClientFactoryServiceName != null) {
            this.httpClientFactory = (HttpClientFactory)ServiceManagerFactory.getServiceObject(this.httpClientFactoryServiceName);
        }
        if (this.httpClientFactory == null) {
            throw new IllegalArgumentException("HttpClientFactoryServiceName or HttpClientFactory must be specified.");
        }
    }

    public void stopService() throws Exception {
        this.httpClientFactory = null;
    }

    public TransactionResource makeResource(String key) throws Exception {
        if (this.httpClientFactory == null) {
            return null;
        }
        return new HttpClientTransactionResource(this.httpClientFactory.createHttpClient());
    }

    public class HttpClientTransactionResource
    implements TransactionResource {
        protected HttpClient client;

        public HttpClientTransactionResource(HttpClient client) {
            this.client = client;
        }

        public void commit() throws Exception {
        }

        public void rollback() throws Exception {
        }

        public void close() throws Exception {
            this.client.close();
        }

        public Object getObject() {
            return this.client;
        }
    }
}

