/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MapJournalEditorService
extends ImmutableJournalEditorServiceBase
implements MapJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 7556861235467148050L;
    private static final String DEFAULT_SECRET_STRING = "******";
    private String startDelimiter = "{";
    private String endDelimiter = "}";
    private String delimiter = ", ";
    private String keyValueDelimiter = "=";
    private String[] secretKeys;
    private Set secretKeySet;
    private String[] enabledKeys;
    private Set enabledKeySet;
    private String secretString = "******";
    private String startValueDelimiter;
    private String endValueDelimiter;

    public void setStartDelimiter(String delim) {
        this.startDelimiter = delim;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public void setEndDelimiter(String delim) {
        this.endDelimiter = delim;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setKeyValueDelimiter(String delim) {
        this.keyValueDelimiter = delim;
    }

    public String getKeyValueDelimiter() {
        return this.keyValueDelimiter;
    }

    public void setStartValueDelimiter(String delim) {
        this.startValueDelimiter = delim;
    }

    public String getStartValueDelimiter() {
        return this.startValueDelimiter;
    }

    public void setEndValueDelimiter(String delim) {
        this.endValueDelimiter = delim;
    }

    public String getEndValueDelimiter() {
        return this.endValueDelimiter;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretKeys(String[] keys) {
        this.secretKeys = keys;
    }

    public String[] getSecretKeys() {
        return this.secretKeys;
    }

    public void setEnabledKeys(String[] keys) {
        this.enabledKeys = keys;
    }

    public String[] getEnabledKeys() {
        return this.enabledKeys;
    }

    public void startService() {
        int i;
        if (this.secretKeys != null) {
            this.secretKeySet = new HashSet();
            for (i = 0; i < this.secretKeys.length; ++i) {
                this.secretKeySet.add(this.secretKeys[i]);
            }
        }
        if (this.enabledKeys != null) {
            this.enabledKeySet = new HashSet();
            for (i = 0; i < this.enabledKeys.length; ++i) {
                this.enabledKeySet.add(this.enabledKeys[i]);
            }
        }
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        Map map = (Map)value;
        buf.append(this.startDelimiter);
        Iterator keys = map.keySet().iterator();
        boolean isOutput = false;
        while (keys.hasNext()) {
            Object k = keys.next();
            if (this.enabledKeySet != null && !this.enabledKeySet.contains(k)) continue;
            if (isOutput) {
                buf.append(this.delimiter);
            }
            this.makeObjectFormat(finder, null, k, buf);
            buf.append(this.keyValueDelimiter);
            if (this.secretKeySet != null && this.secretKeySet.contains(k)) {
                if (this.getStartValueDelimiter() != null) {
                    buf.append(this.getStartValueDelimiter());
                }
                this.makeObjectFormat(finder, null, this.getSecretString(), buf);
                if (this.getEndValueDelimiter() != null) {
                    buf.append(this.getEndValueDelimiter());
                }
            } else {
                Object val = map.get(k);
                if (val != null && this.getStartValueDelimiter() != null) {
                    buf.append(this.getStartValueDelimiter());
                }
                this.makeObjectFormat(finder, null, val, buf);
                if (val != null && this.getEndValueDelimiter() != null) {
                    buf.append(this.getEndValueDelimiter());
                }
            }
            isOutput = true;
        }
        buf.append(this.endDelimiter);
        return buf.toString();
    }
}

