/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DataSetJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class DataSetJournalEditorService
extends BlockJournalEditorServiceBase
implements DataSetJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -6864665877759876004L;
    protected static final String HEADERS_HEADER = "Headers : ";
    protected static final String RECORD_LISTS_HEADER = "RecordLists : ";
    protected static final String HEADER = "[DataSet]";
    protected String[] enabledHeaders;
    protected Set enabledHeaderSet;
    protected String[] enabledRecordLists;
    protected Set enabledRecordListSet;

    public DataSetJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setEnabledRecordLists(String[] names) {
        this.enabledRecordLists = names;
    }

    public String[] getEnabledRecordLists() {
        return this.enabledRecordLists;
    }

    public void createService() {
        this.enabledHeaderSet = new HashSet();
        this.enabledRecordListSet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.enabledRecordLists != null) {
            for (i = 0; i < this.enabledRecordLists.length; ++i) {
                this.enabledRecordListSet.add(this.enabledRecordLists[i]);
            }
        }
    }

    public void stopService() {
        this.enabledHeaderSet.clear();
        this.enabledRecordListSet.clear();
    }

    public void destroyService() {
        this.enabledHeaderSet = null;
        this.enabledRecordListSet = null;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        DataSet bean = (DataSet)value;
        this.makeHeadersFormat(finder, key, bean, buf);
        buf.append(this.getLineSeparator());
        this.makeRecordListsFormat(finder, key, bean, buf);
        return true;
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, DataSet dataSet, StringBuffer buf) {
        buf.append(HEADERS_HEADER);
        String[] names = dataSet.getHeaderNames();
        if (names.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            Header header = dataSet.getHeader(names[i]);
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(names[i])) continue;
            this.makeObjectFormat(finder, null, header, subBuf);
            if (i == names.length - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeRecordListsFormat(EditorFinder finder, Object key, DataSet dataSet, StringBuffer buf) {
        buf.append(RECORD_LISTS_HEADER);
        String[] names = dataSet.getRecordListNames();
        if (names.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            RecordList list = dataSet.getRecordList(names[i]);
            if (!this.enabledRecordListSet.isEmpty() && !this.enabledRecordListSet.contains(names[i])) continue;
            this.makeObjectFormat(finder, null, list, subBuf);
            if (i == names.length - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

