/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import jp.ossc.nimbus.service.aop.DefaultInvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.SerializableMethod;

public class DefaultMethodInvocationContext
extends DefaultInvocationContext
implements MethodInvocationContext,
Serializable {
    private static final long serialVersionUID = 7148580138244485932L;
    protected transient Method targetMethod;
    protected Object[] parameters;

    public DefaultMethodInvocationContext() {
    }

    public DefaultMethodInvocationContext(Object target, Method method, Object[] params) {
        super(target);
        this.targetMethod = method;
        this.parameters = params;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(Method method) {
        this.targetMethod = method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('@').append(Integer.toHexString(this.hashCode()));
        buf.append('{');
        buf.append("target=").append(this.getTargetObject());
        buf.append(',').append("targetMethod=").append(this.getTargetMethod());
        buf.append(',').append("parameters=(");
        Object[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                buf.append(params[i]);
                if (i == params.length - 1) continue;
                buf.append(',');
            }
        }
        buf.append(')');
        buf.append('}');
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.targetMethod == null) {
            out.writeObject(null);
        } else {
            out.writeObject(new SerializableMethod(this.targetMethod));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializableMethod smethod = (SerializableMethod)in.readObject();
        if (smethod != null) {
            this.targetMethod = smethod.getMethod();
        }
    }
}

