/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.Serializable;
import java.util.Date;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorStopException;

public class BeanFlowMonitor
implements Serializable {
    private static final long serialVersionUID = 1596031860601490370L;
    private boolean isSuspend = false;
    private boolean isStop = false;
    private boolean isEnd = false;
    private String suspendLock = new String();
    private String flowName;
    private String currentFlowName;
    private String currentStepName;
    private long startTime = -1L;
    private long endTime = -1L;

    public void suspend() {
        this.isSuspend = true;
    }

    public boolean isSuspend() {
        return this.isSuspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuspend() throws InterruptedException {
        if (this.isSuspend) {
            String string = this.suspendLock;
            synchronized (string) {
                if (this.isSuspend) {
                    this.suspendLock.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        String string = this.suspendLock;
        synchronized (string) {
            this.isSuspend = false;
            this.suspendLock.notifyAll();
        }
    }

    public void stop() {
        this.isStop = true;
    }

    public boolean isStop() {
        return this.isStop;
    }

    protected void checkStop() throws BeanFlowMonitorStopException {
        if (this.isStop) {
            throw new BeanFlowMonitorStopException();
        }
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected void setFlowName(String name) {
        this.flowName = name;
    }

    public String getCurrentFlowName() {
        return this.currentFlowName;
    }

    protected void setCurrentFlowName(String name) {
        this.currentFlowName = name;
    }

    public String getCurrentStepName() {
        return this.currentStepName;
    }

    protected void setCurrentStepName(String name) {
        this.currentStepName = name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long time) {
        if (this.flowName.equals(this.currentFlowName)) {
            this.startTime = time;
        }
    }

    public long getCurrentProcessTime() {
        if (this.startTime == -1L) {
            return 0L;
        }
        if (this.isEnd) {
            return this.endTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    protected void end() {
        if (this.flowName.equals(this.currentFlowName)) {
            this.endTime = System.currentTimeMillis();
            this.currentFlowName = null;
            this.currentStepName = null;
            this.isEnd = true;
        }
    }

    public void clear() {
        this.resume();
        this.isStop = false;
        this.isEnd = false;
        this.flowName = null;
        this.currentFlowName = null;
        this.currentStepName = null;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("flowName=").append(this.flowName).append(',');
        buf.append("currentFlowName=").append(this.currentFlowName).append(',');
        buf.append("currentStepName=").append(this.currentStepName).append(',');
        buf.append("isSuspend=").append(this.isSuspend).append(',');
        buf.append("isStop=").append(this.isStop).append(',');
        buf.append("startTime=").append(new Date(this.startTime)).append(',');
        buf.append("currentProcessTime=").append(this.getCurrentProcessTime());
        buf.append('}');
        return buf.toString();
    }
}

