/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMHTMLConverter
implements StreamConverter {
    private static final long serialVersionUID = -6085930913740530834L;
    public static final int DOM_FROM_HTML = 1;
    public static final int HTML_FROM_DOM = 2;
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected String xslFilePath;

    public DOMHTMLConverter() {
        this(1);
    }

    public DOMHTMLConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDOM((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDOM((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    public InputStream convertToStream(Object obj) throws ConvertException {
        if (obj instanceof Document) {
            return this.toHTML((Document)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDOM(is);
    }

    protected Document toDOM(InputStream is) throws ConvertException {
        DOMParser parser = new DOMParser();
        try {
            InputSource inputSource = new InputSource(is);
            if (this.characterEncodingToObject != null) {
                inputSource.setEncoding(this.characterEncodingToObject);
            }
            parser.parse(inputSource);
            return parser.getDocument();
        }
        catch (SAXException e) {
            throw new ConvertException(e);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected Document toDOM(File file) throws ConvertException {
        try {
            return this.toDOM(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected InputStream toHTML(Document document) throws ConvertException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            if (this.characterEncodingToStream != null) {
                transformer.setOutputProperty("encoding", this.characterEncodingToStream);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConvertException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
    }
}

