/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.RetryInterceptorServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RetryInterceptorService
extends ServiceBase
implements Interceptor,
Serializable,
RetryInterceptorServiceMBean {
    private static final long serialVersionUID = -6753802900894341113L;
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    private String[] returnConditions;
    private List returnConditionList;
    private String[] exceptionConditions;
    private ClassMappingTree exceptionConditionMap;
    private int maxRetryCount = 1;
    private String retryCountAttributeName = DEFAULT_RETRY_COUNT_ATTRIBUTE_NAME;
    private long retryInterval = 0L;

    public void setReturnConditions(String[] conditions) {
        this.returnConditions = conditions;
    }

    public String[] getReturnConditions() {
        return this.returnConditions;
    }

    public void setExceptionConditions(String[] conditions) {
        this.exceptionConditions = conditions;
    }

    public String[] getExceptionConditions() {
        return this.exceptionConditions;
    }

    public void setMaxRetryCount(int count) {
        this.maxRetryCount = count;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setRetryCountAttributeName(String name) {
        this.retryCountAttributeName = name;
    }

    public String getRetryCountAttributeName() {
        return this.retryCountAttributeName;
    }

    public void setRetryInterval(long millis) {
        this.retryInterval = millis;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void startService() throws Exception {
        int i;
        if (this.returnConditions != null && this.returnConditions.length != 0) {
            if (this.returnConditionList != null) {
                this.returnConditionList.clear();
            } else {
                this.returnConditionList = new ArrayList();
            }
            for (i = 0; i < this.returnConditions.length; ++i) {
                this.returnConditionList.add(new Condition(this.returnConditions[i]));
            }
        } else if (this.returnConditionList != null) {
            this.returnConditionList.clear();
        }
        if (this.exceptionConditions != null && this.exceptionConditions.length != 0) {
            this.exceptionConditionMap = new ClassMappingTree(null);
            for (i = 0; i < this.exceptionConditions.length; ++i) {
                String className = this.exceptionConditions[i];
                int index = className.lastIndexOf(58);
                String conditionStr = null;
                if (index != -1) {
                    if (index != className.length() - 1) {
                        conditionStr = className.substring(index + 1);
                    }
                    className = className.substring(0, index);
                }
                Class clazz = RetryInterceptorService.convertStringToClass(className);
                Condition condition = null;
                condition = conditionStr == null ? new Condition() : new Condition(conditionStr);
                this.exceptionConditionMap.add(clazz, condition);
            }
        } else if (this.exceptionConditionMap != null) {
            this.exceptionConditionMap.clear();
        }
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        int retryCount = 0;
        if (context.getAttribute(this.retryCountAttributeName) != null) {
            retryCount = (Integer)context.getAttribute(this.retryCountAttributeName);
        }
        try {
            Object ret = chain.invokeNext(context);
            if (this.returnConditionList != null && this.returnConditionList.size() != 0 && retryCount < this.maxRetryCount) {
                int imax = this.returnConditionList.size();
                for (int i = 0; i < imax; ++i) {
                    Condition condition = (Condition)this.returnConditionList.get(i);
                    if (!condition.evaluate(ret)) continue;
                    if (this.retryInterval > 0L) {
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    context.setAttribute(this.retryCountAttributeName, new Integer(retryCount + 1));
                    return this.invoke(context, chain);
                }
            }
            return ret;
        }
        catch (Throwable th) {
            Condition condition;
            if (this.exceptionConditionMap != null && retryCount < this.maxRetryCount && (condition = this.getTargetCondition(this.exceptionConditionMap, th)) != null && condition.evaluate(th)) {
                if (this.retryInterval > 0L) {
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                context.setAttribute(this.retryCountAttributeName, new Integer(retryCount + 1));
                return this.invoke(context, chain);
            }
            throw th;
        }
    }

    private Condition getTargetCondition(ClassMappingTree conditions, Throwable th) {
        if (conditions == null) {
            return null;
        }
        Condition condition = (Condition)conditions.getValue(th.getClass());
        if (condition != null) {
            return condition;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetCondition(conditions, cause);
    }

    private Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th.getClass().getName().equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    private static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = RetryInterceptorService.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    private class Condition
    implements Serializable {
        private static final long serialVersionUID = -6857448672025453285L;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition() throws Exception {
            this("true");
        }

        Condition(String cond) throws Exception {
            this.initCondition(cond);
        }

        private void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(object);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new IllegalArgumentException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

