
import javax.naming.NamingException;

import javax.jms.QueueConnection;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.QueueSession;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.QueueReceiver;
import javax.jms.JMSException;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jndi.JndiFinder;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            JMSConnectionFactory factory
                 = (JMSConnectionFactory)ServiceManagerFactory
                    .getServiceObject("ConnectionFactory");
            JndiFinder finder = (JndiFinder)ServiceManagerFactory
                    .getServiceObject("JndiFinder");
            
            // QueueConnection擾
            QueueConnection connection = null;
            try{
                connection = (QueueConnection)factory.getConnection();
                System.out.println("QueueConnection");
            }catch(JMSConnectionCreateException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            // Queue擾
            Queue queue = null;
            try{
                queue = (Queue)finder.lookup("queue/ex");
                System.out.println("Queue擾");
            }catch(NamingException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            try{
                // QueueSession𐶐
                QueueSession session = connection.createQueueSession(
                    false,
                    Session.AUTO_ACKNOWLEDGE
                );
                System.out.println("QueueSession");
                
                // QueueSender𐶐
                QueueSender sender = session.createSender(queue);
                System.out.println("QueueSender");
                
                // bZ[W𑗐M
                TextMessage message = session.createTextMessage();
                message.setText("Hello!");
                System.out.println("bZ[WM : " + message.getText());
                sender.send(message);
                System.out.println("bZ[WM");
                sender.close();
                
                // QueueReceiver𐶐
                QueueReceiver receiver = session.createReceiver(queue);
                System.out.println("QueueReceiver");
                
                // bZ[WM
                System.out.println("bZ[WM҂");
                connection.start();
                message = (TextMessage)receiver.receive();
                System.out.println("bZ[WM : " + message.getText());
                receiver.close();
                
                session.close();
                connection.close();
            }catch(JMSException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
}