//----------------------------------------------------------
// DC[^֐
//----------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include "motor.h"
#include "sio.h"

#define SENSOR_BIT  2
#define SENSOR_PORT PORTD
#define SENSOR_DDR  DDRD
#define SENSOR_PIN  PIND

#define WORMWHEEL 20				//EH[zC[̎
#define SHUTTER	  4				    //EH[M1]̃Vb^[̐
#define EDGECNTS	  (SHUTTER*WORMWHEEL) //EH[zC[1]̃ZTʉߐ

	//ZTʉ1񂠂̊px[x]
									//360/(20M*4)=4.5

#define POWACCELL 1		// 
#define CHECKRATE 2		// x`FbN[Hz]
#define RPMCHECKMAX (T_RATE/CHECKRATE)

#define MOTOR_PORT   PORTB  // |[g
#define MOTOR_DDR    DDRB   // o͐ݒ
#define MOTOR_BIT    0

unsigned char pwmcycle=0;
unsigned char rpmchkcnt=0;

typedef struct {
	unsigned char rpmorder;	// ڕWƂRPM
	unsigned char rpmnow;	// ݂RPM
//	unsigned char rpmtemp;	// 
	unsigned char edgecnt;
	char pow;	// PWM rate(0-MOTPOWERMAX)
	char dir;
	char seq;
} ST_MOT;   // \

#define SEQ_EDGEOFF   0
#define SEQ_EDGEON    1
#define SEQ_TASKEND   2
#define SEQ_TASKEND2   3


ST_MOT motor[MOTOR_MAX];

#ifndef F_CPU
#define   F_CPU   8000000    //CPUNbNg[Hz]
#endif

//---------------
#define T_MAXCNT    0x10000 //^C}ől
#define T_RATE      100     //荞݃[g[Hz]
#define T_PRESCALE  256    //vXP[l
#define T_PRESCALEB 4    //vXP[ݒl
// 1=1 / 2=div8 / 3=div64 / 4=div256 / 5=div1024
#define T_TCNT  (T_MAXCNT-((F_CPU/T_PRESCALE)/T_RATE))
//---------------


void motor_init(void)
{
	SENSOR_DDR &= ~(3 << SENSOR_BIT);

    TCCR1A= 0;             // Timer1 [h
    TCCR1B= T_PRESCALEB;   // Timer1 vXP[
	TIMSK |= (1 << TOIE1); // Timer1荞݋
    TCNT1 = T_TCNT;
    TIFR |= (1 << TOV1);  // TOV1rbgNA

	motor_set_rpm(MOTOR_A,0,0);
	motor_set_rpm(MOTOR_B,0,0);
}

extern char debugflag;

char motor_taskend(void)
{
	if(motor[0].seq == SEQ_TASKEND){
		if(motor[1].seq == SEQ_TASKEND){

			motor[0].seq = SEQ_TASKEND2;
			motor[1].seq = SEQ_TASKEND2;
			return(1);
		}
	}
	return(0);
}


////-------------------------------------------------------
//int motor_getrpm(char num)
//{
//// rpm =(((̃ZTʉߐ/Vb^[̐)*60sec) / EH[zC[̎)
//	return(((int)motor[(int)num].rpmnow *CHECKRATE* 60)/EDGECNTS);
//}

//-------------------------------------------------------
SIGNAL(SIG_OVERFLOW1)
{//
#define EDGELEVEL_ON 0
	char num;
	unsigned char edgelevel;
	ST_MOT *pmot = &motor[0];

    TCNT1 = T_TCNT;
//	pmot = &motor[0];

	for(num=0; num<MOTOR_MAX; num++){
		edgelevel = SENSOR_PIN & (1<<(SENSOR_BIT+num));

		if(pmot->seq==SEQ_EDGEOFF){			//ZTOFF҂
			if(pmot->edgecnt == 0){//ZTʉߐ0̏ꍇ
				pmot->pow = 0;	//]I
				pmot->rpmorder = 0; //xOFF
				pmot->seq = SEQ_TASKEND;
			}else{
				if(edgelevel != EDGELEVEL_ON)
					pmot->seq = SEQ_EDGEON;
			}

		}else if(pmot->seq==SEQ_EDGEON){		//ZTON҂
			if(edgelevel == EDGELEVEL_ON){
//				pmot->rpmtemp++;//ZTʉߐ
				pmot->rpmnow++;//ZTʉߐ
				pmot->seq = SEQ_EDGEOFF;

				if(pmot->edgecnt < 255){
					//]̏ꍇAZ
					pmot->edgecnt--;	//ZTʉߐ-1	
				}
			}
		}else{
//		}else if(pmot->seq==SEQ_TASKEND){
		}

		if(rpmchkcnt==0){	//x`FbN o
//			pmot->rpmnow = pmot->rpmtemp;	//ZTʉߐm
//			pmot->rpmtemp=0;
			pmot->rpmnow=0;

//if(debugflag){
//	if(num==1){				//debug
//		sio_txdec(pmot->rpmorder);//debug
	//	sio_txdec(pmot->rpmnow);//debug
	//	sio_txdec(pmot->seq);//debug
//		sio_tx(13);
//		sio_tx(10);
//	}//debug
//}
			if(pmot->rpmorder > 0){//xON̏ꍇ
				//݃Xs[hƗzXs[h̔r
				if(pmot->rpmnow == pmot->rpmorder){
					//ꍇ
				}else if(pmot->rpmnow > pmot->rpmorder){
					//ꍇA
					if(pmot->pow > 0)
						pmot->pow -= POWACCELL;	//
				}else{
					//xꍇA
					if(pmot->pow < MOTPOWMAX)
						pmot->pow += POWACCELL;	//
				}
			}
		}
		//------PWM
		if(pmot->pow > pwmcycle){
			motor_set(num,pmot->dir);
		}else{
			motor_set(num,MOTOR_STOP);
		}
		pmot++;
	}
	pwmcycle++;
	if(pwmcycle >= MOTPOWCYCLE){
		pwmcycle=0;
	}
	rpmchkcnt++;
	if(rpmchkcnt >= RPMCHECKMAX){
		rpmchkcnt=0;	//
	}
}

//----------------------------------------------------------
//p[
void motor_set_angle(char num,int angle,unsigned char power)
{
	motor_set_rpm(num, angle, power);
	motor[num].rpmorder = 0;
	motor[num].pow = power;
}

//----------------------------------------------------------
//x(=p[ݒ)
// num : [^ԍ(0-1)
// angle :px(0-360)B9999ȂΖ]
// rpm : rpm(30炢𐄏)
void motor_set_rpm(char num,int angle,unsigned char rpm)
{
	char dir=MOTOR_STOP;
	ST_MOT *pmot;

	pmot = &motor[(int)num];

	if(angle == 0){
	}else{
		if(angle >= 0){
			dir=MOTOR_FOW;	//+Ɛ]
		}else{
			dir=MOTOR_BACK;	//-Ƌt]
			angle = -angle;
		}
		if(angle == 9999){
			angle = 255;	// endless
		}else{
			angle = (angle * (EDGECNTS/10)) / (360/10);	//ZTʉߐɕϊ
			if(angle > 254) angle=254;
		}
	}
	cli();
	pmot->rpmorder = (unsigned char)(((int)rpm * EDGECNTS)/(60*CHECKRATE));	//zIZTʉߐ
//	pmot->rpmtemp = 0;	//ZTʉߐ
	pmot->rpmnow = 0;	//ZTʉߐݒl
	pmot->dir = dir;
	pmot->edgecnt = (unsigned char)angle;
	pmot->pow = MOTPOWMAX/2;
	pmot->seq = SEQ_EDGEOFF;
	sei();
}

//----------------------------------------------------------
// DC[^
//  dirF[hݒ0`3 motor.hQ
void motor_set(char num,char dir)
{
	num = (num*2)+MOTOR_BIT;

    MOTOR_PORT &= ~(0x3 << num);   // [^UXgbv
    MOTOR_DDR  |=  (0x3 << num);    // o͂ɐݒ
    MOTOR_PORT |=  (dir << num); 	// [hݒ
}

