#include <avr/io.h>
#include <stdio.h>
#include <avr/interrupt.h>
#include "motor.h"
#include "sio.h"

#define TIRED	126				//^C̊Ԋu[mm]
#define TIREW	35				//^C̒a[mm]
#define TIRE1CM	33	//1cm̃^C]px
					//^C̉~= 35mm * 3.1415=109.9525mm
					// (360 / 109.9525)*10=32.7414x
#define TIRE10TURN	36	//Mn10̃^C]
//Mn̉~126mm *3.1415=395.829mm
//Mn1̃^C] = Mn̉~ / ^C~ = 3.6]


#ifndef F_CPU
#define   F_CPU   8000000    //CPUNbNg[Hz]
#endif

//---------------
#define T0_MAXCNT    0x100 //^C}ől
#define T0_RATE      40     //荞݃[g[Hz]
#define T0_PRESCALE  1024    //vXP[l
#define T0_PRESCALEB 5    //vXP[ݒl
// 1=1 / 2=div8 / 3=div64 / 4=div256 / 5=div1024
#define T0_TCNT  (T0_MAXCNT-((F_CPU/T0_PRESCALE)/T0_RATE))
//---------------

char debugflag=0;
char timercnt=0;

SIGNAL(SIG_OVERFLOW0)
{//
    TCNT0 = T0_TCNT;

	if(timercnt)timercnt--;
}

//------------------
void timer0_init(void)
{
    TCCR0A= 0;             // Timer0 [h
    TCCR0B= T0_PRESCALEB;   // Timer0 vXP[
	TIMSK |= (1 << TOIE0); // Timer0荞݋
    TCNT0 = T0_TCNT;
    TIFR |= (1 << TOV0);  // TOV0rbgNA
}

//-------------------------------------------------------
//void waitloop(long i)
//{
//	while(i--){
//	}
//}
//-------------------------------------------------------
char cmd[3]="__";

char cmd_cmp(char *p2)
{
	char *p1 = &cmd[0];

	while(*p1 == *p2)
	{
		if(*p2 == 0)return(0);//equal
		p1++;
		p2++;
	}
	return(1);// not equal
}

char sts_cnt='0';

//------------------------------------------------
int rx_val(void)
{
	int ret;
	int value=0;
	char minus=0;

	while(1){
		ret = sio_rx();	//1oCgM
		if(ret==-1) continue;	//no data
		if((ret==13)||(ret==',')) break;

		if(ret=='-'){
			minus=1;
//		}else if(ret=='+'){
//			minus=0;
		}else{
			ret -= '0';
			if((ret >= 0)&&(ret <= 9)){
				value *= 10;
				value += ret;
			}else{
			//error
			}
		}
	}
	if(minus) value = -value;

	return(value);
}

//-------------------------------------------------------
int main(void)
{
	int val;
	int val_right=0;
	int val_left=0;
	char rpm;

	timer0_init();
	sio_init();
	motor_init();

	DDRB &= ~(1<<6);
	PORTB |= (1<<6);	//pullup

	val=0;
	sei();	//荞݋
//	sio_txstr(".ST.");

	if((PINB & (1<<6))==0){
		debugflag=1;
		sio_txstr("DEBUG");
		motor_set_rpm(MOTOR_RIGHT, 90,10);
		motor_set_rpm(MOTOR_LEFT, 90,10);
	}

	while(1){
		cmd[0]=0;
		cmd[1]=0;
		while(1){

			if(debugflag){
			}else{
				if(timercnt==0){
					timercnt = 20;
					sts_cnt++;
					if(sts_cnt > '9')sts_cnt='0';

					sio_txstr("00000000000000000e");
					sio_tx(sts_cnt);
					if(motor_taskend())
						sio_tx('N');
					else
						sio_tx('0');

					sio_tx(13);
//					sio_txdec(motor_getrpm(MOTOR_A));	//debug
//					sio_txstr("rpm\r");	//debug
				}	//debug
			}
			val = sio_rx();	//1oCgM
			if(val==-1) continue;	//no data
			if((val==13)||(val==',')) break;
			val &= ~0x20;	// upper case
//			if((val >= 'a')&&(val <= 'z')){
//				val -= ('a'-'A');	// upper case
//			}
			if((val >= 'A')&&(val <= 'Z')){
				if(cmd[0]==0){
					cmd[0]=(char)val;
				}else if(cmd[1]==0){
					cmd[1]=(char)val;
				}
			}else{
				//error
			}
		}

		if(debugflag)
			sio_txstr(cmd);//debug

		if(cmd_cmp("ST")==0){	// stop
			motor_set_rpm(MOTOR_RIGHT, 0,0);
			motor_set_rpm(MOTOR_LEFT , 0,0);
			continue;
		}
		rpm = rx_val();	//rpm(20`60)
//		rpm += 1;
		val = rx_val();
		val_right = 0;
		val_left = 0;

		if(cmd_cmp("RR")==0){
			val_right = val;
		}else if(cmd_cmp("LL")==0){
			val_left = val;
		}else{
			if(cmd_cmp("FD")==0){// foward
				val *= TIRE1CM;	//cmpxɕϊ
				val_right = val;
				val_left = val;
			}else if(cmd_cmp("BK")==0){//back
				val *= TIRE1CM;	//cmpxɕϊ
				val_right = -val;
				val_left = -val;
			}else{
				val = (36 * val)/10;

				if(cmd_cmp("RT")==0){	// turn right
					val_right =  -val;
					val_left = val;
				}else if(cmd_cmp("LT")==0){	// turn left	
					val_right = val;
					val_left =  -val;
				}else{
					val *= 2;

					if(cmd_cmp("FR")==0){	// right
						val_left =  val;
					}else if(cmd_cmp("FL")==0){	// left	
						val_right =  val;
					}else if(cmd_cmp("BR")==0){	// right
						val_right = -val;
					}else if(cmd_cmp("BL")==0){	// left	
						val_left = -val;
					}else{
						continue;//error
					}
				}
			}
		}
		motor_set_rpm(MOTOR_RIGHT, val_right,rpm);
		motor_set_rpm(MOTOR_LEFT, val_left,rpm);
	}
}
