//VIDEO OUT
//for ATtiny2313 (ext. clock 8MHz)

//by takuya matsubara
//http://nicotak.com

//Ђ傢̋ZpgĂ܂
// http://www7.big.jp/~kerokero/avr/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>

#include "text.h"

//--------------------------------------
#define BYTE unsigned char
#define WORD unsigned short


//---------------------------------------------------------------------
//   h^ns`
//---------------------------------------------------------------------

struct PB{
	char :1;			//0
	char :1;			//1
	char VID_DOT:1;		//2 rfIEhbg
	char VID_SYNC:1;	//3 rfIMoc1a
	char BEEP:1;		//4 TEhooc1b
	char :1;			//5
	char :1;			//6
	char :1;			//7
};

#define pib (*(volatile struct PB*)&PINB)
#define pdb (*(volatile struct PB*)&DDRB)
#define pob (*(volatile struct PB*)&PORTB)

//--------------------------------------

//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]



///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////// rfIM
///////////////////////////////////////////////////////////////////////////

BYTE linesync=1;
BYTE linetmp=0;
BYTE flagodd=0;
BYTE tick=0;

#if F_CPU == 8000000
	#define OFFSETV 60		//s̗][clock]
//	#define VIDEOWIDTH 16	//screen width[pixel]
	#define DOTH 10			//1pixel̃TCY[line]
#else
	#define OFFSETV 230		//s̗][clock]
//	#define VIDEOWIDTH 52	//screen width[pixel]
	#define DOTH 5			//1pixel̃TCY[line]
#endif

//#define DOTH 6			//1pixel̃TCY[line]
#define VIDEOHEIGHT 16	//screen height[pixel]

WORD vram[16];


///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////// 荞ݏ
// 1sec/15750Hz =  63.49...usec
// (1sec/60) / (1sec/15750) = 262.5

//   1`9:M
//       1`3OupX
//       4`6pX
//       7`9upX
//   10`21:eXgMȂ

char video_driver(void)
{
	if(linesync < 22){	// line001-line021 
		if(linesync == 1){	//(line001-line006)
			//Output Compare Register A
#if F_CPU>8000000
			OCR1A = ((F_CPU / FREQ_H) - 20);
#else
			OCR1A = ((F_CPU / FREQ_H) - 8);
#endif
		}else if(linesync == 7){
			OCR1A = F_CPU / 160000; //
		}
		linesync++;
		return(0);
	}
	//line022-

	BYTE row;
	WORD temp;

	row = linetmp / DOTH;

//	if(linetmp >= (VIDEOHEIGHT * DOTH)){
	if(row >= VIDEOHEIGHT){

		linetmp++;
		if(linetmp == ((VIDEOHEIGHT * DOTH)+1)){
			return(1);
		}
		if(linetmp == ((262-21)+flagodd)){
			flagodd ^= 1;	// f odd/even
			linesync = 1;
			linetmp = 0;
		}
		return(0);
	}

//	mask = pgm_read_byte(&masktable[row & 7]);
	temp = vram[row];

#if F_CPU>8000000
		while(TCNT1L < OFFSETV);	//// Ԓ ////
#endif
	char bitcnt=16;
	while(bitcnt--){
		pob.VID_DOT = ((temp & 0x8000)!=0);
		temp<<=1;
	}

	bitcnt=4;
	while(bitcnt--){
	}
	pob.VID_DOT = 0;

	linetmp++;

	return(0);
}


////////////////////////////////////////////////////
/////////////////////////// 
////////////////////////////////////////////////////

void video_init(void)
{
	/// PWMݒ ///
	TCNT1 = 0;
	ICR1 = (F_CPU / FREQ_H) - 1;	/// TOPl

	TCCR1A = (3<<COM1A0)|(2<<COM1B0)|(2<<WGM10);//fast pwm
	TCCR1B = (3<<WGM12)|(1<<CS10);

//Waveform Generation Mode WGM1x = 0b1110
//clock select= clk div1

	/// 
	TIMSK |= (1<<TOIE1);	// ^C}[Pꊄ

	/// |[go
	pdb.VID_DOT  = 1;
	pdb.VID_SYNC = 1;

}

/////////////////////////////////////////////////////

//-----------------------^C}荞
SIGNAL(SIG_OVERFLOW1)
{	//	15750Hz
	if(video_driver()) tick++;
}

//void vram_dummy(void)
//{
//	unsigned char i=16;
//	char j;
//
//	while(i--){
//		j=4;
//		while(j--){
//			vram[i] <<=4;
//			vram[i] += i;
//		}
//	}
//}
void idle(void){
	sleep_mode();		// 
}

void sleep_loop(char i)
{
	BYTE tickback=0;

    set_sleep_mode(SLEEP_MODE_IDLE); //
	while(i--){
		while(tickback == tick){
			idle();// 1/60sec
		}
		tickback=tick;
	}
}


SIGNAL(SIG_INTERRUPT0)
{
	// power on
	GIMSK &= ~(1<<INT0);   // INT0(Lowxo)荞disable
}


//-------------------------------------------------------
int main(void)
{
#define SW_DDR     DDRD
#define SW_PORT    PORTD
#define SW_BIT     (1<<2)

	char ch=' ';

//	SW_DDR  &= ~SW_BIT;   // Input
	SW_PORT |=  SW_BIT;   // Pullup

	video_init();	// initialize H-sync intr.
//	vram_dummy();
	sei();
	while(1)
	{
		sleep_loop(20);
		
		vram_putch(ch++);
		if(ch >= 0x7f){
			GIMSK |= (1<<INT0);   // INT0(Lowxo)荞݋
			EIFR |= (1<<INTF0);
		    set_sleep_mode(SLEEP_MODE_PWR_DOWN); //
			sleep_mode();		// 

			ch=0x20;
		}
	}
	return 0;
}
