// SIO
// by takuya matsubara
//http://nicotak.com
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
//#include <avr/signal.h>
#include "sio.h"

// (1sec/8MHz)*1 =0,125usec
#ifndef F_CPU
	#define F_CPU   8000000
#endif

#define UBRR38400 (F_CPU/38400/16-1)
#define UBRR9600  (F_CPU/9600/16-1)
#define UBRR4800  (F_CPU/4800/16-1)
#define UBRR2400  (F_CPU/2400/16-1)


#define RINGRXSIZE	26	//Oobt@TCY
char ringrx[RINGRXSIZE];	//MOobt@
char ringrxc1;
char ringrxc2;

#define SIO_OPENED	1
#define SIO_CLOSED	0
char sio_flag=SIO_CLOSED;

#define SSHOT_PORT PORTG
#define SSHOT_PIN  PING
#define SSHOT_DDR  DDRG

#define SSHOT_IBIT (1<<3)
#define SSHOT_OBIT (1<<4)

extern unsigned char vram[];

void sio_txvram(void)
{
	int i;

	if(SSHOT_PIN & SSHOT_IBIT)return;

	sio_tx(0x43);
	for(i=0; i<(122*4); i++){
		sio_tx(vram[i]);
	}
}


void sio_close(void)
{
	UCSR0B = 0;
	sio_flag=SIO_CLOSED;
}

//--------------------------------------------------------------
void sio_init(unsigned int baudrate)
{
	unsigned int ubrr = UBRR9600;

	ringrxc1=0;	//ring buffer counter
	ringrxc2=0;

	if(baudrate == 4800)  ubrr = UBRR4800;
	if(baudrate == 38400) ubrr = UBRR38400;

	UBRR0H = ubrr >> 8;	// baud rate
	UBRR0L = ubrr & 0xff;
	UCSR0B = _BV(RXEN0)|_BV(RXCIE0)|_BV(TXEN0);

	// screen shot
	SSHOT_PORT |=  SSHOT_IBIT;	//pullup
	SSHOT_DDR  &= ~SSHOT_IBIT;//input
	SSHOT_PORT &= ~SSHOT_OBIT;	// low
	SSHOT_DDR  |=  SSHOT_OBIT;//output

	sio_flag = SIO_OPENED;
}


//---------------------------------------------------------------------

SIGNAL(SIG_UART0_RECV)
{
	ringrx[(int)ringrxc1++] = UDR0;	//Oobt@Ɋi[
	if(ringrxc1 >= RINGRXSIZE)
		ringrxc1 = 0;


}

//-----------------------------------------------------------------------
// 1oCgM
// sio_txdatFMf[^0x00-0xff
void sio_tx(char sio_txdat)
{
	if(sio_flag==SIO_CLOSED)
		return;

	while (!(UCSR0A & (1<<UDRE0))); // 

	UDR0=sio_txdat;
}



//-----------------------------------------------------------------------
// 1oCgM
// ߂l: Mf[^0x00`0xFF / 0xFFFF(-1)̏ꍇ̓^CAEgG[
int sio_rx(void)
{
    #define TIMEOUT 30000
    int timeo=0;
    unsigned char rxdat;

	while(1)
	{
		if(ringrxc1 != ringrxc2){
			rxdat = ringrx[(int)ringrxc2++];	//Oobt@o
			if(ringrxc2 >= RINGRXSIZE)
				ringrxc2 = 0;

			return(rxdat);
		}
		timeo++;
		if(timeo>TIMEOUT)
			return(-1);	//error
	}
}


//---------------------------------------------------------------
// Mf[^o
//EMf[^邩Ȃ`FbN
// ߂l:0=Mf[^Ȃ / 1=Mf[^
char sio_rxflag(void)
{
	if(sio_flag==SIO_OPENED){
		if(ringrxc1 != ringrxc2)
			return(1);
	}
	return(0);
}
//-----------------------------------------------------------------------
// 񑗐M
// *strF̃|C^BI[NULL(0)
void sio_txstr(char *str)
{
    while(*str != 0)
    {
        sio_tx(*str++);
    }
//	sio_tx(13);//CR
//	sio_tx(10);//LF
}
