//---------------------------------------------------------------------
// by Takuya Matsubara / NICO Corp. 2006-2008
// http://www.nicotak.com/
//
// NicoBASIC(Original BASIC Interpreter) Alpha Ver.
//
//
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <avr/sleep.h>

#include "nicobasic.h"
#include "adc.h"
#include "i2c.h"
#include "sio.h"

#if USE_BEEP
	#include "beep.h"
#endif
#if USE_PWM
	#include "motor.h"//
#endif

#include "vram.h"
#include "textx.h"
#include "str.h"
#include "keyboard.h"
#include "sw.h"
#include "vect.h"

#if MEMORYTYPE==MEMTYPE_FLASH
	#include "program.h"	//program in Flash ROM
#endif

#if HARDTYPE==HARD_EDUMK2
	#if USE_MMC
		#include "tff.h"	//FAT file system by ChaN
		#include "diskio.h"	//FAT file system by ChaN

		FIL fileobj;
	#endif
#endif


#if HARDTYPE==HARD_EDUMK2
extern void filesave (char *fname);
extern void fileload (char *fname);
#endif

unsigned char getkey(void);

unsigned int bas_skipline(unsigned int adr);
char bas_skipword(char *keyword);

unsigned char * hensu_getdef(int id);
char isAlphabet(char ch);
char isNumber(char ch);
unsigned char code_readbyte(unsigned int adr);
void code_writebyte(unsigned int adr, unsigned char data);
unsigned int bas_getlinenum(unsigned int adr);
void hensu_init(void);
void itoa(char *p,int val);



//--------------
#define ARGLENMAX	18	//ő啶u&Bxxxxxxxxxxxxxxxxv
#define HENSU_LENMAX		6	//ϐ̍ő啶

#if HARDTYPE==HARD_EDUMK2
	#define HENSU_MAX		200		//ϐ̍ő吔
	#define HENSU_NAMEIDMAX	   20	//ϐ̐
#else
	#define HENSU_MAX		40		//ϐ̍ő吔
	#define HENSU_NAMEIDMAX	   10	//ϐ̐
#endif


#define HENSU_EMPTY       -1

#define NEST_MAX 7
//char loop_nest;

typedef struct {
	unsigned int adr;
	int id;	//ϐid
	int step;
	int to;
} ST_LOOP;
		//loopp\

ST_LOOP loop[NEST_MAX];
ST_LOOP *pLoop;

int  hensu_val[HENSU_MAX];

typedef struct {
   int id;		//ϐ
   char name[HENSU_LENMAX+1];	//ϐO
} ST_HENSUNAME;		//ϐp\

ST_HENSUNAME hensutbl[HENSU_NAMEIDMAX];
int hensu_emptyid=0;

//؂oobt@
#if (ARGLENMAX > HENSU_LENMAX)
	#define TEMP_LENMAX ARGLENMAX
#else
	#define TEMP_LENMAX HENSU_LENMAX
#endif
char temp[TEMP_LENMAX+1];
char datatype; 
#define DATA_SUJI 0
#define DATA_MOJI 1

char bas_err;

char bascode[BASCODEMAX+1];	//1ssobt@
unsigned int bas_adr=0;
char *bas_ptr;


#if MEMORYTYPE==MEMTYPE_RAM
	#define CODE_ADRMAX	100
	unsigned char mem[CODE_ADRMAX+1];
#endif
#if MEMORYTYPE==MEMTYPE_EEPROM
	#if HARDTYPE==HARD_EDUMK2
		#define CODE_ADRMAX	2000
	#else
		#define CODE_ADRMAX	511
	#endif
#endif
#if MEMORYTYPE==MEMTYPE_FLASH
	#define CODE_ADRMAX	1023
#endif
#if MEMORYTYPE==MEMTYPE_I2C
	#define EEPROMSLA 0xA0     // EEPROM AhX
	#define CODE_ADRMAX	1023
#endif

#define CODE_ADRNONE	0xffff	//AhXȂ

//--------------------------------------------------
void bas_cls(void)
{
	vram_clear();
	text_locate(0,0);
}
//--------------------------------------------------
void bas_init(void)
{
	if(code_size()==0){	//ĂȂꍇA
		bas_new();//
	}

	sw_init();
	waitloop(100000);
	vram_init();
//	sio_init();	//open̂ŕsv

//#if MEMORYTYPE==2
// R/W test
//	code_writebyte(0,27);
//	if(code_readbyte(0)!=27){
//		bas_errset(ERR_I2C);
//	}
//#endif

	kb_init(); // Initialize keyboard reception
	i2c_init();
	hensu_init();

	sei();

	bascode[0]='\0';	//NULL
}


//------------------------------------------------------------
void waitloop(long cnt)
{
	while(cnt--);
}


//-----------------------------------------------------------
unsigned char code_readbyte(unsigned int adr)
{
	#if MEMORYTYPE==MEMTYPE_I2C
		unsigned char pdata;
	#endif
	#if MEMORYTYPE==MEMTYPE_FLASH
		PGM_P pbas = (PGM_P)pgm_bas;
	#endif

	if(adr > CODE_ADRMAX)return(BASCODE_EOF);

	#if MEMORYTYPE==MEMTYPE_EEPROM
		eeprom_busy_wait();
		return( eeprom_read_byte((uint8_t *)adr));
	#endif
	#if MEMORYTYPE==MEMTYPE_RAM
		return(mem[adr]);
	#endif
	#if MEMORYTYPE==MEMTYPE_I2C
		i2c_eeprom_read(EEPROMSLA,adr,&pdata,1);
		return(pdata);
	#endif
	#if MEMORYTYPE==MEMTYPE_FLASH
		return(pgm_read_byte(pbas + adr));
	#endif
}


//---------------------ERROR CONTROL
//----------ERROR STRING
PROGMEM char pgm_error[]=
	"None\0"	/*0*/
	"Sintax\0"	/*1*/
	"OutMem\0"	/*2*/
	"TooLong\0"	/*3*/
	"BufFull\0"	/*4*/
	"Card\0"	/*5*/
	"Linenum\0"	/*6*/
	"OvrNest\0"	/*7*/
;


//void bas_errclr(unsigned char cnt)
//{
//	bas_err = ERR_NONE;
//}
//--------------------------
void bas_errset(unsigned char errcnt)
{
	bas_err = errcnt;

	prm_strcpy(temp, pgm_error, errcnt);
	bas_print(temp);
	bas_print2(" Err");
//	while(cnt == ERR_FATAL);	//vIG[͖[v
}



//----------------MEMORY CONTROL
void code_writebyte(unsigned int adr, unsigned char data)
{
	if(adr > CODE_ADRMAX){
//		bas_errset(ERR_OUTOFMEMORY);
		return;
	}
	#if MEMORYTYPE==MEMTYPE_FLASH
		return;
	#endif

	#if MEMORYTYPE==MEMTYPE_EEPROM
		eeprom_busy_wait();
		if(	eeprom_read_byte((uint8_t *)adr)==data)return;

		eeprom_write_byte((uint8_t *)adr, data);
	#endif

	#if MEMORYTYPE==MEMTYPE_RAM
		mem[adr]=data;
	#endif

	#if MEMORYTYPE==MEMTYPE_I2C
		i2c_eeprom_write(EEPROMSLA,	adr,&data,1	);
		waitloop(10000);	//20msec
	#endif
}

#define HENSUTEIGIID 19999

//--------------------------
void bas_new(void)
{
	code_writebyte(0, BASCODE_EOF);	//擪ԒnEOF
}

//--------------------------
//sԍvOAhXZo
//linenum : sԍ
unsigned int bas_line2adr(unsigned int linenum)
{
	unsigned int adr=0;

	while(1){
		if(linenum == bas_getlinenum(adr))break;
		adr = bas_skipline(adr);
		if(adr > CODE_ADRMAX){
			return(CODE_ADRNONE);	//Not Found error
		}
	}
	return(adr);
}

//-----------------------
unsigned int bas_label2adr(char *name)
{
	unsigned int adr=0;
	char *pTmp;

	while(1){
		if( code_readbyte(adr++)=='*'){
			pTmp = name;
			while(*pTmp == str_ucase(code_readbyte(adr++))){
				if(*pTmp == '\0')return(adr);
				pTmp++;
			}
		}
		adr = bas_skipline(adr);
		if(adr > CODE_ADRMAX) return(CODE_ADRNONE);	//Not Found error
	}
}

//--------------------------1sOǂݎ
//AhXbas_adr1ŝڂ
void bas_readbakline(void)
{
	char nullcnt=0;
	unsigned char ch;

//	if(bas_adr > 0){
		while(1){
			if(bas_adr == 0)break;

			ch = code_readbyte(bas_adr);
			if((bascode[0]=='\0')&&(ch==BASCODE_EOF)){
				nullcnt++;	//EOFT[`ꍇ
			}
			if(ch=='\0'){
				nullcnt++;
			}
			if(nullcnt >= 3){
				bas_adr++;
				break;
			}
			bas_adr--;
//		}
	}
	bas_readline();
}

//--------------------------1sǂݎ
//AhXbas_adr̃R[hbascodeփRs[
char bas_readline(void)
{
	int i=0;
	unsigned char ch;

	while(1)
	{
		ch = code_readbyte(bas_adr);
		if(ch==BASCODE_EOF){
			bascode[0]=0;
			return(1);	//t@CI
		}
		bas_adr++;
		if((ch==13)||(ch==10))continue;	//CR or LF
		bascode[i++] = ch;
		if(ch=='\0')break;
		if(i>BASCODEMAX){
			bas_errset(ERR_TOOLONG);
			return(1);	//G[
		}
	}
	bas_ptr = bascode;
	return(0);
}

//--------------------------ŏ1sڂǂ
char bas_readline0(void)
{
	bas_adr=0;
	return(bas_readline());
}

/* 
̃f[^\̗
*1sƂNULL܂B
*

10 PRINT A[NULL]
20 A=A+1[NULL]
[EOF]
*/

//--------------------------
void bas_run(void)
{
	unsigned int adr_next;
	FATFS fatfs;	//(FAT file system by ChaN)

	f_mount(0, &fatfs);	//mount diskdrive
	bas_err = ERR_NONE;
	pLoop = &loop[0];
	bas_adr = 0;
	while(1){
		//R[h1sԂǂݎAbascodeɃRs[
		if(bas_readline())
			break;	//vOEOF

		adr_next = bas_decode();	//BASICߎs

		if(bas_err != ERR_NONE)break;	//I

		if(adr_next != CODE_ADRNONE){	//goto for whileȂǂɂړ
			bas_adr = adr_next;
		}
	}
	f_mount(0, 0);	//unmount diskdrive
	text_putch(13);	//cr
}

//--------------------------
void bas_list(void)
{
	bas_adr=0;
	while(1){
		//bascodeɃRs[
		if(bas_readline())
			break;	//vOEOF

		bas_print2(bascode);
		sio_txstr(bascode);
		sio_tx(13);
		sio_tx(10);
//		waitloop(100000);
	}
}


//--------------------------1sǂݔ΂
unsigned int bas_skipline(unsigned int adr)
{
	unsigned char ch;
	while(1){
		ch = code_readbyte(adr++);
		if(ch=='\0')break;	//null
		if(ch==BASCODE_EOF)
			return(CODE_ADRMAX+1);	//t@CI
	}
	return(adr);
}

//------------------------------
unsigned int code_size(void)
{
	unsigned int adr=0;

	while(1)
	{
		if(code_readbyte(adr)==BASCODE_EOF)return(adr);	//t@CI
		adr++;
		if(adr > CODE_ADRMAX)
			return(0);	//EOFȂG[
	}
}

//--------------------------sԍ؂o
// adr : JnAhX(0-)
unsigned int bas_getlinenum(unsigned int adr)
{
	unsigned char ch;
	int num=0;

	while(1){	//sԍ؂o
		ch = code_readbyte(adr++);
		if(ch==BASCODE_EOF)return(CODE_ADRNONE);	//t@CI

		if(isNumber(ch)==0)break;	//łȂȂI
//		if(ch==' ')break;	//łȂȂI
		num *= 10;
		num += (ch-'0');
	}

	return(num);
}

//--------------------------Sf[^ǂݍ
//obt@eʂɒ
void bas_readall(char *pmem)
{
	unsigned int adr=0;
	char ch;

	while(1){
		ch = code_readbyte(adr++);
		*pmem++ = ch;
		if(ch == BASCODE_EOF)break;	//t@CI
	}
}

//--------------------------Sf[^
// char *pmem :buffer address
void bas_writeall(char *pmem)
{
	unsigned int adr=0;
	char ch;

	while(1){
		ch = *pmem++;
		code_writebyte(adr++,ch);
		if(ch == BASCODE_EOF)break;
	}
}

//--------------------------
//wsԍ̃R[h
void bas_del(unsigned int linenum)
{
	unsigned int adr=0;
	unsigned int adr_dst;
//	int len;
	unsigned char ch;

	adr_dst = bas_line2adr(linenum);
	if(adr_dst==CODE_ADRNONE){
		return;	//炸 error
	}
	adr = bas_skipline(adr_dst);
//	len = adr - adr_dst;
	while(1){
		ch = code_readbyte(adr++);
		code_writebyte(adr_dst++,ch);
		if(ch == BASCODE_EOF)break;
	}
}



//-------------------------
//vO
// linenum :ǉsԍ
void bas_enter(unsigned int newlinenum)
{
	unsigned int oldlinenum;
	int len;	//
	unsigned int i;

	len = str_len(bas_ptr)+1;	//ǉ+null

	if(newlinenum==0){
		len -= bas_skipword(" ");
		bas_adr = code_size();	//EOF݂̑AhX
	}else{
		//ds̏
		bas_adr = 0;
		while(1){
			oldlinenum = bas_getlinenum(bas_adr);
			if(oldlinenum == newlinenum){	//sԍ̏ꍇA
				bas_del(oldlinenum);	//vO
			}
			if(oldlinenum >= newlinenum)break;//
			bas_adr = bas_skipline(bas_adr);
		}
	}
		//ǉ̃󂯂
	i = code_size();	//EOF݂̑AhX
	while(1){
		code_writebyte(i+len, code_readbyte(i));
		if(i==bas_adr)break;
		i--;
	}

	for(i=0; i<len; i++){
		code_writebyte(bas_adr+i,*bas_ptr++);	//vO
	}
}


/*
char srt_instr(char *keyword)
{
	char i=0;
	char ch;

	while(1){
		ch = *bas_ptr;
		if(*(keyword+i) != ch){
			i=0;
		}else{
			i++;
			if(*(keyword+i) ==0)return(1);
		}
		if(ch==0)return(0);
		bas_ptr++;
	}
}
*/
//--------------------------
void hensu_init(void)
{
	int i;
	for(i=0; i<HENSU_MAX; i++){
		hensu_val[i] = HENSU_EMPTY;
	}

	for(i=0; i<HENSU_NAMEIDMAX; i++){
		hensutbl[i].id = HENSU_EMPTY;	//empty
		hensutbl[i].name[i] = '\0';
	}

}

#define DEFLEN 6
//typedef struct {
//	char name[DEFLEN];	// 
//	unsigned char adr;	// 
//} ST_DEF;   // \


PROGMEM unsigned char pgm_defadr[]={
	(unsigned char)&PINB ,
	(unsigned char)&PINC ,
	(unsigned char)&PIND ,
	(unsigned char)&PORTB ,
	(unsigned char)&PORTC ,
	(unsigned char)&PORTD ,
	(unsigned char)&DDRB ,
	(unsigned char)&DDRC ,
	(unsigned char)&DDRD ,
	(unsigned char)&TCNT2 ,
//	(unsigned char)&TCNT0 ,
//	(unsigned char)&TCCR0A ,
//	(unsigned char)&TCCR0B ,
	0
};

PROGMEM char pgm_def[]=
	"PINB\0"  /*0*/
	"PINC\0"  /*1*/	
	"PIND\0"  /*2*/
	"PORTB\0" /*3*/
	"PORTC\0" /*4*/
	"PORTD\0" /*5*/
	"DDRB\0"  /*6*/
	"DDRC\0"  /*7*/
	"DDRD\0"  /*8*/
	"RND\0"   /*9*/
//	"TCNT0\0"	
//	"TCCR0A\0"
//	"TCCR0B\0"
	"\0";

//ϐID
int hensu_id(char *name)
{
	int i,id;

	for(i=0; i<HENSU_NAMEIDMAX; i++){
		if( hensutbl[i].id == HENSU_EMPTY)continue;	//empty

		if(str_cmp(hensutbl[i].name,name)==STR_EQU){
			return(hensutbl[i].id);	//ϐ݂
		}
	}
	//ϐ݂炸

	//`ςݕϐ
	id = prm_search(pgm_def,name);
	if(id != -1)
		return(HENSUTEIGIID + id);//

	//Ȃꍇ͐VKϐ
	//new
	for(i=0; i<HENSU_NAMEIDMAX; i++){	//ϐe[uappend
		if(hensutbl[i].id == HENSU_EMPTY){	//empty
			str_cpy(hensutbl[i].name,name);
			id = hensu_emptyid++;
			hensutbl[i].id = id;
			hensu_val[id] = 0;
			return(id);
		}
	}

	bas_errset(ERR_OUTOFMEMORY);
	return(-1);
}

//--------------------------
void hensu_set(int id,int val)
{
	unsigned char *ptr;

	//VKϐ//ʂ̕ϐ
	if(id <HENSUTEIGIID){
		hensu_val[id] = val;
		return;
	}
	//`ςݕϐ
	ptr = hensu_getdef(id);
	*ptr = (unsigned char)val;
}

PROGMEM char pgm_defhensu[]=
	"ADC4\0"   /*0*/
	"ADC5\0"   /*1*/	
	"ADC6\0"   /*2*/
	"ADC7\0"   /*3*/
	"SW\0"     /*4*/
	"RXFLAG\0" /*5*/
	"RCX\0"    /*6*/
	"\0";

#define DEFHENSU_ADC4   0
#define DEFHENSU_ADC5   1
#define DEFHENSU_ADC6   2
#define DEFHENSU_ADC7   3
#define DEFHENSU_SW     4
#define DEFHENSU_RXFLAG 5
#define DEFHENSU_RCX    6

//--------------------------
int hensu_get(char *name)
{
	unsigned char *ptr;
	int id;

	id = prm_search(pgm_defhensu,name);

	if(id == DEFHENSU_ADC4){
		return(ad_get(4));
	}else if(id == DEFHENSU_ADC5){
		return(ad_get(5));
	}else if(id == DEFHENSU_ADC6){
		return(ad_get(6));
	}else if(id == DEFHENSU_ADC7){
		return(ad_get(7));
	}else if(id == DEFHENSU_SW){
		return( sw_get() );
	}else if(id == DEFHENSU_RXFLAG){
		return( sio_rxflag() );
	}else if(id == DEFHENSU_RCX){
		return( sio_rx() );
	}
	id = hensu_id(name);

	//ʂ̕ϐ
	if(id < HENSUTEIGIID){
		return(hensu_val[id]);
	}

	//`ςݕϐ
	ptr = hensu_getdef(id);
	return((int) *ptr);
}


/*
PROGMEM ST_DEF defword[]={
	{"PINB"		,(unsigned char)&PINB },
	{"PINC"		,(unsigned char)&PINC },
	{"PIND"		,(unsigned char)&PIND },
	{"PORTB"	,(unsigned char)&PORTB },
	{"PORTC"	,(unsigned char)&PORTC },
	{"PORTD"	,(unsigned char)&PORTD },
	{"DDRB"		,(unsigned char)&DDRB },
	{"DDRC"		,(unsigned char)&DDRC },
	{"DDRD"		,(unsigned char)&DDRD },
	{"TCNT0"	,(unsigned char)&TCNT0 },
	{"TCCR0A"	,(unsigned char)&TCCR0A },
	{"TCCR0B"	,(unsigned char)&TCCR0B },
	{"",0},
};
*/

unsigned char * hensu_getdef(int id)
{
	PGM_P pDef = pgm_defadr;

	id -= HENSUTEIGIID;
	if(id<0)return(0);

	return((unsigned char *)pgm_read_byte(pDef+id));
}

/*
unsigned char hensu_getdef(char *valname)
{
	char tempstr[DEFLEN];
	int i;
	PGM_P pDef = (PGM_P)defword;

	while(1){
		for(i=0;i<DEFLEN;i++){
			tempstr[i] = pgm_read_byte(pDef+i);
			if(tempstr[i]==0)break;
		}
		if(tempstr[0]==0)break;

		if(str_cmp(tempstr,valname)==STR_EQU){
			return(pgm_read_byte(pDef+DEFLEN));
		}
		pDef += sizeof(ST_DEF);
	}
	return(0);
}
*/



#define CHRTYPE_ANUM  0	//number or alphabet
#define CHRTYPE_OTHER 1	//
#define CHRTYPE_NONE  2


char isAlphabet(char ch)
{
	if((ch>='A')&&(ch<='Z'))return(1);
	if((ch>='a')&&(ch<='z'))return(1);
	return(0);
}

char isNumber(char ch)
{
	if((ch>='0')&&(ch<='9'))return(1);
	return(0);
}

char chrtype(char ch)
{
	if(isNumber(ch))return(CHRTYPE_ANUM);
	if(isAlphabet(ch))return(CHRTYPE_ANUM);
	return(CHRTYPE_OTHER);
}


char temp_cmp(char *p2)
{
//	O[oϐchar temp[]QƂ
	char *p1;
	p1 = &temp[0];

	while(*p1 == *p2)
	{
		if(*p1 == 0)return(1);	//v
		p1++;
		p2++;
	}
	return(0);//sv
}

//R}h^ϐ 1̐؂o
//	O[oϐchar temp[]Ɋi[
//Ep/L2ނɕ
//Ep|L̂ǂ炩ɕω؂oI
//ENULLɂԂ؂oI
//EXy[XɂԂ؂oI
// ߂lFchar^ 0= / -1=ُ
//
char bas_getword(void)
{
	char ch;
	char copycnt=0;
	int cnt=0;
	char chrtype_sta;
	char chrtype_bak = CHRTYPE_NONE;

	while(*bas_ptr == ' '){
		bas_ptr++;
	}
	chrtype_sta = chrtype(*bas_ptr);
	//u&Hvu&BvO

	while(1){
		ch = *bas_ptr;
		if((ch=='\0')||(ch==' '))break; //PI

		chrtype_sta = chrtype(ch);	//p/Lɕ
		copycnt=1;
		//u&Hvu&BvOIɐl
		if(ch == '&'){
			ch = *(bas_ptr+1) & ~0x20;	//upper case
			if((ch=='H')||(ch=='B')){
				copycnt=2;
				chrtype_sta = CHRTYPE_ANUM;
			}
		}
		if(chrtype_bak == CHRTYPE_NONE){
			chrtype_bak = chrtype_sta;
		}else{
			if(chrtype_sta != chrtype_bak)break;//p/LωI
		}
		while(copycnt--){
//			temp[cnt++] = *bas_ptr;	//Rs[
			temp[cnt++] = str_ucase(*bas_ptr);	//Rs[A啶ɕϊ
			bas_ptr++;
			if(cnt > TEMP_LENMAX){	//too long
				bas_errset(ERR_TOOLONG);
				return -1;	//error
			}
		}
		if((ch=='=')||(ch==',')||(ch=='\"')||(ch=='(')||(ch==')'))break;	//J}܂񂾒P͑I
	}
	temp[cnt] = 0;	//NULL
	return 0;
}

#define ARG_ELSE  0
#define ARG_THEN  1
#define ARG_TO    2
#define ARG_STEP  3
#define ARG_AND   4
#define ARG_OR    5
#define ARG_XOR   6
#define ARG_POINT 7
#define ARG_PEEK  8
#define ARG_CHR   9
#define ARG_SIN   10
#define ARG_COS   11
#define ARG_ABS   12
#define ARG_INT   13

PROGMEM char pgm_arg[]=
"ELSE\0"  /*0*/
"THEN\0"  /*1*/
"TO\0"    /*2*/
"STEP\0"  /*3*/
"AND\0"   /*4*/
"OR\0"    /*5*/
"XOR\0"   /*6*/
"POINT\0" /*7*/
"PEEK\0"  /*8*/
"CHR\0"   /*9*/
"SIN\0"   /*10*/
"COS\0"   /*11*/
"ABS\0"   /*12*/
"INT\0"   /*13*/
"\0";

//----------------------------------------------------
//؂oEZ
int bas_getarg(void)
{
#define CALC_EQ      1
#define CALC_NEQ     2
#define CALC_BIG     3
#define CALC_SMALL   4
#define CALC_EQBIG   5
#define CALC_EQSMALL 6
#define CALC_AND     7
#define CALC_OR      8
#define CALC_XOR     9
#define CALC_SHIFTR  10
#define CALC_SHIFTL  11

#define VAL_EQUAL    1	//_YESl N88-BASIC̏ꍇA-1

	char ch;
	int valtemp=0;
	int val=0;
	char calc='+';

	datatype=DATA_SUJI;

	while(1){
		if(bas_getword())	//1P؂o
			break;	//؂oG[

		ch = temp[0];
		if(ch=='\0')
			break;	//null

		if((ch==',')||(ch==':')||(ch==';')||(ch==')'))
			break;	//I

		if(ch=='(')
			continue;

		if(isAlphabet(ch)){	//At@xbg̏ꍇAϐƔf
			char codenum;
			codenum = prm_search(pgm_arg,temp);
			if(codenum==-1){
				if(*bas_ptr=='('){	//zϐ̏ꍇ
					int id;

					id = hensu_id(temp);
					id += bas_getarg();	//vfnum
					valtemp = hensu_val[(int)id];
				}else{
					valtemp = hensu_get(temp);	//z񂶂Ȃϐ
				}
			}else if(codenum==ARG_ELSE){
				bas_ptr -= 4;
				break;//I
//			}else if(codenum==ARG_THEN){
//			}else if(codenum==ARG_TO){
			}else if(codenum<=ARG_STEP){
				break;//I
			}else if(codenum==ARG_AND){
				calc = CALC_AND;	// _Zq
				continue;
			}else if(codenum==ARG_OR){
				calc = CALC_OR;	// _Zq
				continue;
			}else if(codenum==ARG_XOR){
				calc = CALC_XOR;	// _Zq
				continue;
			}else if(codenum==ARG_POINT){
				char px,py;
				px = bas_getarg();	//擾(x)
				py = bas_getarg();	//擾(y)
				valtemp = vram_point(px,py);
			}else if(codenum==ARG_PEEK){
				unsigned char *ptr;
				valtemp = bas_getarg();	//擾(address)
				ptr = (unsigned char *)valtemp;
				valtemp = *ptr;
			}else if(codenum==ARG_CHR){
				temp[0]=(unsigned char)bas_getarg();	//擾(chr code);
				temp[1]='\0';
				datatype = DATA_MOJI;
				break;
			}else if(codenum==ARG_COS){
				valtemp = bas_getarg();	//擾
				valtemp = vect_x1(valtemp);
			}else if(codenum==ARG_SIN){
				valtemp = bas_getarg();	//擾
				valtemp = vect_y1(valtemp);
			}else if(codenum==ARG_ABS){
				valtemp = bas_getarg();	//擾
				if(valtemp < 0)
					valtemp = -valtemp;
			}
		}else if(isNumber(ch)){		//̏ꍇ
			valtemp = str_val(temp);			//
		}else if(ch=='&'){	//L̏ꍇ
			if((temp[1]=='B')||(temp[1]=='H')){		//u&Hvu&Bv̗O
				valtemp = str_val(temp);
			}else{
				break;	//@G[
			}
		}else if(ch=='='){
			ch=temp[1];
			if(ch=='>'){
				calc = CALC_EQSMALL;
			}else if(ch=='<'){
				calc = CALC_EQBIG;
			}else{
				calc = CALC_EQ;
			}
			continue;
		}else if(ch=='<'){
			ch=temp[1];
			if(ch=='>'){
				calc = CALC_NEQ;
			}else if(ch=='='){
				calc = CALC_EQBIG;
			}else if(ch=='<'){
				calc = CALC_SHIFTL;
			}else{
				calc = CALC_BIG;
			}
			continue;
		}else if(ch=='>'){
			ch=temp[1];
			if(ch=='='){
				calc = CALC_EQSMALL;
			}else if(ch=='>'){
				calc = CALC_SHIFTR;
			}else{
				calc = CALC_SMALL;
			}
			continue;
		}else if(ch=='\"'){	//_uNH[e[V
			datatype = DATA_MOJI;
			val=0;
			while(1){
				ch = *bas_ptr++;
				if(ch=='\"'){
					ch='\0';	//null
				}else if(ch=='\\'){
					ch = *bas_ptr++;
					ch &= ~0x20;	//upper case
					if(ch=='R'){
						ch = 13;	// CR
					}
				}
				temp[val++] = ch;
				if(ch=='\0')break;
			}
			break;
		}else{
			//lZƔf
			calc = ch;	//
			continue;
		}
		if(calc=='+'){
			val += valtemp;
		}else if(calc=='-'){
			val -= valtemp;
		}else if(calc=='*'){	// multi
			val *= valtemp;
		}else if(calc=='/'){	// div
			val /= valtemp;
		}else if(calc=='%'){	// mod
			val %= valtemp;
		}else if(calc==CALC_AND){
			val &= valtemp;
		}else if(calc==CALC_OR){
			val |= valtemp;
		}else if(calc==CALC_XOR){
			val ^= valtemp;
		}else if(calc==CALC_EQ){
			if(val == valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_NEQ){
			if(val != valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_BIG){
			if(val < valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_SMALL){
			if(val > valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_EQBIG){
			if(val <= valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_EQSMALL){
			if(val >= valtemp) val=VAL_EQUAL; else val=0;
		}else if(calc==CALC_SHIFTR){
			val = (unsigned int)val >> valtemp;
//			val = val >> valtemp;
		}else if(calc==CALC_SHIFTL){
			val <<= valtemp;
		}
	}

	return(val);
}

//̃L[[hǂݔ΂
//XLbvoCgԂ
char bas_skipword(char *keyword)
{
	char ch;
	char i=0;
	char skipcnt=0;

	while(1){
		ch = *bas_ptr;
		if(ch == 0){	//Syntax Error
			return(-1);	//ُIBL[[h炸
		}
		if(ch != *(keyword+i)){
			i=0;	//not equal
		}else{
			i++;	//equal
		}
		bas_ptr++;
		skipcnt++;
		if(*(keyword+i)==0)
			break;
	}
	return(skipcnt);	//I
}

char for_check(void)
{
	int val;
	val=hensu_val[pLoop->id];

	if(pLoop->step > 0){	//Zloop
		if(val <= pLoop->to)
			return(1);	//[vp
	}else{							//Zloop
		if(val >= pLoop->to)
			return(1);	//[vp
	}
	return(0);	//[vI
}

void bas_commandline(char *str)
{
	str_cpy(bascode,str);
	bas_command();
}

//R}hs
//߂l R}hs=1 / R}hł͂Ȃ=0
PROGMEM char pgm_bascmd[]=
	"RUN\0"    /*0*/
	"NEW\0"    /*1*/
	"EDIT\0"   /*2*/
	"LOAD\0"   /*3*/
	"LIST\0"   /*4*/
	"SAVE\0"   /*5*/
	"\0"
;

#define BASCMD_RUN  0
#define BASCMD_NEW  1
#define BASCMD_EDIT 2
#define BASCMD_LOAD 3
#define BASCMD_LIST 4
#define BASCMD_SAVE 5


char bas_command(void)
{
	char codenum;
	bas_ptr = bascode;

	if(bas_getword())return(-1);//ُI

	codenum = prm_search(pgm_bascmd,temp);

	if(isNumber(temp[0])){		//擪Ȃ̂ōsԍƔf
		unsigned int linenum;

		linenum=str_val(temp);

		if(*bas_ptr=='\0'){	//sԍ̏ꍇ
			bas_del(linenum);
		}else{
			bas_ptr = bascode;
			bas_enter(linenum);		//sԍ,R[h̃|C^
		}
	}else if(codenum == BASCMD_RUN){
		bas_run();
	}else if(codenum == BASCMD_NEW){
		bas_new();
	}else if(codenum == BASCMD_LIST){
		//val = bas_getarg();	//擾
		bas_list(/*val*/);

#if HARDTYPE==HARD_EDUMK2
	}else if(codenum == BASCMD_EDIT){
		edit();		
	}else if(codenum == BASCMD_LOAD){
		if(*bas_ptr == '\0'){
			bas_errset(ERR_CARD);
		}else{
			fileload(temp);
		}
	}else if(codenum == BASCMD_SAVE){
		if(*bas_ptr == '\0'){
			bas_errset(ERR_CARD);
		}else{
			bas_getarg();	//擾
			if(datatype==DATA_MOJI){
				str_cat(temp,".txt");
				filesave(temp);
			}else
				bas_errset(ERR_CARD);
		}
#endif
	}else{
		return(0);	//Y
	}
	bascode[0]=0;
	return(1);	//I
}

//for[v̏ꍇAnext̖[܂ŃWv
//while[v̏ꍇAwend̖[܂ŃWv

PROGMEM char pgm_skipnest[2][13]=
{/*mode0*/
	"FOR\0"     /*0*/
	"NEXT\0"    /*1*/
	"\0"
,/*mode1*/
	"WHILE\0"   /*0*/
	"WEND\0"    /*1*/
	"\0"

};

void bas_skipnest(char mode)
{
	char nest=0;
	char codenum;

	//΂A
	while(1){
		bas_getword();
		if(temp[0]==0){	//R[hȂȂꍇA
			if(bas_readline())
				break;//error

		}else{
			codenum = prm_search(pgm_skipnest[(int)mode],temp);
			if(codenum==0){	//loop start
				nest++;
			}else if(codenum==1){	//loop end
				if(nest<=0){
					break;
				}
				nest--;
			}
		}
	}
}

//---------------------------
//ELSE܂ENDIF܂ŏ΂
//@0=̍sT / 1=ȍ~̍sׂĒT
PROGMEM char pgm_skipif[]=
	"THEN\0"   /*0*/
	"ENDIF\0"  /*1*/
	"ELSE\0"   /*2*/
	"END\0"    /*3 END IF(Z^[BASICp)*/
	"\0"
;

void bas_skipif(char cnt)
{
	char nest=0;
	char codenum;

	//΂A
	while(1){
		bas_getword();
		if(temp[0]=='\0'){	//R[hȂȂꍇA
			if(cnt==0)break;	//
			if(bas_readline())
				break;	//not found error

		}else{
			codenum = prm_search(pgm_skipif,temp);
			if(codenum==0){ //THEN
				if(*bas_ptr == '\0')	//THEN̒オ̏ꍇA
					nest++;
			}else if(codenum==1){//ENDIF
				if(nest<=0)
					break;
				nest--;
			}else if(codenum==2){//ELSE
				if(nest<=0)
					break;
			}else if(codenum==3){//END IF(Z^[BASICp)
				bas_getword();	//O
				if(nest<=0)
					break;

				nest--;
			}
		}
	}
}

unsigned int bas_getretcode(void){
	bas_skipword(" ");	//ǂݔ΂
	if(*bas_ptr=='*'){
		bas_ptr++;
		bas_getword();	//ϐ擾
		return(bas_label2adr(temp));
	}else{
			//擾(sԍ)
		return(bas_line2adr(bas_getarg()));
	}
}


void bas_input(int id)
{
	char inputcnt=0;
	char inputbuf[7];
	unsigned char key;
	int val=0;

	text_putch('?');
	while(1)
	{
			key = getkey();
			if((key==2)||(key==KEYBOARD_ENTER)){	//Enter key
				break;
			}
			if((key==KEYBOARD_BS)||(key==KEYBOARD_LEFT)){	//
				if(inputcnt > 0){
					text_putch(8);
					inputbuf[(int)inputcnt]='\0';
					inputcnt--;
				}
			}else if((key==KEYBOARD_UP)||(key==KEYBOARD_DOWN)){	//
				if(key==KEYBOARD_DOWN)
					val--;
				else
					val++;

				while(inputcnt--){
					text_putch(8);
				}
				itoa(inputbuf,val);
				bas_print(inputbuf);
				inputcnt=str_len(inputbuf);

			}else if(key < 0x20){
				//
			}else{
				text_putch(key);
				inputbuf[(int)inputcnt++] = key;
				inputbuf[(int)inputcnt+1]='\0';
				if(inputcnt > 4)
					inputcnt = 4;
			}
	}
	text_putch(13);	//cr

	hensu_val[id] = str_val(inputbuf);
}


PROGMEM char pgm_decode[]=
	"IF\0"     /*0*/
	"PRINT\0"  /*1*/
	"PSET\0"   /*2*/
	"LINE\0"   /*3*/
	"CIRCLE\0" /*4*/
	"POKE\0"   /*5*/
	"COLOR\0"  /*6*/
	"LOCATE\0" /*7*/
	"GOTO\0"   /*8*/
	"BEEP\0"   /*9*/
	"SCROLL\0" /*10*/
	"PWM\0"    /*11*/
	"WHILE\0"  /*12*/
	"WEND\0"   /*13*/
	"DIM\0"    /*14*/
	"FOR\0"    /*15*/
	"NEXT\0"   /*16*/
	"CLS\0"    /*17*/
	"STX\0"    /*18*/
	"FOPEN\0"  /*19*/
	"FREAD\0"  /*20*/
	"FCLOSE\0" /*21*/
	"SOPEN\0"  /*22*/
	"SCLOSE\0" /*23*/
	"REM\0"    /*24*/
	"END\0"    /*25*/
	"GOSUB\0"  /*26*/
	"RETURN\0" /*27*/
	"ELSE\0"   /*28*/
	"ENDIF\0"  /*29*/
	"BITMAP\0" /*30*/
	"INPUT\0"  /*31*/
	"LET\0"    /*32*/
	"\0"
;


#define BASDEC_IF     0
#define BASDEC_PRINT  1
#define BASDEC_PSET   2
#define BASDEC_LINE   3
#define BASDEC_CIRCLE 4
#define BASDEC_POKE   5
#define BASDEC_COLOR  6
#define BASDEC_LOCATE 7
#define BASDEC_GOTO   8
#define BASDEC_BEEP   9
#define BASDEC_SCROLL 10
#define BASDEC_PWM    11
#define BASDEC_WHILE  12
#define BASDEC_WEND   13
#define BASDEC_DIM    14
#define BASDEC_FOR    15
#define BASDEC_NEXT   16
#define BASDEC_CLS    17
#define BASDEC_STX    18
#define BASDEC_FOPEN  19
#define BASDEC_FREAD  20
#define BASDEC_FCLOSE 21
#define BASDEC_SOPEN  22
#define BASDEC_SCLOSE 23
#define BASDEC_REM    24
#define BASDEC_END    25
#define BASDEC_GOSUB  26
#define BASDEC_RETURN 27
#define BASDEC_ELSE   28
#define BASDEC_ENDIF  29
#define BASDEC_BITMAP 30
#define BASDEC_INPUT  31
#define BASDEC_LET    32



//---------------------------------
//BASIC fR[h
//1sƂ̉/s
unsigned int bas_decode(void)
{
//	char lcd_update=0;	//LCDւ̍XVtO
	int val,val2;
	char codenum;
	unsigned int retcode = CODE_ADRNONE;

	bas_ptr = bascode;
	while(isNumber(*bas_ptr)){	// sԍǂݔ΂
		bas_ptr++;
	}

	while(1){
//		sleep_mode();		//
		if(bas_getword()){
			retcode = CODE_ADRMAX;	//EOFo܂̓f[^ُ̈ =I
			break;
		}
		if(temp[0]=='\0'){	//R[hȂȂꍇA
			break;	//I
		}
		if(temp[0]=='*'){	//label
			break;	//
		}
		if(temp[0]==':'){	//
			continue;	//
		}

		codenum = prm_search(pgm_decode,temp);

		if(codenum == -1){	//ϐ
			int id;

			id = hensu_id(temp);	//ID

			bas_getword();	// '=' or '('
			if(temp[0]=='('){	//zϐ
				id += bas_getarg();	//vfnum
				bas_skipword("=");	//ǂݔ΂
			}

			val = bas_getarg();	//擾
			hensu_set(id,val);	//ϐɑ
		}else if(codenum == BASDEC_IF){
			val = bas_getarg();	//擾(Z)
			if(val==0){	//0̏ꍇAvOfR[hf
				if(*bas_ptr == '\0'){	//THEN̒オNULL̏ꍇA
					bas_skipif(1);	//ELSE܂ENDIF܂ŏ΂
				}else{
					bas_skipif(0);	//ELSE܂͂̍s̏I܂ŏ΂
				}
			}
		}else if(codenum == BASDEC_ELSE){
			if(*bas_ptr != '\0'){	//elsȇ
					//I
			}else{
				bas_skipif(1);	//ENDIF܂ŏ΂
			}
		}else if(codenum == BASDEC_ENDIF){
			//
		}else if(codenum == BASDEC_PRINT){
			while(*bas_ptr != 0){
				val = bas_getarg();	//擾
				if(datatype==DATA_SUJI){
					bas_printd(val);
					if(temp[0] != ';'){	//
						text_putch(13);	//s
						break;
					}
				}else{
					bas_print(temp);
					if(*bas_ptr != ';'){	//
						text_putch(13);	//s
						break;
					}
					bas_ptr++;
				}
				//u;v̒オNULL sI
			}
		}else if(codenum == BASDEC_PSET){
			char col;
			val  = bas_getarg();	// 擾X
			val2 = bas_getarg();	// 擾Y
			col = bas_getarg();	// 擾COLOR
			vram_pset(val,val2,col);
		}else if(codenum == BASDEC_LINE){
			char x2,y2,col;

			val  = bas_getarg();	// 擾X1
			val2 = bas_getarg();	// 擾Y1
			x2 = bas_getarg();		// 擾X2
			y2 = bas_getarg();		// 擾Y2
			col = bas_getarg();     // 擾COLOR
//			if(temp_cmp(",")){
			if(temp[0]==','){	//
				bas_getword();	//ϐ擾
				col |= 0x10;	//box full 
			}
			vram_line(val,val2,x2,y2,col);
		}else if(codenum == BASDEC_BITMAP){
			char arraymax;
			char x,y,i;
			int id,col=99;
			unsigned int bitdata;

			bas_getword();	//zϐ擾
			id = hensu_id(temp);	//ϐid
			if(*bas_ptr != ','){	//
				id += bas_getarg();		//vfnum
			}
			bas_skipword(",");	//ǂݔ΂
			x = bas_getarg();	//
			y = bas_getarg();	//
			arraymax = bas_getarg();	//z̗vf
			if(temp[0]==','){	//[,color]w
				col = bas_getarg();	//
				while(arraymax--){
					bitdata = hensu_val[id];
					for(i=0;i<16;i++){
						if(bitdata & 0x8000){
							vram_pset(x+i,y,col);
						}
						bitdata <<= 1;
					}
					id++;
					y++;
				}
			}else{			//FwȂꍇ0`
				while(arraymax--){
					bitdata = hensu_val[id];
					for(i=0;i<16;i++){
						vram_pset(x+i,y,((bitdata & 0x8000)!=0));
						bitdata <<= 1;
					}
					id++;
					y++;
				}
			}
		}else if(codenum == BASDEC_CIRCLE){
			char r,col;
			val  = bas_getarg();	// 擾X
			val2 = bas_getarg();	// 擾Y
			r = bas_getarg();	// 擾R
			col = bas_getarg();	// 擾R
			vram_circle(val,val2,r,col);
		}else if(codenum == BASDEC_POKE){
			unsigned char *pPoke;
			pPoke = (unsigned char *)bas_getarg();		//擾(AhX)
			val = bas_getarg();		//擾(f[^)
			*pPoke = (unsigned char)val;
		}else if(codenum == BASDEC_COLOR){
			val  = bas_getarg();	// 擾
			text_setcolor(val);
		}else if(codenum == BASDEC_LOCATE){
			val  = bas_getarg();	// 擾X
			val2 = bas_getarg();	// 擾Y
			text_locate(val,val2);
		}else if(codenum == BASDEC_GOTO){
			retcode = bas_getretcode();
			break;

#if USE_BEEP
		}else if(codenum == BASDEC_BEEP){
			val  = bas_getarg();	// Hz
			val2 = bas_getarg();	// time(100msec)
			beep_set(val,val2);
#endif
		}else if(codenum == BASDEC_SCROLL){
			val  = bas_getarg();	// x1
			val2 = bas_getarg();	// y1
			vram_scroll(val,val2);
//			lcd_update=1;

#if USE_PWM
		}else if(codenum == BASDEC_PWM){	//motor drive
			char motorid;
			motorid = bas_getarg();	// motor_ID
			val2 = bas_getarg();	// power
			val  = bas_getarg();	// time
			motor_set_pow(motorid,val2,val);
#endif
		}else if(codenum == BASDEC_WHILE){
			pLoop->adr = bas_adr - str_len(bascode)-1;
			pLoop++;
			val = bas_getarg();	//擾(Z)
			if(val==0){	//0̏ꍇAWEND܂ŃvOfR[hf
				bas_skipnest(1);	//
				pLoop--;
				break;
			}
		}else if(codenum == BASDEC_WEND){
			pLoop--;
			retcode = pLoop->adr;
			break;
		}else if(codenum == BASDEC_FOR){
			if(pLoop >= &loop[NEST_MAX]){
				bas_errset(ERR_NEST);
				break;
			}
			bas_getword();	//ϐ擾
			pLoop->id = hensu_id(temp);
			bas_skipword("=");	//
			hensu_val[pLoop->id] = bas_getarg();	//擾;

			pLoop->to = bas_getarg();	//TO擾

			if(temp_cmp("STEP")){
				val = bas_getarg();	//STEP擾
			}else{
				val=1;
			}
			pLoop->step = val;
			pLoop->adr = bas_adr;

			if(for_check()==0){
				bas_skipnest(0);	//next
			}else{
				pLoop++;
			}
		}else if(codenum == BASDEC_NEXT){
			if(*bas_ptr == ' '){	//
				bas_getword();	//ϐ擾
			}
			pLoop--;
			hensu_val[pLoop->id] += pLoop->step;

			if(for_check()){	//[vp
				retcode = pLoop->adr;	//back to FOR
				pLoop++;
				break;
			}
		}else if(codenum == BASDEC_CLS){
			bas_cls();	//

		}else if(codenum == BASDEC_STX){
			val = bas_getarg();	//擾
			sio_txstr(temp);

#if HARDTYPE==HARD_EDUMK2
		}else if(codenum == BASDEC_FOPEN){
				BYTE res;

				if(fileobj.fs != 0){	// t@CY΍
					f_close(&fileobj);
				}
				val = bas_getarg();	//擾
				res = f_open(&fileobj, temp, FA_OPEN_EXISTING | FA_READ);

//			}else if(codenum == BASDEC_FSEEK){
//				val = bas_getarg();	//擾
//				res = f_lseek(&fileobj, val);

		}else if(codenum == BASDEC_FREAD){
				unsigned char tempbuf[50];
				int i;
				int bytes;
				BYTE res;
				UINT cnt;

				bas_getword();	//ϐ擾
				val = hensu_id(temp);	//ϐid
				bas_skipword(",");	//
				bytes = bas_getarg();	//   ǂݍ݃oCg;
				res = f_read(&fileobj, tempbuf, bytes, &cnt);

				//copy byte to word
				for(i=0; i<bytes ;i++)
					hensu_val[val++] = tempbuf[i];

		}else if(codenum == BASDEC_FCLOSE){
			f_close(&fileobj);	// t@C

		}else if(codenum == BASDEC_SOPEN){
			if(*bas_ptr==' ')
				val = bas_getarg();	//擾
			else
				val =9600;

			sio_init(val);
		}else if(codenum == BASDEC_SCLOSE){
			sio_close();
#endif
		}else if(codenum == BASDEC_END){
			if(*bas_ptr == ' '){	//
				bas_getword();		//uEND IFvƔf
			}else{
				retcode=CODE_ADRNONE;
			}
			break;
		}else if(codenum == BASDEC_GOSUB){
			if(pLoop >= &loop[NEST_MAX]){
				bas_errset(ERR_NEST);
				break;
			}
			retcode = bas_getretcode();
			pLoop->adr = bas_adr;	//return address
			pLoop++;
			break;
		}else if(codenum == BASDEC_RETURN){
			pLoop--;
			retcode = pLoop->adr;
			break;
		}else if(codenum == BASDEC_DIM){
			char arraymax;

			bas_getword();	//ϐ擾
			hensu_emptyid = hensu_id(temp);	//ϐid
			bas_skipword("(");	//ǂݔ΂
			arraymax = bas_getarg();	//z̗vf

			while(arraymax--){
				hensu_val[hensu_emptyid++] = 0;
				if(hensu_emptyid >= HENSU_MAX){
					bas_errset(ERR_OUTOFMEMORY);
					break;
				}
			}
		}else if(codenum == BASDEC_INPUT){
			int id;

			val = bas_getarg();	//擾
			bas_print(temp);
			bas_skipword(";");	//ǂݔ΂
			bas_getword();		//ϐ擾
			id = hensu_id(temp);	//ϐid
			bas_input(id);
		}else if(codenum == BASDEC_REM){
			sio_txvram();	//capture screen
			break;
		}
	}
	return(retcode);
}



//---------------------
void bas_cmddel(int pos)
{
	mem_del(bascode, pos, BASCODEMAX);
}

//---------------------
void mem_ins(char *p,int pos,char ch,int lastpos)
{
	int i;
	i=lastpos-1;

	while(pos <= i){
		*(p+i+1) = *(p+i);
		i--;
	}

	*(p+pos) = ch;
}

//---------------------
void mem_del(char *p,int pos,int lastpos)
{
	while(pos <= lastpos){
		*(p+pos) = *(p+pos+1);
		pos++;
	}
	*(p+lastpos) = 0;	//ŌNULLǉ
}

//---------------------
void bas_cmdins(int pos,char ch)
{
	mem_ins(bascode, pos, ch, BASCODEMAX);
//	int i=BASCODEMAX-1;
//
//	while(pos <= i){
//		bascode[i+1] = bascode[i];
//		i--;
//	}
//
//	bascode[pos] = ch;
}

//---------------------
char bas_cmdget(char cnt)
{
	return(bascode[(int)cnt]);
}



//---------------------------------------------------------------------
void bas_print2(char *p)
{
	bas_print(p);
	text_putch(13);
}

//---------------------------------------------------------------------
void bas_print(char *p)
{
	unsigned char ch;

	while(1){
		ch = *p++;
		if(ch == 0)break;
		text_putch(ch);
	}
}

//void bas_print(char *p)
//{
//	unsigned char ch;
//	unsigned char chh=0;
//
//	while(1){
//		ch =(unsigned char) *p++;
//		if(ch == 0)break;
//
//		//SJIS
//		if(chh != 0){	//high byte = exist
//			text_putchw(((unsigned int)chh << 8) | ch);
//			chh=0;
//		}else{			 //high byte = empty
//			if((ch >= 0x81)&&(ch < 0x98)){
//				chh = ch;
//			}else{
//				text_putch(ch);	//normal code
//			}
//		}
//	}
//}
//---------------------------------------------------------------------
void itoa(char *p,int val)
{
	int ketaval=10000;

	if(val<0){
		*p++ = '-';
		val = -val;
	}

	while (ketaval != 0) {
		*p = '0';
		while(val >= ketaval){
			val -= ketaval;
			*p += 1;
		}
		p++;
		ketaval /= 10;
	}
	*p = 0;	//null
}


void bas_printd(int val)
{
	unsigned char tempch;
	char putflag=0;
	int ketaval=10000;

	if(val<0){
		text_putch('-');
		val=-val;
	}
	while (ketaval != 0) {
		tempch='0';
		while(val >= ketaval){
			val -= ketaval;
			tempch++;
		}
		if((ketaval==1)||(tempch!='0')) putflag=1;
		if(putflag)	text_putch(tempch);

		ketaval /= 10;
	}
}



//--------------------------------------------------------------

void bas_printhex(unsigned char x)
{
	unsigned char tempch;
	char shiftcnt=4;

	while (1) {
		tempch = (x >> shiftcnt) & 0xF;
		if(tempch < 10)
			tempch += '0';
		else
			tempch += ('A'-10);

		text_putch(tempch);
		if(shiftcnt==0)break;
		shiftcnt >>= 4;
	}
}

