//---------------------------------------------------------------------
//
//   BEEP
//  by Takuya Matsubara / NICO Corp. 2008
// http://www.nicotak.com/
//
//---------------------------------------------------------------------

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "beep.h"


#define BEEPINTRHZ	15750	//Ăяo

//#define BEEP_PORT PORTB
//#define BEEP_DDR  DDRB
//#define BEEP_BIT  (1<<6)

unsigned int FREQW=0;			// freq(0-ffff)
unsigned int TWRK=0;			// work *dont change
unsigned char VOLUME=0;		// volume(00-f0)
unsigned char beeptime=0;


//---------------------------------------------------------------------------
//TEhĐ
// hzFg[Hz]
// timeFĐ[100msP]BƂ10Ȃ1bԍĐ܂B
void beep_set(unsigned int hz,unsigned char t)
{
	FREQW = ((unsigned long)hz * 15750L)>> (16-5);
	VOLUME = 0xc0;
	beeptime = t * 6;
}

void beep_ctrl(void)
{
	if(beeptime==0)return;

	beeptime--;
	if(beeptime==0){
		FREQW = 0;
		VOLUME = 0;
	}
}

PROGMEM char wave_table[]={
  35, 35, 35, 35, 35, 35, 35, 35,-40,-40,-40,-40,-40,-40,-40,-40,
 -40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40
};

//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]

void wave_driver(void)
{
	char stotal;

	TWRK += FREQW;	//gʑZ

	//U擾    [gʑ 5bit(0-31)]
	stotal = (char)pgm_read_byte(&wave_table[TWRK >> (16-5)]);

#if F_CPU==8000000
//		stotal = ((stotal * VOLUME) >> 8);
		stotal = (stotal * VOLUME) / 256;
#else
		stotal = ((stotal * VOLUME) >> 6);
#endif
	stotal += ((F_CPU / FREQ_H)/2);		// TOPl̔

		// vZʂ̏bitZ
	OCR1B = (unsigned int)stotal;		//Output Compare Register B
}

