/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view.action;

import netjfwatcher.engine.model.action.ActionBuilderNodeTree;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeView;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionShowNodeSnmpView;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.portscan.actions.ActionBuilderPortScanOperationEditor;
import netjfwatcher.portscan.actions.ActionBuilderPortScanOperationEditor.ActionPortScanEditor;

import org.eclipse.jface.action.IMenuManager;

public class MenuActionControl extends AbstractMenuActionControl {

	private ActionBuilderPortScanOperationEditor portScaneditorAction = new ActionBuilderPortScanOperationEditor();

	private MenuActionControl() {

	}

	protected void createToolBarList(ActionBuilderNodeTree actionNodeTree) {

		menuActionList.add(actionNodeTree.actionReloadNodeTreeDatabase());
		menuActionList.add(actionNodeTree.actionSortNodeTreeDatabase());
		menuActionList.add(actionBuilderNodeOperation.getActionNodeOperation());
		menuActionList.add(portScaneditorAction.getActionPortScanEditor());
		menuActionList.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	protected void setNodeInfoMenuList(IMenuManager manager,
			NodeInformation targetNodeInfo) {
		/* m[h\`j[ǉ */
		((ActionShowNodeView) actionBuilderNodeOperation
				.getActionShowNodeView()).setNodeInfo(targetNodeInfo);
		/* m[hAlarmj[ǉ */
		((ActionOpenEditorPartPersonalNodeAlarm) actinAlarm
				.getActionOpenEditorPartPersonalNodeAlarm())
				.setNodeInfo(targetNodeInfo);
		/* m[hSNMP\j[ǉ */
		((ActionShowNodeSnmpView) snmpAction.getActionSnmpInfo())
				.setNodeInfo(targetNodeInfo);
		/* m[hǉEҏWE폜j[ǉ */
		((ActionNodeOperation) actionBuilderNodeOperation
				.getActionNodeOperation()).setNodeInfo(targetNodeInfo);
		/* Port Scan Editorj[ǉ */
		((ActionPortScanEditor) portScaneditorAction.getActionPortScanEditor())
				.setNodeInfo(targetNodeInfo);
	}

	protected void setNodeMenuList(IMenuManager manager) {
		manager.add(actionBuilderNodeOperation.getActionShowNodeView());
		manager.add(actinAlarm.getActionOpenEditorPartPersonalNodeAlarm());
		manager.add(snmpAction.getActionSnmpInfo());
		manager.add(actionBuilderNodeOperation.getActionNodeOperation());
		manager.add(portScaneditorAction.getActionPortScanEditor());
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static MenuActionControl getInstance() {
		return SingletonAboutMessage.INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonAboutMessage {
		static final MenuActionControl INSTANCE = new MenuActionControl();
	}
}
