/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view.action;

import java.util.ArrayList;

import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNodeDetect;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeTree;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeView;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionShowNodeSnmpView;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionSnmpStatisticsSet;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

public abstract class AbstractMenuActionControl {

	protected ArrayList menuActionList = new ArrayList();

	/* SNMPv\j[ */
	protected NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();

	/* Pingf[^\j[ */
	protected NodePingMenu nodePingMenu = new NodePingMenu();

	/* A[ɊւANV */
	protected ActionBuilderAlarmList actinAlarm = new ActionBuilderAlarmList();

	/* m[hSnmp֘ÃANV */
	protected ActionBuilderSnmp snmpAction = new ActionBuilderSnmp();

	/* Ot\ɊւANV */
	protected ActionBuilderChart nodeChart = new ActionBuilderChart();

	/* Editor PartɊւANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/* m[hɊւANV */
	protected ActionBuilderNodeOperation actionBuilderNodeOperation = new ActionBuilderNodeOperation();

	/* m[hoɊւANV */
	protected ActionBuilderNodeDetect actionBuilderNodeDetect = new ActionBuilderNodeDetect();

	public AbstractMenuActionControl() {

	}

	public void setToolBarActions(IToolBarManager toolBarManager,
			ActionBuilderNodeTree actionNodeTree) {
		menuActionList.clear();
		createToolBarList(actionNodeTree);
		for (int i = 0; i < menuActionList.size(); i++) {
			toolBarManager.add((IAction) menuActionList.get(i));
		}
	}

	protected void createToolBarList(ActionBuilderNodeTree actionNodeTree) {

		menuActionList.add(actionNodeTree.actionReloadNodeTreeDatabase());
		menuActionList.add(actionNodeTree.actionSortNodeTreeDatabase());
		menuActionList.add(actionBuilderNodeOperation.getActionNodeOperation());
		menuActionList.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	public void setContextMenu(TreeViewer nodeListTreeViewer,
			ActionBuilderNodeTree actionNodeTree, IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(actionNodeTree.actionReloadNodeTreeDatabase());

		/* m[hTree\[g */
		manager.add(actionNodeTree.actionSortNodeTreeDatabase());

		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (nodeListTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = nodeListTreeViewer.getTree().getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
						/* GroupI */
						nodeListTreeViewer.getTree().deselectAll();
					} else if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
						NodeInformation targetNodeInfo = ((NodeTree) treeItem[nodeTreeSelectNo]
								.getData()).getNodeInfo();

						setNodeMenu(manager, targetNodeInfo);
					} else {
						/* Groupłm[hłȂ */
						nodeListTreeViewer.getTree().deselectAll();
					}
				}
			} else {
				/* TreeI */
				manager
						.add(actionBuilderNodeOperation
								.getActionNodeOperation());
			}
		}

		/* SNMPvr[\ */
		manager.add(snmpAction.getActionSnmpStatistics());

		/* Sm[hAlarmr[\ */
		manager.add(actinAlarm.getActionShowAllNodeAlarmListTable());
		/* m[hor[\ */
		manager.add(actionBuilderNodeDetect.getActionNodeDetectView());
	}

	protected void setNodeMenu(IMenuManager manager,
			NodeInformation targetNodeInfo) {

		setNodeInfoMenuList(manager, targetNodeInfo);

		setNodeMenuList(manager);
		/*
		 * m[hPingf[^j[j[}l[W ǉ
		 */
		nodePingMenu.createPingMenu(manager, targetNodeInfo, false);

		/*
		 * m[hSnmpv\j[j[}l[W ɒǉ
		 */
		nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager,
				targetNodeInfo, false);

		/*
		 * m[hSnmpvZbgj[j[}l[W ɒǉ
		 */
		((ActionSnmpStatisticsSet) snmpAction.getActionSnmpStatisticsSet())
				.setNodeInfo(targetNodeInfo);
		manager.add(snmpAction.getActionSnmpStatisticsSet());
	}

	protected void setNodeInfoMenuList(IMenuManager manager,
			NodeInformation targetNodeInfo) {
		/* m[h\`j[ǉ */
		((ActionShowNodeView) actionBuilderNodeOperation
				.getActionShowNodeView()).setNodeInfo(targetNodeInfo);
		/* m[hAlarmj[ǉ */
		((ActionOpenEditorPartPersonalNodeAlarm) actinAlarm
				.getActionOpenEditorPartPersonalNodeAlarm())
				.setNodeInfo(targetNodeInfo);
		/* m[hSNMP\j[ǉ */
		((ActionShowNodeSnmpView) snmpAction.getActionSnmpInfo())
				.setNodeInfo(targetNodeInfo);
		/* m[hǉEҏWE폜j[ǉ */
		((ActionNodeOperation) actionBuilderNodeOperation
				.getActionNodeOperation()).setNodeInfo(targetNodeInfo);
	}

	protected void setNodeMenuList(IMenuManager manager) {
		manager.add(actionBuilderNodeOperation.getActionShowNodeView());
		manager.add(actinAlarm.getActionOpenEditorPartPersonalNodeAlarm());
		manager.add(snmpAction.getActionSnmpInfo());
		manager.add(actionBuilderNodeOperation.getActionNodeOperation());
	}

}
