/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.view;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.portscan.preference.PortInfo;
import netjfwatcher.portscan.preference.PortScanDefineConfig;
import netjfwatcher.portscan.thread.PortScanBaseList;
import netjfwatcher.portscan.thread.info.PortScanNode;
import netjfwatcher.portscan.thread.info.PortScanNodeList;
import netjfwatcher.portscan.thread.info.PortScanNodePort;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

/**
 * Port Scan𐧌䂷ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PortScanEditorView extends AbstractEditorNodeView {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = "Port Scan";

	public static final String TCP_DISCRIPTION = "tcp";

	private static final String PORT_SCAN_INITIAL_PERIOD = "300";

	private static final int LIMIT_PERIOD = 30;

	private static final int TCP_TIMEOUT = 3000;

	private static final int UDP_TIMEOUT = 3000;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 400 };

	private static final int TEXT_WIDTH = 100;

	/* List widthhint */
	private static final int PORT_LIST_WIDTHHINT = 300;

	/* List verticalSpan */
	private static final int PORT_LIST_VERTIALSPAN = 7;

	private static final int ADDRESS_LIST_VERTIALSPAN = 4;

	/* List ItemHeight */
	private static final int PORT_LIST_ITEMHEIGHT = 15;

	private static final int ADDRESS_LIST_ITEMHEIGHT = 8;

	private static final String PATTERN_SPACE_SPLIT = "[ \t]"; // 󔒂܂̓^u

	private static final String SPACE = " ";

	private NodeInformation targetNodeInfo;

	private List addressList;

	private List portList;

	private List checkPortList;

	private HashMap checkPortMap = new HashMap();

	private String selectPortDisc;

	private String selectCheckPortDisc;

	/* Display */
	private Display display;

	/* Logging */
	private static Logger logger;

	private Button portScanSartButton;

	private Button portScanStopButton;

	private Button setAlarmButton;

	private Text ipAddressText;

	private Text scanPeriodText;

	private Button portAddButton;

	private Button portDeleteButton;

	/* eLXg\BackGroundFi[ */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public PortScanEditorView() {
		logger = Logger.getLogger(this.getClass().getName());
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(3, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		addressList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);

		GridData data0 = new GridData();
		data0.horizontalSpan = 1;
		data0.verticalSpan = ADDRESS_LIST_VERTIALSPAN;
		data0.widthHint = PORT_LIST_WIDTHHINT;
		data0.heightHint = addressList.getItemHeight()
				* ADDRESS_LIST_ITEMHEIGHT;
		addressList.setLayoutData(data0);

		portScanSartButton = new Button(composite1, SWT.NONE);
		portScanSartButton.setText("Start");

		portScanStopButton = new Button(composite1, SWT.NONE);
		portScanStopButton.setText("Stop");

		setAlarmButton = new Button(composite1, SWT.CHECK);
		setAlarmButton.setText("Set Alarm");

		/* Dummy column */
		Label label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("IP Address");
		label.setLayoutData(new GridData());
		ipAddressText = new Text(composite1, SWT.BORDER);
		ipAddressText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		ipAddressText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Period(Sec)");
		label.setLayoutData(new GridData());
		scanPeriodText = new Text(composite1, SWT.BORDER | SWT.RIGHT);
		scanPeriodText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		scanPeriodText.setLayoutData(gridData);

		GridLayout gridLayout2 = new GridLayout(3, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		GridLayout gridLayout3 = new GridLayout(1, false);
		Composite composite3 = new Composite(composite2, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		label = new Label(composite3, SWT.NONE);
		label.setText("Port List");
		label.setLayoutData(new GridData());

		portList = new List(composite3, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL
				| SWT.H_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = PORT_LIST_VERTIALSPAN;
		data.widthHint = PORT_LIST_WIDTHHINT;
		data.heightHint = portList.getItemHeight() * PORT_LIST_ITEMHEIGHT;
		portList.setLayoutData(data);

		GridLayout gridLayout4 = new GridLayout(1, false);
		Composite composite4 = new Composite(composite2, SWT.NONE);
		composite4.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite4.setLayout(gridLayout4);

		portAddButton = new Button(composite4, SWT.NONE);
		portAddButton.setText(">>");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		portAddButton.setLayoutData(gridData);

		portDeleteButton = new Button(composite4, SWT.NONE);
		portDeleteButton.setText("<<");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		portDeleteButton.setLayoutData(gridData);

		GridLayout gridLayout5 = new GridLayout(1, false);
		Composite composite5 = new Composite(composite2, SWT.NONE);
		composite5.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite5.setLayout(gridLayout5);

		label = new Label(composite5, SWT.NONE);
		label.setText("Check Port List");
		label.setLayoutData(new GridData());

		GridData data2 = new GridData(GridData.FILL_BOTH);
		checkPortList = new List(composite5, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);

		data2.horizontalSpan = 1;
		data2.verticalSpan = PORT_LIST_VERTIALSPAN;
		data2.widthHint = PORT_LIST_WIDTHHINT;
		data2.heightHint = checkPortList.getItemHeight() * PORT_LIST_ITEMHEIGHT;

		checkPortList.setLayoutData(data2);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		scanPeriodText.setText(PORT_SCAN_INITIAL_PERIOD);

		setAlarmButton.setSelection(true);
		setPortList();
		setAddressList();

		if (targetNodeInfo == null) {
			ipAddressText.setText("");
		} else {
			ipAddressText.setText(targetNodeInfo.getIpaddress());
			selectAddress(targetNodeInfo.getIpaddress());
		}

		setListener();

	}

	private void setListener() {
		portAddButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				portAddButton.setEnabled(false);

				int period = 0;
				try {
					period = Integer.parseInt(scanPeriodText.getText());
				} catch (NumberFormatException e) {

					MessageDialog.openError(getEditorSite().getShell(),
							"Input error", e.getMessage() + " Input error.");
					scanPeriodText.setFocus();
					return;
				}
				if (period < LIMIT_PERIOD) {
					MessageDialog.openError(getSite().getShell(),
							"Input error", "Please scan period >= 60sec.");
					scanPeriodText.setFocus();
					return;
				}

				try {
					String[] portItem = splitPortString(selectPortDisc);
					if (!checkPortMap.containsKey(portItem[0])) {
						checkPortList.add(selectPortDisc);

						String periodString = scanPeriodText.getText();
						checkPortMap.put(portItem[0], periodString);
						portScanSartButton.setEnabled(true);
						portScanStopButton.setEnabled(true);
					}
				} finally {
					portAddButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		portDeleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				portDeleteButton.setEnabled(false);

				try {
					if (checkPortList.getSelectionCount() > 0) {
						String[] portItem = splitPortString(selectCheckPortDisc);
						checkPortList.remove(selectCheckPortDisc);
						checkPortMap.remove(portItem[0]);
					}
					portScanSartButton.setEnabled(true);
					portScanStopButton.setEnabled(true);

				} finally {
					portDeleteButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		portList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = portList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				if (portList.getItemCount() > 0) {
					selectPortDisc = portList.getItem(index);
				}

			}
		});
		checkPortList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				if (checkPortList.getItemCount() == 0) {
					return;
				}
				int index = checkPortList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				selectCheckPortDisc = checkPortList.getItem(index);
				String[] portItem = splitPortString(selectCheckPortDisc);
				String period = (String) checkPortMap.get(portItem[0]);
				if (period != null) {
					scanPeriodText.setText(period);
				}
			}
		});

		portScanSartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				if (setAlarmButton.getSelection()) {
					if (!DatabaseControl.getInstance().isDatabaseStart()) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"Not running Database.");
						setAlarmButton.setSelection(false);
					}
				}

				PortScanBaseList.getInstance().removePortScanNodeBaseList(
						ipAddressText.getText());
				startPortScan(setAlarmButton.getSelection());
				checkPortList.removeAll();
				checkPortMap.clear();
				setAddressList();
				portScanSartButton.setEnabled(true);
				portScanStopButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		portScanStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				PortScanBaseList.getInstance().removePortScanNodeBaseList(
						ipAddressText.getText());
				checkPortList.removeAll();
				checkPortMap.clear();
				setAddressList();
				portScanSartButton.setEnabled(true);
				portScanStopButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		addressList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				if (addressList.getItemCount() == 0) {
					return;
				}
				int index = addressList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				String selectAddress = addressList.getItem(index);
				if (selectAddress != null && !selectAddress.equals("")) {
					ipAddressText.setText(selectAddress);
					selectAddress(selectAddress);
				}
			}
		});
	}

	private void setAddressList() {
		addressList.removeAll();
		Iterator it = null;
		Map baseList = PortScanBaseList.getInstance().getPortScanBaseList();
		for (it = baseList.keySet().iterator(); it.hasNext();) {
			String ipAddressKey = (String) it.next();
			addressList.add(ipAddressKey);
			portScanSartButton.setEnabled(true);
			portScanStopButton.setEnabled(true);
		}
	}

	/*
	 * w̃m[hAhX̃|[gXLXgɕ\܂B
	 * 
	 * @param selectAddress m[hAhX
	 */
	private void selectAddress(String selectAddress) {
		checkPortMap.clear();
		checkPortList.removeAll();

		Map baseList = PortScanBaseList.getInstance().getPortScanBaseList();

		PortScanNodeList portScanNodeList = (PortScanNodeList) baseList
				.get(selectAddress);

		if (portScanNodeList == null) {
			return;
		}

		PortScanNode portScanNode = portScanNodeList
				.popPortScanNodeInfo(selectAddress);

		if (portScanNode == null) {
			return;
		}

		Map nodePortList = portScanNode.getPortScanNodePortList();
		if (nodePortList == null) {
			return;
		}
		Iterator iterator = null;
		for (iterator = nodePortList.keySet().iterator(); iterator.hasNext();) {
			String portKey = (String) iterator.next();
			PortScanNodePort portScanNodePort = (PortScanNodePort) nodePortList
					.get(portKey);

			if (portScanNodePort == null) {
				continue;
			}

			Map portMap = PortScanDefineConfig.getInstance()
					.getResourceFileParse().getPortInfoHashMap();
			PortInfo portInfo = (PortInfo) portMap.get(portKey);
			checkPortList.add(portKey + SPACE + portInfo.getPortDiscription());

			String periodString = Integer
					.toString(portScanNodePort.getPeriod());
			checkPortMap.put(portKey, periodString);

		}

	}

	/*
	 * Text\̃m[hAhXAXLyуXg\̃|[gɑ΂Ă |[gXLZbg܂B
	 * 
	 */
	private void startPortScan(boolean isSetAlarm) {

		String ipAddress = ipAddressText.getText();
		if ((ipAddress == null) || ipAddress.equals("")) {
			MessageDialog.openError(getEditorSite().getShell(), "Error",
					"Illegal IP Address");
			ipAddressText.setFocus();

			return;
		}
		try {
			InetAddress host = InetAddress.getByName(ipAddress);
			ipAddress = host.getHostAddress();
		} catch (UnknownHostException e2) {
			MessageDialog.openError(getEditorSite().getShell(), "Error",
					"UnknownHostException" + " IP Address = " + ipAddress);
			ipAddressText.setFocus();

			return;
		}

		Iterator it = null;
		for (it = checkPortMap.keySet().iterator(); it.hasNext();) {
			String portInfo = (String) it.next();
			if (portInfo == null) {
				break;
			}
			String period = (String) checkPortMap.get(portInfo);
			String[] portInfoItem = splitPortKindString(portInfo);
			if (portInfoItem != null && portInfoItem.length >= 2) {

				setPortScanInfo(ipAddress, period, portInfoItem[0],
						portInfoItem[1], isSetAlarm);
			}

		}

	}

	/*
	 * w̃m[hAhX̃|[gXLThread䃊XgɃZbg܂B
	 * 
	 * @param ipAddress m[hAhX @param period Ď @param portNo |[gԍ @param
	 * portKind |[g
	 */
	private void setPortScanInfo(String ipAddress, String period,
			String portNo, String portKind, boolean isSetAlarm) {

		String portKey = portNo + "/" + portKind;
		PortScanNodeList nodeList;
		if (PortScanBaseList.getInstance().getPortScanNodeBaseList(ipAddress) != null) {
			nodeList = PortScanBaseList.getInstance().getPortScanNodeBaseList(
					ipAddress);
		} else {
			nodeList = new PortScanNodeList();
		}
		PortScanNode portScanNode;
		if (nodeList.popPortScanNodeInfo(ipAddress) != null) {
			portScanNode = nodeList.popPortScanNodeInfo(ipAddress);
		} else {
			portScanNode = new PortScanNode();
		}

		PortScanNodePort portScanNodePort;

		if (portScanNode.popPortScanNodePortInfo(portKey) != null) {
			portScanNodePort = portScanNode.popPortScanNodePortInfo(portKey);
		} else {
			portScanNodePort = new PortScanNodePort();

		}

		portScanNodePort.setIpAddress(ipAddress);
		portScanNodePort.setCountPeriod(Integer.parseInt(period));
		portScanNodePort.setPeriod(Integer.parseInt(period));
		portScanNodePort.setPortKind(portKind);

		portScanNodePort.setStartDate(Calendar.getInstance().getTime());
		if (portKind.equals(TCP_DISCRIPTION)) {
			portScanNodePort.setTimeOut(TCP_TIMEOUT);
		} else {
			portScanNodePort.setTimeOut(UDP_TIMEOUT);
		}
		portScanNodePort.setPort(Integer.parseInt(portNo));
		portScanNodePort.setSetAlarm(isSetAlarm);
		portScanNode.putPortScanNodePortInfo(portKey, portScanNodePort);
		nodeList.putPortScanNodeInfo(ipAddress, portScanNode);
		PortScanBaseList.getInstance().setPortScanNodeBaseList(ipAddress,
				nodeList);

	}

	/*
	 * |[gԍALq擾܂B
	 */
	private String[] splitPortString(String str) {

		Pattern pattern;
		String[] item;

		pattern = Pattern.compile(PATTERN_SPACE_SPLIT);
		item = pattern.split(str, 2);

		return item;

	}

	/*
	 * |[gʏ擾܂B
	 * 
	 */
	private String[] splitPortKindString(String str) {

		Pattern pattern;
		String[] item;

		pattern = Pattern.compile("/");
		item = pattern.split(str, 2);

		return item;

	}

	private void setPortList() {
		Map portMap = PortScanDefineConfig.getInstance().getResourceFileParse()
				.getPortInfoHashMap();
		for (Iterator it = portMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			PortInfo portInfo = (PortInfo) portMap.get(key);
			portList.add(key + SPACE + portInfo.getPortDiscription());
		}

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/*
		 * InterfaceԂɍ킹ĕFZbgpColorIuWFNg CX^Xj
		 */
		if (textBackColor != null) {
			textBackColor.dispose();
		}

	}

}
