/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.preference;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.portscan.plugin.NetJFWatcherPortSacnPlugin;

import org.osgi.framework.Bundle;


/**
 * |[g`t@C̉͂sNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PortScanConfigFileParse {
    /* Logging */
    private static Logger logger = null;
    private Map portInfoHashMap;

    /**
     *
     * ŏɎwfBNgt@C͂邩GW
     * \[X擾܂B
     * wfBNg擾łȂꍇ́AGW
     * \[X擾܂B
     *
     * @throws Exception \[X͂ňُ킪ꍇ
     */
    public PortScanConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        portInfoHashMap = Collections.synchronizedMap(new LinkedHashMap());

        URL url = getDocument(Preference.PORT_DEFINE_FILE);

        if (url != null) {
            parse(url);
        }
    }

    /*
     * t@CE͂URLԂ܂B
     *
     * @param filePath t@CpX
     * @return url URL
     */
    private URL getDocument(String filePath) {
        URL url = null;

        Bundle bundle = NetJFWatcherPortSacnPlugin.getInstance().getBundle();

        // this.getClass().getClassLoader().getResource(filePath);
        url = bundle.getEntry(filePath);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe("Not found file url : " + filePath);

            return null;
        }

        return url;
    }

    public void parse(URL url) {
        logger = Logger.getLogger(this.getClass().getName());

        logger.info("file : " + url.getFile());

        InputStream is = null;

        try {
            is = url.openStream();
        } catch (IOException e3) {
            e3.printStackTrace();
            return;
        }

        BufferedReader buffReader = null;

        try {
            InputStreamReader ti = new InputStreamReader(is);
            buffReader = new BufferedReader(ti);

            String str;
            Pattern pattern;
            String[] item;

            while ((str = buffReader.readLine()) != null) {
                pattern = Pattern.compile("[ \t]"); // 󔒂܂̓^u
                item = pattern.split(str, 2);

                if (item.length >= 2) {
                    PortInfo portInfo = new PortInfo();
                    portInfo.setPortNo(item[0]);
                    portInfo.setPortDiscription(item[1]);
                    portInfoHashMap.put(item[0], portInfo);
                }
            }
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }

            if (is != null) {
                try {
                    is.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public Map getPortInfoHashMap() {
        return portInfoHashMap;
    }
}
