/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.plugin;

import netjfwatcher.portscan.thread.PortScanThreadManage;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetJFWatcherPortSacnPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static NetJFWatcherPortSacnPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public NetJFWatcherPortSacnPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
		PortScanThreadManage manager = new PortScanThreadManage();
		manager.startThread();
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

    /**
     * UIPluginCX^XԂ܂B
     *
     * @return instance NetWatchRCPJettyPlugin
     */
    public static NetJFWatcherPortSacnPlugin getInstance() {
        return plugin;
    }
    
	/**
	 * Returns the shared instance.
	 */
	public static NetJFWatcherPortSacnPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("NetWatcherRCPPortScan", path);
	}
}
