/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.actions;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class PortScanUDPConnectionThread implements Runnable {

	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	private DatagramSocket socket = null;

	private String portScanAddress;

	private int scanPort;

	private int timeOut;

	/* MO */
	private static Logger logger = null;

	public PortScanUDPConnectionThread() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void startUDPPortScan(String portScanAddress, int scanPort,
			int timeOut) {
		this.portScanAddress = portScanAddress;
		this.scanPort = scanPort;
		this.timeOut = timeOut;

		Thread portScanThread = new Thread(this);
		portScanThread.start();
	}

	public void run() {

		try {

			InetAddress dstInetAddr = InetAddress.getByName(portScanAddress);

			byte [] test = new byte[0];
			java.net.DatagramPacket packet = new java.net.DatagramPacket(test, 0);
			socket = new DatagramSocket();
			socket.setSoTimeout(timeOut);
			socket.connect(dstInetAddr, scanPort);
			socket.send(packet);
			
			while (true) {
				logger.info("getRemoteSocketAddress : " + socket.getRemoteSocketAddress());
				if (socket.isConnected()) {
					logger.info("Check " + "address=" + portScanAddress + " udp port=" + scanPort + " timeout=" + timeOut);
					break;
				}
				try {
					Thread.sleep(WAIT_SLEEP_TIME);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		} catch (UnknownHostException ex) {
			logger.warning("UnknownHostException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);

		} catch (ConnectException ex) {
			logger.warning("ConnectException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);
		} catch (IOException ex) {
			logger.warning("IOException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);
			ex.printStackTrace();
		} finally {

			if (socket != null) {
				socket.close();

			}

		}

	}

	/**
	 * finalI[o[Ch܂B
	 * 
	 */
	protected void finalize() throws java.lang.Throwable {
		close();
		super.finalize();
	}

	/*
	 * \[XN[Y܂B
	 * 
	 */
	private void close() {

		if (socket != null) {

			socket.close();

		}
	}

}
