/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.actions;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.portscan.thread.PortScanBaseList;
import netjfwatcher.portscan.thread.info.PortScanNode;
import netjfwatcher.portscan.thread.info.PortScanNodeList;
import netjfwatcher.portscan.thread.info.PortScanNodePort;

public class PortScanTCPConnectionThread implements Runnable {

	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 1000;

	private Socket socket = null;

	private PortScanNodePort portScanNodePort;

	private String portScanAddress;

	private boolean isSetAlarm;

	private int scanPort;

	private int timeOut;

	/* MO */
	private static Logger logger = null;

	public PortScanTCPConnectionThread() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	public void startTCPPortScan(PortScanNodePort portScanNodePort,
			String portScanAddress, int scanPort, int timeOut) {
		this.portScanNodePort = portScanNodePort;
		this.portScanAddress = portScanAddress;
		this.scanPort = scanPort;
		this.timeOut = timeOut;

		isSetAlarm = portScanNodePort.isSetAlarm();
		Thread portScanThread = new Thread(this);
		portScanThread.start();
	}

	public void run() {
		PortScanNodePort portScanNodePort2 = null;
		try {

			Map baseList = PortScanBaseList.getInstance().getPortScanBaseList();

			PortScanNodeList portScanNodeList = (PortScanNodeList) baseList
					.get(portScanAddress);

			PortScanNode portScanNode = portScanNodeList
					.popPortScanNodeInfo(portScanAddress);

			Map nodePortList = portScanNode.getPortScanNodePortList();
			portScanNodePort2 = (PortScanNodePort) nodePortList
					.get(portScanNodePort.getPort() + "/"
							+ portScanNodePort.getPortKind());

			if (portScanNodePort2 != null) {
				int checkCount = portScanNodePort.getCheckCount();
				portScanNodePort2.setCheckCount(++checkCount);
				portScanNodePort2
						.setCheckDate(Calendar.getInstance().getTime());
			}

			InetAddress dstInetAddr = InetAddress.getByName(portScanAddress);

			socket = new Socket(dstInetAddr, scanPort);
			socket.setSoTimeout(timeOut);
			while (true) {
				if (socket.isConnected()) {
					logger.info("Check " + "address=" + portScanAddress
							+ " tcp port=" + scanPort + " timeout=" + timeOut);
					break;
				}
				try {
					Thread.sleep(WAIT_SLEEP_TIME);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
			if (isSetAlarm) {
				/*
				 * O񂪈ُō񐳏ŏQ ł邩`FbN
				 */
				if (AlarmRecovery.getInstance().isOccurredAlarmId(
						portScanAddress, AlarmMessageResource.PORT_SCAN_NG)) {
					/* Port ScanQZbg */
					AlarmMessageMake messageMake = AlarmMessageMake
							.getInstance();
					String message = portScanAddress + " Port=" + scanPort;
					messageMake.setRecoveryPortScanError(portScanAddress,
							message);
				}
			}
		} catch (UnknownHostException ex) {
			setNGCount(portScanNodePort2);
			logger.warning("UnknownHostException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);

		} catch (ConnectException ex) {
			setNGCount(portScanNodePort2);
			logger.warning("ConnectException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);

		} catch (IOException ex) {
			setNGCount(portScanNodePort2);
			logger.warning("IOException : " + ex.getMessage()
					+ " Port scan address=" + portScanAddress + " Port="
					+ scanPort);

		} finally {

			if (socket != null) {
				try {
					socket.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}

		}

	}

	private void setNGCount(PortScanNodePort portScanNodePort) {
		if (portScanNodePort != null) {
			int ngCount = portScanNodePort.getNgCount();
			portScanNodePort.setNgCount(++ngCount);
		}

		if (isSetAlarm) {
			AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
					.getInstance();
			String message = portScanAddress + " Port=" + scanPort;
			alarmMessageMakeInstance.setPortScanError(portScanAddress, message);

		}

	}

	/**
	 * finalI[o[Ch܂B
	 * 
	 */
	protected void finalize() throws java.lang.Throwable {
		close();
		super.finalize();
	}

	/*
	 * \[XN[Y܂B
	 * 
	 */
	private void close() {

		if (socket != null) {
			try {
				socket.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
	}

}
