/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.actions;

import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.portscan.view.PortScanEditorView;
import netjfwatcher.portscan.view.PortScanManagerPerspective;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Our sample action implements workbench action delegate.
 * The action proxy will be created by the workbench and
 * shown in the UI. When the user tries to use the action,
 * this delegate will be created and execution will be 
 * delegated to it.
 * @see IWorkbenchWindowActionDelegate
 */
public class PortScanAction implements IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow window;
	/**
	 * The constructor.
	 */
	public PortScanAction() {
	}

	/**
	 * The action has been activated. The argument of the
	 * method represents the 'real' action sitting
	 * in the workbench UI.
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		IWorkbench workbench = PlatformUI.getWorkbench();
		try {
			workbench.openWorkbenchWindow(PortScanManagerPerspective.ID,
					null);

		} catch (Exception e) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error",
					"Abort Port scan.");
			
			shell.dispose();
		}
		
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart portScanEditor = ActionBuilderPortScanOperationEditor.getPortScanEditor();
        if (portScanEditor != null) {
            activePage.closeEditor(portScanEditor, false);
            portScanEditor = null;
        }
        try {
        	portScanEditor = activePage.openEditor(
                new EditorInputNodeView(PortScanEditorView.TITLE_SUFFIX, null, false), PortScanEditorView.class.getName(), true);
        } catch (PartInitException e) {
            e.printStackTrace();
        }
        ActionBuilderPortScanOperationEditor.setPortScanEditor(portScanEditor);
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}