/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.portscan.actions;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.portscan.thread.PortScanBaseList;
import netjfwatcher.portscan.thread.info.PortScanNode;
import netjfwatcher.portscan.thread.info.PortScanNodeList;
import netjfwatcher.portscan.thread.info.PortScanNodePort;
import netjfwatcher.portscan.view.PortScanTableViewLabelProvider;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;

public class ActionBuilderPortScanTable {
	/** Timer~R[h */
	public static final int TIMER_STOP = -1;

	/* MO */
	private static Logger logger;

	private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private Display display;

	private final TableViewer viewer;

	private final Table portScanTable;

	/* Xe[^XC}l[W */
	private final SubStatusLineManager statusLineManager;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private final IAction refreshPortScanTableAction = new ActionRefreshPortScanTable();

	public ActionBuilderPortScanTable(final Display display,
			final TableViewer viewer, final Table table,
			final SubStatusLineManager statusLineManager) {
		logger = Logger.getLogger(this.getClass().getName());
		this.display = display;
		this.viewer = viewer;
		this.portScanTable = table;
		this.statusLineManager = statusLineManager;
	}

	public IAction getActionRefreshPortScanTable() {
		return refreshPortScanTableAction;
	}

	private abstract class AbstractPortScanTableAction extends Action {

		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	private final class ActionRefreshPortScanTable extends
			AbstractPortScanTableAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		public String getText() {
			return "Refresh port scan table";
		}

		public String getToolTipText() {
			return "Refresh port scan table";
		}

		protected void doTask() {

			setPortScanTable();
		}
	}

	public void setPortScanTable() {
		/* e[ȗSč폜ătbV */
		portScanTable.removeAll();
		viewer.refresh();

		long count = 0;
		Iterator it = null;
		Map baseList = PortScanBaseList.getInstance().getPortScanBaseList();
		for (it = baseList.keySet().iterator(); it.hasNext();) {
			String ipAddressKey = (String) it.next();
			PortScanNodeList portScanNodeList = (PortScanNodeList) baseList
					.get(ipAddressKey);

			if (portScanNodeList == null) {
				continue;
			}

			PortScanNode portScanNode = portScanNodeList
					.popPortScanNodeInfo(ipAddressKey);

			if (portScanNode == null) {
				continue;
			}

			Map nodePortList = portScanNode.getPortScanNodePortList();
			if (nodePortList == null) {
				continue;
			}
			Iterator it2 = null;
			for (it2 = nodePortList.keySet().iterator(); it2.hasNext();) {
				String portKey = (String) it2.next();
				PortScanNodePort portScanNodePort = (PortScanNodePort) nodePortList
						.get(portKey);

				if (portScanNodePort == null) {
					continue;
				}
				String[] portScanTableCellArray = new String[PortScanTableViewLabelProvider.PORT_SCAN_TABLE_ARRAY_COUNT];
				NodeInformation nodeInfo = getNodeList(false, portScanNodePort
						.getIpAddress());
				if (nodeInfo != null) {
					portScanTableCellArray[PortScanTableViewLabelProvider.NODE_NAME] = nodeInfo
							.getNodename();
					portScanTableCellArray[PortScanTableViewLabelProvider.GROUP] = nodeInfo
							.getGroup();
				} else {
					portScanTableCellArray[PortScanTableViewLabelProvider.NODE_NAME] = "";
					portScanTableCellArray[PortScanTableViewLabelProvider.GROUP] = "";
				}

				Date startDate = portScanNodePort.getStartDate();
				Date checkDate = portScanNodePort.getCheckDate();
				count++;
				portScanTableCellArray[PortScanTableViewLabelProvider.NO] = Long
						.toString(count);
				portScanTableCellArray[PortScanTableViewLabelProvider.IP_ADDRESS] = portScanNodePort
						.getIpAddress();

				portScanTableCellArray[PortScanTableViewLabelProvider.PORT] = portScanNodePort
						.getPort()
						+ "/" + portScanNodePort.getPortKind();
				portScanTableCellArray[PortScanTableViewLabelProvider.PERIOD] = Integer
						.toString(portScanNodePort.getPeriod());
				if (startDate != null) {
					portScanTableCellArray[PortScanTableViewLabelProvider.START_DATE] = dateformat
							.format(startDate);
				} else {
					portScanTableCellArray[PortScanTableViewLabelProvider.START_DATE] = "";
				}
				if (checkDate != null) {
					portScanTableCellArray[PortScanTableViewLabelProvider.CHECK_DATE] = dateformat
							.format(checkDate);
				} else {
					portScanTableCellArray[PortScanTableViewLabelProvider.CHECK_DATE] = "";
				}
				portScanTableCellArray[PortScanTableViewLabelProvider.CHECK_COUNT] = Integer
						.toString(portScanNodePort.getCheckCount());
				portScanTableCellArray[PortScanTableViewLabelProvider.NG_COUNT] = Integer
						.toString(portScanNodePort.getNgCount());

				TableItem item = new TableItem(portScanTable, SWT.NULL);
				item.setText(portScanTableCellArray);
				item.setData(portScanTableCellArray);

			}
		}
	}

	private NodeInformation getNodeList(boolean isSocket, String ipAddress) {

		NodeInformation nodeInfo = null;
		try {
			if (!isSocket) {
				DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
						.getInstance();
				ArrayList nodeList = nodeRegisterDBTable.findTarget(ipAddress);
				if (nodeList != null && nodeList.size() > 0) {
					nodeInfo = (NodeInformation) nodeList.get(0);
				}
			} else {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeInfo = connectNodeInfo.getNodeInformation(ipAddress);
			}

		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		}

		return nodeInfo;
	}
}
