# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Comment.pm 65 2008-05-17 01:00:54Z nekotama $

package Nekorum::App::Comment;

use strict;

use MT;
use Nekorum::Util;

sub _post_comment {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);
	
	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $text = $app->param('topic_text') or return $app->errtrans("Invalid parameter");

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or retrun $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);

	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load({blog_id => $blog_id, id => $entry_id}) or return $app->errtrans("Load entry error.");

	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	if(!$permission->can_comment){
		return $app->errtrans("Permission denied.");
	}

	# save comment
	require MT::Comment;
	my $comment = MT::Comment->new;
	$comment->blog_id($blog_id);
	$comment->entry_id($entry_id);
	$comment->commenter_id($author_id);
	$comment->author($author->nickname);
	$comment->email($author->email);
	$comment->ip($app->remote_ip);
	$comment->text($text);
	$comment->visible(1);
	$comment->save or die $comment->errstr;
	
	# rebuild entry
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
}

sub _edit_comment {
	my $app = shift;
	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $comment_id = $app->param('comment_id') or return $app->errtrans("Invalid parameter");
	my $text = $app->param('topic_text');

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	if(!$permission->can_comment){
		return $app->errtrans("Permission denied.");
	}
	
	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load({id => $entry_id, blog_id => $blog_id});

	# save comment
	require MT::Comment;
	my $comment = MT::Comment->load({id => $comment_id, blog_id => $blog_id, entry_id => $entry_id});
	if($comment->commenter_id != $author_id){
		return $app->errtrans("Permission denied.");
	}
	$comment->text($text);
	$comment->modified_by($author_id);
	$comment->save or die $comment->errstr;
	
	# rebuild entry
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
}

sub _remove_comment {
	my $app = shift;

	return $app->errtrans("This system not use forum plugin.") if(!Nekorum::Util->is_forum_use);

	my $blog_id = $app->param('blog_id');
	my $entry_id = $app->param('entry_id') or return $app->errtrans("Invalid parameter");
	my $comment_id = $app->param('comment_id') or return $app->errtrans("Invalid parameter");

	my $type = $app->param('_type') || 'entry';
	my $class = $app->model($type) or retrun $app->errtrans("Invalid parameter");

	# author session
	my $author = Nekorum::Util->_get_author($app);
	return $app->errtrans("Session timeout.") unless($author);
	$app->{author} = $author;
	my $author_id = $author->id;

	# load blog
	require MT::Blog;
	my $blog = MT::Blog->load($blog_id);
	
	# load permission
	require MT::Permission;
	my $permission = MT::Permission->load({ blog_id => $blog_id, author_id => $author_id }) or $app->errtrans("Load permission error.");
	return $app->errtrans("Permission denied.") if(!$permission->can_comment);
	
	# load entry
	require MT::Entry;
	my $entry = MT::Entry->load({id => $entry_id, blog_id => $blog_id});

	# delete comment
	require MT::Comment;
	my $comment = MT::Comment->load({id => $comment_id, blog_id => $blog_id, entry_id => $entry_id});
	return $app->errtrans("Permission denied.") if($comment->commenter_id != $author_id && !$author->is_superuser);
	
	$comment->moderate;
	$comment->save or die $comment->errstr;
	$comment->remove if(!Nekorum::Util->is_remove_hold);
	$app->rebuild_entry(Entry => $entry, BuildDependencies => 1) or return $app->publish_error();
	$app->redirect($entry->permalink);
}

1;