# This program is distributed under the terms of the
# GNU General Public License, version 2.
#
# Nekorum is forum additional plugin for MTOS/MT4.1 later.
# Original Copyright (c) 2008 nekotama (http://nekotama.org/)
#
# $Id: Nekorum.pl 77 2008-05-17 06:29:42Z nekotama $

package MT::Plugin::Nekorum;

use strict;
use MT;

use base qw( MT::Plugin );
@MT::Plugin::Nekorum::ISA = qw(MT::Plugin);

use vars qw($PLUGIN_NAME $VERSION);
$PLUGIN_NAME = "Nekotama's forum plugin - Nekorum";
$VERSION = '0.7';

use MT::Template;

my $plugin = MT::Plugin::Nekorum->new({
  name  => $PLUGIN_NAME,
  version  => $VERSION,
  id => 'Nekorum',
  key => 'nekotama_forum',
  description  => "Nekorum is forum additional plugin for MTOS/MT4.1 later.",
  doc_link => 'http://blog.nekotama.org/contents/mt/plugin/nekorum.php',
  author_name  => 'nekotama',
  author_link  => 'http://blog.nekotama.org/',
  l10n_class  => 'Nekorum::L10N',
#  schema_version  => 0.01,
  object_classes  => [ 'Nekorum::Object', ],
  blog_config_template  => 'blog_config.tmpl',
  system_config_template  => 'system_config.tmpl',
  settings  => new MT::PluginSettings([
     ['default_plugin_use', { Default => 1, Scope => 'system'  }],
     ['blog_plugin_use', { Default => 0, Scope => 'blog'  }],
     ['blog_remove_hold', { Default => 1, Scope => 'blog'  }],
  ]),
});

MT->add_plugin($plugin);

sub instance { $plugin }

sub runner {
  my $class = shift;
  my $method = shift;

  eval "require $class;";
  if ($@) { die $@; $@ = undef; return 1; }
  my $method_ref = $class->can($method);
  return $method_ref->($plugin, @_) if $method_ref;
  die $plugin->translate("Failed to find [_1]::[_2]", $class, $method);
}

sub init_request {
  my $cb = shift;
  my ($app) = @_;
  return if $app->id eq 'wizard';

  if (($app->mode || '') =~ /^stylecatcher_/) {
    my $r = $plugin->registry;
    my $path = $app->static_path;
    if ($path !~ m!^https?://!) {
      $path = $app->base . $path;
    }
    $path .= '/' unless $path =~ m!/$!;
    $r->{stylecatcher_libraries}{nekorum_themes}{url} = $path . 'plugins/Nekorum/themes/nekorum.html';
  }
}

sub init_registry {
  my $plugin = shift;
  $plugin->registry({
    object_types  => {
    },
    callbacks  => {
      'MT::App::CMS::init_request' => \&init_request,
    },
    tags => {
      help_url => sub { MT->translate('http://blog.nekotama.org/contents/mt/plugin/tags/mt%t.php') },
      function => {
        'TinyMCE'  => 'Nekorum::Tags::TinyMCE::_print_script',
        'NekorumScriptPath'  => 'Nekorum::Tags::Function::NekorumScriptPath',
        'NekorumPostTopicPath'  => 'Nekorum::Tags::Function::NekorumPostTopicPath',
        'NekorumEditTopicPath'  => 'Nekorum::Tags::Function::NekorumEditTopicPath',
        'NekorumRemoveTopicPath'  => 'Nekorum::Tags::Function::NekorumRemoveTopicPath',
        'NekorumFreezeTopicPath'  => 'Nekorum::Tags::Function::NekorumFreezeTopicPath',
        'NekorumPostCommentPath'  => 'Nekorum::Tags::Function::NekorumPostCommentPath',
        'NekorumEditCommentPath'  => 'Nekorum::Tags::Function::NekorumEditCommentPath',
        'NekorumRemoveCommentPath'  => 'Nekorum::Tags::Function::NekorumRemoveCommentPath',
        'NekorumSigninPath'  => 'Nekorum::Tags::Function::NekorumSigninPath',
        'NekorumEditProfilePath'  => 'Nekorum::Tags::Function::NekorumEditProfilePath',
        'NekorumViewTemplatePath'  => 'Nekorum::Tags::Function::NekorumViewTemplatePath',
      },
      block => {
        'NekorumAuthorEntryBlock'  => 'Nekorum::Tags::Block::NekorumAuthorEntryBlock',
        'NekorumAuthorCommentBlock'  => 'Nekorum::Tags::Block::NekorumAuthorCommentBlock',
      },
    },
    stylecatcher_libraries => {
      nekorum_themes => {
        label => 'Nekorum themes',
        order => 100,
        description_label => 'Themes that are compatible with the Nekorum template set.',
      },
    },
    template_sets => {
      Nekorum_mt41 => {
        label => "Nekotama's forum template for MT4.1 Ver.$VERSION",
        base_path => 'templates',
        order => '99',
        templates => {
          'index' => {
            'index_main' => {
              label => 'Main Index',
              outfile => 'index.html',
              rebuild_me => 1,
            },
            'styles' => {
              label => 'Stylesheet',
              outfile => 'styles.css',
              rebuild_me => 1,
            },
            'index_javascript' => {
              label => 'JavaScript',
              outfile => 'mt.js',
              rebuild_me => 1,
            },
            'index_feed_recent' => {
              label => 'Feed - Recent Entries',
              outfile => 'atom.xml',
              rebuild_me => 1,
            },
            'index_rsd' => {
              label => 'RSD',
              outfile => 'rsd.xml',
              rebuild_me => 1,
            },
            'index_member' => {
              label => 'Member list',
              outfile => 'member.html',
              rebuild_me => 1,
            },
          },
          'individual' => {
            'archive_entry' => {
              label => 'Entry',
              mappings => {
                entry_archive => {
                  archive_type => 'Individual',
                  file_template => '%-c/%-f',
                },
              },
            },
          },
          'page' => {
            'archive_page' => {
              label => 'Page',
              mappings => {
                page_archive => {
                  archive_type => 'Page',
                },
              },
            },
          },
          'archive' => {
            'archive_category_entry_listing' => {
              label => 'Category Entry Listing',
              mappings => {
                category => {
                  archive_type => 'Category',
                },
              },
            },
          },
          'system' => {
            'comment_response' => {
              label => 'Comment Response',
              description_label => 'Displays error, pending or confirmation message for comments.'
            },
            'comment_preview' => {
              label => 'Comment Preview',
              description_label => 'Displays preview of comment.',
            },
            'dynamic_error' => {
              label => 'Dynamic Error',
              description_label => 'Displays errors for dynamically published templates.',
            },
            'popup_image' => {
              label => 'Popup Image',
              description_label => 'Displays image when user clicks a popup-linked image.',
            },
            'search_results' => {
              label => 'Search Results',
              description_label => 'Displays results of a search.',
            },
          },
          'module' => {
            'module_banner_header' => {
              label => 'Banner Header',
            },
            'module_banner_footer' => {
              label => 'Banner Footer',
            },
            'module_entry_summary' => {
              label => 'Entry Summary',
            },
            'module_html_head' => {
              label => 'HTML Head',
            },
            'module_sidebar' => {
              label => 'Sidebar',
            },
            'module_comments' => {
              label => 'Comments',
            },
            'module_trackbacks' => {
              label => 'Trackbacks',
            },
            'module_nekorum_topic' => {
              label => 'Nekorum Topic',
            },
            'module_nekorum_comment' => {
              label => 'Nekorum Comment',
            },
            'module_nekorum_signin' => {
              label => 'Nekorum Signin',
            },
            'module_nekorum_profile' => {
              label => 'Nekorum Profile',
            },
            'module_profile' => {
              label => 'Profile',
            },
          },
          'widget' => {
            'widget_about_this_page' => {
              fielname => 'about_this_page.mtml',
              label => 'About This Page',
            },
            'widget_archive_widgets_group' => {
              fielname => 'archive_widgets_group.mtml',
              label => 'Archive Widgets Group',
            },
            'widget_author_archive_list' => {
              fielname => 'author_archive_list.mtml',
              label => 'Author Archives',
            },
            'widget_current_author_monthly_archive_list' => {
              fielname => 'current_author_monthly_archive_list.mtml',
              label => 'Current Author Monthly Archives',
            },
            'widget_calendar' => {
              fielname => 'calendar.mtml',
              label => 'Calendar',
            },
            'widget_category_archive_list' => {
              fielname => 'category_archive_list.mtml',
              label => 'Category Archives',
            },
            'widget_current_category_monthly_archive_list' => {
              fielname => 'current_category_monthly_archive_list.mtml',
              label => 'Current Category Monthly Archives',
            },
            'widget_creative_commons' => {
              fielname => 'creative_commons.mtml',
              label => 'Creative Commons',
            },
            'widget_main_index_widgets_group' => {
              fielname => 'main_index_widgets_group.mtml',
              label => 'Home Page Widgets Group',
            },
            'widget_monthly_archive_dropdown' => {
              fielname => 'monthly_archive_dropdown.mtml',
              label => 'Monthly Archives Dropdown',
            },
            'widget_monthly_archive_list' => {
              fielname => 'monthly_archive_list.mtml',
              label => 'Monthly Archives',
            },
            'widget_pages_list' => {
              fielname => 'pages_list.mtml',
              label => 'Page Listing',
            },
            'widget_recent_assets' => {
              fielname => 'recent_assets.mtml',
              label => 'Recent Assets',
            },
            'widget_powered_by' => {
              fielname => 'powered_by.mtml',
              label => 'Powered By',
            },
            'widget_recent_comments' => {
              fielname => 'recent_comments.mtml',
              label => 'Recent Comments',
            },
            'widget_recent_entries' => {
              fielname => 'recent_entries.mtml',
              label => 'Recent Entries',
            },
            'widget_search' => {
              fielname => 'search.mtml',
              label => 'Search',
            },
            'widget_signin' => {
              fielname => 'signin.mtml',
              label => 'Sign In',
            },
            'widget_syndication' => {
              fielname => 'syndication.mtml',
              label => 'Syndication',
            },
            'widget_tag_cloud' => {
              fielname => 'tag_cloud.mtml',
              label => 'Tag Cloud',
            },
            'widget_technorati_search' => {
              fielname => 'technorati_search.mtml',
              label => 'Technorati Search',
            },
            'widget_date_based_author_archives' => {
              fielname => 'date_based_author_archives.mtml',
              label => 'Date-Based Author Archives',
            },
            'widget_date_based_category_archives' => {
              fielname => 'date_based_category_archives.mtml',
              label => 'Date-Based Category Archives',
            }
          },
          'widgetset' => {
            '2column_layout_sidebar' => {
              order => 1000,
              label   => '2-column layout - Sidebar',
              widgets => [
                'Search',
                'About This Page',
                'Home Page Widgets Group',
                'Archive Widgets Group',
                'Page Listing',
                'Syndication',
                'Powered By',
              ],
            },
            '3column_layout_primary_sidebar' => {
              order => 1000,
              label   => '3-column layout - Primary Sidebar',
              widgets => [
                'Archive Widgets Group',
                'Page Listing',
                'Syndication',
                'Powered By',
              ],
            },
            '3column_layout_secondary_sidebar' => {
              order => 1000,
              label   => '3-column layout - Secondary Sidebar',
              widgets => [
                'Search',
                'Home Page Widgets Group',
                'About This Page',
              ],
            },
          },
          'global:module' => {
            'global-footer-email' => {
              label => 'Mail Footer',
            },
          },
          'global:email' => {
            'global-comment_throttle' => {
              label => 'Comment throttle',
            },
            'global-commenter_confirm' => {
              label => 'Commenter Confirm',
            },
            'global-commenter_notify' => {
              label => 'Commenter Notify',
            },
            'global-new-comment' => {
              label => 'New Comment',
            },
            'global-new-ping' => {
              label => 'New Ping',
            },
            'global-notify-entry' => {
              label => 'Entry Notify',
            },
            'global-recover-password' => {
              label => 'Password Recovery',
            },
            'global-verify-subscribe' => {
              label => 'Subscribe Verify',
            },
          },
        },
      },
      Nekorum_mt415 => {
        label => "Nekotama's forum template for MT4.15 Ver.$VERSION",
        base_path => 'templates_mt415',
        order => '99',
        templates => {
          'index' => {
            'index_main' => {
              label => 'Main Index',
              outfile => 'index.html',
              rebuild_me => 1,
            },
            'styles' => {
              label => 'Stylesheet',
              outfile => 'styles.css',
              rebuild_me => 1,
            },
            'index_javascript' => {
              label => 'JavaScript',
              outfile => 'mt.js',
              rebuild_me => 1,
            },
            'index_feed_recent' => {
              label => 'Feed - Recent Entries',
              outfile => 'atom.xml',
              rebuild_me => 1,
            },
            'index_rsd' => {
              label => 'RSD',
              outfile => 'rsd.xml',
              rebuild_me => 1,
            },
            'index_member' => {
              label => 'Member list',
              outfile => 'member.html',
              rebuild_me => 1,
            },
          },
          'individual' => {
            'archive_entry' => {
              label => 'Entry',
              mappings => {
                entry_archive => {
                  archive_type => 'Individual',
                  file_template => '%-c/%-f',
                },
              },
            },
          },
          'page' => {
            'archive_page' => {
              label => 'Page',
              mappings => {
                page_archive => {
                  archive_type => 'Page',
                },
              },
            },
          },
          'archive' => {
            'archive_category_entry_listing' => {
              label => 'Category Entry Listing',
              mappings => {
                category => {
                  archive_type => 'Category',
                },
              },
            },
          },
          'system' => {
            'comment_response' => {
              label => 'Comment Response',
              description_label => 'Displays error, pending or confirmation message for comments.'
            },
            'comment_preview' => {
              label => 'Comment Preview',
              description_label => 'Displays preview of comment.',
            },
            'dynamic_error' => {
              label => 'Dynamic Error',
              description_label => 'Displays errors for dynamically published templates.',
            },
            'popup_image' => {
              label => 'Popup Image',
              description_label => 'Displays image when user clicks a popup-linked image.',
            },
            'search_results' => {
              label => 'Search Results',
              description_label => 'Displays results of a search.',
            },
          },
          'module' => {
            'module_banner_header' => {
              label => 'Banner Header',
            },
            'module_banner_footer' => {
              label => 'Banner Footer',
            },
            'module_entry_summary' => {
              label => 'Entry Summary',
            },
            'module_html_head' => {
              label => 'HTML Head',
            },
            'module_sidebar' => {
              label => 'Sidebar',
            },
            'module_comments' => {
              label => 'Comments',
            },
            'module_trackbacks' => {
              label => 'Trackbacks',
            },
            'module_nekorum_topic' => {
              label => 'Nekorum Topic',
            },
            'module_nekorum_comment' => {
              label => 'Nekorum Comment',
            },
            'module_nekorum_signin' => {
              label => 'Nekorum Signin',
            },
            'module_nekorum_profile' => {
              label => 'Nekorum Profile',
            },
            'module_profile' => {
              label => 'Profile',
            },
          },
          'widget' => {
            'widget_about_this_page' => {
              fielname => 'about_this_page.mtml',
              label => 'About This Page',
            },
            'widget_archive_widgets_group' => {
              fielname => 'archive_widgets_group.mtml',
              label => 'Archive Widgets Group',
            },
            'widget_author_archive_list' => {
              fielname => 'author_archive_list.mtml',
              label => 'Author Archives',
            },
            'widget_current_author_monthly_archive_list' => {
              fielname => 'current_author_monthly_archive_list.mtml',
              label => 'Current Author Monthly Archives',
            },
            'widget_calendar' => {
              fielname => 'calendar.mtml',
              label => 'Calendar',
            },
            'widget_category_archive_list' => {
              fielname => 'category_archive_list.mtml',
              label => 'Category Archives',
            },
            'widget_current_category_monthly_archive_list' => {
              fielname => 'current_category_monthly_archive_list.mtml',
              label => 'Current Category Monthly Archives',
            },
            'widget_creative_commons' => {
              fielname => 'creative_commons.mtml',
              label => 'Creative Commons',
            },
            'widget_main_index_widgets_group' => {
              fielname => 'main_index_widgets_group.mtml',
              label => 'Home Page Widgets Group',
            },
            'widget_monthly_archive_dropdown' => {
              fielname => 'monthly_archive_dropdown.mtml',
              label => 'Monthly Archives Dropdown',
            },
            'widget_monthly_archive_list' => {
              fielname => 'monthly_archive_list.mtml',
              label => 'Monthly Archives',
            },
            'widget_pages_list' => {
              fielname => 'pages_list.mtml',
              label => 'Page Listing',
            },
            'widget_recent_assets' => {
              fielname => 'recent_assets.mtml',
              label => 'Recent Assets',
            },
            'widget_powered_by' => {
              fielname => 'powered_by.mtml',
              label => 'Powered By',
            },
            'widget_recent_comments' => {
              fielname => 'recent_comments.mtml',
              label => 'Recent Comments',
            },
            'widget_recent_entries' => {
              fielname => 'recent_entries.mtml',
              label => 'Recent Entries',
            },
            'widget_search' => {
              fielname => 'search.mtml',
              label => 'Search',
            },
            'widget_signin' => {
              fielname => 'signin.mtml',
              label => 'Sign In',
            },
            'widget_syndication' => {
              fielname => 'syndication.mtml',
              label => 'Syndication',
            },
            'widget_tag_cloud' => {
              fielname => 'tag_cloud.mtml',
              label => 'Tag Cloud',
            },
            'widget_technorati_search' => {
              fielname => 'technorati_search.mtml',
              label => 'Technorati Search',
            },
            'widget_date_based_author_archives' => {
              fielname => 'date_based_author_archives.mtml',
              label => 'Date-Based Author Archives',
            },
            'widget_date_based_category_archives' => {
              fielname => 'date_based_category_archives.mtml',
              label => 'Date-Based Category Archives',
            }
          },
          'widgetset' => {
            '2column_layout_sidebar' => {
              order => 1000,
              label   => '2-column layout - Sidebar',
              widgets => [
                'Search',
                'About This Page',
                'Home Page Widgets Group',
                'Archive Widgets Group',
                'Page Listing',
                'Syndication',
                'Powered By',
              ],
            },
            '3column_layout_primary_sidebar' => {
              order => 1000,
              label   => '3-column layout - Primary Sidebar',
              widgets => [
                'Archive Widgets Group',
                'Page Listing',
                'Syndication',
                'Powered By',
              ],
            },
            '3column_layout_secondary_sidebar' => {
              order => 1000,
              label   => '3-column layout - Secondary Sidebar',
              widgets => [
                'Search',
                'Home Page Widgets Group',
                'About This Page',
              ],
            },
          },
          'global:module' => {
            'global-footer-email' => {
              label => 'Mail Footer',
            },
          },
          'global:email' => {
            'global-comment_throttle' => {
              label => 'Comment throttle',
            },
            'global-commenter_confirm' => {
              label => 'Commenter Confirm',
            },
            'global-commenter_notify' => {
              label => 'Commenter Notify',
            },
            'global-new-comment' => {
              label => 'New Comment',
            },
            'global-new-ping' => {
              label => 'New Ping',
            },
            'global-notify-entry' => {
              label => 'Entry Notify',
            },
            'global-recover-password' => {
              label => 'Password Recovery',
            },
            'global-verify-subscribe' => {
              label => 'Subscribe Verify',
            },
          },
        },
      },
    },
  });
}

1;
