/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ReferenceCache
extends ArrayList {
    private static final long serialVersionUID = -6808020476640514389L;
    public static final int SOFT = 0;
    public static final int WEAK = 1;
    protected volatile boolean _liveSweepMonitor;
    protected SweepListener _sweepBeginListener;
    protected ReferenceQueue _queue;
    private Class _elementType;
    private int _referenceType;
    private String _name;
    protected Map _labelReferenceMap;
    static /* synthetic */ Class class$java$lang$Object;

    public ReferenceCache() {
        this(class$java$lang$Object == null ? (class$java$lang$Object = ReferenceCache.class$("java.lang.Object")) : class$java$lang$Object, 0, null);
    }

    public ReferenceCache(Class elementType) {
        this(elementType, 0, null);
    }

    public ReferenceCache(Class elementType, int referenceType) {
        this(elementType, 0, null);
    }

    public ReferenceCache(Class elementType, int referenceType, SweepListener listener) {
        if (referenceType != 0 && referenceType != 1) {
            throw new IllegalArgumentException();
        }
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        this._elementType = elementType;
        this._referenceType = referenceType;
        this._sweepBeginListener = listener;
    }

    private void check(Object element) {
        if (element == null || !this._elementType.isAssignableFrom(element.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    protected synchronized void sweepMonitorStart() {
        if (this._liveSweepMonitor) {
            return;
        }
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        this._labelReferenceMap = new HashMap();
        this._queue = new ReferenceQueue();
        new Thread(topThreadGroup, "ReferenceCache Sweep Monitor"){
            {
                this.setPriority(1);
                this.setDaemon(true);
                ReferenceCache.this._liveSweepMonitor = true;
            }

            public void run() {
                while (ReferenceCache.this._liveSweepMonitor) {
                    try {
                        PhantomReference ref = (PhantomReference)ReferenceCache.this._queue.remove(1L);
                        if (ref == null) continue;
                        Object label = ReferenceCache.this._labelReferenceMap.get(ref);
                        ReferenceCache.this._labelReferenceMap.remove(ref);
                        ReferenceCache.this._sweepBeginListener.sweepFinish(ReferenceCache.this, label);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
    }

    protected Reference createReference(Object referent) {
        if (this._sweepBeginListener != null) {
            this.sweepMonitorStart();
            Object labelObject = this._sweepBeginListener.labeling(referent);
            if (labelObject == null || labelObject == referent) {
                labelObject = referent.toString();
            }
            PhantomReference<Object> ref = new PhantomReference<Object>(referent, this._queue);
            this._labelReferenceMap.put(ref, labelObject);
        }
        switch (this._referenceType) {
            case 0: {
                return new SoftReference<Object>(referent);
            }
            case 1: {
                return new WeakReference<Object>(referent);
            }
        }
        throw new IllegalStateException();
    }

    public void add(int index, Object element) {
        this.check(element);
        super.add(index, this.createReference(element));
    }

    public boolean add(Object o) {
        this.check(o);
        return super.add(this.createReference(o));
    }

    public Iterator iterator() {
        return new ReferenceCacheIterator(this);
    }

    protected void finalize() throws Throwable {
        this._liveSweepMonitor = false;
        super.finalize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ReferenceCacheIterator
    implements Iterator {
        private int _index;
        private Object _next;
        private List _list;

        public ReferenceCacheIterator(List list) {
            if (list == null) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._index = list.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (this._next != null) {
                return true;
            }
            while (this._next == null) {
                --this._index;
                if (this._index < 0) {
                    return false;
                }
                List list = this._list;
                synchronized (list) {
                    Reference ref = (Reference)this._list.get(this._index);
                    this._next = ref.get();
                    if (this._next == null) {
                        this._list.remove(this._index);
                    }
                }
            }
            return true;
        }

        public Object next() {
            if (this._next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = this._next;
            this._next = null;
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface SweepListener {
        public Object labeling(Object var1);

        public void sweepFinish(ReferenceCache var1, Object var2);
    }
}

