/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.seasar.mayaa.impl.util.collection.AbstractSoftReferencePool;

public class DateFormatPool {
    private static Map _formatPools = new HashMap();

    private DateFormatPool() {
        throw new UnsupportedOperationException();
    }

    public static DateFormat borrowFormat(String formatPattern) {
        return DateFormatPool.borrowFormat(formatPattern, Locale.getDefault());
    }

    private static String makeKey(String formatPattern, Locale locale) {
        return formatPattern + "\n" + locale.toString();
    }

    public static DateFormat borrowFormat(String formatPattern, Locale locale) {
        String key = DateFormatPool.makeKey(formatPattern, locale);
        Pool pool = (Pool)_formatPools.get(key);
        if (pool == null) {
            pool = new Pool(formatPattern, locale);
            _formatPools.put(key, pool);
        }
        return pool.borrowFormat();
    }

    public static void returnFormat(DateFormat object) {
        if (!(object instanceof SimpleLocaleDateFormat)) {
            return;
        }
        SimpleLocaleDateFormat format = (SimpleLocaleDateFormat)object;
        String key = DateFormatPool.makeKey(format.toPattern(), format.getLocale());
        Pool pool = (Pool)_formatPools.get(key);
        if (pool != null) {
            pool.returnFormat(format);
        }
    }

    public static DateFormat borrowRFC1123Format() {
        DateFormat result = DateFormatPool.borrowFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        return result;
    }

    public static DateFormat borrowRFC2822Format() {
        DateFormat result = DateFormatPool.borrowFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        return result;
    }

    private static class SimpleLocaleDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;
        private Locale _locale;

        public SimpleLocaleDateFormat(String pattern, Locale locale) {
            super(pattern, locale);
            this._locale = locale;
        }

        public Locale getLocale() {
            return this._locale;
        }
    }

    private static class Pool
    extends AbstractSoftReferencePool {
        private static final long serialVersionUID = 32939508346669867L;
        private String _formatPattern;
        private Locale _locale;

        public Pool(String formatPattern, Locale locale) {
            if (formatPattern == null) {
                throw new IllegalArgumentException();
            }
            this._formatPattern = formatPattern;
            this._locale = locale;
        }

        protected Object createObject() {
            SimpleLocaleDateFormat result = new SimpleLocaleDateFormat(this._formatPattern, this._locale);
            return result;
        }

        protected boolean validateObject(Object object) {
            return object instanceof DateFormat;
        }

        public DateFormat borrowFormat() {
            return (DateFormat)this.borrowObject();
        }

        public void returnFormat(DateFormat format) {
            if (format != null) {
                this.returnObject(format);
            }
        }
    }
}

