/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class FileSourceDescriptor
extends ParameterAwareImpl
implements SourceDescriptor {
    private static final long serialVersionUID = 9199082270985131347L;
    private String _root = "/";
    private File _file;

    public void setFile(File file) {
        this._file = file;
    }

    public File getFile() {
        this.exists();
        return this._file;
    }

    public void setRoot(String root) {
        this._root = StringUtil.preparePath(root);
    }

    public String getRoot() {
        return this._root;
    }

    public void setSystemID(String systemID) {
        super.setSystemID(StringUtil.preparePath(systemID));
    }

    protected String getRealPath() {
        return this._root + this.getSystemID();
    }

    public boolean exists() {
        File file;
        String realPath;
        if (this._file == null && StringUtil.hasValue(realPath = this.getRealPath()) && (file = new File(realPath)).exists()) {
            this._file = file;
        }
        return this._file != null && this._file.exists();
    }

    public InputStream getInputStream() {
        if (this.exists()) {
            if (this._file.isFile()) {
                try {
                    return new FileInputStream(this._file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this._file.isDirectory()) {
                CycleUtil.getServiceCycle().redirect(this._file.getName() + "/");
            }
        }
        return null;
    }

    public Date getTimestamp() {
        if (this.exists()) {
            return new Date(this._file.lastModified());
        }
        return new Date(0L);
    }
}

