/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification.serialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.NodeResolveListener;

public class NodeSerializeController
implements NodeReferenceResolver {
    private List _nodeListeners;
    private Map _nodes;

    public void init() {
        this._nodeListeners = new ArrayList(20);
        this._nodes = new HashMap(100);
    }

    public void release() {
        this.doNotify();
        Iterator it = this._nodeListeners.iterator();
        while (it.hasNext()) {
            NodeListener listener = (NodeListener)it.next();
            listener.release();
        }
        this._nodeListeners.clear();
        this._nodes.clear();
    }

    public NodeTreeWalker getNode(String uniqueID) {
        return (NodeTreeWalker)this._nodes.get(uniqueID);
    }

    public void doNotify() {
        Iterator it = this._nodeListeners.iterator();
        while (it.hasNext()) {
            NodeListener listener = (NodeListener)it.next();
            NodeTreeWalker node = this.getNode(listener._id);
            listener._listener.notify(listener._id, node);
            if (node == null) continue;
            it.remove();
        }
    }

    public void registResolveNodeListener(String uniqueID, NodeResolveListener listener) {
        this._nodeListeners.add(new NodeListener(uniqueID, listener));
    }

    public void nodeLoaded(SpecificationNode item) {
        this._nodes.put(NodeSerializeController.makeKey(item), item);
    }

    public void specLoaded(Specification item) {
        this._nodes.put(NodeSerializeController.makeKey(item), item);
    }

    public static String makeKey(SpecificationNode item) {
        return item.getSystemID() + "\n" + item.getSequenceID() + "\n" + item.getQName();
    }

    public static String makeKey(Specification item) {
        return item.getSystemID();
    }

    public class NodeListener {
        String _id;
        NodeResolveListener _listener;

        public NodeListener(String id, NodeResolveListener listener) {
            this._id = id;
            this._listener = listener;
        }

        public void release() {
            this._listener.release();
            this._listener = null;
        }
    }
}

