/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.impl.util.StringUtil;

public class PrefixAwareNameImpl
implements PrefixAwareName,
Serializable {
    private static final long serialVersionUID = -8898891078217203404L;
    private static Map _cache = new ReferenceMap(1, 1, true);
    private QName _qName;
    private String _prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrefixAwareName getInstance(QName qName, String prefix) {
        PrefixAwareName result;
        String key = PrefixAwareNameImpl.forPrefixAwareNameString(qName, prefix);
        Map map = _cache;
        synchronized (map) {
            result = (PrefixAwareName)_cache.get(key);
            if (result == null) {
                result = new PrefixAwareNameImpl(qName, prefix);
                _cache.put(key, result);
            }
        }
        return result;
    }

    private PrefixAwareNameImpl() {
    }

    private PrefixAwareNameImpl(QName qName, String prefix) {
        if (qName == null || prefix == null) {
            throw new IllegalArgumentException();
        }
        this._qName = qName;
        this._prefix = prefix;
    }

    public QName getQName() {
        return this._qName;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String toString() {
        return PrefixAwareNameImpl.forPrefixAwareNameString(this.getQName(), this.getPrefix());
    }

    public boolean equals(Object test) {
        return this.getQName().equals(test);
    }

    public int hashCode() {
        return this.getQName().hashCode();
    }

    public static String forPrefixAwareNameString(QName qName, String prefix) {
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.hasValue(prefix)) {
            buffer.append(prefix).append(":");
        }
        buffer.append(qName.toString());
        return buffer.toString();
    }

    private Object readResolve() {
        return PrefixAwareNameImpl.getInstance(this._qName, this._prefix);
    }
}

