/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class NodeTreeWalkerImpl
implements NodeTreeWalker {
    private static final long serialVersionUID = -1269833640801417204L;
    private transient NodeTreeWalker _owner;
    private transient NodeTreeWalker _parent;
    private List _childNodes;
    private String _systemID;
    private int _lineNumber;
    private boolean _onTemplate;

    public void setOwner(NodeTreeWalker owner) {
        this._owner = owner;
    }

    public void setParentNode(NodeTreeWalker parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parentNode;
    }

    public NodeTreeWalker getParentNode() {
        return this._parent;
    }

    public void addChildNode(NodeTreeWalker childNode) {
        int index = this._childNodes == null ? 0 : this._childNodes.size();
        this.insertChildNode(index, childNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChildNode(int index, NodeTreeWalker childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException();
        }
        Object object = this;
        synchronized (object) {
            if (this._childNodes == null) {
                this._childNodes = new ArrayList();
            }
        }
        object = this._childNodes;
        synchronized (object) {
            if (index < 0 || index > this._childNodes.size()) {
                throw new IndexOutOfBoundsException();
            }
            this._childNodes.add(index, childNode);
            childNode.setParentNode(this._owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChildNode(NodeTreeWalker childNode) {
        if (childNode != null && this._childNodes != null) {
            List list = this._childNodes;
            synchronized (list) {
                return this._childNodes.remove(childNode);
            }
        }
        return false;
    }

    public int getChildNodeSize() {
        if (this._childNodes == null) {
            return 0;
        }
        return this._childNodes.size();
    }

    public NodeTreeWalker getChildNode(int index) {
        if (this._childNodes == null || index < 0 || index >= this._childNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (NodeTreeWalker)this._childNodes.get(index);
    }

    public Iterator iterateChildNode() {
        if (this._childNodes == null) {
            return NullIterator.getInstance();
        }
        return this._childNodes.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this._parent = null;
        if (this._childNodes != null) {
            List list = this._childNodes;
            synchronized (list) {
                Iterator it = this.iterateChildNode();
                while (it.hasNext()) {
                    NodeTreeWalker node = (NodeTreeWalker)it.next();
                    node.kill();
                }
                this._childNodes.clear();
            }
        }
        this._owner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildNodes() {
        if (this._childNodes != null) {
            List list = this._childNodes;
            synchronized (list) {
                this._childNodes.clear();
                this._childNodes = null;
            }
        }
    }

    public void setSystemID(String systemID) {
        if (systemID == null) {
            throw new IllegalArgumentException();
        }
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setOnTemplate(boolean onTemplate) {
        this._onTemplate = onTemplate;
    }

    public boolean isOnTemplate() {
        return this._onTemplate;
    }

    public NodeReferenceResolver findNodeResolver() {
        return SpecificationImpl.nodeSerializer();
    }
}

