/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.StringUtil;

public class ProcessingInstructionProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = 6717263251948534639L;
    private static final int DEFAULT_BUFFER_SIZE = 128;
    private String _target;
    private String _data;

    public void setTarget(String target) {
        if (StringUtil.isEmpty(target)) {
            throw new IllegalArgumentException();
        }
        this._target = target;
    }

    public String getTarget() {
        return this._target;
    }

    public void setData(String data) {
        this._data = data;
    }

    public String getData() {
        return this._data;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        StringBuffer processingInstruction = new StringBuffer(128);
        processingInstruction.append("<?").append(this._target);
        if (StringUtil.hasValue(this._data)) {
            processingInstruction.append(" ").append(this._data);
        }
        processingInstruction.append("?>\r\n");
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(processingInstruction.toString());
        return ProcessStatus.SKIP_BODY;
    }
}

