/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.mayaa.builder.SpecificationBuilder;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.ProcessorReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.ProcessorResolveListener;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.RenderUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.engine.specification.serialize.ProcessorSerializeController;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class TemplateImpl
extends SpecificationImpl
implements Template,
NodeReferenceResolver,
ProcessorReferenceResolver,
CONST_IMPL {
    private static final long serialVersionUID = -5368325487192629078L;
    private String _pageName;
    private String _suffix;
    private String _extension;
    private List _childProcessors = new ArrayList();
    private static final String SERIALIZE_CONTROLLER_KEY = (class$org$seasar$mayaa$impl$engine$TemplateImpl == null ? (class$org$seasar$mayaa$impl$engine$TemplateImpl = TemplateImpl.class$("org.seasar.mayaa.impl.engine.TemplateImpl")) : class$org$seasar$mayaa$impl$engine$TemplateImpl).getName() + "#serializeController";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$TemplateImpl;

    public void initialize(Page page, String suffix, String extension) {
        if (page == null || suffix == null || extension == null) {
            throw new IllegalArgumentException();
        }
        if (this._pageName != null) {
            throw new IllegalStateException();
        }
        this._pageName = page.getPageName();
        this._suffix = suffix;
        this._extension = extension;
    }

    public Page getPage() {
        return ProviderUtil.getEngine().getPage(this._pageName);
    }

    public String getSuffix() {
        return this._suffix;
    }

    public String getExtension() {
        return this._extension;
    }

    protected String getMayaaAttribute(Specification spec, QName qname) {
        SpecificationNode mayaa = SpecificationUtil.getMayaaNode(spec);
        if (mayaa != null) {
            return SpecificationUtil.getAttributeValue(mayaa, qname);
        }
        return null;
    }

    protected String findMayaaAttribute(Page topLevelPage, QName qname) {
        String topLevelValue = this.getMayaaAttribute(topLevelPage, qname);
        if (StringUtil.hasValue(topLevelValue)) {
            return topLevelValue;
        }
        Specification spec = this;
        while (spec != null) {
            String value = this.getMayaaAttribute(spec, qname);
            if (StringUtil.hasValue(value)) {
                return value;
            }
            spec = EngineUtil.getParentSpecification(spec);
        }
        return null;
    }

    protected String getContentType(Page topLevelPage) {
        String contentType = this.findMayaaAttribute(topLevelPage, CONST_IMPL.QM_CONTENT_TYPE);
        if (contentType != null) {
            return contentType;
        }
        RequestScope request = CycleUtil.getRequestScope();
        String ret = request.getMimeType();
        if (ret == null) {
            ret = "text/html; charset=UTF-8";
        }
        return ret;
    }

    protected boolean isNoCache(Page topLevelPage) {
        String noCache = this.findMayaaAttribute(topLevelPage, CONST_IMPL.QM_NO_CACHE);
        if (noCache != null) {
            return ObjectUtil.booleanValue(noCache, false);
        }
        return false;
    }

    protected void prepareCycle(Page topLevelPage) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        Response response = cycle.getResponse();
        String contentType = this.getContentType(topLevelPage);
        response.setContentType(contentType);
        if (this.isNoCache(topLevelPage)) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        }
    }

    public ProcessStatus doTemplateRender(Page topLevelPage) {
        RenderUtil.saveToCycle(this);
        this.prepareCycle(topLevelPage);
        ProcessStatus ret = RenderUtil.renderProcessorTree(topLevelPage, this);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            Iterator it = this._childProcessors.iterator();
            while (it.hasNext()) {
                TemplateProcessor processor = (TemplateProcessor)it.next();
                processor.kill();
            }
            super.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceProcessors(List processors) {
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            this.clearChildProcessors();
            for (int i = 0; i < processors.size(); ++i) {
                Object item = processors.get(i);
                if (!(item instanceof ProcessorTreeWalker)) continue;
                this.addChildProcessor((ProcessorTreeWalker)processors.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        CycleUtil.beginDraftWriting();
        try {
            super.build();
        }
        finally {
            CycleUtil.endDraftWriting();
        }
    }

    protected SpecificationBuilder getBuilder() {
        return ProviderUtil.getTemplateBuilder();
    }

    public boolean isDeprecated() {
        Date templateTime = this.getTimestamp();
        if (templateTime != null) {
            Date engineTime;
            Page page = this.getPage();
            Date pageTime = page.getTimestamp();
            if (pageTime == null) {
                pageTime = new Date(0L);
            }
            if ((engineTime = ProviderUtil.getEngine().getTimestamp()) == null) {
                engineTime = new Date(0L);
            }
            if (pageTime.after(templateTime) || engineTime.after(templateTime)) {
                return true;
            }
        }
        return super.isDeprecated();
    }

    public Map getVariables() {
        return null;
    }

    public void setParentProcessor(ProcessorTreeWalker parent) {
        throw new IllegalStateException();
    }

    public ProcessorTreeWalker getParentProcessor() {
        return null;
    }

    public void addChildProcessor(ProcessorTreeWalker child) {
        this.insertProcessor(this._childProcessors.size(), child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertProcessor(int index, ProcessorTreeWalker child) {
        List list = this._childProcessors;
        synchronized (list) {
            if (child == null) {
                throw new IllegalArgumentException();
            }
            if (index < 0 || index > this._childProcessors.size()) {
                throw new IndexOutOfBoundsException();
            }
            this._childProcessors.add(index, child);
            child.setParentProcessor(this);
            ++index;
            while (index < this._childProcessors.size()) {
                child = (ProcessorTreeWalker)this._childProcessors.get(index);
                child.setParentProcessor(this);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProcessor(ProcessorTreeWalker child) {
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            return this._childProcessors.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildProcessors() {
        TemplateImpl templateImpl = this;
        synchronized (templateImpl) {
            this._childProcessors.clear();
        }
    }

    public int getChildProcessorSize() {
        return this._childProcessors.size();
    }

    public ProcessorTreeWalker getChildProcessor(int index) {
        return (ProcessorTreeWalker)this._childProcessors.get(index);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this._childProcessors != null) {
            for (int i = this._childProcessors.size() - 1; i >= 0; --i) {
                ProcessorTreeWalker child = (ProcessorTreeWalker)this._childProcessors.get(i);
                child.setParentProcessor(this);
            }
        }
        SpecificationImpl.nodeSerializer().specLoaded(this);
    }

    protected void afterDeserialize() {
        TemplateImpl.processorSerializer().release();
    }

    public static ProcessorSerializeController processorSerializer() {
        return (ProcessorSerializeController)CycleUtil.getGlobalVariable(SERIALIZE_CONTROLLER_KEY, null);
    }

    public void registResolveProcessorListener(String uniqueID, ProcessorResolveListener listener) {
        TemplateImpl.processorSerializer().registResolveProcessorListener(uniqueID, listener);
    }

    public void processorLoaded(String uniqueID, ProcessorTreeWalker item) {
        TemplateImpl.processorSerializer().processorLoaded(uniqueID, item);
    }

    public ProcessorReferenceResolver findProcessorResolver() {
        return TemplateImpl.processorSerializer();
    }

    public boolean isOnTemplate() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CycleUtil.registVariableFactory(SERIALIZE_CONTROLLER_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                ProcessorSerializeController result = new ProcessorSerializeController();
                result.init();
                return result;
            }
        });
    }
}

